/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.PublicIp;
import java.beans.ConstructorProperties;

public class GetPublicIpResponse {
    private String etag;
    private String opcRequestId;
    private PublicIp publicIp;

    @ConstructorProperties(value={"etag", "opcRequestId", "publicIp"})
    GetPublicIpResponse(String etag, String opcRequestId, PublicIp publicIp) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.publicIp = publicIp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public PublicIp getPublicIp() {
        return this.publicIp;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private PublicIp publicIp;

        public Builder copy(GetPublicIpResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.publicIp(o.getPublicIp());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder publicIp(PublicIp publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public GetPublicIpResponse build() {
            return new GetPublicIpResponse(this.etag, this.opcRequestId, this.publicIp);
        }

        public String toString() {
            return "GetPublicIpResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", publicIp=" + this.publicIp + ")";
        }
    }
}

