/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.SecurityList;
import java.beans.ConstructorProperties;

public class GetSecurityListResponse {
    private String etag;
    private String opcRequestId;
    private SecurityList securityList;

    @ConstructorProperties(value={"etag", "opcRequestId", "securityList"})
    GetSecurityListResponse(String etag, String opcRequestId, SecurityList securityList) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.securityList = securityList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public SecurityList getSecurityList() {
        return this.securityList;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private SecurityList securityList;

        public Builder copy(GetSecurityListResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.securityList(o.getSecurityList());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder securityList(SecurityList securityList) {
            this.securityList = securityList;
            return this;
        }

        public GetSecurityListResponse build() {
            return new GetSecurityListResponse(this.etag, this.opcRequestId, this.securityList);
        }

        public String toString() {
            return "GetSecurityListResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", securityList=" + this.securityList + ")";
        }
    }
}

