/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.Service;
import java.beans.ConstructorProperties;

public class GetServiceResponse {
    private String etag;
    private String opcRequestId;
    private Service service;

    @ConstructorProperties(value={"etag", "opcRequestId", "service"})
    GetServiceResponse(String etag, String opcRequestId, Service service) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.service = service;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Service getService() {
        return this.service;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Service service;

        public Builder copy(GetServiceResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.service(o.getService());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder service(Service service) {
            this.service = service;
            return this;
        }

        public GetServiceResponse build() {
            return new GetServiceResponse(this.etag, this.opcRequestId, this.service);
        }

        public String toString() {
            return "GetServiceResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", service=" + this.service + ")";
        }
    }
}

