/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.Vcn;
import java.beans.ConstructorProperties;

public class GetVcnResponse {
    private String etag;
    private String opcRequestId;
    private Vcn vcn;

    @ConstructorProperties(value={"etag", "opcRequestId", "vcn"})
    GetVcnResponse(String etag, String opcRequestId, Vcn vcn) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.vcn = vcn;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Vcn getVcn() {
        return this.vcn;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Vcn vcn;

        public Builder copy(GetVcnResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.vcn(o.getVcn());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder vcn(Vcn vcn) {
            this.vcn = vcn;
            return this;
        }

        public GetVcnResponse build() {
            return new GetVcnResponse(this.etag, this.opcRequestId, this.vcn);
        }

        public String toString() {
            return "GetVcnResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", vcn=" + this.vcn + ")";
        }
    }
}

