/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.VnicAttachment;
import java.beans.ConstructorProperties;

public class GetVnicAttachmentResponse {
    private String etag;
    private String opcRequestId;
    private VnicAttachment vnicAttachment;

    @ConstructorProperties(value={"etag", "opcRequestId", "vnicAttachment"})
    GetVnicAttachmentResponse(String etag, String opcRequestId, VnicAttachment vnicAttachment) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.vnicAttachment = vnicAttachment;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public VnicAttachment getVnicAttachment() {
        return this.vnicAttachment;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private VnicAttachment vnicAttachment;

        public Builder copy(GetVnicAttachmentResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.vnicAttachment(o.getVnicAttachment());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder vnicAttachment(VnicAttachment vnicAttachment) {
            this.vnicAttachment = vnicAttachment;
            return this;
        }

        public GetVnicAttachmentResponse build() {
            return new GetVnicAttachmentResponse(this.etag, this.opcRequestId, this.vnicAttachment);
        }

        public String toString() {
            return "GetVnicAttachmentResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", vnicAttachment=" + this.vnicAttachment + ")";
        }
    }
}

