/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.Vnic;
import java.beans.ConstructorProperties;

public class GetVnicResponse {
    private String etag;
    private String opcRequestId;
    private Vnic vnic;

    @ConstructorProperties(value={"etag", "opcRequestId", "vnic"})
    GetVnicResponse(String etag, String opcRequestId, Vnic vnic) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.vnic = vnic;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Vnic getVnic() {
        return this.vnic;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Vnic vnic;

        public Builder copy(GetVnicResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.vnic(o.getVnic());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder vnic(Vnic vnic) {
            this.vnic = vnic;
            return this;
        }

        public GetVnicResponse build() {
            return new GetVnicResponse(this.etag, this.opcRequestId, this.vnic);
        }

        public String toString() {
            return "GetVnicResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", vnic=" + this.vnic + ")";
        }
    }
}

