/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.VolumeAttachment;
import java.beans.ConstructorProperties;

public class GetVolumeAttachmentResponse {
    private String etag;
    private String opcRequestId;
    private VolumeAttachment volumeAttachment;

    @ConstructorProperties(value={"etag", "opcRequestId", "volumeAttachment"})
    GetVolumeAttachmentResponse(String etag, String opcRequestId, VolumeAttachment volumeAttachment) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.volumeAttachment = volumeAttachment;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public VolumeAttachment getVolumeAttachment() {
        return this.volumeAttachment;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private VolumeAttachment volumeAttachment;

        public Builder copy(GetVolumeAttachmentResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.volumeAttachment(o.getVolumeAttachment());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder volumeAttachment(VolumeAttachment volumeAttachment) {
            this.volumeAttachment = volumeAttachment;
            return this;
        }

        public GetVolumeAttachmentResponse build() {
            return new GetVolumeAttachmentResponse(this.etag, this.opcRequestId, this.volumeAttachment);
        }

        public String toString() {
            return "GetVolumeAttachmentResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", volumeAttachment=" + this.volumeAttachment + ")";
        }
    }
}

