/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.VolumeGroup;
import java.beans.ConstructorProperties;

public class GetVolumeGroupResponse {
    private String etag;
    private String opcRequestId;
    private VolumeGroup volumeGroup;

    @ConstructorProperties(value={"etag", "opcRequestId", "volumeGroup"})
    GetVolumeGroupResponse(String etag, String opcRequestId, VolumeGroup volumeGroup) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.volumeGroup = volumeGroup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public VolumeGroup getVolumeGroup() {
        return this.volumeGroup;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private VolumeGroup volumeGroup;

        public Builder copy(GetVolumeGroupResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.volumeGroup(o.getVolumeGroup());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder volumeGroup(VolumeGroup volumeGroup) {
            this.volumeGroup = volumeGroup;
            return this;
        }

        public GetVolumeGroupResponse build() {
            return new GetVolumeGroupResponse(this.etag, this.opcRequestId, this.volumeGroup);
        }

        public String toString() {
            return "GetVolumeGroupResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", volumeGroup=" + this.volumeGroup + ")";
        }
    }
}

