/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.VolumeKmsKey;
import java.beans.ConstructorProperties;

public class GetVolumeKmsKeyResponse {
    private String etag;
    private String opcRequestId;
    private VolumeKmsKey volumeKmsKey;

    @ConstructorProperties(value={"etag", "opcRequestId", "volumeKmsKey"})
    GetVolumeKmsKeyResponse(String etag, String opcRequestId, VolumeKmsKey volumeKmsKey) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.volumeKmsKey = volumeKmsKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public VolumeKmsKey getVolumeKmsKey() {
        return this.volumeKmsKey;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private VolumeKmsKey volumeKmsKey;

        public Builder copy(GetVolumeKmsKeyResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.volumeKmsKey(o.getVolumeKmsKey());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder volumeKmsKey(VolumeKmsKey volumeKmsKey) {
            this.volumeKmsKey = volumeKmsKey;
            return this;
        }

        public GetVolumeKmsKeyResponse build() {
            return new GetVolumeKmsKeyResponse(this.etag, this.opcRequestId, this.volumeKmsKey);
        }

        public String toString() {
            return "GetVolumeKmsKeyResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", volumeKmsKey=" + this.volumeKmsKey + ")";
        }
    }
}

