/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.InstanceCredentials;
import java.beans.ConstructorProperties;

public class GetWindowsInstanceInitialCredentialsResponse {
    private String opcRequestId;
    private InstanceCredentials instanceCredentials;

    @ConstructorProperties(value={"opcRequestId", "instanceCredentials"})
    GetWindowsInstanceInitialCredentialsResponse(String opcRequestId, InstanceCredentials instanceCredentials) {
        this.opcRequestId = opcRequestId;
        this.instanceCredentials = instanceCredentials;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public InstanceCredentials getInstanceCredentials() {
        return this.instanceCredentials;
    }

    public static class Builder {
        private String opcRequestId;
        private InstanceCredentials instanceCredentials;

        public Builder copy(GetWindowsInstanceInitialCredentialsResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.instanceCredentials(o.getInstanceCredentials());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder instanceCredentials(InstanceCredentials instanceCredentials) {
            this.instanceCredentials = instanceCredentials;
            return this;
        }

        public GetWindowsInstanceInitialCredentialsResponse build() {
            return new GetWindowsInstanceInitialCredentialsResponse(this.opcRequestId, this.instanceCredentials);
        }

        public String toString() {
            return "GetWindowsInstanceInitialCredentialsResponse.Builder(opcRequestId=" + this.opcRequestId + ", instanceCredentials=" + this.instanceCredentials + ")";
        }
    }
}

