/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.Instance;
import java.beans.ConstructorProperties;

public class LaunchInstanceResponse {
    private String etag;
    private String opcRequestId;
    private String opcWorkRequestId;
    private Instance instance;

    @ConstructorProperties(value={"etag", "opcRequestId", "opcWorkRequestId", "instance"})
    LaunchInstanceResponse(String etag, String opcRequestId, String opcWorkRequestId, Instance instance) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.opcWorkRequestId = opcWorkRequestId;
        this.instance = instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private String opcWorkRequestId;
        private Instance instance;

        public Builder copy(LaunchInstanceResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.instance(o.getInstance());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder instance(Instance instance) {
            this.instance = instance;
            return this;
        }

        public LaunchInstanceResponse build() {
            return new LaunchInstanceResponse(this.etag, this.opcRequestId, this.opcWorkRequestId, this.instance);
        }

        public String toString() {
            return "LaunchInstanceResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", opcWorkRequestId=" + this.opcWorkRequestId + ", instance=" + this.instance + ")";
        }
    }
}

