/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.AppCatalogListingSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListAppCatalogListingsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<AppCatalogListingSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListAppCatalogListingsResponse(String opcNextPage, String opcRequestId, List<AppCatalogListingSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<AppCatalogListingSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<AppCatalogListingSummary> items;

        public Builder copy(ListAppCatalogListingsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<AppCatalogListingSummary> items) {
            this.items = items;
            return this;
        }

        public ListAppCatalogListingsResponse build() {
            return new ListAppCatalogListingsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListAppCatalogListingsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

