/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.BootVolumeBackup;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListBootVolumeBackupsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<BootVolumeBackup> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListBootVolumeBackupsResponse(String opcNextPage, String opcRequestId, List<BootVolumeBackup> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<BootVolumeBackup> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<BootVolumeBackup> items;

        public Builder copy(ListBootVolumeBackupsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<BootVolumeBackup> items) {
            this.items = items;
            return this;
        }

        public ListBootVolumeBackupsResponse build() {
            return new ListBootVolumeBackupsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListBootVolumeBackupsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

