/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.InstanceSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListClusterNetworkInstancesResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<InstanceSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListClusterNetworkInstancesResponse(String opcNextPage, String opcRequestId, List<InstanceSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<InstanceSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<InstanceSummary> items;

        public Builder copy(ListClusterNetworkInstancesResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<InstanceSummary> items) {
            this.items = items;
            return this;
        }

        public ListClusterNetworkInstancesResponse build() {
            return new ListClusterNetworkInstancesResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListClusterNetworkInstancesResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

