/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.Cpe;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListCpesResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<Cpe> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListCpesResponse(String opcNextPage, String opcRequestId, List<Cpe> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<Cpe> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<Cpe> items;

        public Builder copy(ListCpesResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<Cpe> items) {
            this.items = items;
            return this;
        }

        public ListCpesResponse build() {
            return new ListCpesResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListCpesResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

