/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.DhcpOptions;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListDhcpOptionsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<DhcpOptions> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListDhcpOptionsResponse(String opcNextPage, String opcRequestId, List<DhcpOptions> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<DhcpOptions> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<DhcpOptions> items;

        public Builder copy(ListDhcpOptionsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<DhcpOptions> items) {
            this.items = items;
            return this;
        }

        public ListDhcpOptionsResponse build() {
            return new ListDhcpOptionsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListDhcpOptionsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

