/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.DrgAttachment;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListDrgAttachmentsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<DrgAttachment> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListDrgAttachmentsResponse(String opcNextPage, String opcRequestId, List<DrgAttachment> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<DrgAttachment> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<DrgAttachment> items;

        public Builder copy(ListDrgAttachmentsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<DrgAttachment> items) {
            this.items = items;
            return this;
        }

        public ListDrgAttachmentsResponse build() {
            return new ListDrgAttachmentsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListDrgAttachmentsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

