/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.InstanceConsoleConnection;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListInstanceConsoleConnectionsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<InstanceConsoleConnection> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListInstanceConsoleConnectionsResponse(String opcNextPage, String opcRequestId, List<InstanceConsoleConnection> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<InstanceConsoleConnection> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<InstanceConsoleConnection> items;

        public Builder copy(ListInstanceConsoleConnectionsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<InstanceConsoleConnection> items) {
            this.items = items;
            return this;
        }

        public ListInstanceConsoleConnectionsResponse build() {
            return new ListInstanceConsoleConnectionsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListInstanceConsoleConnectionsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

