/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.InstancePoolSummary;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListInstancePoolsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<InstancePoolSummary> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListInstancePoolsResponse(String opcNextPage, String opcRequestId, List<InstancePoolSummary> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<InstancePoolSummary> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<InstancePoolSummary> items;

        public Builder copy(ListInstancePoolsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<InstancePoolSummary> items) {
            this.items = items;
            return this;
        }

        public ListInstancePoolsResponse build() {
            return new ListInstancePoolsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListInstancePoolsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

