/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.Ipv6;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListIpv6sResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<Ipv6> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListIpv6sResponse(String opcNextPage, String opcRequestId, List<Ipv6> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<Ipv6> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<Ipv6> items;

        public Builder copy(ListIpv6sResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<Ipv6> items) {
            this.items = items;
            return this;
        }

        public ListIpv6sResponse build() {
            return new ListIpv6sResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListIpv6sResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

