/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.NatGateway;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListNatGatewaysResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<NatGateway> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListNatGatewaysResponse(String opcNextPage, String opcRequestId, List<NatGateway> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<NatGateway> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<NatGateway> items;

        public Builder copy(ListNatGatewaysResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<NatGateway> items) {
            this.items = items;
            return this;
        }

        public ListNatGatewaysResponse build() {
            return new ListNatGatewaysResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListNatGatewaysResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

