/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.Service;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListServicesResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<Service> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListServicesResponse(String opcNextPage, String opcRequestId, List<Service> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<Service> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<Service> items;

        public Builder copy(ListServicesResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<Service> items) {
            this.items = items;
            return this;
        }

        public ListServicesResponse build() {
            return new ListServicesResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListServicesResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

