/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.Vcn;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListVcnsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<Vcn> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListVcnsResponse(String opcNextPage, String opcRequestId, List<Vcn> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<Vcn> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<Vcn> items;

        public Builder copy(ListVcnsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<Vcn> items) {
            this.items = items;
            return this;
        }

        public ListVcnsResponse build() {
            return new ListVcnsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListVcnsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

