/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.VirtualCircuitPublicPrefix;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListVirtualCircuitPublicPrefixesResponse {
    private String opcRequestId;
    private List<VirtualCircuitPublicPrefix> items;

    @ConstructorProperties(value={"opcRequestId", "items"})
    ListVirtualCircuitPublicPrefixesResponse(String opcRequestId, List<VirtualCircuitPublicPrefix> items) {
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<VirtualCircuitPublicPrefix> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcRequestId;
        private List<VirtualCircuitPublicPrefix> items;

        public Builder copy(ListVirtualCircuitPublicPrefixesResponse o) {
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<VirtualCircuitPublicPrefix> items) {
            this.items = items;
            return this;
        }

        public ListVirtualCircuitPublicPrefixesResponse build() {
            return new ListVirtualCircuitPublicPrefixesResponse(this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListVirtualCircuitPublicPrefixesResponse.Builder(opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

