/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.VolumeGroup;
import java.beans.ConstructorProperties;
import java.util.List;

public class ListVolumeGroupsResponse {
    private String opcNextPage;
    private String opcRequestId;
    private List<VolumeGroup> items;

    @ConstructorProperties(value={"opcNextPage", "opcRequestId", "items"})
    ListVolumeGroupsResponse(String opcNextPage, String opcRequestId, List<VolumeGroup> items) {
        this.opcNextPage = opcNextPage;
        this.opcRequestId = opcRequestId;
        this.items = items;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<VolumeGroup> getItems() {
        return this.items;
    }

    public static class Builder {
        private String opcNextPage;
        private String opcRequestId;
        private List<VolumeGroup> items;

        public Builder copy(ListVolumeGroupsResponse o) {
            this.opcNextPage(o.getOpcNextPage());
            this.opcRequestId(o.getOpcRequestId());
            this.items(o.getItems());
            return this;
        }

        Builder() {
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder items(List<VolumeGroup> items) {
            this.items = items;
            return this;
        }

        public ListVolumeGroupsResponse build() {
            return new ListVolumeGroupsResponse(this.opcNextPage, this.opcRequestId, this.items);
        }

        public String toString() {
            return "ListVolumeGroupsResponse.Builder(opcNextPage=" + this.opcNextPage + ", opcRequestId=" + this.opcRequestId + ", items=" + this.items + ")";
        }
    }
}

