/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.InstancePool;
import java.beans.ConstructorProperties;

public class SoftresetInstancePoolResponse {
    private String etag;
    private String opcRequestId;
    private InstancePool instancePool;

    @ConstructorProperties(value={"etag", "opcRequestId", "instancePool"})
    SoftresetInstancePoolResponse(String etag, String opcRequestId, InstancePool instancePool) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.instancePool = instancePool;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public InstancePool getInstancePool() {
        return this.instancePool;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private InstancePool instancePool;

        public Builder copy(SoftresetInstancePoolResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.instancePool(o.getInstancePool());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder instancePool(InstancePool instancePool) {
            this.instancePool = instancePool;
            return this;
        }

        public SoftresetInstancePoolResponse build() {
            return new SoftresetInstancePoolResponse(this.etag, this.opcRequestId, this.instancePool);
        }

        public String toString() {
            return "SoftresetInstancePoolResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", instancePool=" + this.instancePool + ")";
        }
    }
}

