/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.BootVolumeBackup;
import java.beans.ConstructorProperties;

public class UpdateBootVolumeBackupResponse {
    private String etag;
    private BootVolumeBackup bootVolumeBackup;

    @ConstructorProperties(value={"etag", "bootVolumeBackup"})
    UpdateBootVolumeBackupResponse(String etag, BootVolumeBackup bootVolumeBackup) {
        this.etag = etag;
        this.bootVolumeBackup = bootVolumeBackup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public BootVolumeBackup getBootVolumeBackup() {
        return this.bootVolumeBackup;
    }

    public static class Builder {
        private String etag;
        private BootVolumeBackup bootVolumeBackup;

        public Builder copy(UpdateBootVolumeBackupResponse o) {
            this.etag(o.getEtag());
            this.bootVolumeBackup(o.getBootVolumeBackup());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder bootVolumeBackup(BootVolumeBackup bootVolumeBackup) {
            this.bootVolumeBackup = bootVolumeBackup;
            return this;
        }

        public UpdateBootVolumeBackupResponse build() {
            return new UpdateBootVolumeBackupResponse(this.etag, this.bootVolumeBackup);
        }

        public String toString() {
            return "UpdateBootVolumeBackupResponse.Builder(etag=" + this.etag + ", bootVolumeBackup=" + this.bootVolumeBackup + ")";
        }
    }
}

