/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.BootVolume;
import java.beans.ConstructorProperties;

public class UpdateBootVolumeResponse {
    private String etag;
    private String opcRequestId;
    private BootVolume bootVolume;

    @ConstructorProperties(value={"etag", "opcRequestId", "bootVolume"})
    UpdateBootVolumeResponse(String etag, String opcRequestId, BootVolume bootVolume) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.bootVolume = bootVolume;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public BootVolume getBootVolume() {
        return this.bootVolume;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private BootVolume bootVolume;

        public Builder copy(UpdateBootVolumeResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.bootVolume(o.getBootVolume());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder bootVolume(BootVolume bootVolume) {
            this.bootVolume = bootVolume;
            return this;
        }

        public UpdateBootVolumeResponse build() {
            return new UpdateBootVolumeResponse(this.etag, this.opcRequestId, this.bootVolume);
        }

        public String toString() {
            return "UpdateBootVolumeResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", bootVolume=" + this.bootVolume + ")";
        }
    }
}

