/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.Cpe;
import java.beans.ConstructorProperties;

public class UpdateCpeResponse {
    private String etag;
    private String opcRequestId;
    private Cpe cpe;

    @ConstructorProperties(value={"etag", "opcRequestId", "cpe"})
    UpdateCpeResponse(String etag, String opcRequestId, Cpe cpe) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.cpe = cpe;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Cpe getCpe() {
        return this.cpe;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Cpe cpe;

        public Builder copy(UpdateCpeResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.cpe(o.getCpe());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder cpe(Cpe cpe) {
            this.cpe = cpe;
            return this;
        }

        public UpdateCpeResponse build() {
            return new UpdateCpeResponse(this.etag, this.opcRequestId, this.cpe);
        }

        public String toString() {
            return "UpdateCpeResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", cpe=" + this.cpe + ")";
        }
    }
}

