/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.CrossConnect;
import java.beans.ConstructorProperties;

public class UpdateCrossConnectResponse {
    private String etag;
    private String opcRequestId;
    private CrossConnect crossConnect;

    @ConstructorProperties(value={"etag", "opcRequestId", "crossConnect"})
    UpdateCrossConnectResponse(String etag, String opcRequestId, CrossConnect crossConnect) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.crossConnect = crossConnect;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public CrossConnect getCrossConnect() {
        return this.crossConnect;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private CrossConnect crossConnect;

        public Builder copy(UpdateCrossConnectResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.crossConnect(o.getCrossConnect());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder crossConnect(CrossConnect crossConnect) {
            this.crossConnect = crossConnect;
            return this;
        }

        public UpdateCrossConnectResponse build() {
            return new UpdateCrossConnectResponse(this.etag, this.opcRequestId, this.crossConnect);
        }

        public String toString() {
            return "UpdateCrossConnectResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", crossConnect=" + this.crossConnect + ")";
        }
    }
}

