/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.IPSecConnectionTunnel;
import java.beans.ConstructorProperties;

public class UpdateIPSecConnectionTunnelResponse {
    private String etag;
    private String opcRequestId;
    private IPSecConnectionTunnel iPSecConnectionTunnel;

    @ConstructorProperties(value={"etag", "opcRequestId", "iPSecConnectionTunnel"})
    UpdateIPSecConnectionTunnelResponse(String etag, String opcRequestId, IPSecConnectionTunnel iPSecConnectionTunnel) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.iPSecConnectionTunnel = iPSecConnectionTunnel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public IPSecConnectionTunnel getIPSecConnectionTunnel() {
        return this.iPSecConnectionTunnel;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private IPSecConnectionTunnel iPSecConnectionTunnel;

        public Builder copy(UpdateIPSecConnectionTunnelResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.iPSecConnectionTunnel(o.getIPSecConnectionTunnel());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder iPSecConnectionTunnel(IPSecConnectionTunnel iPSecConnectionTunnel) {
            this.iPSecConnectionTunnel = iPSecConnectionTunnel;
            return this;
        }

        public UpdateIPSecConnectionTunnelResponse build() {
            return new UpdateIPSecConnectionTunnelResponse(this.etag, this.opcRequestId, this.iPSecConnectionTunnel);
        }

        public String toString() {
            return "UpdateIPSecConnectionTunnelResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", iPSecConnectionTunnel=" + this.iPSecConnectionTunnel + ")";
        }
    }
}

