/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.Image;
import java.beans.ConstructorProperties;

public class UpdateImageResponse {
    private String etag;
    private String opcRequestId;
    private Image image;

    @ConstructorProperties(value={"etag", "opcRequestId", "image"})
    UpdateImageResponse(String etag, String opcRequestId, Image image) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.image = image;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Image getImage() {
        return this.image;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Image image;

        public Builder copy(UpdateImageResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.image(o.getImage());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder image(Image image) {
            this.image = image;
            return this;
        }

        public UpdateImageResponse build() {
            return new UpdateImageResponse(this.etag, this.opcRequestId, this.image);
        }

        public String toString() {
            return "UpdateImageResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", image=" + this.image + ")";
        }
    }
}

