/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.InstanceConfiguration;
import java.beans.ConstructorProperties;

public class UpdateInstanceConfigurationResponse {
    private String etag;
    private String opcRequestId;
    private InstanceConfiguration instanceConfiguration;

    @ConstructorProperties(value={"etag", "opcRequestId", "instanceConfiguration"})
    UpdateInstanceConfigurationResponse(String etag, String opcRequestId, InstanceConfiguration instanceConfiguration) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.instanceConfiguration = instanceConfiguration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public InstanceConfiguration getInstanceConfiguration() {
        return this.instanceConfiguration;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private InstanceConfiguration instanceConfiguration;

        public Builder copy(UpdateInstanceConfigurationResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.instanceConfiguration(o.getInstanceConfiguration());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder instanceConfiguration(InstanceConfiguration instanceConfiguration) {
            this.instanceConfiguration = instanceConfiguration;
            return this;
        }

        public UpdateInstanceConfigurationResponse build() {
            return new UpdateInstanceConfigurationResponse(this.etag, this.opcRequestId, this.instanceConfiguration);
        }

        public String toString() {
            return "UpdateInstanceConfigurationResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", instanceConfiguration=" + this.instanceConfiguration + ")";
        }
    }
}

