/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.InternetGateway;
import java.beans.ConstructorProperties;

public class UpdateInternetGatewayResponse {
    private String etag;
    private String opcRequestId;
    private InternetGateway internetGateway;

    @ConstructorProperties(value={"etag", "opcRequestId", "internetGateway"})
    UpdateInternetGatewayResponse(String etag, String opcRequestId, InternetGateway internetGateway) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.internetGateway = internetGateway;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public InternetGateway getInternetGateway() {
        return this.internetGateway;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private InternetGateway internetGateway;

        public Builder copy(UpdateInternetGatewayResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.internetGateway(o.getInternetGateway());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder internetGateway(InternetGateway internetGateway) {
            this.internetGateway = internetGateway;
            return this;
        }

        public UpdateInternetGatewayResponse build() {
            return new UpdateInternetGatewayResponse(this.etag, this.opcRequestId, this.internetGateway);
        }

        public String toString() {
            return "UpdateInternetGatewayResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", internetGateway=" + this.internetGateway + ")";
        }
    }
}

