/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.NetworkSecurityGroup;
import java.beans.ConstructorProperties;

public class UpdateNetworkSecurityGroupResponse {
    private String etag;
    private String opcRequestId;
    private NetworkSecurityGroup networkSecurityGroup;

    @ConstructorProperties(value={"etag", "opcRequestId", "networkSecurityGroup"})
    UpdateNetworkSecurityGroupResponse(String etag, String opcRequestId, NetworkSecurityGroup networkSecurityGroup) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.networkSecurityGroup = networkSecurityGroup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public NetworkSecurityGroup getNetworkSecurityGroup() {
        return this.networkSecurityGroup;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private NetworkSecurityGroup networkSecurityGroup;

        public Builder copy(UpdateNetworkSecurityGroupResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.networkSecurityGroup(o.getNetworkSecurityGroup());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder networkSecurityGroup(NetworkSecurityGroup networkSecurityGroup) {
            this.networkSecurityGroup = networkSecurityGroup;
            return this;
        }

        public UpdateNetworkSecurityGroupResponse build() {
            return new UpdateNetworkSecurityGroupResponse(this.etag, this.opcRequestId, this.networkSecurityGroup);
        }

        public String toString() {
            return "UpdateNetworkSecurityGroupResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", networkSecurityGroup=" + this.networkSecurityGroup + ")";
        }
    }
}

