/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.ServiceGateway;
import java.beans.ConstructorProperties;

public class UpdateServiceGatewayResponse {
    private String etag;
    private String opcRequestId;
    private ServiceGateway serviceGateway;

    @ConstructorProperties(value={"etag", "opcRequestId", "serviceGateway"})
    UpdateServiceGatewayResponse(String etag, String opcRequestId, ServiceGateway serviceGateway) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.serviceGateway = serviceGateway;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public ServiceGateway getServiceGateway() {
        return this.serviceGateway;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private ServiceGateway serviceGateway;

        public Builder copy(UpdateServiceGatewayResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.serviceGateway(o.getServiceGateway());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder serviceGateway(ServiceGateway serviceGateway) {
            this.serviceGateway = serviceGateway;
            return this;
        }

        public UpdateServiceGatewayResponse build() {
            return new UpdateServiceGatewayResponse(this.etag, this.opcRequestId, this.serviceGateway);
        }

        public String toString() {
            return "UpdateServiceGatewayResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", serviceGateway=" + this.serviceGateway + ")";
        }
    }
}

