/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.Subnet;
import java.beans.ConstructorProperties;

public class UpdateSubnetResponse {
    private String etag;
    private String opcRequestId;
    private Subnet subnet;

    @ConstructorProperties(value={"etag", "opcRequestId", "subnet"})
    UpdateSubnetResponse(String etag, String opcRequestId, Subnet subnet) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.subnet = subnet;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Subnet getSubnet() {
        return this.subnet;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Subnet subnet;

        public Builder copy(UpdateSubnetResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.subnet(o.getSubnet());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder subnet(Subnet subnet) {
            this.subnet = subnet;
            return this;
        }

        public UpdateSubnetResponse build() {
            return new UpdateSubnetResponse(this.etag, this.opcRequestId, this.subnet);
        }

        public String toString() {
            return "UpdateSubnetResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", subnet=" + this.subnet + ")";
        }
    }
}

