/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.Vcn;
import java.beans.ConstructorProperties;

public class UpdateVcnResponse {
    private String etag;
    private String opcRequestId;
    private Vcn vcn;

    @ConstructorProperties(value={"etag", "opcRequestId", "vcn"})
    UpdateVcnResponse(String etag, String opcRequestId, Vcn vcn) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.vcn = vcn;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Vcn getVcn() {
        return this.vcn;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Vcn vcn;

        public Builder copy(UpdateVcnResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.vcn(o.getVcn());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder vcn(Vcn vcn) {
            this.vcn = vcn;
            return this;
        }

        public UpdateVcnResponse build() {
            return new UpdateVcnResponse(this.etag, this.opcRequestId, this.vcn);
        }

        public String toString() {
            return "UpdateVcnResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", vcn=" + this.vcn + ")";
        }
    }
}

