/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.VirtualCircuit;
import java.beans.ConstructorProperties;

public class UpdateVirtualCircuitResponse {
    private String etag;
    private String opcRequestId;
    private VirtualCircuit virtualCircuit;

    @ConstructorProperties(value={"etag", "opcRequestId", "virtualCircuit"})
    UpdateVirtualCircuitResponse(String etag, String opcRequestId, VirtualCircuit virtualCircuit) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.virtualCircuit = virtualCircuit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public VirtualCircuit getVirtualCircuit() {
        return this.virtualCircuit;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private VirtualCircuit virtualCircuit;

        public Builder copy(UpdateVirtualCircuitResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.virtualCircuit(o.getVirtualCircuit());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder virtualCircuit(VirtualCircuit virtualCircuit) {
            this.virtualCircuit = virtualCircuit;
            return this;
        }

        public UpdateVirtualCircuitResponse build() {
            return new UpdateVirtualCircuitResponse(this.etag, this.opcRequestId, this.virtualCircuit);
        }

        public String toString() {
            return "UpdateVirtualCircuitResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", virtualCircuit=" + this.virtualCircuit + ")";
        }
    }
}

