/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.VolumeBackup;
import java.beans.ConstructorProperties;

public class UpdateVolumeBackupResponse {
    private String etag;
    private VolumeBackup volumeBackup;

    @ConstructorProperties(value={"etag", "volumeBackup"})
    UpdateVolumeBackupResponse(String etag, VolumeBackup volumeBackup) {
        this.etag = etag;
        this.volumeBackup = volumeBackup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public VolumeBackup getVolumeBackup() {
        return this.volumeBackup;
    }

    public static class Builder {
        private String etag;
        private VolumeBackup volumeBackup;

        public Builder copy(UpdateVolumeBackupResponse o) {
            this.etag(o.getEtag());
            this.volumeBackup(o.getVolumeBackup());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder volumeBackup(VolumeBackup volumeBackup) {
            this.volumeBackup = volumeBackup;
            return this;
        }

        public UpdateVolumeBackupResponse build() {
            return new UpdateVolumeBackupResponse(this.etag, this.volumeBackup);
        }

        public String toString() {
            return "UpdateVolumeBackupResponse.Builder(etag=" + this.etag + ", volumeBackup=" + this.volumeBackup + ")";
        }
    }
}

