/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.responses;

import com.oracle.bmc.core.model.Volume;
import java.beans.ConstructorProperties;

public class UpdateVolumeResponse {
    private String etag;
    private String opcRequestId;
    private Volume volume;

    @ConstructorProperties(value={"etag", "opcRequestId", "volume"})
    UpdateVolumeResponse(String etag, String opcRequestId, Volume volume) {
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.volume = volume;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Volume getVolume() {
        return this.volume;
    }

    public static class Builder {
        private String etag;
        private String opcRequestId;
        private Volume volume;

        public Builder copy(UpdateVolumeResponse o) {
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.volume(o.getVolume());
            return this;
        }

        Builder() {
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder volume(Volume volume) {
            this.volume = volume;
            return this;
        }

        public UpdateVolumeResponse build() {
            return new UpdateVolumeResponse(this.etag, this.opcRequestId, this.volume);
        }

        public String toString() {
            return "UpdateVolumeResponse.Builder(etag=" + this.etag + ", opcRequestId=" + this.opcRequestId + ", volume=" + this.volume + ")";
        }
    }
}

