/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.database.DatabaseAsync;
import com.oracle.bmc.database.internal.http.ActivateExadataInfrastructureConverter;
import com.oracle.bmc.database.internal.http.ChangeAutonomousContainerDatabaseCompartmentConverter;
import com.oracle.bmc.database.internal.http.ChangeAutonomousDatabaseCompartmentConverter;
import com.oracle.bmc.database.internal.http.ChangeAutonomousExadataInfrastructureCompartmentConverter;
import com.oracle.bmc.database.internal.http.ChangeBackupDestinationCompartmentConverter;
import com.oracle.bmc.database.internal.http.ChangeDbSystemCompartmentConverter;
import com.oracle.bmc.database.internal.http.ChangeExadataInfrastructureCompartmentConverter;
import com.oracle.bmc.database.internal.http.ChangeVmClusterCompartmentConverter;
import com.oracle.bmc.database.internal.http.CompleteExternalBackupJobConverter;
import com.oracle.bmc.database.internal.http.CreateAutonomousContainerDatabaseConverter;
import com.oracle.bmc.database.internal.http.CreateAutonomousDataWarehouseBackupConverter;
import com.oracle.bmc.database.internal.http.CreateAutonomousDataWarehouseConverter;
import com.oracle.bmc.database.internal.http.CreateAutonomousDatabaseBackupConverter;
import com.oracle.bmc.database.internal.http.CreateAutonomousDatabaseConverter;
import com.oracle.bmc.database.internal.http.CreateBackupConverter;
import com.oracle.bmc.database.internal.http.CreateBackupDestinationConverter;
import com.oracle.bmc.database.internal.http.CreateDataGuardAssociationConverter;
import com.oracle.bmc.database.internal.http.CreateDbHomeConverter;
import com.oracle.bmc.database.internal.http.CreateExadataInfrastructureConverter;
import com.oracle.bmc.database.internal.http.CreateExternalBackupJobConverter;
import com.oracle.bmc.database.internal.http.CreateVmClusterConverter;
import com.oracle.bmc.database.internal.http.CreateVmClusterNetworkConverter;
import com.oracle.bmc.database.internal.http.DbNodeActionConverter;
import com.oracle.bmc.database.internal.http.DeleteAutonomousDataWarehouseConverter;
import com.oracle.bmc.database.internal.http.DeleteAutonomousDatabaseConverter;
import com.oracle.bmc.database.internal.http.DeleteBackupConverter;
import com.oracle.bmc.database.internal.http.DeleteBackupDestinationConverter;
import com.oracle.bmc.database.internal.http.DeleteDbHomeConverter;
import com.oracle.bmc.database.internal.http.DeleteExadataInfrastructureConverter;
import com.oracle.bmc.database.internal.http.DeleteVmClusterConverter;
import com.oracle.bmc.database.internal.http.DeleteVmClusterNetworkConverter;
import com.oracle.bmc.database.internal.http.DownloadExadataInfrastructureConfigFileConverter;
import com.oracle.bmc.database.internal.http.DownloadVmClusterNetworkConfigFileConverter;
import com.oracle.bmc.database.internal.http.FailoverDataGuardAssociationConverter;
import com.oracle.bmc.database.internal.http.GenerateAutonomousDataWarehouseWalletConverter;
import com.oracle.bmc.database.internal.http.GenerateAutonomousDatabaseWalletConverter;
import com.oracle.bmc.database.internal.http.GenerateRecommendedVmClusterNetworkConverter;
import com.oracle.bmc.database.internal.http.GetAutonomousContainerDatabaseConverter;
import com.oracle.bmc.database.internal.http.GetAutonomousDataWarehouseBackupConverter;
import com.oracle.bmc.database.internal.http.GetAutonomousDataWarehouseConverter;
import com.oracle.bmc.database.internal.http.GetAutonomousDatabaseBackupConverter;
import com.oracle.bmc.database.internal.http.GetAutonomousDatabaseConverter;
import com.oracle.bmc.database.internal.http.GetAutonomousExadataInfrastructureConverter;
import com.oracle.bmc.database.internal.http.GetBackupConverter;
import com.oracle.bmc.database.internal.http.GetBackupDestinationConverter;
import com.oracle.bmc.database.internal.http.GetDataGuardAssociationConverter;
import com.oracle.bmc.database.internal.http.GetDatabaseConverter;
import com.oracle.bmc.database.internal.http.GetDbHomeConverter;
import com.oracle.bmc.database.internal.http.GetDbHomePatchConverter;
import com.oracle.bmc.database.internal.http.GetDbHomePatchHistoryEntryConverter;
import com.oracle.bmc.database.internal.http.GetDbNodeConverter;
import com.oracle.bmc.database.internal.http.GetDbSystemConverter;
import com.oracle.bmc.database.internal.http.GetDbSystemPatchConverter;
import com.oracle.bmc.database.internal.http.GetDbSystemPatchHistoryEntryConverter;
import com.oracle.bmc.database.internal.http.GetExadataInfrastructureConverter;
import com.oracle.bmc.database.internal.http.GetExadataIormConfigConverter;
import com.oracle.bmc.database.internal.http.GetExternalBackupJobConverter;
import com.oracle.bmc.database.internal.http.GetMaintenanceRunConverter;
import com.oracle.bmc.database.internal.http.GetVmClusterConverter;
import com.oracle.bmc.database.internal.http.GetVmClusterNetworkConverter;
import com.oracle.bmc.database.internal.http.LaunchAutonomousExadataInfrastructureConverter;
import com.oracle.bmc.database.internal.http.LaunchDbSystemConverter;
import com.oracle.bmc.database.internal.http.ListAutonomousContainerDatabasesConverter;
import com.oracle.bmc.database.internal.http.ListAutonomousDataWarehouseBackupsConverter;
import com.oracle.bmc.database.internal.http.ListAutonomousDataWarehousesConverter;
import com.oracle.bmc.database.internal.http.ListAutonomousDatabaseBackupsConverter;
import com.oracle.bmc.database.internal.http.ListAutonomousDatabasesConverter;
import com.oracle.bmc.database.internal.http.ListAutonomousDbPreviewVersionsConverter;
import com.oracle.bmc.database.internal.http.ListAutonomousExadataInfrastructureShapesConverter;
import com.oracle.bmc.database.internal.http.ListAutonomousExadataInfrastructuresConverter;
import com.oracle.bmc.database.internal.http.ListBackupDestinationConverter;
import com.oracle.bmc.database.internal.http.ListBackupsConverter;
import com.oracle.bmc.database.internal.http.ListDataGuardAssociationsConverter;
import com.oracle.bmc.database.internal.http.ListDatabasesConverter;
import com.oracle.bmc.database.internal.http.ListDbHomePatchHistoryEntriesConverter;
import com.oracle.bmc.database.internal.http.ListDbHomePatchesConverter;
import com.oracle.bmc.database.internal.http.ListDbHomesConverter;
import com.oracle.bmc.database.internal.http.ListDbNodesConverter;
import com.oracle.bmc.database.internal.http.ListDbSystemPatchHistoryEntriesConverter;
import com.oracle.bmc.database.internal.http.ListDbSystemPatchesConverter;
import com.oracle.bmc.database.internal.http.ListDbSystemShapesConverter;
import com.oracle.bmc.database.internal.http.ListDbSystemsConverter;
import com.oracle.bmc.database.internal.http.ListDbVersionsConverter;
import com.oracle.bmc.database.internal.http.ListExadataInfrastructuresConverter;
import com.oracle.bmc.database.internal.http.ListGiVersionsConverter;
import com.oracle.bmc.database.internal.http.ListMaintenanceRunsConverter;
import com.oracle.bmc.database.internal.http.ListVmClusterNetworksConverter;
import com.oracle.bmc.database.internal.http.ListVmClustersConverter;
import com.oracle.bmc.database.internal.http.ReinstateDataGuardAssociationConverter;
import com.oracle.bmc.database.internal.http.RestartAutonomousContainerDatabaseConverter;
import com.oracle.bmc.database.internal.http.RestoreAutonomousDataWarehouseConverter;
import com.oracle.bmc.database.internal.http.RestoreAutonomousDatabaseConverter;
import com.oracle.bmc.database.internal.http.RestoreDatabaseConverter;
import com.oracle.bmc.database.internal.http.StartAutonomousDataWarehouseConverter;
import com.oracle.bmc.database.internal.http.StartAutonomousDatabaseConverter;
import com.oracle.bmc.database.internal.http.StopAutonomousDataWarehouseConverter;
import com.oracle.bmc.database.internal.http.StopAutonomousDatabaseConverter;
import com.oracle.bmc.database.internal.http.SwitchoverDataGuardAssociationConverter;
import com.oracle.bmc.database.internal.http.TerminateAutonomousContainerDatabaseConverter;
import com.oracle.bmc.database.internal.http.TerminateAutonomousExadataInfrastructureConverter;
import com.oracle.bmc.database.internal.http.TerminateDbSystemConverter;
import com.oracle.bmc.database.internal.http.UpdateAutonomousContainerDatabaseConverter;
import com.oracle.bmc.database.internal.http.UpdateAutonomousDataWarehouseConverter;
import com.oracle.bmc.database.internal.http.UpdateAutonomousDatabaseConverter;
import com.oracle.bmc.database.internal.http.UpdateAutonomousExadataInfrastructureConverter;
import com.oracle.bmc.database.internal.http.UpdateBackupDestinationConverter;
import com.oracle.bmc.database.internal.http.UpdateDatabaseConverter;
import com.oracle.bmc.database.internal.http.UpdateDbHomeConverter;
import com.oracle.bmc.database.internal.http.UpdateDbSystemConverter;
import com.oracle.bmc.database.internal.http.UpdateExadataInfrastructureConverter;
import com.oracle.bmc.database.internal.http.UpdateExadataIormConfigConverter;
import com.oracle.bmc.database.internal.http.UpdateMaintenanceRunConverter;
import com.oracle.bmc.database.internal.http.UpdateVmClusterConverter;
import com.oracle.bmc.database.internal.http.UpdateVmClusterNetworkConverter;
import com.oracle.bmc.database.internal.http.ValidateVmClusterNetworkConverter;
import com.oracle.bmc.database.requests.ActivateExadataInfrastructureRequest;
import com.oracle.bmc.database.requests.ChangeAutonomousContainerDatabaseCompartmentRequest;
import com.oracle.bmc.database.requests.ChangeAutonomousDatabaseCompartmentRequest;
import com.oracle.bmc.database.requests.ChangeAutonomousExadataInfrastructureCompartmentRequest;
import com.oracle.bmc.database.requests.ChangeBackupDestinationCompartmentRequest;
import com.oracle.bmc.database.requests.ChangeDbSystemCompartmentRequest;
import com.oracle.bmc.database.requests.ChangeExadataInfrastructureCompartmentRequest;
import com.oracle.bmc.database.requests.ChangeVmClusterCompartmentRequest;
import com.oracle.bmc.database.requests.CompleteExternalBackupJobRequest;
import com.oracle.bmc.database.requests.CreateAutonomousContainerDatabaseRequest;
import com.oracle.bmc.database.requests.CreateAutonomousDataWarehouseBackupRequest;
import com.oracle.bmc.database.requests.CreateAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.requests.CreateAutonomousDatabaseBackupRequest;
import com.oracle.bmc.database.requests.CreateAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.CreateBackupDestinationRequest;
import com.oracle.bmc.database.requests.CreateBackupRequest;
import com.oracle.bmc.database.requests.CreateDataGuardAssociationRequest;
import com.oracle.bmc.database.requests.CreateDbHomeRequest;
import com.oracle.bmc.database.requests.CreateExadataInfrastructureRequest;
import com.oracle.bmc.database.requests.CreateExternalBackupJobRequest;
import com.oracle.bmc.database.requests.CreateVmClusterNetworkRequest;
import com.oracle.bmc.database.requests.CreateVmClusterRequest;
import com.oracle.bmc.database.requests.DbNodeActionRequest;
import com.oracle.bmc.database.requests.DeleteAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.requests.DeleteAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.DeleteBackupDestinationRequest;
import com.oracle.bmc.database.requests.DeleteBackupRequest;
import com.oracle.bmc.database.requests.DeleteDbHomeRequest;
import com.oracle.bmc.database.requests.DeleteExadataInfrastructureRequest;
import com.oracle.bmc.database.requests.DeleteVmClusterNetworkRequest;
import com.oracle.bmc.database.requests.DeleteVmClusterRequest;
import com.oracle.bmc.database.requests.DownloadExadataInfrastructureConfigFileRequest;
import com.oracle.bmc.database.requests.DownloadVmClusterNetworkConfigFileRequest;
import com.oracle.bmc.database.requests.FailoverDataGuardAssociationRequest;
import com.oracle.bmc.database.requests.GenerateAutonomousDataWarehouseWalletRequest;
import com.oracle.bmc.database.requests.GenerateAutonomousDatabaseWalletRequest;
import com.oracle.bmc.database.requests.GenerateRecommendedVmClusterNetworkRequest;
import com.oracle.bmc.database.requests.GetAutonomousContainerDatabaseRequest;
import com.oracle.bmc.database.requests.GetAutonomousDataWarehouseBackupRequest;
import com.oracle.bmc.database.requests.GetAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.requests.GetAutonomousDatabaseBackupRequest;
import com.oracle.bmc.database.requests.GetAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.GetAutonomousExadataInfrastructureRequest;
import com.oracle.bmc.database.requests.GetBackupDestinationRequest;
import com.oracle.bmc.database.requests.GetBackupRequest;
import com.oracle.bmc.database.requests.GetDataGuardAssociationRequest;
import com.oracle.bmc.database.requests.GetDatabaseRequest;
import com.oracle.bmc.database.requests.GetDbHomePatchHistoryEntryRequest;
import com.oracle.bmc.database.requests.GetDbHomePatchRequest;
import com.oracle.bmc.database.requests.GetDbHomeRequest;
import com.oracle.bmc.database.requests.GetDbNodeRequest;
import com.oracle.bmc.database.requests.GetDbSystemPatchHistoryEntryRequest;
import com.oracle.bmc.database.requests.GetDbSystemPatchRequest;
import com.oracle.bmc.database.requests.GetDbSystemRequest;
import com.oracle.bmc.database.requests.GetExadataInfrastructureRequest;
import com.oracle.bmc.database.requests.GetExadataIormConfigRequest;
import com.oracle.bmc.database.requests.GetExternalBackupJobRequest;
import com.oracle.bmc.database.requests.GetMaintenanceRunRequest;
import com.oracle.bmc.database.requests.GetVmClusterNetworkRequest;
import com.oracle.bmc.database.requests.GetVmClusterRequest;
import com.oracle.bmc.database.requests.LaunchAutonomousExadataInfrastructureRequest;
import com.oracle.bmc.database.requests.LaunchDbSystemRequest;
import com.oracle.bmc.database.requests.ListAutonomousContainerDatabasesRequest;
import com.oracle.bmc.database.requests.ListAutonomousDataWarehouseBackupsRequest;
import com.oracle.bmc.database.requests.ListAutonomousDataWarehousesRequest;
import com.oracle.bmc.database.requests.ListAutonomousDatabaseBackupsRequest;
import com.oracle.bmc.database.requests.ListAutonomousDatabasesRequest;
import com.oracle.bmc.database.requests.ListAutonomousDbPreviewVersionsRequest;
import com.oracle.bmc.database.requests.ListAutonomousExadataInfrastructureShapesRequest;
import com.oracle.bmc.database.requests.ListAutonomousExadataInfrastructuresRequest;
import com.oracle.bmc.database.requests.ListBackupDestinationRequest;
import com.oracle.bmc.database.requests.ListBackupsRequest;
import com.oracle.bmc.database.requests.ListDataGuardAssociationsRequest;
import com.oracle.bmc.database.requests.ListDatabasesRequest;
import com.oracle.bmc.database.requests.ListDbHomePatchHistoryEntriesRequest;
import com.oracle.bmc.database.requests.ListDbHomePatchesRequest;
import com.oracle.bmc.database.requests.ListDbHomesRequest;
import com.oracle.bmc.database.requests.ListDbNodesRequest;
import com.oracle.bmc.database.requests.ListDbSystemPatchHistoryEntriesRequest;
import com.oracle.bmc.database.requests.ListDbSystemPatchesRequest;
import com.oracle.bmc.database.requests.ListDbSystemShapesRequest;
import com.oracle.bmc.database.requests.ListDbSystemsRequest;
import com.oracle.bmc.database.requests.ListDbVersionsRequest;
import com.oracle.bmc.database.requests.ListExadataInfrastructuresRequest;
import com.oracle.bmc.database.requests.ListGiVersionsRequest;
import com.oracle.bmc.database.requests.ListMaintenanceRunsRequest;
import com.oracle.bmc.database.requests.ListVmClusterNetworksRequest;
import com.oracle.bmc.database.requests.ListVmClustersRequest;
import com.oracle.bmc.database.requests.ReinstateDataGuardAssociationRequest;
import com.oracle.bmc.database.requests.RestartAutonomousContainerDatabaseRequest;
import com.oracle.bmc.database.requests.RestoreAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.requests.RestoreAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.RestoreDatabaseRequest;
import com.oracle.bmc.database.requests.StartAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.requests.StartAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.StopAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.requests.StopAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.SwitchoverDataGuardAssociationRequest;
import com.oracle.bmc.database.requests.TerminateAutonomousContainerDatabaseRequest;
import com.oracle.bmc.database.requests.TerminateAutonomousExadataInfrastructureRequest;
import com.oracle.bmc.database.requests.TerminateDbSystemRequest;
import com.oracle.bmc.database.requests.UpdateAutonomousContainerDatabaseRequest;
import com.oracle.bmc.database.requests.UpdateAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.requests.UpdateAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.UpdateAutonomousExadataInfrastructureRequest;
import com.oracle.bmc.database.requests.UpdateBackupDestinationRequest;
import com.oracle.bmc.database.requests.UpdateDatabaseRequest;
import com.oracle.bmc.database.requests.UpdateDbHomeRequest;
import com.oracle.bmc.database.requests.UpdateDbSystemRequest;
import com.oracle.bmc.database.requests.UpdateExadataInfrastructureRequest;
import com.oracle.bmc.database.requests.UpdateExadataIormConfigRequest;
import com.oracle.bmc.database.requests.UpdateMaintenanceRunRequest;
import com.oracle.bmc.database.requests.UpdateVmClusterNetworkRequest;
import com.oracle.bmc.database.requests.UpdateVmClusterRequest;
import com.oracle.bmc.database.requests.ValidateVmClusterNetworkRequest;
import com.oracle.bmc.database.responses.ActivateExadataInfrastructureResponse;
import com.oracle.bmc.database.responses.ChangeAutonomousContainerDatabaseCompartmentResponse;
import com.oracle.bmc.database.responses.ChangeAutonomousDatabaseCompartmentResponse;
import com.oracle.bmc.database.responses.ChangeAutonomousExadataInfrastructureCompartmentResponse;
import com.oracle.bmc.database.responses.ChangeBackupDestinationCompartmentResponse;
import com.oracle.bmc.database.responses.ChangeDbSystemCompartmentResponse;
import com.oracle.bmc.database.responses.ChangeExadataInfrastructureCompartmentResponse;
import com.oracle.bmc.database.responses.ChangeVmClusterCompartmentResponse;
import com.oracle.bmc.database.responses.CompleteExternalBackupJobResponse;
import com.oracle.bmc.database.responses.CreateAutonomousContainerDatabaseResponse;
import com.oracle.bmc.database.responses.CreateAutonomousDataWarehouseBackupResponse;
import com.oracle.bmc.database.responses.CreateAutonomousDataWarehouseResponse;
import com.oracle.bmc.database.responses.CreateAutonomousDatabaseBackupResponse;
import com.oracle.bmc.database.responses.CreateAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.CreateBackupDestinationResponse;
import com.oracle.bmc.database.responses.CreateBackupResponse;
import com.oracle.bmc.database.responses.CreateDataGuardAssociationResponse;
import com.oracle.bmc.database.responses.CreateDbHomeResponse;
import com.oracle.bmc.database.responses.CreateExadataInfrastructureResponse;
import com.oracle.bmc.database.responses.CreateExternalBackupJobResponse;
import com.oracle.bmc.database.responses.CreateVmClusterNetworkResponse;
import com.oracle.bmc.database.responses.CreateVmClusterResponse;
import com.oracle.bmc.database.responses.DbNodeActionResponse;
import com.oracle.bmc.database.responses.DeleteAutonomousDataWarehouseResponse;
import com.oracle.bmc.database.responses.DeleteAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.DeleteBackupDestinationResponse;
import com.oracle.bmc.database.responses.DeleteBackupResponse;
import com.oracle.bmc.database.responses.DeleteDbHomeResponse;
import com.oracle.bmc.database.responses.DeleteExadataInfrastructureResponse;
import com.oracle.bmc.database.responses.DeleteVmClusterNetworkResponse;
import com.oracle.bmc.database.responses.DeleteVmClusterResponse;
import com.oracle.bmc.database.responses.DownloadExadataInfrastructureConfigFileResponse;
import com.oracle.bmc.database.responses.DownloadVmClusterNetworkConfigFileResponse;
import com.oracle.bmc.database.responses.FailoverDataGuardAssociationResponse;
import com.oracle.bmc.database.responses.GenerateAutonomousDataWarehouseWalletResponse;
import com.oracle.bmc.database.responses.GenerateAutonomousDatabaseWalletResponse;
import com.oracle.bmc.database.responses.GenerateRecommendedVmClusterNetworkResponse;
import com.oracle.bmc.database.responses.GetAutonomousContainerDatabaseResponse;
import com.oracle.bmc.database.responses.GetAutonomousDataWarehouseBackupResponse;
import com.oracle.bmc.database.responses.GetAutonomousDataWarehouseResponse;
import com.oracle.bmc.database.responses.GetAutonomousDatabaseBackupResponse;
import com.oracle.bmc.database.responses.GetAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.GetAutonomousExadataInfrastructureResponse;
import com.oracle.bmc.database.responses.GetBackupDestinationResponse;
import com.oracle.bmc.database.responses.GetBackupResponse;
import com.oracle.bmc.database.responses.GetDataGuardAssociationResponse;
import com.oracle.bmc.database.responses.GetDatabaseResponse;
import com.oracle.bmc.database.responses.GetDbHomePatchHistoryEntryResponse;
import com.oracle.bmc.database.responses.GetDbHomePatchResponse;
import com.oracle.bmc.database.responses.GetDbHomeResponse;
import com.oracle.bmc.database.responses.GetDbNodeResponse;
import com.oracle.bmc.database.responses.GetDbSystemPatchHistoryEntryResponse;
import com.oracle.bmc.database.responses.GetDbSystemPatchResponse;
import com.oracle.bmc.database.responses.GetDbSystemResponse;
import com.oracle.bmc.database.responses.GetExadataInfrastructureResponse;
import com.oracle.bmc.database.responses.GetExadataIormConfigResponse;
import com.oracle.bmc.database.responses.GetExternalBackupJobResponse;
import com.oracle.bmc.database.responses.GetMaintenanceRunResponse;
import com.oracle.bmc.database.responses.GetVmClusterNetworkResponse;
import com.oracle.bmc.database.responses.GetVmClusterResponse;
import com.oracle.bmc.database.responses.LaunchAutonomousExadataInfrastructureResponse;
import com.oracle.bmc.database.responses.LaunchDbSystemResponse;
import com.oracle.bmc.database.responses.ListAutonomousContainerDatabasesResponse;
import com.oracle.bmc.database.responses.ListAutonomousDataWarehouseBackupsResponse;
import com.oracle.bmc.database.responses.ListAutonomousDataWarehousesResponse;
import com.oracle.bmc.database.responses.ListAutonomousDatabaseBackupsResponse;
import com.oracle.bmc.database.responses.ListAutonomousDatabasesResponse;
import com.oracle.bmc.database.responses.ListAutonomousDbPreviewVersionsResponse;
import com.oracle.bmc.database.responses.ListAutonomousExadataInfrastructureShapesResponse;
import com.oracle.bmc.database.responses.ListAutonomousExadataInfrastructuresResponse;
import com.oracle.bmc.database.responses.ListBackupDestinationResponse;
import com.oracle.bmc.database.responses.ListBackupsResponse;
import com.oracle.bmc.database.responses.ListDataGuardAssociationsResponse;
import com.oracle.bmc.database.responses.ListDatabasesResponse;
import com.oracle.bmc.database.responses.ListDbHomePatchHistoryEntriesResponse;
import com.oracle.bmc.database.responses.ListDbHomePatchesResponse;
import com.oracle.bmc.database.responses.ListDbHomesResponse;
import com.oracle.bmc.database.responses.ListDbNodesResponse;
import com.oracle.bmc.database.responses.ListDbSystemPatchHistoryEntriesResponse;
import com.oracle.bmc.database.responses.ListDbSystemPatchesResponse;
import com.oracle.bmc.database.responses.ListDbSystemShapesResponse;
import com.oracle.bmc.database.responses.ListDbSystemsResponse;
import com.oracle.bmc.database.responses.ListDbVersionsResponse;
import com.oracle.bmc.database.responses.ListExadataInfrastructuresResponse;
import com.oracle.bmc.database.responses.ListGiVersionsResponse;
import com.oracle.bmc.database.responses.ListMaintenanceRunsResponse;
import com.oracle.bmc.database.responses.ListVmClusterNetworksResponse;
import com.oracle.bmc.database.responses.ListVmClustersResponse;
import com.oracle.bmc.database.responses.ReinstateDataGuardAssociationResponse;
import com.oracle.bmc.database.responses.RestartAutonomousContainerDatabaseResponse;
import com.oracle.bmc.database.responses.RestoreAutonomousDataWarehouseResponse;
import com.oracle.bmc.database.responses.RestoreAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.RestoreDatabaseResponse;
import com.oracle.bmc.database.responses.StartAutonomousDataWarehouseResponse;
import com.oracle.bmc.database.responses.StartAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.StopAutonomousDataWarehouseResponse;
import com.oracle.bmc.database.responses.StopAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.SwitchoverDataGuardAssociationResponse;
import com.oracle.bmc.database.responses.TerminateAutonomousContainerDatabaseResponse;
import com.oracle.bmc.database.responses.TerminateAutonomousExadataInfrastructureResponse;
import com.oracle.bmc.database.responses.TerminateDbSystemResponse;
import com.oracle.bmc.database.responses.UpdateAutonomousContainerDatabaseResponse;
import com.oracle.bmc.database.responses.UpdateAutonomousDataWarehouseResponse;
import com.oracle.bmc.database.responses.UpdateAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.UpdateAutonomousExadataInfrastructureResponse;
import com.oracle.bmc.database.responses.UpdateBackupDestinationResponse;
import com.oracle.bmc.database.responses.UpdateDatabaseResponse;
import com.oracle.bmc.database.responses.UpdateDbHomeResponse;
import com.oracle.bmc.database.responses.UpdateDbSystemResponse;
import com.oracle.bmc.database.responses.UpdateExadataInfrastructureResponse;
import com.oracle.bmc.database.responses.UpdateExadataIormConfigResponse;
import com.oracle.bmc.database.responses.UpdateMaintenanceRunResponse;
import com.oracle.bmc.database.responses.UpdateVmClusterNetworkResponse;
import com.oracle.bmc.database.responses.UpdateVmClusterResponse;
import com.oracle.bmc.database.responses.ValidateVmClusterNetworkResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.ErrorConsumer;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.SuccessConsumer;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenTransformingFuture;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrappingAsyncHandler;
import com.oracle.bmc.util.internal.TransformingFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseAsyncClient
implements DatabaseAsync {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATABASE").serviceEndpointPrefix("database").serviceEndpointTemplate("https://database.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public DatabaseAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DatabaseAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DatabaseAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DatabaseAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DatabaseAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DatabaseAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DatabaseAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ActivateExadataInfrastructureResponse> activateExadataInfrastructure(ActivateExadataInfrastructureRequest request, AsyncHandler<ActivateExadataInfrastructureRequest, ActivateExadataInfrastructureResponse> handler) {
        LOG.trace("Called async activateExadataInfrastructure");
        final ActivateExadataInfrastructureRequest interceptedRequest = ActivateExadataInfrastructureConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ActivateExadataInfrastructureConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ActivateExadataInfrastructureResponse> transformer = ActivateExadataInfrastructureConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ActivateExadataInfrastructureRequest, ActivateExadataInfrastructureResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ActivateExadataInfrastructureRequest, ActivateExadataInfrastructureResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ActivateExadataInfrastructureRequest, ActivateExadataInfrastructureResponse> onSuccess = new SuccessConsumer<ActivateExadataInfrastructureRequest, ActivateExadataInfrastructureResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ActivateExadataInfrastructureRequest> onError = new ErrorConsumer<ActivateExadataInfrastructureRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getActivateExadataInfrastructureDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ActivateExadataInfrastructureRequest, ActivateExadataInfrastructureResponse> onSuccess = handler == null ? null : new SuccessConsumer<ActivateExadataInfrastructureRequest, ActivateExadataInfrastructureResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ActivateExadataInfrastructureRequest> onError = handler == null ? null : new ErrorConsumer<ActivateExadataInfrastructureRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getActivateExadataInfrastructureDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ActivateExadataInfrastructureResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getActivateExadataInfrastructureDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ActivateExadataInfrastructureResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeAutonomousContainerDatabaseCompartmentResponse> changeAutonomousContainerDatabaseCompartment(ChangeAutonomousContainerDatabaseCompartmentRequest request, AsyncHandler<ChangeAutonomousContainerDatabaseCompartmentRequest, ChangeAutonomousContainerDatabaseCompartmentResponse> handler) {
        LOG.trace("Called async changeAutonomousContainerDatabaseCompartment");
        final ChangeAutonomousContainerDatabaseCompartmentRequest interceptedRequest = ChangeAutonomousContainerDatabaseCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeAutonomousContainerDatabaseCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeAutonomousContainerDatabaseCompartmentResponse> transformer = ChangeAutonomousContainerDatabaseCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeAutonomousContainerDatabaseCompartmentRequest, ChangeAutonomousContainerDatabaseCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeAutonomousContainerDatabaseCompartmentRequest, ChangeAutonomousContainerDatabaseCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeAutonomousContainerDatabaseCompartmentRequest, ChangeAutonomousContainerDatabaseCompartmentResponse> onSuccess = new SuccessConsumer<ChangeAutonomousContainerDatabaseCompartmentRequest, ChangeAutonomousContainerDatabaseCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeAutonomousContainerDatabaseCompartmentRequest> onError = new ErrorConsumer<ChangeAutonomousContainerDatabaseCompartmentRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getChangeCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeAutonomousContainerDatabaseCompartmentRequest, ChangeAutonomousContainerDatabaseCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeAutonomousContainerDatabaseCompartmentRequest, ChangeAutonomousContainerDatabaseCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeAutonomousContainerDatabaseCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeAutonomousContainerDatabaseCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeAutonomousContainerDatabaseCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getChangeCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeAutonomousContainerDatabaseCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeAutonomousDatabaseCompartmentResponse> changeAutonomousDatabaseCompartment(ChangeAutonomousDatabaseCompartmentRequest request, AsyncHandler<ChangeAutonomousDatabaseCompartmentRequest, ChangeAutonomousDatabaseCompartmentResponse> handler) {
        LOG.trace("Called async changeAutonomousDatabaseCompartment");
        final ChangeAutonomousDatabaseCompartmentRequest interceptedRequest = ChangeAutonomousDatabaseCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeAutonomousDatabaseCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeAutonomousDatabaseCompartmentResponse> transformer = ChangeAutonomousDatabaseCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeAutonomousDatabaseCompartmentRequest, ChangeAutonomousDatabaseCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeAutonomousDatabaseCompartmentRequest, ChangeAutonomousDatabaseCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeAutonomousDatabaseCompartmentRequest, ChangeAutonomousDatabaseCompartmentResponse> onSuccess = new SuccessConsumer<ChangeAutonomousDatabaseCompartmentRequest, ChangeAutonomousDatabaseCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeAutonomousDatabaseCompartmentRequest> onError = new ErrorConsumer<ChangeAutonomousDatabaseCompartmentRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getChangeCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeAutonomousDatabaseCompartmentRequest, ChangeAutonomousDatabaseCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeAutonomousDatabaseCompartmentRequest, ChangeAutonomousDatabaseCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeAutonomousDatabaseCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeAutonomousDatabaseCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeAutonomousDatabaseCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getChangeCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeAutonomousDatabaseCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeAutonomousExadataInfrastructureCompartmentResponse> changeAutonomousExadataInfrastructureCompartment(ChangeAutonomousExadataInfrastructureCompartmentRequest request, AsyncHandler<ChangeAutonomousExadataInfrastructureCompartmentRequest, ChangeAutonomousExadataInfrastructureCompartmentResponse> handler) {
        LOG.trace("Called async changeAutonomousExadataInfrastructureCompartment");
        final ChangeAutonomousExadataInfrastructureCompartmentRequest interceptedRequest = ChangeAutonomousExadataInfrastructureCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeAutonomousExadataInfrastructureCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeAutonomousExadataInfrastructureCompartmentResponse> transformer = ChangeAutonomousExadataInfrastructureCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeAutonomousExadataInfrastructureCompartmentRequest, ChangeAutonomousExadataInfrastructureCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeAutonomousExadataInfrastructureCompartmentRequest, ChangeAutonomousExadataInfrastructureCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeAutonomousExadataInfrastructureCompartmentRequest, ChangeAutonomousExadataInfrastructureCompartmentResponse> onSuccess = new SuccessConsumer<ChangeAutonomousExadataInfrastructureCompartmentRequest, ChangeAutonomousExadataInfrastructureCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeAutonomousExadataInfrastructureCompartmentRequest> onError = new ErrorConsumer<ChangeAutonomousExadataInfrastructureCompartmentRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getChangeCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeAutonomousExadataInfrastructureCompartmentRequest, ChangeAutonomousExadataInfrastructureCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeAutonomousExadataInfrastructureCompartmentRequest, ChangeAutonomousExadataInfrastructureCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeAutonomousExadataInfrastructureCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeAutonomousExadataInfrastructureCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeAutonomousExadataInfrastructureCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getChangeCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeAutonomousExadataInfrastructureCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeBackupDestinationCompartmentResponse> changeBackupDestinationCompartment(ChangeBackupDestinationCompartmentRequest request, AsyncHandler<ChangeBackupDestinationCompartmentRequest, ChangeBackupDestinationCompartmentResponse> handler) {
        LOG.trace("Called async changeBackupDestinationCompartment");
        final ChangeBackupDestinationCompartmentRequest interceptedRequest = ChangeBackupDestinationCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeBackupDestinationCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeBackupDestinationCompartmentResponse> transformer = ChangeBackupDestinationCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeBackupDestinationCompartmentRequest, ChangeBackupDestinationCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeBackupDestinationCompartmentRequest, ChangeBackupDestinationCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeBackupDestinationCompartmentRequest, ChangeBackupDestinationCompartmentResponse> onSuccess = new SuccessConsumer<ChangeBackupDestinationCompartmentRequest, ChangeBackupDestinationCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeBackupDestinationCompartmentRequest> onError = new ErrorConsumer<ChangeBackupDestinationCompartmentRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getChangeCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeBackupDestinationCompartmentRequest, ChangeBackupDestinationCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeBackupDestinationCompartmentRequest, ChangeBackupDestinationCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeBackupDestinationCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeBackupDestinationCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeBackupDestinationCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getChangeCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeBackupDestinationCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeDbSystemCompartmentResponse> changeDbSystemCompartment(ChangeDbSystemCompartmentRequest request, AsyncHandler<ChangeDbSystemCompartmentRequest, ChangeDbSystemCompartmentResponse> handler) {
        LOG.trace("Called async changeDbSystemCompartment");
        final ChangeDbSystemCompartmentRequest interceptedRequest = ChangeDbSystemCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeDbSystemCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeDbSystemCompartmentResponse> transformer = ChangeDbSystemCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeDbSystemCompartmentRequest, ChangeDbSystemCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeDbSystemCompartmentRequest, ChangeDbSystemCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeDbSystemCompartmentRequest, ChangeDbSystemCompartmentResponse> onSuccess = new SuccessConsumer<ChangeDbSystemCompartmentRequest, ChangeDbSystemCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeDbSystemCompartmentRequest> onError = new ErrorConsumer<ChangeDbSystemCompartmentRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getChangeCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeDbSystemCompartmentRequest, ChangeDbSystemCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeDbSystemCompartmentRequest, ChangeDbSystemCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeDbSystemCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeDbSystemCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeDbSystemCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getChangeCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeDbSystemCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeExadataInfrastructureCompartmentResponse> changeExadataInfrastructureCompartment(ChangeExadataInfrastructureCompartmentRequest request, AsyncHandler<ChangeExadataInfrastructureCompartmentRequest, ChangeExadataInfrastructureCompartmentResponse> handler) {
        LOG.trace("Called async changeExadataInfrastructureCompartment");
        final ChangeExadataInfrastructureCompartmentRequest interceptedRequest = ChangeExadataInfrastructureCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeExadataInfrastructureCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeExadataInfrastructureCompartmentResponse> transformer = ChangeExadataInfrastructureCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeExadataInfrastructureCompartmentRequest, ChangeExadataInfrastructureCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeExadataInfrastructureCompartmentRequest, ChangeExadataInfrastructureCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeExadataInfrastructureCompartmentRequest, ChangeExadataInfrastructureCompartmentResponse> onSuccess = new SuccessConsumer<ChangeExadataInfrastructureCompartmentRequest, ChangeExadataInfrastructureCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeExadataInfrastructureCompartmentRequest> onError = new ErrorConsumer<ChangeExadataInfrastructureCompartmentRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getChangeExadataInfrastructureCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeExadataInfrastructureCompartmentRequest, ChangeExadataInfrastructureCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeExadataInfrastructureCompartmentRequest, ChangeExadataInfrastructureCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeExadataInfrastructureCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeExadataInfrastructureCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeExadataInfrastructureCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeExadataInfrastructureCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getChangeExadataInfrastructureCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeExadataInfrastructureCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ChangeVmClusterCompartmentResponse> changeVmClusterCompartment(ChangeVmClusterCompartmentRequest request, AsyncHandler<ChangeVmClusterCompartmentRequest, ChangeVmClusterCompartmentResponse> handler) {
        LOG.trace("Called async changeVmClusterCompartment");
        final ChangeVmClusterCompartmentRequest interceptedRequest = ChangeVmClusterCompartmentConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ChangeVmClusterCompartmentConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ChangeVmClusterCompartmentResponse> transformer = ChangeVmClusterCompartmentConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ChangeVmClusterCompartmentRequest, ChangeVmClusterCompartmentResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ChangeVmClusterCompartmentRequest, ChangeVmClusterCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ChangeVmClusterCompartmentRequest, ChangeVmClusterCompartmentResponse> onSuccess = new SuccessConsumer<ChangeVmClusterCompartmentRequest, ChangeVmClusterCompartmentResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ChangeVmClusterCompartmentRequest> onError = new ErrorConsumer<ChangeVmClusterCompartmentRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getChangeVmClusterCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ChangeVmClusterCompartmentRequest, ChangeVmClusterCompartmentResponse> onSuccess = handler == null ? null : new SuccessConsumer<ChangeVmClusterCompartmentRequest, ChangeVmClusterCompartmentResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ChangeVmClusterCompartmentRequest> onError = handler == null ? null : new ErrorConsumer<ChangeVmClusterCompartmentRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getChangeVmClusterCompartmentDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ChangeVmClusterCompartmentResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getChangeVmClusterCompartmentDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ChangeVmClusterCompartmentResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CompleteExternalBackupJobResponse> completeExternalBackupJob(CompleteExternalBackupJobRequest request, AsyncHandler<CompleteExternalBackupJobRequest, CompleteExternalBackupJobResponse> handler) {
        LOG.trace("Called async completeExternalBackupJob");
        final CompleteExternalBackupJobRequest interceptedRequest = CompleteExternalBackupJobConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CompleteExternalBackupJobConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CompleteExternalBackupJobResponse> transformer = CompleteExternalBackupJobConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CompleteExternalBackupJobRequest, CompleteExternalBackupJobResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CompleteExternalBackupJobRequest, CompleteExternalBackupJobResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CompleteExternalBackupJobRequest, CompleteExternalBackupJobResponse> onSuccess = new SuccessConsumer<CompleteExternalBackupJobRequest, CompleteExternalBackupJobResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CompleteExternalBackupJobRequest> onError = new ErrorConsumer<CompleteExternalBackupJobRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCompleteExternalBackupJobDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CompleteExternalBackupJobRequest, CompleteExternalBackupJobResponse> onSuccess = handler == null ? null : new SuccessConsumer<CompleteExternalBackupJobRequest, CompleteExternalBackupJobResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CompleteExternalBackupJobRequest> onError = handler == null ? null : new ErrorConsumer<CompleteExternalBackupJobRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCompleteExternalBackupJobDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CompleteExternalBackupJobResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCompleteExternalBackupJobDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CompleteExternalBackupJobResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateAutonomousContainerDatabaseResponse> createAutonomousContainerDatabase(CreateAutonomousContainerDatabaseRequest request, AsyncHandler<CreateAutonomousContainerDatabaseRequest, CreateAutonomousContainerDatabaseResponse> handler) {
        LOG.trace("Called async createAutonomousContainerDatabase");
        final CreateAutonomousContainerDatabaseRequest interceptedRequest = CreateAutonomousContainerDatabaseConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateAutonomousContainerDatabaseConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateAutonomousContainerDatabaseResponse> transformer = CreateAutonomousContainerDatabaseConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateAutonomousContainerDatabaseRequest, CreateAutonomousContainerDatabaseResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateAutonomousContainerDatabaseRequest, CreateAutonomousContainerDatabaseResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateAutonomousContainerDatabaseRequest, CreateAutonomousContainerDatabaseResponse> onSuccess = new SuccessConsumer<CreateAutonomousContainerDatabaseRequest, CreateAutonomousContainerDatabaseResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateAutonomousContainerDatabaseRequest> onError = new ErrorConsumer<CreateAutonomousContainerDatabaseRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCreateAutonomousContainerDatabaseDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateAutonomousContainerDatabaseRequest, CreateAutonomousContainerDatabaseResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateAutonomousContainerDatabaseRequest, CreateAutonomousContainerDatabaseResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateAutonomousContainerDatabaseRequest> onError = handler == null ? null : new ErrorConsumer<CreateAutonomousContainerDatabaseRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateAutonomousContainerDatabaseDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateAutonomousContainerDatabaseResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCreateAutonomousContainerDatabaseDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateAutonomousContainerDatabaseResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateAutonomousDataWarehouseResponse> createAutonomousDataWarehouse(CreateAutonomousDataWarehouseRequest request, AsyncHandler<CreateAutonomousDataWarehouseRequest, CreateAutonomousDataWarehouseResponse> handler) {
        LOG.trace("Called async createAutonomousDataWarehouse");
        final CreateAutonomousDataWarehouseRequest interceptedRequest = CreateAutonomousDataWarehouseConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateAutonomousDataWarehouseConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateAutonomousDataWarehouseResponse> transformer = CreateAutonomousDataWarehouseConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateAutonomousDataWarehouseRequest, CreateAutonomousDataWarehouseResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateAutonomousDataWarehouseRequest, CreateAutonomousDataWarehouseResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateAutonomousDataWarehouseRequest, CreateAutonomousDataWarehouseResponse> onSuccess = new SuccessConsumer<CreateAutonomousDataWarehouseRequest, CreateAutonomousDataWarehouseResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateAutonomousDataWarehouseRequest> onError = new ErrorConsumer<CreateAutonomousDataWarehouseRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCreateAutonomousDataWarehouseDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateAutonomousDataWarehouseRequest, CreateAutonomousDataWarehouseResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateAutonomousDataWarehouseRequest, CreateAutonomousDataWarehouseResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateAutonomousDataWarehouseRequest> onError = handler == null ? null : new ErrorConsumer<CreateAutonomousDataWarehouseRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateAutonomousDataWarehouseDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateAutonomousDataWarehouseResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCreateAutonomousDataWarehouseDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateAutonomousDataWarehouseResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateAutonomousDataWarehouseBackupResponse> createAutonomousDataWarehouseBackup(CreateAutonomousDataWarehouseBackupRequest request, AsyncHandler<CreateAutonomousDataWarehouseBackupRequest, CreateAutonomousDataWarehouseBackupResponse> handler) {
        LOG.trace("Called async createAutonomousDataWarehouseBackup");
        final CreateAutonomousDataWarehouseBackupRequest interceptedRequest = CreateAutonomousDataWarehouseBackupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateAutonomousDataWarehouseBackupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateAutonomousDataWarehouseBackupResponse> transformer = CreateAutonomousDataWarehouseBackupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateAutonomousDataWarehouseBackupRequest, CreateAutonomousDataWarehouseBackupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateAutonomousDataWarehouseBackupRequest, CreateAutonomousDataWarehouseBackupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateAutonomousDataWarehouseBackupRequest, CreateAutonomousDataWarehouseBackupResponse> onSuccess = new SuccessConsumer<CreateAutonomousDataWarehouseBackupRequest, CreateAutonomousDataWarehouseBackupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateAutonomousDataWarehouseBackupRequest> onError = new ErrorConsumer<CreateAutonomousDataWarehouseBackupRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCreateAutonomousDataWarehouseBackupDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateAutonomousDataWarehouseBackupRequest, CreateAutonomousDataWarehouseBackupResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateAutonomousDataWarehouseBackupRequest, CreateAutonomousDataWarehouseBackupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateAutonomousDataWarehouseBackupRequest> onError = handler == null ? null : new ErrorConsumer<CreateAutonomousDataWarehouseBackupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateAutonomousDataWarehouseBackupDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateAutonomousDataWarehouseBackupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCreateAutonomousDataWarehouseBackupDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateAutonomousDataWarehouseBackupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateAutonomousDatabaseResponse> createAutonomousDatabase(CreateAutonomousDatabaseRequest request, AsyncHandler<CreateAutonomousDatabaseRequest, CreateAutonomousDatabaseResponse> handler) {
        LOG.trace("Called async createAutonomousDatabase");
        final CreateAutonomousDatabaseRequest interceptedRequest = CreateAutonomousDatabaseConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateAutonomousDatabaseConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateAutonomousDatabaseResponse> transformer = CreateAutonomousDatabaseConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateAutonomousDatabaseRequest, CreateAutonomousDatabaseResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateAutonomousDatabaseRequest, CreateAutonomousDatabaseResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateAutonomousDatabaseRequest, CreateAutonomousDatabaseResponse> onSuccess = new SuccessConsumer<CreateAutonomousDatabaseRequest, CreateAutonomousDatabaseResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateAutonomousDatabaseRequest> onError = new ErrorConsumer<CreateAutonomousDatabaseRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCreateAutonomousDatabaseDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateAutonomousDatabaseRequest, CreateAutonomousDatabaseResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateAutonomousDatabaseRequest, CreateAutonomousDatabaseResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateAutonomousDatabaseRequest> onError = handler == null ? null : new ErrorConsumer<CreateAutonomousDatabaseRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateAutonomousDatabaseDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateAutonomousDatabaseResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCreateAutonomousDatabaseDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateAutonomousDatabaseResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateAutonomousDatabaseBackupResponse> createAutonomousDatabaseBackup(CreateAutonomousDatabaseBackupRequest request, AsyncHandler<CreateAutonomousDatabaseBackupRequest, CreateAutonomousDatabaseBackupResponse> handler) {
        LOG.trace("Called async createAutonomousDatabaseBackup");
        final CreateAutonomousDatabaseBackupRequest interceptedRequest = CreateAutonomousDatabaseBackupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateAutonomousDatabaseBackupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateAutonomousDatabaseBackupResponse> transformer = CreateAutonomousDatabaseBackupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateAutonomousDatabaseBackupRequest, CreateAutonomousDatabaseBackupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateAutonomousDatabaseBackupRequest, CreateAutonomousDatabaseBackupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateAutonomousDatabaseBackupRequest, CreateAutonomousDatabaseBackupResponse> onSuccess = new SuccessConsumer<CreateAutonomousDatabaseBackupRequest, CreateAutonomousDatabaseBackupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateAutonomousDatabaseBackupRequest> onError = new ErrorConsumer<CreateAutonomousDatabaseBackupRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCreateAutonomousDatabaseBackupDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateAutonomousDatabaseBackupRequest, CreateAutonomousDatabaseBackupResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateAutonomousDatabaseBackupRequest, CreateAutonomousDatabaseBackupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateAutonomousDatabaseBackupRequest> onError = handler == null ? null : new ErrorConsumer<CreateAutonomousDatabaseBackupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateAutonomousDatabaseBackupDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateAutonomousDatabaseBackupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCreateAutonomousDatabaseBackupDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateAutonomousDatabaseBackupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateBackupResponse> createBackup(CreateBackupRequest request, AsyncHandler<CreateBackupRequest, CreateBackupResponse> handler) {
        LOG.trace("Called async createBackup");
        final CreateBackupRequest interceptedRequest = CreateBackupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateBackupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateBackupResponse> transformer = CreateBackupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateBackupRequest, CreateBackupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateBackupRequest, CreateBackupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateBackupRequest, CreateBackupResponse> onSuccess = new SuccessConsumer<CreateBackupRequest, CreateBackupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateBackupRequest> onError = new ErrorConsumer<CreateBackupRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCreateBackupDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateBackupRequest, CreateBackupResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateBackupRequest, CreateBackupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateBackupRequest> onError = handler == null ? null : new ErrorConsumer<CreateBackupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateBackupDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateBackupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCreateBackupDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateBackupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateBackupDestinationResponse> createBackupDestination(CreateBackupDestinationRequest request, AsyncHandler<CreateBackupDestinationRequest, CreateBackupDestinationResponse> handler) {
        LOG.trace("Called async createBackupDestination");
        final CreateBackupDestinationRequest interceptedRequest = CreateBackupDestinationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateBackupDestinationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateBackupDestinationResponse> transformer = CreateBackupDestinationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateBackupDestinationRequest, CreateBackupDestinationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateBackupDestinationRequest, CreateBackupDestinationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateBackupDestinationRequest, CreateBackupDestinationResponse> onSuccess = new SuccessConsumer<CreateBackupDestinationRequest, CreateBackupDestinationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateBackupDestinationRequest> onError = new ErrorConsumer<CreateBackupDestinationRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCreateBackupDestinationDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateBackupDestinationRequest, CreateBackupDestinationResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateBackupDestinationRequest, CreateBackupDestinationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateBackupDestinationRequest> onError = handler == null ? null : new ErrorConsumer<CreateBackupDestinationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateBackupDestinationDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateBackupDestinationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCreateBackupDestinationDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateBackupDestinationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateDataGuardAssociationResponse> createDataGuardAssociation(CreateDataGuardAssociationRequest request, AsyncHandler<CreateDataGuardAssociationRequest, CreateDataGuardAssociationResponse> handler) {
        LOG.trace("Called async createDataGuardAssociation");
        final CreateDataGuardAssociationRequest interceptedRequest = CreateDataGuardAssociationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateDataGuardAssociationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateDataGuardAssociationResponse> transformer = CreateDataGuardAssociationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateDataGuardAssociationRequest, CreateDataGuardAssociationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateDataGuardAssociationRequest, CreateDataGuardAssociationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateDataGuardAssociationRequest, CreateDataGuardAssociationResponse> onSuccess = new SuccessConsumer<CreateDataGuardAssociationRequest, CreateDataGuardAssociationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateDataGuardAssociationRequest> onError = new ErrorConsumer<CreateDataGuardAssociationRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCreateDataGuardAssociationDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateDataGuardAssociationRequest, CreateDataGuardAssociationResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateDataGuardAssociationRequest, CreateDataGuardAssociationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateDataGuardAssociationRequest> onError = handler == null ? null : new ErrorConsumer<CreateDataGuardAssociationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateDataGuardAssociationDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateDataGuardAssociationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCreateDataGuardAssociationDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateDataGuardAssociationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateDbHomeResponse> createDbHome(CreateDbHomeRequest request, AsyncHandler<CreateDbHomeRequest, CreateDbHomeResponse> handler) {
        LOG.trace("Called async createDbHome");
        final CreateDbHomeRequest interceptedRequest = CreateDbHomeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateDbHomeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateDbHomeResponse> transformer = CreateDbHomeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateDbHomeRequest, CreateDbHomeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateDbHomeRequest, CreateDbHomeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateDbHomeRequest, CreateDbHomeResponse> onSuccess = new SuccessConsumer<CreateDbHomeRequest, CreateDbHomeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateDbHomeRequest> onError = new ErrorConsumer<CreateDbHomeRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCreateDbHomeWithDbSystemIdDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateDbHomeRequest, CreateDbHomeResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateDbHomeRequest, CreateDbHomeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateDbHomeRequest> onError = handler == null ? null : new ErrorConsumer<CreateDbHomeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateDbHomeWithDbSystemIdDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateDbHomeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCreateDbHomeWithDbSystemIdDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateDbHomeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateExadataInfrastructureResponse> createExadataInfrastructure(CreateExadataInfrastructureRequest request, AsyncHandler<CreateExadataInfrastructureRequest, CreateExadataInfrastructureResponse> handler) {
        LOG.trace("Called async createExadataInfrastructure");
        final CreateExadataInfrastructureRequest interceptedRequest = CreateExadataInfrastructureConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateExadataInfrastructureConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateExadataInfrastructureResponse> transformer = CreateExadataInfrastructureConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateExadataInfrastructureRequest, CreateExadataInfrastructureResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateExadataInfrastructureRequest, CreateExadataInfrastructureResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateExadataInfrastructureRequest, CreateExadataInfrastructureResponse> onSuccess = new SuccessConsumer<CreateExadataInfrastructureRequest, CreateExadataInfrastructureResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateExadataInfrastructureRequest> onError = new ErrorConsumer<CreateExadataInfrastructureRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCreateExadataInfrastructureDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateExadataInfrastructureRequest, CreateExadataInfrastructureResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateExadataInfrastructureRequest, CreateExadataInfrastructureResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateExadataInfrastructureRequest> onError = handler == null ? null : new ErrorConsumer<CreateExadataInfrastructureRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateExadataInfrastructureDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateExadataInfrastructureResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCreateExadataInfrastructureDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateExadataInfrastructureResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateExternalBackupJobResponse> createExternalBackupJob(CreateExternalBackupJobRequest request, AsyncHandler<CreateExternalBackupJobRequest, CreateExternalBackupJobResponse> handler) {
        LOG.trace("Called async createExternalBackupJob");
        final CreateExternalBackupJobRequest interceptedRequest = CreateExternalBackupJobConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateExternalBackupJobConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateExternalBackupJobResponse> transformer = CreateExternalBackupJobConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateExternalBackupJobRequest, CreateExternalBackupJobResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateExternalBackupJobRequest, CreateExternalBackupJobResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateExternalBackupJobRequest, CreateExternalBackupJobResponse> onSuccess = new SuccessConsumer<CreateExternalBackupJobRequest, CreateExternalBackupJobResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateExternalBackupJobRequest> onError = new ErrorConsumer<CreateExternalBackupJobRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCreateExternalBackupJobDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateExternalBackupJobRequest, CreateExternalBackupJobResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateExternalBackupJobRequest, CreateExternalBackupJobResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateExternalBackupJobRequest> onError = handler == null ? null : new ErrorConsumer<CreateExternalBackupJobRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateExternalBackupJobDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateExternalBackupJobResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCreateExternalBackupJobDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateExternalBackupJobResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateVmClusterResponse> createVmCluster(CreateVmClusterRequest request, AsyncHandler<CreateVmClusterRequest, CreateVmClusterResponse> handler) {
        LOG.trace("Called async createVmCluster");
        final CreateVmClusterRequest interceptedRequest = CreateVmClusterConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateVmClusterConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateVmClusterResponse> transformer = CreateVmClusterConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateVmClusterRequest, CreateVmClusterResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateVmClusterRequest, CreateVmClusterResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateVmClusterRequest, CreateVmClusterResponse> onSuccess = new SuccessConsumer<CreateVmClusterRequest, CreateVmClusterResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateVmClusterRequest> onError = new ErrorConsumer<CreateVmClusterRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCreateVmClusterDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateVmClusterRequest, CreateVmClusterResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateVmClusterRequest, CreateVmClusterResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateVmClusterRequest> onError = handler == null ? null : new ErrorConsumer<CreateVmClusterRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getCreateVmClusterDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateVmClusterResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getCreateVmClusterDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateVmClusterResponse>(responseFuture, transformer);
    }

    @Override
    public Future<CreateVmClusterNetworkResponse> createVmClusterNetwork(CreateVmClusterNetworkRequest request, AsyncHandler<CreateVmClusterNetworkRequest, CreateVmClusterNetworkResponse> handler) {
        LOG.trace("Called async createVmClusterNetwork");
        final CreateVmClusterNetworkRequest interceptedRequest = CreateVmClusterNetworkConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = CreateVmClusterNetworkConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, CreateVmClusterNetworkResponse> transformer = CreateVmClusterNetworkConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<CreateVmClusterNetworkRequest, CreateVmClusterNetworkResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<CreateVmClusterNetworkRequest, CreateVmClusterNetworkResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<CreateVmClusterNetworkRequest, CreateVmClusterNetworkResponse> onSuccess = new SuccessConsumer<CreateVmClusterNetworkRequest, CreateVmClusterNetworkResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<CreateVmClusterNetworkRequest> onError = new ErrorConsumer<CreateVmClusterNetworkRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getVmClusterNetworkDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<CreateVmClusterNetworkRequest, CreateVmClusterNetworkResponse> onSuccess = handler == null ? null : new SuccessConsumer<CreateVmClusterNetworkRequest, CreateVmClusterNetworkResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<CreateVmClusterNetworkRequest> onError = handler == null ? null : new ErrorConsumer<CreateVmClusterNetworkRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getVmClusterNetworkDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, CreateVmClusterNetworkResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getVmClusterNetworkDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, CreateVmClusterNetworkResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DbNodeActionResponse> dbNodeAction(DbNodeActionRequest request, AsyncHandler<DbNodeActionRequest, DbNodeActionResponse> handler) {
        LOG.trace("Called async dbNodeAction");
        final DbNodeActionRequest interceptedRequest = DbNodeActionConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DbNodeActionConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DbNodeActionResponse> transformer = DbNodeActionConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DbNodeActionRequest, DbNodeActionResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DbNodeActionRequest, DbNodeActionResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DbNodeActionRequest, DbNodeActionResponse> onSuccess = new SuccessConsumer<DbNodeActionRequest, DbNodeActionResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DbNodeActionRequest> onError = new ErrorConsumer<DbNodeActionRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DbNodeActionRequest, DbNodeActionResponse> onSuccess = handler == null ? null : new SuccessConsumer<DbNodeActionRequest, DbNodeActionResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DbNodeActionRequest> onError = handler == null ? null : new ErrorConsumer<DbNodeActionRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DbNodeActionResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DbNodeActionResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteAutonomousDataWarehouseResponse> deleteAutonomousDataWarehouse(DeleteAutonomousDataWarehouseRequest request, AsyncHandler<DeleteAutonomousDataWarehouseRequest, DeleteAutonomousDataWarehouseResponse> handler) {
        LOG.trace("Called async deleteAutonomousDataWarehouse");
        final DeleteAutonomousDataWarehouseRequest interceptedRequest = DeleteAutonomousDataWarehouseConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteAutonomousDataWarehouseConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteAutonomousDataWarehouseResponse> transformer = DeleteAutonomousDataWarehouseConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteAutonomousDataWarehouseRequest, DeleteAutonomousDataWarehouseResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteAutonomousDataWarehouseRequest, DeleteAutonomousDataWarehouseResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteAutonomousDataWarehouseRequest, DeleteAutonomousDataWarehouseResponse> onSuccess = new SuccessConsumer<DeleteAutonomousDataWarehouseRequest, DeleteAutonomousDataWarehouseResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteAutonomousDataWarehouseRequest> onError = new ErrorConsumer<DeleteAutonomousDataWarehouseRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteAutonomousDataWarehouseRequest, DeleteAutonomousDataWarehouseResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteAutonomousDataWarehouseRequest, DeleteAutonomousDataWarehouseResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteAutonomousDataWarehouseRequest> onError = handler == null ? null : new ErrorConsumer<DeleteAutonomousDataWarehouseRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteAutonomousDataWarehouseResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteAutonomousDataWarehouseResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteAutonomousDatabaseResponse> deleteAutonomousDatabase(DeleteAutonomousDatabaseRequest request, AsyncHandler<DeleteAutonomousDatabaseRequest, DeleteAutonomousDatabaseResponse> handler) {
        LOG.trace("Called async deleteAutonomousDatabase");
        final DeleteAutonomousDatabaseRequest interceptedRequest = DeleteAutonomousDatabaseConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteAutonomousDatabaseConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteAutonomousDatabaseResponse> transformer = DeleteAutonomousDatabaseConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteAutonomousDatabaseRequest, DeleteAutonomousDatabaseResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteAutonomousDatabaseRequest, DeleteAutonomousDatabaseResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteAutonomousDatabaseRequest, DeleteAutonomousDatabaseResponse> onSuccess = new SuccessConsumer<DeleteAutonomousDatabaseRequest, DeleteAutonomousDatabaseResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteAutonomousDatabaseRequest> onError = new ErrorConsumer<DeleteAutonomousDatabaseRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteAutonomousDatabaseRequest, DeleteAutonomousDatabaseResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteAutonomousDatabaseRequest, DeleteAutonomousDatabaseResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteAutonomousDatabaseRequest> onError = handler == null ? null : new ErrorConsumer<DeleteAutonomousDatabaseRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteAutonomousDatabaseResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteAutonomousDatabaseResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteBackupResponse> deleteBackup(DeleteBackupRequest request, AsyncHandler<DeleteBackupRequest, DeleteBackupResponse> handler) {
        LOG.trace("Called async deleteBackup");
        final DeleteBackupRequest interceptedRequest = DeleteBackupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteBackupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteBackupResponse> transformer = DeleteBackupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteBackupRequest, DeleteBackupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteBackupRequest, DeleteBackupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteBackupRequest, DeleteBackupResponse> onSuccess = new SuccessConsumer<DeleteBackupRequest, DeleteBackupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteBackupRequest> onError = new ErrorConsumer<DeleteBackupRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteBackupRequest, DeleteBackupResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteBackupRequest, DeleteBackupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteBackupRequest> onError = handler == null ? null : new ErrorConsumer<DeleteBackupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteBackupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteBackupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteBackupDestinationResponse> deleteBackupDestination(DeleteBackupDestinationRequest request, AsyncHandler<DeleteBackupDestinationRequest, DeleteBackupDestinationResponse> handler) {
        LOG.trace("Called async deleteBackupDestination");
        final DeleteBackupDestinationRequest interceptedRequest = DeleteBackupDestinationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteBackupDestinationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteBackupDestinationResponse> transformer = DeleteBackupDestinationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteBackupDestinationRequest, DeleteBackupDestinationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteBackupDestinationRequest, DeleteBackupDestinationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteBackupDestinationRequest, DeleteBackupDestinationResponse> onSuccess = new SuccessConsumer<DeleteBackupDestinationRequest, DeleteBackupDestinationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteBackupDestinationRequest> onError = new ErrorConsumer<DeleteBackupDestinationRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteBackupDestinationRequest, DeleteBackupDestinationResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteBackupDestinationRequest, DeleteBackupDestinationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteBackupDestinationRequest> onError = handler == null ? null : new ErrorConsumer<DeleteBackupDestinationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteBackupDestinationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteBackupDestinationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteDbHomeResponse> deleteDbHome(DeleteDbHomeRequest request, AsyncHandler<DeleteDbHomeRequest, DeleteDbHomeResponse> handler) {
        LOG.trace("Called async deleteDbHome");
        final DeleteDbHomeRequest interceptedRequest = DeleteDbHomeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteDbHomeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteDbHomeResponse> transformer = DeleteDbHomeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteDbHomeRequest, DeleteDbHomeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteDbHomeRequest, DeleteDbHomeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteDbHomeRequest, DeleteDbHomeResponse> onSuccess = new SuccessConsumer<DeleteDbHomeRequest, DeleteDbHomeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteDbHomeRequest> onError = new ErrorConsumer<DeleteDbHomeRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteDbHomeRequest, DeleteDbHomeResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteDbHomeRequest, DeleteDbHomeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteDbHomeRequest> onError = handler == null ? null : new ErrorConsumer<DeleteDbHomeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteDbHomeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteDbHomeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteExadataInfrastructureResponse> deleteExadataInfrastructure(DeleteExadataInfrastructureRequest request, AsyncHandler<DeleteExadataInfrastructureRequest, DeleteExadataInfrastructureResponse> handler) {
        LOG.trace("Called async deleteExadataInfrastructure");
        final DeleteExadataInfrastructureRequest interceptedRequest = DeleteExadataInfrastructureConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteExadataInfrastructureConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteExadataInfrastructureResponse> transformer = DeleteExadataInfrastructureConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteExadataInfrastructureRequest, DeleteExadataInfrastructureResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteExadataInfrastructureRequest, DeleteExadataInfrastructureResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteExadataInfrastructureRequest, DeleteExadataInfrastructureResponse> onSuccess = new SuccessConsumer<DeleteExadataInfrastructureRequest, DeleteExadataInfrastructureResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteExadataInfrastructureRequest> onError = new ErrorConsumer<DeleteExadataInfrastructureRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteExadataInfrastructureRequest, DeleteExadataInfrastructureResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteExadataInfrastructureRequest, DeleteExadataInfrastructureResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteExadataInfrastructureRequest> onError = handler == null ? null : new ErrorConsumer<DeleteExadataInfrastructureRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteExadataInfrastructureResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteExadataInfrastructureResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteVmClusterResponse> deleteVmCluster(DeleteVmClusterRequest request, AsyncHandler<DeleteVmClusterRequest, DeleteVmClusterResponse> handler) {
        LOG.trace("Called async deleteVmCluster");
        final DeleteVmClusterRequest interceptedRequest = DeleteVmClusterConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteVmClusterConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteVmClusterResponse> transformer = DeleteVmClusterConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteVmClusterRequest, DeleteVmClusterResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteVmClusterRequest, DeleteVmClusterResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteVmClusterRequest, DeleteVmClusterResponse> onSuccess = new SuccessConsumer<DeleteVmClusterRequest, DeleteVmClusterResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteVmClusterRequest> onError = new ErrorConsumer<DeleteVmClusterRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteVmClusterRequest, DeleteVmClusterResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteVmClusterRequest, DeleteVmClusterResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteVmClusterRequest> onError = handler == null ? null : new ErrorConsumer<DeleteVmClusterRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteVmClusterResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteVmClusterResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DeleteVmClusterNetworkResponse> deleteVmClusterNetwork(DeleteVmClusterNetworkRequest request, AsyncHandler<DeleteVmClusterNetworkRequest, DeleteVmClusterNetworkResponse> handler) {
        LOG.trace("Called async deleteVmClusterNetwork");
        final DeleteVmClusterNetworkRequest interceptedRequest = DeleteVmClusterNetworkConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DeleteVmClusterNetworkConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DeleteVmClusterNetworkResponse> transformer = DeleteVmClusterNetworkConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DeleteVmClusterNetworkRequest, DeleteVmClusterNetworkResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DeleteVmClusterNetworkRequest, DeleteVmClusterNetworkResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DeleteVmClusterNetworkRequest, DeleteVmClusterNetworkResponse> onSuccess = new SuccessConsumer<DeleteVmClusterNetworkRequest, DeleteVmClusterNetworkResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DeleteVmClusterNetworkRequest> onError = new ErrorConsumer<DeleteVmClusterNetworkRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DeleteVmClusterNetworkRequest, DeleteVmClusterNetworkResponse> onSuccess = handler == null ? null : new SuccessConsumer<DeleteVmClusterNetworkRequest, DeleteVmClusterNetworkResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DeleteVmClusterNetworkRequest> onError = handler == null ? null : new ErrorConsumer<DeleteVmClusterNetworkRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DeleteVmClusterNetworkResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DeleteVmClusterNetworkResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DownloadExadataInfrastructureConfigFileResponse> downloadExadataInfrastructureConfigFile(DownloadExadataInfrastructureConfigFileRequest request, AsyncHandler<DownloadExadataInfrastructureConfigFileRequest, DownloadExadataInfrastructureConfigFileResponse> handler) {
        LOG.trace("Called async downloadExadataInfrastructureConfigFile");
        final DownloadExadataInfrastructureConfigFileRequest interceptedRequest = DownloadExadataInfrastructureConfigFileConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DownloadExadataInfrastructureConfigFileConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DownloadExadataInfrastructureConfigFileResponse> transformer = DownloadExadataInfrastructureConfigFileConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DownloadExadataInfrastructureConfigFileRequest, DownloadExadataInfrastructureConfigFileResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DownloadExadataInfrastructureConfigFileRequest, DownloadExadataInfrastructureConfigFileResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DownloadExadataInfrastructureConfigFileRequest, DownloadExadataInfrastructureConfigFileResponse> onSuccess = new SuccessConsumer<DownloadExadataInfrastructureConfigFileRequest, DownloadExadataInfrastructureConfigFileResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DownloadExadataInfrastructureConfigFileRequest> onError = new ErrorConsumer<DownloadExadataInfrastructureConfigFileRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DownloadExadataInfrastructureConfigFileRequest, DownloadExadataInfrastructureConfigFileResponse> onSuccess = handler == null ? null : new SuccessConsumer<DownloadExadataInfrastructureConfigFileRequest, DownloadExadataInfrastructureConfigFileResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DownloadExadataInfrastructureConfigFileRequest> onError = handler == null ? null : new ErrorConsumer<DownloadExadataInfrastructureConfigFileRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DownloadExadataInfrastructureConfigFileResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DownloadExadataInfrastructureConfigFileResponse>(responseFuture, transformer);
    }

    @Override
    public Future<DownloadVmClusterNetworkConfigFileResponse> downloadVmClusterNetworkConfigFile(DownloadVmClusterNetworkConfigFileRequest request, AsyncHandler<DownloadVmClusterNetworkConfigFileRequest, DownloadVmClusterNetworkConfigFileResponse> handler) {
        LOG.trace("Called async downloadVmClusterNetworkConfigFile");
        final DownloadVmClusterNetworkConfigFileRequest interceptedRequest = DownloadVmClusterNetworkConfigFileConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = DownloadVmClusterNetworkConfigFileConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, DownloadVmClusterNetworkConfigFileResponse> transformer = DownloadVmClusterNetworkConfigFileConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<DownloadVmClusterNetworkConfigFileRequest, DownloadVmClusterNetworkConfigFileResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<DownloadVmClusterNetworkConfigFileRequest, DownloadVmClusterNetworkConfigFileResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<DownloadVmClusterNetworkConfigFileRequest, DownloadVmClusterNetworkConfigFileResponse> onSuccess = new SuccessConsumer<DownloadVmClusterNetworkConfigFileRequest, DownloadVmClusterNetworkConfigFileResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<DownloadVmClusterNetworkConfigFileRequest> onError = new ErrorConsumer<DownloadVmClusterNetworkConfigFileRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<DownloadVmClusterNetworkConfigFileRequest, DownloadVmClusterNetworkConfigFileResponse> onSuccess = handler == null ? null : new SuccessConsumer<DownloadVmClusterNetworkConfigFileRequest, DownloadVmClusterNetworkConfigFileResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<DownloadVmClusterNetworkConfigFileRequest> onError = handler == null ? null : new ErrorConsumer<DownloadVmClusterNetworkConfigFileRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, DownloadVmClusterNetworkConfigFileResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, DownloadVmClusterNetworkConfigFileResponse>(responseFuture, transformer);
    }

    @Override
    public Future<FailoverDataGuardAssociationResponse> failoverDataGuardAssociation(FailoverDataGuardAssociationRequest request, AsyncHandler<FailoverDataGuardAssociationRequest, FailoverDataGuardAssociationResponse> handler) {
        LOG.trace("Called async failoverDataGuardAssociation");
        final FailoverDataGuardAssociationRequest interceptedRequest = FailoverDataGuardAssociationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = FailoverDataGuardAssociationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, FailoverDataGuardAssociationResponse> transformer = FailoverDataGuardAssociationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<FailoverDataGuardAssociationRequest, FailoverDataGuardAssociationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<FailoverDataGuardAssociationRequest, FailoverDataGuardAssociationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<FailoverDataGuardAssociationRequest, FailoverDataGuardAssociationResponse> onSuccess = new SuccessConsumer<FailoverDataGuardAssociationRequest, FailoverDataGuardAssociationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<FailoverDataGuardAssociationRequest> onError = new ErrorConsumer<FailoverDataGuardAssociationRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getFailoverDataGuardAssociationDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<FailoverDataGuardAssociationRequest, FailoverDataGuardAssociationResponse> onSuccess = handler == null ? null : new SuccessConsumer<FailoverDataGuardAssociationRequest, FailoverDataGuardAssociationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<FailoverDataGuardAssociationRequest> onError = handler == null ? null : new ErrorConsumer<FailoverDataGuardAssociationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getFailoverDataGuardAssociationDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, FailoverDataGuardAssociationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getFailoverDataGuardAssociationDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, FailoverDataGuardAssociationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GenerateAutonomousDataWarehouseWalletResponse> generateAutonomousDataWarehouseWallet(GenerateAutonomousDataWarehouseWalletRequest request, AsyncHandler<GenerateAutonomousDataWarehouseWalletRequest, GenerateAutonomousDataWarehouseWalletResponse> handler) {
        LOG.trace("Called async generateAutonomousDataWarehouseWallet");
        final GenerateAutonomousDataWarehouseWalletRequest interceptedRequest = GenerateAutonomousDataWarehouseWalletConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GenerateAutonomousDataWarehouseWalletConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GenerateAutonomousDataWarehouseWalletResponse> transformer = GenerateAutonomousDataWarehouseWalletConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GenerateAutonomousDataWarehouseWalletRequest, GenerateAutonomousDataWarehouseWalletResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GenerateAutonomousDataWarehouseWalletRequest, GenerateAutonomousDataWarehouseWalletResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GenerateAutonomousDataWarehouseWalletRequest, GenerateAutonomousDataWarehouseWalletResponse> onSuccess = new SuccessConsumer<GenerateAutonomousDataWarehouseWalletRequest, GenerateAutonomousDataWarehouseWalletResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GenerateAutonomousDataWarehouseWalletRequest> onError = new ErrorConsumer<GenerateAutonomousDataWarehouseWalletRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getGenerateAutonomousDataWarehouseWalletDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GenerateAutonomousDataWarehouseWalletRequest, GenerateAutonomousDataWarehouseWalletResponse> onSuccess = handler == null ? null : new SuccessConsumer<GenerateAutonomousDataWarehouseWalletRequest, GenerateAutonomousDataWarehouseWalletResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GenerateAutonomousDataWarehouseWalletRequest> onError = handler == null ? null : new ErrorConsumer<GenerateAutonomousDataWarehouseWalletRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getGenerateAutonomousDataWarehouseWalletDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GenerateAutonomousDataWarehouseWalletResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getGenerateAutonomousDataWarehouseWalletDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GenerateAutonomousDataWarehouseWalletResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GenerateAutonomousDatabaseWalletResponse> generateAutonomousDatabaseWallet(GenerateAutonomousDatabaseWalletRequest request, AsyncHandler<GenerateAutonomousDatabaseWalletRequest, GenerateAutonomousDatabaseWalletResponse> handler) {
        LOG.trace("Called async generateAutonomousDatabaseWallet");
        final GenerateAutonomousDatabaseWalletRequest interceptedRequest = GenerateAutonomousDatabaseWalletConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GenerateAutonomousDatabaseWalletConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GenerateAutonomousDatabaseWalletResponse> transformer = GenerateAutonomousDatabaseWalletConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GenerateAutonomousDatabaseWalletRequest, GenerateAutonomousDatabaseWalletResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GenerateAutonomousDatabaseWalletRequest, GenerateAutonomousDatabaseWalletResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GenerateAutonomousDatabaseWalletRequest, GenerateAutonomousDatabaseWalletResponse> onSuccess = new SuccessConsumer<GenerateAutonomousDatabaseWalletRequest, GenerateAutonomousDatabaseWalletResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GenerateAutonomousDatabaseWalletRequest> onError = new ErrorConsumer<GenerateAutonomousDatabaseWalletRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getGenerateAutonomousDatabaseWalletDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GenerateAutonomousDatabaseWalletRequest, GenerateAutonomousDatabaseWalletResponse> onSuccess = handler == null ? null : new SuccessConsumer<GenerateAutonomousDatabaseWalletRequest, GenerateAutonomousDatabaseWalletResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GenerateAutonomousDatabaseWalletRequest> onError = handler == null ? null : new ErrorConsumer<GenerateAutonomousDatabaseWalletRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getGenerateAutonomousDatabaseWalletDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GenerateAutonomousDatabaseWalletResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getGenerateAutonomousDatabaseWalletDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GenerateAutonomousDatabaseWalletResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GenerateRecommendedVmClusterNetworkResponse> generateRecommendedVmClusterNetwork(GenerateRecommendedVmClusterNetworkRequest request, AsyncHandler<GenerateRecommendedVmClusterNetworkRequest, GenerateRecommendedVmClusterNetworkResponse> handler) {
        LOG.trace("Called async generateRecommendedVmClusterNetwork");
        final GenerateRecommendedVmClusterNetworkRequest interceptedRequest = GenerateRecommendedVmClusterNetworkConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GenerateRecommendedVmClusterNetworkConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GenerateRecommendedVmClusterNetworkResponse> transformer = GenerateRecommendedVmClusterNetworkConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GenerateRecommendedVmClusterNetworkRequest, GenerateRecommendedVmClusterNetworkResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GenerateRecommendedVmClusterNetworkRequest, GenerateRecommendedVmClusterNetworkResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GenerateRecommendedVmClusterNetworkRequest, GenerateRecommendedVmClusterNetworkResponse> onSuccess = new SuccessConsumer<GenerateRecommendedVmClusterNetworkRequest, GenerateRecommendedVmClusterNetworkResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GenerateRecommendedVmClusterNetworkRequest> onError = new ErrorConsumer<GenerateRecommendedVmClusterNetworkRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getGenerateRecommendedNetworkDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GenerateRecommendedVmClusterNetworkRequest, GenerateRecommendedVmClusterNetworkResponse> onSuccess = handler == null ? null : new SuccessConsumer<GenerateRecommendedVmClusterNetworkRequest, GenerateRecommendedVmClusterNetworkResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GenerateRecommendedVmClusterNetworkRequest> onError = handler == null ? null : new ErrorConsumer<GenerateRecommendedVmClusterNetworkRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getGenerateRecommendedNetworkDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GenerateRecommendedVmClusterNetworkResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getGenerateRecommendedNetworkDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GenerateRecommendedVmClusterNetworkResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetAutonomousContainerDatabaseResponse> getAutonomousContainerDatabase(GetAutonomousContainerDatabaseRequest request, AsyncHandler<GetAutonomousContainerDatabaseRequest, GetAutonomousContainerDatabaseResponse> handler) {
        LOG.trace("Called async getAutonomousContainerDatabase");
        final GetAutonomousContainerDatabaseRequest interceptedRequest = GetAutonomousContainerDatabaseConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetAutonomousContainerDatabaseConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetAutonomousContainerDatabaseResponse> transformer = GetAutonomousContainerDatabaseConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetAutonomousContainerDatabaseRequest, GetAutonomousContainerDatabaseResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetAutonomousContainerDatabaseRequest, GetAutonomousContainerDatabaseResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetAutonomousContainerDatabaseRequest, GetAutonomousContainerDatabaseResponse> onSuccess = new SuccessConsumer<GetAutonomousContainerDatabaseRequest, GetAutonomousContainerDatabaseResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetAutonomousContainerDatabaseRequest> onError = new ErrorConsumer<GetAutonomousContainerDatabaseRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetAutonomousContainerDatabaseRequest, GetAutonomousContainerDatabaseResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetAutonomousContainerDatabaseRequest, GetAutonomousContainerDatabaseResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetAutonomousContainerDatabaseRequest> onError = handler == null ? null : new ErrorConsumer<GetAutonomousContainerDatabaseRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetAutonomousContainerDatabaseResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetAutonomousContainerDatabaseResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetAutonomousDataWarehouseResponse> getAutonomousDataWarehouse(GetAutonomousDataWarehouseRequest request, AsyncHandler<GetAutonomousDataWarehouseRequest, GetAutonomousDataWarehouseResponse> handler) {
        LOG.trace("Called async getAutonomousDataWarehouse");
        final GetAutonomousDataWarehouseRequest interceptedRequest = GetAutonomousDataWarehouseConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetAutonomousDataWarehouseConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetAutonomousDataWarehouseResponse> transformer = GetAutonomousDataWarehouseConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetAutonomousDataWarehouseRequest, GetAutonomousDataWarehouseResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetAutonomousDataWarehouseRequest, GetAutonomousDataWarehouseResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetAutonomousDataWarehouseRequest, GetAutonomousDataWarehouseResponse> onSuccess = new SuccessConsumer<GetAutonomousDataWarehouseRequest, GetAutonomousDataWarehouseResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetAutonomousDataWarehouseRequest> onError = new ErrorConsumer<GetAutonomousDataWarehouseRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetAutonomousDataWarehouseRequest, GetAutonomousDataWarehouseResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetAutonomousDataWarehouseRequest, GetAutonomousDataWarehouseResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetAutonomousDataWarehouseRequest> onError = handler == null ? null : new ErrorConsumer<GetAutonomousDataWarehouseRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetAutonomousDataWarehouseResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetAutonomousDataWarehouseResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetAutonomousDataWarehouseBackupResponse> getAutonomousDataWarehouseBackup(GetAutonomousDataWarehouseBackupRequest request, AsyncHandler<GetAutonomousDataWarehouseBackupRequest, GetAutonomousDataWarehouseBackupResponse> handler) {
        LOG.trace("Called async getAutonomousDataWarehouseBackup");
        final GetAutonomousDataWarehouseBackupRequest interceptedRequest = GetAutonomousDataWarehouseBackupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetAutonomousDataWarehouseBackupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetAutonomousDataWarehouseBackupResponse> transformer = GetAutonomousDataWarehouseBackupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetAutonomousDataWarehouseBackupRequest, GetAutonomousDataWarehouseBackupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetAutonomousDataWarehouseBackupRequest, GetAutonomousDataWarehouseBackupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetAutonomousDataWarehouseBackupRequest, GetAutonomousDataWarehouseBackupResponse> onSuccess = new SuccessConsumer<GetAutonomousDataWarehouseBackupRequest, GetAutonomousDataWarehouseBackupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetAutonomousDataWarehouseBackupRequest> onError = new ErrorConsumer<GetAutonomousDataWarehouseBackupRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetAutonomousDataWarehouseBackupRequest, GetAutonomousDataWarehouseBackupResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetAutonomousDataWarehouseBackupRequest, GetAutonomousDataWarehouseBackupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetAutonomousDataWarehouseBackupRequest> onError = handler == null ? null : new ErrorConsumer<GetAutonomousDataWarehouseBackupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetAutonomousDataWarehouseBackupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetAutonomousDataWarehouseBackupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetAutonomousDatabaseResponse> getAutonomousDatabase(GetAutonomousDatabaseRequest request, AsyncHandler<GetAutonomousDatabaseRequest, GetAutonomousDatabaseResponse> handler) {
        LOG.trace("Called async getAutonomousDatabase");
        final GetAutonomousDatabaseRequest interceptedRequest = GetAutonomousDatabaseConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetAutonomousDatabaseConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetAutonomousDatabaseResponse> transformer = GetAutonomousDatabaseConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetAutonomousDatabaseRequest, GetAutonomousDatabaseResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetAutonomousDatabaseRequest, GetAutonomousDatabaseResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetAutonomousDatabaseRequest, GetAutonomousDatabaseResponse> onSuccess = new SuccessConsumer<GetAutonomousDatabaseRequest, GetAutonomousDatabaseResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetAutonomousDatabaseRequest> onError = new ErrorConsumer<GetAutonomousDatabaseRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetAutonomousDatabaseRequest, GetAutonomousDatabaseResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetAutonomousDatabaseRequest, GetAutonomousDatabaseResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetAutonomousDatabaseRequest> onError = handler == null ? null : new ErrorConsumer<GetAutonomousDatabaseRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetAutonomousDatabaseResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetAutonomousDatabaseResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetAutonomousDatabaseBackupResponse> getAutonomousDatabaseBackup(GetAutonomousDatabaseBackupRequest request, AsyncHandler<GetAutonomousDatabaseBackupRequest, GetAutonomousDatabaseBackupResponse> handler) {
        LOG.trace("Called async getAutonomousDatabaseBackup");
        final GetAutonomousDatabaseBackupRequest interceptedRequest = GetAutonomousDatabaseBackupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetAutonomousDatabaseBackupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetAutonomousDatabaseBackupResponse> transformer = GetAutonomousDatabaseBackupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetAutonomousDatabaseBackupRequest, GetAutonomousDatabaseBackupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetAutonomousDatabaseBackupRequest, GetAutonomousDatabaseBackupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetAutonomousDatabaseBackupRequest, GetAutonomousDatabaseBackupResponse> onSuccess = new SuccessConsumer<GetAutonomousDatabaseBackupRequest, GetAutonomousDatabaseBackupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetAutonomousDatabaseBackupRequest> onError = new ErrorConsumer<GetAutonomousDatabaseBackupRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetAutonomousDatabaseBackupRequest, GetAutonomousDatabaseBackupResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetAutonomousDatabaseBackupRequest, GetAutonomousDatabaseBackupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetAutonomousDatabaseBackupRequest> onError = handler == null ? null : new ErrorConsumer<GetAutonomousDatabaseBackupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetAutonomousDatabaseBackupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetAutonomousDatabaseBackupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetAutonomousExadataInfrastructureResponse> getAutonomousExadataInfrastructure(GetAutonomousExadataInfrastructureRequest request, AsyncHandler<GetAutonomousExadataInfrastructureRequest, GetAutonomousExadataInfrastructureResponse> handler) {
        LOG.trace("Called async getAutonomousExadataInfrastructure");
        final GetAutonomousExadataInfrastructureRequest interceptedRequest = GetAutonomousExadataInfrastructureConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetAutonomousExadataInfrastructureConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetAutonomousExadataInfrastructureResponse> transformer = GetAutonomousExadataInfrastructureConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetAutonomousExadataInfrastructureRequest, GetAutonomousExadataInfrastructureResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetAutonomousExadataInfrastructureRequest, GetAutonomousExadataInfrastructureResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetAutonomousExadataInfrastructureRequest, GetAutonomousExadataInfrastructureResponse> onSuccess = new SuccessConsumer<GetAutonomousExadataInfrastructureRequest, GetAutonomousExadataInfrastructureResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetAutonomousExadataInfrastructureRequest> onError = new ErrorConsumer<GetAutonomousExadataInfrastructureRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetAutonomousExadataInfrastructureRequest, GetAutonomousExadataInfrastructureResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetAutonomousExadataInfrastructureRequest, GetAutonomousExadataInfrastructureResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetAutonomousExadataInfrastructureRequest> onError = handler == null ? null : new ErrorConsumer<GetAutonomousExadataInfrastructureRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetAutonomousExadataInfrastructureResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetAutonomousExadataInfrastructureResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetBackupResponse> getBackup(GetBackupRequest request, AsyncHandler<GetBackupRequest, GetBackupResponse> handler) {
        LOG.trace("Called async getBackup");
        final GetBackupRequest interceptedRequest = GetBackupConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetBackupConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetBackupResponse> transformer = GetBackupConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetBackupRequest, GetBackupResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetBackupRequest, GetBackupResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetBackupRequest, GetBackupResponse> onSuccess = new SuccessConsumer<GetBackupRequest, GetBackupResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetBackupRequest> onError = new ErrorConsumer<GetBackupRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetBackupRequest, GetBackupResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetBackupRequest, GetBackupResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetBackupRequest> onError = handler == null ? null : new ErrorConsumer<GetBackupRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetBackupResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetBackupResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetBackupDestinationResponse> getBackupDestination(GetBackupDestinationRequest request, AsyncHandler<GetBackupDestinationRequest, GetBackupDestinationResponse> handler) {
        LOG.trace("Called async getBackupDestination");
        final GetBackupDestinationRequest interceptedRequest = GetBackupDestinationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetBackupDestinationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetBackupDestinationResponse> transformer = GetBackupDestinationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetBackupDestinationRequest, GetBackupDestinationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetBackupDestinationRequest, GetBackupDestinationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetBackupDestinationRequest, GetBackupDestinationResponse> onSuccess = new SuccessConsumer<GetBackupDestinationRequest, GetBackupDestinationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetBackupDestinationRequest> onError = new ErrorConsumer<GetBackupDestinationRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetBackupDestinationRequest, GetBackupDestinationResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetBackupDestinationRequest, GetBackupDestinationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetBackupDestinationRequest> onError = handler == null ? null : new ErrorConsumer<GetBackupDestinationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetBackupDestinationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetBackupDestinationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetDataGuardAssociationResponse> getDataGuardAssociation(GetDataGuardAssociationRequest request, AsyncHandler<GetDataGuardAssociationRequest, GetDataGuardAssociationResponse> handler) {
        LOG.trace("Called async getDataGuardAssociation");
        final GetDataGuardAssociationRequest interceptedRequest = GetDataGuardAssociationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetDataGuardAssociationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetDataGuardAssociationResponse> transformer = GetDataGuardAssociationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetDataGuardAssociationRequest, GetDataGuardAssociationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetDataGuardAssociationRequest, GetDataGuardAssociationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetDataGuardAssociationRequest, GetDataGuardAssociationResponse> onSuccess = new SuccessConsumer<GetDataGuardAssociationRequest, GetDataGuardAssociationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetDataGuardAssociationRequest> onError = new ErrorConsumer<GetDataGuardAssociationRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetDataGuardAssociationRequest, GetDataGuardAssociationResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetDataGuardAssociationRequest, GetDataGuardAssociationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetDataGuardAssociationRequest> onError = handler == null ? null : new ErrorConsumer<GetDataGuardAssociationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetDataGuardAssociationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetDataGuardAssociationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetDatabaseResponse> getDatabase(GetDatabaseRequest request, AsyncHandler<GetDatabaseRequest, GetDatabaseResponse> handler) {
        LOG.trace("Called async getDatabase");
        final GetDatabaseRequest interceptedRequest = GetDatabaseConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetDatabaseConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetDatabaseResponse> transformer = GetDatabaseConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetDatabaseRequest, GetDatabaseResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetDatabaseRequest, GetDatabaseResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetDatabaseRequest, GetDatabaseResponse> onSuccess = new SuccessConsumer<GetDatabaseRequest, GetDatabaseResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetDatabaseRequest> onError = new ErrorConsumer<GetDatabaseRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetDatabaseRequest, GetDatabaseResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetDatabaseRequest, GetDatabaseResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetDatabaseRequest> onError = handler == null ? null : new ErrorConsumer<GetDatabaseRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetDatabaseResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetDatabaseResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetDbHomeResponse> getDbHome(GetDbHomeRequest request, AsyncHandler<GetDbHomeRequest, GetDbHomeResponse> handler) {
        LOG.trace("Called async getDbHome");
        final GetDbHomeRequest interceptedRequest = GetDbHomeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetDbHomeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetDbHomeResponse> transformer = GetDbHomeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetDbHomeRequest, GetDbHomeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetDbHomeRequest, GetDbHomeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetDbHomeRequest, GetDbHomeResponse> onSuccess = new SuccessConsumer<GetDbHomeRequest, GetDbHomeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetDbHomeRequest> onError = new ErrorConsumer<GetDbHomeRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetDbHomeRequest, GetDbHomeResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetDbHomeRequest, GetDbHomeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetDbHomeRequest> onError = handler == null ? null : new ErrorConsumer<GetDbHomeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetDbHomeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetDbHomeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetDbHomePatchResponse> getDbHomePatch(GetDbHomePatchRequest request, AsyncHandler<GetDbHomePatchRequest, GetDbHomePatchResponse> handler) {
        LOG.trace("Called async getDbHomePatch");
        final GetDbHomePatchRequest interceptedRequest = GetDbHomePatchConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetDbHomePatchConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetDbHomePatchResponse> transformer = GetDbHomePatchConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetDbHomePatchRequest, GetDbHomePatchResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetDbHomePatchRequest, GetDbHomePatchResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetDbHomePatchRequest, GetDbHomePatchResponse> onSuccess = new SuccessConsumer<GetDbHomePatchRequest, GetDbHomePatchResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetDbHomePatchRequest> onError = new ErrorConsumer<GetDbHomePatchRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetDbHomePatchRequest, GetDbHomePatchResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetDbHomePatchRequest, GetDbHomePatchResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetDbHomePatchRequest> onError = handler == null ? null : new ErrorConsumer<GetDbHomePatchRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetDbHomePatchResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetDbHomePatchResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetDbHomePatchHistoryEntryResponse> getDbHomePatchHistoryEntry(GetDbHomePatchHistoryEntryRequest request, AsyncHandler<GetDbHomePatchHistoryEntryRequest, GetDbHomePatchHistoryEntryResponse> handler) {
        LOG.trace("Called async getDbHomePatchHistoryEntry");
        final GetDbHomePatchHistoryEntryRequest interceptedRequest = GetDbHomePatchHistoryEntryConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetDbHomePatchHistoryEntryConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetDbHomePatchHistoryEntryResponse> transformer = GetDbHomePatchHistoryEntryConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetDbHomePatchHistoryEntryRequest, GetDbHomePatchHistoryEntryResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetDbHomePatchHistoryEntryRequest, GetDbHomePatchHistoryEntryResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetDbHomePatchHistoryEntryRequest, GetDbHomePatchHistoryEntryResponse> onSuccess = new SuccessConsumer<GetDbHomePatchHistoryEntryRequest, GetDbHomePatchHistoryEntryResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetDbHomePatchHistoryEntryRequest> onError = new ErrorConsumer<GetDbHomePatchHistoryEntryRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetDbHomePatchHistoryEntryRequest, GetDbHomePatchHistoryEntryResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetDbHomePatchHistoryEntryRequest, GetDbHomePatchHistoryEntryResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetDbHomePatchHistoryEntryRequest> onError = handler == null ? null : new ErrorConsumer<GetDbHomePatchHistoryEntryRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetDbHomePatchHistoryEntryResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetDbHomePatchHistoryEntryResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetDbNodeResponse> getDbNode(GetDbNodeRequest request, AsyncHandler<GetDbNodeRequest, GetDbNodeResponse> handler) {
        LOG.trace("Called async getDbNode");
        final GetDbNodeRequest interceptedRequest = GetDbNodeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetDbNodeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetDbNodeResponse> transformer = GetDbNodeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetDbNodeRequest, GetDbNodeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetDbNodeRequest, GetDbNodeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetDbNodeRequest, GetDbNodeResponse> onSuccess = new SuccessConsumer<GetDbNodeRequest, GetDbNodeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetDbNodeRequest> onError = new ErrorConsumer<GetDbNodeRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetDbNodeRequest, GetDbNodeResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetDbNodeRequest, GetDbNodeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetDbNodeRequest> onError = handler == null ? null : new ErrorConsumer<GetDbNodeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetDbNodeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetDbNodeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetDbSystemResponse> getDbSystem(GetDbSystemRequest request, AsyncHandler<GetDbSystemRequest, GetDbSystemResponse> handler) {
        LOG.trace("Called async getDbSystem");
        final GetDbSystemRequest interceptedRequest = GetDbSystemConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetDbSystemConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetDbSystemResponse> transformer = GetDbSystemConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetDbSystemRequest, GetDbSystemResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetDbSystemRequest, GetDbSystemResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetDbSystemRequest, GetDbSystemResponse> onSuccess = new SuccessConsumer<GetDbSystemRequest, GetDbSystemResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetDbSystemRequest> onError = new ErrorConsumer<GetDbSystemRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetDbSystemRequest, GetDbSystemResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetDbSystemRequest, GetDbSystemResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetDbSystemRequest> onError = handler == null ? null : new ErrorConsumer<GetDbSystemRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetDbSystemResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetDbSystemResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetDbSystemPatchResponse> getDbSystemPatch(GetDbSystemPatchRequest request, AsyncHandler<GetDbSystemPatchRequest, GetDbSystemPatchResponse> handler) {
        LOG.trace("Called async getDbSystemPatch");
        final GetDbSystemPatchRequest interceptedRequest = GetDbSystemPatchConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetDbSystemPatchConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetDbSystemPatchResponse> transformer = GetDbSystemPatchConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetDbSystemPatchRequest, GetDbSystemPatchResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetDbSystemPatchRequest, GetDbSystemPatchResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetDbSystemPatchRequest, GetDbSystemPatchResponse> onSuccess = new SuccessConsumer<GetDbSystemPatchRequest, GetDbSystemPatchResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetDbSystemPatchRequest> onError = new ErrorConsumer<GetDbSystemPatchRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetDbSystemPatchRequest, GetDbSystemPatchResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetDbSystemPatchRequest, GetDbSystemPatchResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetDbSystemPatchRequest> onError = handler == null ? null : new ErrorConsumer<GetDbSystemPatchRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetDbSystemPatchResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetDbSystemPatchResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetDbSystemPatchHistoryEntryResponse> getDbSystemPatchHistoryEntry(GetDbSystemPatchHistoryEntryRequest request, AsyncHandler<GetDbSystemPatchHistoryEntryRequest, GetDbSystemPatchHistoryEntryResponse> handler) {
        LOG.trace("Called async getDbSystemPatchHistoryEntry");
        final GetDbSystemPatchHistoryEntryRequest interceptedRequest = GetDbSystemPatchHistoryEntryConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetDbSystemPatchHistoryEntryConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetDbSystemPatchHistoryEntryResponse> transformer = GetDbSystemPatchHistoryEntryConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetDbSystemPatchHistoryEntryRequest, GetDbSystemPatchHistoryEntryResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetDbSystemPatchHistoryEntryRequest, GetDbSystemPatchHistoryEntryResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetDbSystemPatchHistoryEntryRequest, GetDbSystemPatchHistoryEntryResponse> onSuccess = new SuccessConsumer<GetDbSystemPatchHistoryEntryRequest, GetDbSystemPatchHistoryEntryResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetDbSystemPatchHistoryEntryRequest> onError = new ErrorConsumer<GetDbSystemPatchHistoryEntryRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetDbSystemPatchHistoryEntryRequest, GetDbSystemPatchHistoryEntryResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetDbSystemPatchHistoryEntryRequest, GetDbSystemPatchHistoryEntryResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetDbSystemPatchHistoryEntryRequest> onError = handler == null ? null : new ErrorConsumer<GetDbSystemPatchHistoryEntryRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetDbSystemPatchHistoryEntryResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetDbSystemPatchHistoryEntryResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetExadataInfrastructureResponse> getExadataInfrastructure(GetExadataInfrastructureRequest request, AsyncHandler<GetExadataInfrastructureRequest, GetExadataInfrastructureResponse> handler) {
        LOG.trace("Called async getExadataInfrastructure");
        final GetExadataInfrastructureRequest interceptedRequest = GetExadataInfrastructureConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetExadataInfrastructureConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetExadataInfrastructureResponse> transformer = GetExadataInfrastructureConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetExadataInfrastructureRequest, GetExadataInfrastructureResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetExadataInfrastructureRequest, GetExadataInfrastructureResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetExadataInfrastructureRequest, GetExadataInfrastructureResponse> onSuccess = new SuccessConsumer<GetExadataInfrastructureRequest, GetExadataInfrastructureResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetExadataInfrastructureRequest> onError = new ErrorConsumer<GetExadataInfrastructureRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetExadataInfrastructureRequest, GetExadataInfrastructureResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetExadataInfrastructureRequest, GetExadataInfrastructureResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetExadataInfrastructureRequest> onError = handler == null ? null : new ErrorConsumer<GetExadataInfrastructureRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetExadataInfrastructureResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetExadataInfrastructureResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetExadataIormConfigResponse> getExadataIormConfig(GetExadataIormConfigRequest request, AsyncHandler<GetExadataIormConfigRequest, GetExadataIormConfigResponse> handler) {
        LOG.trace("Called async getExadataIormConfig");
        final GetExadataIormConfigRequest interceptedRequest = GetExadataIormConfigConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetExadataIormConfigConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetExadataIormConfigResponse> transformer = GetExadataIormConfigConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetExadataIormConfigRequest, GetExadataIormConfigResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetExadataIormConfigRequest, GetExadataIormConfigResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetExadataIormConfigRequest, GetExadataIormConfigResponse> onSuccess = new SuccessConsumer<GetExadataIormConfigRequest, GetExadataIormConfigResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetExadataIormConfigRequest> onError = new ErrorConsumer<GetExadataIormConfigRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetExadataIormConfigRequest, GetExadataIormConfigResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetExadataIormConfigRequest, GetExadataIormConfigResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetExadataIormConfigRequest> onError = handler == null ? null : new ErrorConsumer<GetExadataIormConfigRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetExadataIormConfigResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetExadataIormConfigResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetExternalBackupJobResponse> getExternalBackupJob(GetExternalBackupJobRequest request, AsyncHandler<GetExternalBackupJobRequest, GetExternalBackupJobResponse> handler) {
        LOG.trace("Called async getExternalBackupJob");
        final GetExternalBackupJobRequest interceptedRequest = GetExternalBackupJobConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetExternalBackupJobConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetExternalBackupJobResponse> transformer = GetExternalBackupJobConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetExternalBackupJobRequest, GetExternalBackupJobResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetExternalBackupJobRequest, GetExternalBackupJobResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetExternalBackupJobRequest, GetExternalBackupJobResponse> onSuccess = new SuccessConsumer<GetExternalBackupJobRequest, GetExternalBackupJobResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetExternalBackupJobRequest> onError = new ErrorConsumer<GetExternalBackupJobRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetExternalBackupJobRequest, GetExternalBackupJobResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetExternalBackupJobRequest, GetExternalBackupJobResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetExternalBackupJobRequest> onError = handler == null ? null : new ErrorConsumer<GetExternalBackupJobRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetExternalBackupJobResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetExternalBackupJobResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetMaintenanceRunResponse> getMaintenanceRun(GetMaintenanceRunRequest request, AsyncHandler<GetMaintenanceRunRequest, GetMaintenanceRunResponse> handler) {
        LOG.trace("Called async getMaintenanceRun");
        final GetMaintenanceRunRequest interceptedRequest = GetMaintenanceRunConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetMaintenanceRunConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetMaintenanceRunResponse> transformer = GetMaintenanceRunConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetMaintenanceRunRequest, GetMaintenanceRunResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetMaintenanceRunRequest, GetMaintenanceRunResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetMaintenanceRunRequest, GetMaintenanceRunResponse> onSuccess = new SuccessConsumer<GetMaintenanceRunRequest, GetMaintenanceRunResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetMaintenanceRunRequest> onError = new ErrorConsumer<GetMaintenanceRunRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetMaintenanceRunRequest, GetMaintenanceRunResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetMaintenanceRunRequest, GetMaintenanceRunResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetMaintenanceRunRequest> onError = handler == null ? null : new ErrorConsumer<GetMaintenanceRunRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetMaintenanceRunResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetMaintenanceRunResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetVmClusterResponse> getVmCluster(GetVmClusterRequest request, AsyncHandler<GetVmClusterRequest, GetVmClusterResponse> handler) {
        LOG.trace("Called async getVmCluster");
        final GetVmClusterRequest interceptedRequest = GetVmClusterConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetVmClusterConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetVmClusterResponse> transformer = GetVmClusterConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetVmClusterRequest, GetVmClusterResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetVmClusterRequest, GetVmClusterResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetVmClusterRequest, GetVmClusterResponse> onSuccess = new SuccessConsumer<GetVmClusterRequest, GetVmClusterResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetVmClusterRequest> onError = new ErrorConsumer<GetVmClusterRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetVmClusterRequest, GetVmClusterResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetVmClusterRequest, GetVmClusterResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetVmClusterRequest> onError = handler == null ? null : new ErrorConsumer<GetVmClusterRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetVmClusterResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetVmClusterResponse>(responseFuture, transformer);
    }

    @Override
    public Future<GetVmClusterNetworkResponse> getVmClusterNetwork(GetVmClusterNetworkRequest request, AsyncHandler<GetVmClusterNetworkRequest, GetVmClusterNetworkResponse> handler) {
        LOG.trace("Called async getVmClusterNetwork");
        final GetVmClusterNetworkRequest interceptedRequest = GetVmClusterNetworkConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = GetVmClusterNetworkConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, GetVmClusterNetworkResponse> transformer = GetVmClusterNetworkConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<GetVmClusterNetworkRequest, GetVmClusterNetworkResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<GetVmClusterNetworkRequest, GetVmClusterNetworkResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<GetVmClusterNetworkRequest, GetVmClusterNetworkResponse> onSuccess = new SuccessConsumer<GetVmClusterNetworkRequest, GetVmClusterNetworkResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<GetVmClusterNetworkRequest> onError = new ErrorConsumer<GetVmClusterNetworkRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<GetVmClusterNetworkRequest, GetVmClusterNetworkResponse> onSuccess = handler == null ? null : new SuccessConsumer<GetVmClusterNetworkRequest, GetVmClusterNetworkResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<GetVmClusterNetworkRequest> onError = handler == null ? null : new ErrorConsumer<GetVmClusterNetworkRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, GetVmClusterNetworkResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, GetVmClusterNetworkResponse>(responseFuture, transformer);
    }

    @Override
    public Future<LaunchAutonomousExadataInfrastructureResponse> launchAutonomousExadataInfrastructure(LaunchAutonomousExadataInfrastructureRequest request, AsyncHandler<LaunchAutonomousExadataInfrastructureRequest, LaunchAutonomousExadataInfrastructureResponse> handler) {
        LOG.trace("Called async launchAutonomousExadataInfrastructure");
        final LaunchAutonomousExadataInfrastructureRequest interceptedRequest = LaunchAutonomousExadataInfrastructureConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = LaunchAutonomousExadataInfrastructureConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, LaunchAutonomousExadataInfrastructureResponse> transformer = LaunchAutonomousExadataInfrastructureConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<LaunchAutonomousExadataInfrastructureRequest, LaunchAutonomousExadataInfrastructureResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<LaunchAutonomousExadataInfrastructureRequest, LaunchAutonomousExadataInfrastructureResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<LaunchAutonomousExadataInfrastructureRequest, LaunchAutonomousExadataInfrastructureResponse> onSuccess = new SuccessConsumer<LaunchAutonomousExadataInfrastructureRequest, LaunchAutonomousExadataInfrastructureResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<LaunchAutonomousExadataInfrastructureRequest> onError = new ErrorConsumer<LaunchAutonomousExadataInfrastructureRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getLaunchAutonomousExadataInfrastructureDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<LaunchAutonomousExadataInfrastructureRequest, LaunchAutonomousExadataInfrastructureResponse> onSuccess = handler == null ? null : new SuccessConsumer<LaunchAutonomousExadataInfrastructureRequest, LaunchAutonomousExadataInfrastructureResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<LaunchAutonomousExadataInfrastructureRequest> onError = handler == null ? null : new ErrorConsumer<LaunchAutonomousExadataInfrastructureRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getLaunchAutonomousExadataInfrastructureDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, LaunchAutonomousExadataInfrastructureResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getLaunchAutonomousExadataInfrastructureDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, LaunchAutonomousExadataInfrastructureResponse>(responseFuture, transformer);
    }

    @Override
    public Future<LaunchDbSystemResponse> launchDbSystem(LaunchDbSystemRequest request, AsyncHandler<LaunchDbSystemRequest, LaunchDbSystemResponse> handler) {
        LOG.trace("Called async launchDbSystem");
        final LaunchDbSystemRequest interceptedRequest = LaunchDbSystemConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = LaunchDbSystemConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, LaunchDbSystemResponse> transformer = LaunchDbSystemConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<LaunchDbSystemRequest, LaunchDbSystemResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<LaunchDbSystemRequest, LaunchDbSystemResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<LaunchDbSystemRequest, LaunchDbSystemResponse> onSuccess = new SuccessConsumer<LaunchDbSystemRequest, LaunchDbSystemResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<LaunchDbSystemRequest> onError = new ErrorConsumer<LaunchDbSystemRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getLaunchDbSystemDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<LaunchDbSystemRequest, LaunchDbSystemResponse> onSuccess = handler == null ? null : new SuccessConsumer<LaunchDbSystemRequest, LaunchDbSystemResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<LaunchDbSystemRequest> onError = handler == null ? null : new ErrorConsumer<LaunchDbSystemRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getLaunchDbSystemDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, LaunchDbSystemResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getLaunchDbSystemDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, LaunchDbSystemResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListAutonomousContainerDatabasesResponse> listAutonomousContainerDatabases(ListAutonomousContainerDatabasesRequest request, AsyncHandler<ListAutonomousContainerDatabasesRequest, ListAutonomousContainerDatabasesResponse> handler) {
        LOG.trace("Called async listAutonomousContainerDatabases");
        final ListAutonomousContainerDatabasesRequest interceptedRequest = ListAutonomousContainerDatabasesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAutonomousContainerDatabasesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAutonomousContainerDatabasesResponse> transformer = ListAutonomousContainerDatabasesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListAutonomousContainerDatabasesRequest, ListAutonomousContainerDatabasesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAutonomousContainerDatabasesRequest, ListAutonomousContainerDatabasesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListAutonomousContainerDatabasesRequest, ListAutonomousContainerDatabasesResponse> onSuccess = new SuccessConsumer<ListAutonomousContainerDatabasesRequest, ListAutonomousContainerDatabasesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListAutonomousContainerDatabasesRequest> onError = new ErrorConsumer<ListAutonomousContainerDatabasesRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListAutonomousContainerDatabasesRequest, ListAutonomousContainerDatabasesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListAutonomousContainerDatabasesRequest, ListAutonomousContainerDatabasesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListAutonomousContainerDatabasesRequest> onError = handler == null ? null : new ErrorConsumer<ListAutonomousContainerDatabasesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListAutonomousContainerDatabasesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListAutonomousContainerDatabasesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListAutonomousDataWarehouseBackupsResponse> listAutonomousDataWarehouseBackups(ListAutonomousDataWarehouseBackupsRequest request, AsyncHandler<ListAutonomousDataWarehouseBackupsRequest, ListAutonomousDataWarehouseBackupsResponse> handler) {
        LOG.trace("Called async listAutonomousDataWarehouseBackups");
        final ListAutonomousDataWarehouseBackupsRequest interceptedRequest = ListAutonomousDataWarehouseBackupsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAutonomousDataWarehouseBackupsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAutonomousDataWarehouseBackupsResponse> transformer = ListAutonomousDataWarehouseBackupsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListAutonomousDataWarehouseBackupsRequest, ListAutonomousDataWarehouseBackupsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAutonomousDataWarehouseBackupsRequest, ListAutonomousDataWarehouseBackupsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListAutonomousDataWarehouseBackupsRequest, ListAutonomousDataWarehouseBackupsResponse> onSuccess = new SuccessConsumer<ListAutonomousDataWarehouseBackupsRequest, ListAutonomousDataWarehouseBackupsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListAutonomousDataWarehouseBackupsRequest> onError = new ErrorConsumer<ListAutonomousDataWarehouseBackupsRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListAutonomousDataWarehouseBackupsRequest, ListAutonomousDataWarehouseBackupsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListAutonomousDataWarehouseBackupsRequest, ListAutonomousDataWarehouseBackupsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListAutonomousDataWarehouseBackupsRequest> onError = handler == null ? null : new ErrorConsumer<ListAutonomousDataWarehouseBackupsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListAutonomousDataWarehouseBackupsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListAutonomousDataWarehouseBackupsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListAutonomousDataWarehousesResponse> listAutonomousDataWarehouses(ListAutonomousDataWarehousesRequest request, AsyncHandler<ListAutonomousDataWarehousesRequest, ListAutonomousDataWarehousesResponse> handler) {
        LOG.trace("Called async listAutonomousDataWarehouses");
        final ListAutonomousDataWarehousesRequest interceptedRequest = ListAutonomousDataWarehousesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAutonomousDataWarehousesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAutonomousDataWarehousesResponse> transformer = ListAutonomousDataWarehousesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListAutonomousDataWarehousesRequest, ListAutonomousDataWarehousesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAutonomousDataWarehousesRequest, ListAutonomousDataWarehousesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListAutonomousDataWarehousesRequest, ListAutonomousDataWarehousesResponse> onSuccess = new SuccessConsumer<ListAutonomousDataWarehousesRequest, ListAutonomousDataWarehousesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListAutonomousDataWarehousesRequest> onError = new ErrorConsumer<ListAutonomousDataWarehousesRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListAutonomousDataWarehousesRequest, ListAutonomousDataWarehousesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListAutonomousDataWarehousesRequest, ListAutonomousDataWarehousesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListAutonomousDataWarehousesRequest> onError = handler == null ? null : new ErrorConsumer<ListAutonomousDataWarehousesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListAutonomousDataWarehousesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListAutonomousDataWarehousesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListAutonomousDatabaseBackupsResponse> listAutonomousDatabaseBackups(ListAutonomousDatabaseBackupsRequest request, AsyncHandler<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse> handler) {
        LOG.trace("Called async listAutonomousDatabaseBackups");
        final ListAutonomousDatabaseBackupsRequest interceptedRequest = ListAutonomousDatabaseBackupsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAutonomousDatabaseBackupsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAutonomousDatabaseBackupsResponse> transformer = ListAutonomousDatabaseBackupsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse> onSuccess = new SuccessConsumer<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListAutonomousDatabaseBackupsRequest> onError = new ErrorConsumer<ListAutonomousDatabaseBackupsRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListAutonomousDatabaseBackupsRequest> onError = handler == null ? null : new ErrorConsumer<ListAutonomousDatabaseBackupsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListAutonomousDatabaseBackupsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListAutonomousDatabaseBackupsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListAutonomousDatabasesResponse> listAutonomousDatabases(ListAutonomousDatabasesRequest request, AsyncHandler<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse> handler) {
        LOG.trace("Called async listAutonomousDatabases");
        final ListAutonomousDatabasesRequest interceptedRequest = ListAutonomousDatabasesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAutonomousDatabasesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAutonomousDatabasesResponse> transformer = ListAutonomousDatabasesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse> onSuccess = new SuccessConsumer<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListAutonomousDatabasesRequest> onError = new ErrorConsumer<ListAutonomousDatabasesRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListAutonomousDatabasesRequest> onError = handler == null ? null : new ErrorConsumer<ListAutonomousDatabasesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListAutonomousDatabasesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListAutonomousDatabasesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListAutonomousDbPreviewVersionsResponse> listAutonomousDbPreviewVersions(ListAutonomousDbPreviewVersionsRequest request, AsyncHandler<ListAutonomousDbPreviewVersionsRequest, ListAutonomousDbPreviewVersionsResponse> handler) {
        LOG.trace("Called async listAutonomousDbPreviewVersions");
        final ListAutonomousDbPreviewVersionsRequest interceptedRequest = ListAutonomousDbPreviewVersionsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAutonomousDbPreviewVersionsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAutonomousDbPreviewVersionsResponse> transformer = ListAutonomousDbPreviewVersionsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListAutonomousDbPreviewVersionsRequest, ListAutonomousDbPreviewVersionsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAutonomousDbPreviewVersionsRequest, ListAutonomousDbPreviewVersionsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListAutonomousDbPreviewVersionsRequest, ListAutonomousDbPreviewVersionsResponse> onSuccess = new SuccessConsumer<ListAutonomousDbPreviewVersionsRequest, ListAutonomousDbPreviewVersionsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListAutonomousDbPreviewVersionsRequest> onError = new ErrorConsumer<ListAutonomousDbPreviewVersionsRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListAutonomousDbPreviewVersionsRequest, ListAutonomousDbPreviewVersionsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListAutonomousDbPreviewVersionsRequest, ListAutonomousDbPreviewVersionsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListAutonomousDbPreviewVersionsRequest> onError = handler == null ? null : new ErrorConsumer<ListAutonomousDbPreviewVersionsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListAutonomousDbPreviewVersionsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListAutonomousDbPreviewVersionsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListAutonomousExadataInfrastructureShapesResponse> listAutonomousExadataInfrastructureShapes(ListAutonomousExadataInfrastructureShapesRequest request, AsyncHandler<ListAutonomousExadataInfrastructureShapesRequest, ListAutonomousExadataInfrastructureShapesResponse> handler) {
        LOG.trace("Called async listAutonomousExadataInfrastructureShapes");
        final ListAutonomousExadataInfrastructureShapesRequest interceptedRequest = ListAutonomousExadataInfrastructureShapesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAutonomousExadataInfrastructureShapesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAutonomousExadataInfrastructureShapesResponse> transformer = ListAutonomousExadataInfrastructureShapesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListAutonomousExadataInfrastructureShapesRequest, ListAutonomousExadataInfrastructureShapesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAutonomousExadataInfrastructureShapesRequest, ListAutonomousExadataInfrastructureShapesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListAutonomousExadataInfrastructureShapesRequest, ListAutonomousExadataInfrastructureShapesResponse> onSuccess = new SuccessConsumer<ListAutonomousExadataInfrastructureShapesRequest, ListAutonomousExadataInfrastructureShapesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListAutonomousExadataInfrastructureShapesRequest> onError = new ErrorConsumer<ListAutonomousExadataInfrastructureShapesRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListAutonomousExadataInfrastructureShapesRequest, ListAutonomousExadataInfrastructureShapesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListAutonomousExadataInfrastructureShapesRequest, ListAutonomousExadataInfrastructureShapesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListAutonomousExadataInfrastructureShapesRequest> onError = handler == null ? null : new ErrorConsumer<ListAutonomousExadataInfrastructureShapesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListAutonomousExadataInfrastructureShapesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListAutonomousExadataInfrastructureShapesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListAutonomousExadataInfrastructuresResponse> listAutonomousExadataInfrastructures(ListAutonomousExadataInfrastructuresRequest request, AsyncHandler<ListAutonomousExadataInfrastructuresRequest, ListAutonomousExadataInfrastructuresResponse> handler) {
        LOG.trace("Called async listAutonomousExadataInfrastructures");
        final ListAutonomousExadataInfrastructuresRequest interceptedRequest = ListAutonomousExadataInfrastructuresConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListAutonomousExadataInfrastructuresConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListAutonomousExadataInfrastructuresResponse> transformer = ListAutonomousExadataInfrastructuresConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListAutonomousExadataInfrastructuresRequest, ListAutonomousExadataInfrastructuresResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListAutonomousExadataInfrastructuresRequest, ListAutonomousExadataInfrastructuresResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListAutonomousExadataInfrastructuresRequest, ListAutonomousExadataInfrastructuresResponse> onSuccess = new SuccessConsumer<ListAutonomousExadataInfrastructuresRequest, ListAutonomousExadataInfrastructuresResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListAutonomousExadataInfrastructuresRequest> onError = new ErrorConsumer<ListAutonomousExadataInfrastructuresRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListAutonomousExadataInfrastructuresRequest, ListAutonomousExadataInfrastructuresResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListAutonomousExadataInfrastructuresRequest, ListAutonomousExadataInfrastructuresResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListAutonomousExadataInfrastructuresRequest> onError = handler == null ? null : new ErrorConsumer<ListAutonomousExadataInfrastructuresRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListAutonomousExadataInfrastructuresResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListAutonomousExadataInfrastructuresResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListBackupDestinationResponse> listBackupDestination(ListBackupDestinationRequest request, AsyncHandler<ListBackupDestinationRequest, ListBackupDestinationResponse> handler) {
        LOG.trace("Called async listBackupDestination");
        final ListBackupDestinationRequest interceptedRequest = ListBackupDestinationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListBackupDestinationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListBackupDestinationResponse> transformer = ListBackupDestinationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListBackupDestinationRequest, ListBackupDestinationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListBackupDestinationRequest, ListBackupDestinationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListBackupDestinationRequest, ListBackupDestinationResponse> onSuccess = new SuccessConsumer<ListBackupDestinationRequest, ListBackupDestinationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListBackupDestinationRequest> onError = new ErrorConsumer<ListBackupDestinationRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListBackupDestinationRequest, ListBackupDestinationResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListBackupDestinationRequest, ListBackupDestinationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListBackupDestinationRequest> onError = handler == null ? null : new ErrorConsumer<ListBackupDestinationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListBackupDestinationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListBackupDestinationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListBackupsResponse> listBackups(ListBackupsRequest request, AsyncHandler<ListBackupsRequest, ListBackupsResponse> handler) {
        LOG.trace("Called async listBackups");
        final ListBackupsRequest interceptedRequest = ListBackupsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListBackupsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListBackupsResponse> transformer = ListBackupsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListBackupsRequest, ListBackupsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListBackupsRequest, ListBackupsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListBackupsRequest, ListBackupsResponse> onSuccess = new SuccessConsumer<ListBackupsRequest, ListBackupsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListBackupsRequest> onError = new ErrorConsumer<ListBackupsRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListBackupsRequest, ListBackupsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListBackupsRequest, ListBackupsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListBackupsRequest> onError = handler == null ? null : new ErrorConsumer<ListBackupsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListBackupsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListBackupsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListDataGuardAssociationsResponse> listDataGuardAssociations(ListDataGuardAssociationsRequest request, AsyncHandler<ListDataGuardAssociationsRequest, ListDataGuardAssociationsResponse> handler) {
        LOG.trace("Called async listDataGuardAssociations");
        final ListDataGuardAssociationsRequest interceptedRequest = ListDataGuardAssociationsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListDataGuardAssociationsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListDataGuardAssociationsResponse> transformer = ListDataGuardAssociationsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListDataGuardAssociationsRequest, ListDataGuardAssociationsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListDataGuardAssociationsRequest, ListDataGuardAssociationsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListDataGuardAssociationsRequest, ListDataGuardAssociationsResponse> onSuccess = new SuccessConsumer<ListDataGuardAssociationsRequest, ListDataGuardAssociationsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListDataGuardAssociationsRequest> onError = new ErrorConsumer<ListDataGuardAssociationsRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListDataGuardAssociationsRequest, ListDataGuardAssociationsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListDataGuardAssociationsRequest, ListDataGuardAssociationsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListDataGuardAssociationsRequest> onError = handler == null ? null : new ErrorConsumer<ListDataGuardAssociationsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListDataGuardAssociationsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListDataGuardAssociationsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListDatabasesResponse> listDatabases(ListDatabasesRequest request, AsyncHandler<ListDatabasesRequest, ListDatabasesResponse> handler) {
        LOG.trace("Called async listDatabases");
        final ListDatabasesRequest interceptedRequest = ListDatabasesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListDatabasesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListDatabasesResponse> transformer = ListDatabasesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListDatabasesRequest, ListDatabasesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListDatabasesRequest, ListDatabasesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListDatabasesRequest, ListDatabasesResponse> onSuccess = new SuccessConsumer<ListDatabasesRequest, ListDatabasesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListDatabasesRequest> onError = new ErrorConsumer<ListDatabasesRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListDatabasesRequest, ListDatabasesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListDatabasesRequest, ListDatabasesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListDatabasesRequest> onError = handler == null ? null : new ErrorConsumer<ListDatabasesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListDatabasesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListDatabasesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListDbHomePatchHistoryEntriesResponse> listDbHomePatchHistoryEntries(ListDbHomePatchHistoryEntriesRequest request, AsyncHandler<ListDbHomePatchHistoryEntriesRequest, ListDbHomePatchHistoryEntriesResponse> handler) {
        LOG.trace("Called async listDbHomePatchHistoryEntries");
        final ListDbHomePatchHistoryEntriesRequest interceptedRequest = ListDbHomePatchHistoryEntriesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListDbHomePatchHistoryEntriesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListDbHomePatchHistoryEntriesResponse> transformer = ListDbHomePatchHistoryEntriesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListDbHomePatchHistoryEntriesRequest, ListDbHomePatchHistoryEntriesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListDbHomePatchHistoryEntriesRequest, ListDbHomePatchHistoryEntriesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListDbHomePatchHistoryEntriesRequest, ListDbHomePatchHistoryEntriesResponse> onSuccess = new SuccessConsumer<ListDbHomePatchHistoryEntriesRequest, ListDbHomePatchHistoryEntriesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListDbHomePatchHistoryEntriesRequest> onError = new ErrorConsumer<ListDbHomePatchHistoryEntriesRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListDbHomePatchHistoryEntriesRequest, ListDbHomePatchHistoryEntriesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListDbHomePatchHistoryEntriesRequest, ListDbHomePatchHistoryEntriesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListDbHomePatchHistoryEntriesRequest> onError = handler == null ? null : new ErrorConsumer<ListDbHomePatchHistoryEntriesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListDbHomePatchHistoryEntriesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListDbHomePatchHistoryEntriesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListDbHomePatchesResponse> listDbHomePatches(ListDbHomePatchesRequest request, AsyncHandler<ListDbHomePatchesRequest, ListDbHomePatchesResponse> handler) {
        LOG.trace("Called async listDbHomePatches");
        final ListDbHomePatchesRequest interceptedRequest = ListDbHomePatchesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListDbHomePatchesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListDbHomePatchesResponse> transformer = ListDbHomePatchesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListDbHomePatchesRequest, ListDbHomePatchesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListDbHomePatchesRequest, ListDbHomePatchesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListDbHomePatchesRequest, ListDbHomePatchesResponse> onSuccess = new SuccessConsumer<ListDbHomePatchesRequest, ListDbHomePatchesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListDbHomePatchesRequest> onError = new ErrorConsumer<ListDbHomePatchesRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListDbHomePatchesRequest, ListDbHomePatchesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListDbHomePatchesRequest, ListDbHomePatchesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListDbHomePatchesRequest> onError = handler == null ? null : new ErrorConsumer<ListDbHomePatchesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListDbHomePatchesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListDbHomePatchesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListDbHomesResponse> listDbHomes(ListDbHomesRequest request, AsyncHandler<ListDbHomesRequest, ListDbHomesResponse> handler) {
        LOG.trace("Called async listDbHomes");
        final ListDbHomesRequest interceptedRequest = ListDbHomesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListDbHomesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListDbHomesResponse> transformer = ListDbHomesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListDbHomesRequest, ListDbHomesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListDbHomesRequest, ListDbHomesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListDbHomesRequest, ListDbHomesResponse> onSuccess = new SuccessConsumer<ListDbHomesRequest, ListDbHomesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListDbHomesRequest> onError = new ErrorConsumer<ListDbHomesRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListDbHomesRequest, ListDbHomesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListDbHomesRequest, ListDbHomesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListDbHomesRequest> onError = handler == null ? null : new ErrorConsumer<ListDbHomesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListDbHomesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListDbHomesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListDbNodesResponse> listDbNodes(ListDbNodesRequest request, AsyncHandler<ListDbNodesRequest, ListDbNodesResponse> handler) {
        LOG.trace("Called async listDbNodes");
        final ListDbNodesRequest interceptedRequest = ListDbNodesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListDbNodesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListDbNodesResponse> transformer = ListDbNodesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListDbNodesRequest, ListDbNodesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListDbNodesRequest, ListDbNodesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListDbNodesRequest, ListDbNodesResponse> onSuccess = new SuccessConsumer<ListDbNodesRequest, ListDbNodesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListDbNodesRequest> onError = new ErrorConsumer<ListDbNodesRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListDbNodesRequest, ListDbNodesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListDbNodesRequest, ListDbNodesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListDbNodesRequest> onError = handler == null ? null : new ErrorConsumer<ListDbNodesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListDbNodesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListDbNodesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListDbSystemPatchHistoryEntriesResponse> listDbSystemPatchHistoryEntries(ListDbSystemPatchHistoryEntriesRequest request, AsyncHandler<ListDbSystemPatchHistoryEntriesRequest, ListDbSystemPatchHistoryEntriesResponse> handler) {
        LOG.trace("Called async listDbSystemPatchHistoryEntries");
        final ListDbSystemPatchHistoryEntriesRequest interceptedRequest = ListDbSystemPatchHistoryEntriesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListDbSystemPatchHistoryEntriesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListDbSystemPatchHistoryEntriesResponse> transformer = ListDbSystemPatchHistoryEntriesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListDbSystemPatchHistoryEntriesRequest, ListDbSystemPatchHistoryEntriesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListDbSystemPatchHistoryEntriesRequest, ListDbSystemPatchHistoryEntriesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListDbSystemPatchHistoryEntriesRequest, ListDbSystemPatchHistoryEntriesResponse> onSuccess = new SuccessConsumer<ListDbSystemPatchHistoryEntriesRequest, ListDbSystemPatchHistoryEntriesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListDbSystemPatchHistoryEntriesRequest> onError = new ErrorConsumer<ListDbSystemPatchHistoryEntriesRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListDbSystemPatchHistoryEntriesRequest, ListDbSystemPatchHistoryEntriesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListDbSystemPatchHistoryEntriesRequest, ListDbSystemPatchHistoryEntriesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListDbSystemPatchHistoryEntriesRequest> onError = handler == null ? null : new ErrorConsumer<ListDbSystemPatchHistoryEntriesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListDbSystemPatchHistoryEntriesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListDbSystemPatchHistoryEntriesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListDbSystemPatchesResponse> listDbSystemPatches(ListDbSystemPatchesRequest request, AsyncHandler<ListDbSystemPatchesRequest, ListDbSystemPatchesResponse> handler) {
        LOG.trace("Called async listDbSystemPatches");
        final ListDbSystemPatchesRequest interceptedRequest = ListDbSystemPatchesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListDbSystemPatchesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListDbSystemPatchesResponse> transformer = ListDbSystemPatchesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListDbSystemPatchesRequest, ListDbSystemPatchesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListDbSystemPatchesRequest, ListDbSystemPatchesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListDbSystemPatchesRequest, ListDbSystemPatchesResponse> onSuccess = new SuccessConsumer<ListDbSystemPatchesRequest, ListDbSystemPatchesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListDbSystemPatchesRequest> onError = new ErrorConsumer<ListDbSystemPatchesRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListDbSystemPatchesRequest, ListDbSystemPatchesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListDbSystemPatchesRequest, ListDbSystemPatchesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListDbSystemPatchesRequest> onError = handler == null ? null : new ErrorConsumer<ListDbSystemPatchesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListDbSystemPatchesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListDbSystemPatchesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListDbSystemShapesResponse> listDbSystemShapes(ListDbSystemShapesRequest request, AsyncHandler<ListDbSystemShapesRequest, ListDbSystemShapesResponse> handler) {
        LOG.trace("Called async listDbSystemShapes");
        final ListDbSystemShapesRequest interceptedRequest = ListDbSystemShapesConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListDbSystemShapesConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListDbSystemShapesResponse> transformer = ListDbSystemShapesConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListDbSystemShapesRequest, ListDbSystemShapesResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListDbSystemShapesRequest, ListDbSystemShapesResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListDbSystemShapesRequest, ListDbSystemShapesResponse> onSuccess = new SuccessConsumer<ListDbSystemShapesRequest, ListDbSystemShapesResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListDbSystemShapesRequest> onError = new ErrorConsumer<ListDbSystemShapesRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListDbSystemShapesRequest, ListDbSystemShapesResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListDbSystemShapesRequest, ListDbSystemShapesResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListDbSystemShapesRequest> onError = handler == null ? null : new ErrorConsumer<ListDbSystemShapesRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListDbSystemShapesResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListDbSystemShapesResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListDbSystemsResponse> listDbSystems(ListDbSystemsRequest request, AsyncHandler<ListDbSystemsRequest, ListDbSystemsResponse> handler) {
        LOG.trace("Called async listDbSystems");
        final ListDbSystemsRequest interceptedRequest = ListDbSystemsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListDbSystemsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListDbSystemsResponse> transformer = ListDbSystemsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListDbSystemsRequest, ListDbSystemsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListDbSystemsRequest, ListDbSystemsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListDbSystemsRequest, ListDbSystemsResponse> onSuccess = new SuccessConsumer<ListDbSystemsRequest, ListDbSystemsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListDbSystemsRequest> onError = new ErrorConsumer<ListDbSystemsRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListDbSystemsRequest, ListDbSystemsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListDbSystemsRequest, ListDbSystemsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListDbSystemsRequest> onError = handler == null ? null : new ErrorConsumer<ListDbSystemsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListDbSystemsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListDbSystemsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListDbVersionsResponse> listDbVersions(ListDbVersionsRequest request, AsyncHandler<ListDbVersionsRequest, ListDbVersionsResponse> handler) {
        LOG.trace("Called async listDbVersions");
        final ListDbVersionsRequest interceptedRequest = ListDbVersionsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListDbVersionsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListDbVersionsResponse> transformer = ListDbVersionsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListDbVersionsRequest, ListDbVersionsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListDbVersionsRequest, ListDbVersionsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListDbVersionsRequest, ListDbVersionsResponse> onSuccess = new SuccessConsumer<ListDbVersionsRequest, ListDbVersionsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListDbVersionsRequest> onError = new ErrorConsumer<ListDbVersionsRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListDbVersionsRequest, ListDbVersionsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListDbVersionsRequest, ListDbVersionsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListDbVersionsRequest> onError = handler == null ? null : new ErrorConsumer<ListDbVersionsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListDbVersionsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListDbVersionsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListExadataInfrastructuresResponse> listExadataInfrastructures(ListExadataInfrastructuresRequest request, AsyncHandler<ListExadataInfrastructuresRequest, ListExadataInfrastructuresResponse> handler) {
        LOG.trace("Called async listExadataInfrastructures");
        final ListExadataInfrastructuresRequest interceptedRequest = ListExadataInfrastructuresConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListExadataInfrastructuresConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListExadataInfrastructuresResponse> transformer = ListExadataInfrastructuresConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListExadataInfrastructuresRequest, ListExadataInfrastructuresResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListExadataInfrastructuresRequest, ListExadataInfrastructuresResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListExadataInfrastructuresRequest, ListExadataInfrastructuresResponse> onSuccess = new SuccessConsumer<ListExadataInfrastructuresRequest, ListExadataInfrastructuresResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListExadataInfrastructuresRequest> onError = new ErrorConsumer<ListExadataInfrastructuresRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListExadataInfrastructuresRequest, ListExadataInfrastructuresResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListExadataInfrastructuresRequest, ListExadataInfrastructuresResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListExadataInfrastructuresRequest> onError = handler == null ? null : new ErrorConsumer<ListExadataInfrastructuresRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListExadataInfrastructuresResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListExadataInfrastructuresResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListGiVersionsResponse> listGiVersions(ListGiVersionsRequest request, AsyncHandler<ListGiVersionsRequest, ListGiVersionsResponse> handler) {
        LOG.trace("Called async listGiVersions");
        final ListGiVersionsRequest interceptedRequest = ListGiVersionsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListGiVersionsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListGiVersionsResponse> transformer = ListGiVersionsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListGiVersionsRequest, ListGiVersionsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListGiVersionsRequest, ListGiVersionsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListGiVersionsRequest, ListGiVersionsResponse> onSuccess = new SuccessConsumer<ListGiVersionsRequest, ListGiVersionsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListGiVersionsRequest> onError = new ErrorConsumer<ListGiVersionsRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListGiVersionsRequest, ListGiVersionsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListGiVersionsRequest, ListGiVersionsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListGiVersionsRequest> onError = handler == null ? null : new ErrorConsumer<ListGiVersionsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListGiVersionsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListGiVersionsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListMaintenanceRunsResponse> listMaintenanceRuns(ListMaintenanceRunsRequest request, AsyncHandler<ListMaintenanceRunsRequest, ListMaintenanceRunsResponse> handler) {
        LOG.trace("Called async listMaintenanceRuns");
        final ListMaintenanceRunsRequest interceptedRequest = ListMaintenanceRunsConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListMaintenanceRunsConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListMaintenanceRunsResponse> transformer = ListMaintenanceRunsConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListMaintenanceRunsRequest, ListMaintenanceRunsResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListMaintenanceRunsRequest, ListMaintenanceRunsResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListMaintenanceRunsRequest, ListMaintenanceRunsResponse> onSuccess = new SuccessConsumer<ListMaintenanceRunsRequest, ListMaintenanceRunsResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListMaintenanceRunsRequest> onError = new ErrorConsumer<ListMaintenanceRunsRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListMaintenanceRunsRequest, ListMaintenanceRunsResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListMaintenanceRunsRequest, ListMaintenanceRunsResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListMaintenanceRunsRequest> onError = handler == null ? null : new ErrorConsumer<ListMaintenanceRunsRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListMaintenanceRunsResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListMaintenanceRunsResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListVmClusterNetworksResponse> listVmClusterNetworks(ListVmClusterNetworksRequest request, AsyncHandler<ListVmClusterNetworksRequest, ListVmClusterNetworksResponse> handler) {
        LOG.trace("Called async listVmClusterNetworks");
        final ListVmClusterNetworksRequest interceptedRequest = ListVmClusterNetworksConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListVmClusterNetworksConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListVmClusterNetworksResponse> transformer = ListVmClusterNetworksConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListVmClusterNetworksRequest, ListVmClusterNetworksResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListVmClusterNetworksRequest, ListVmClusterNetworksResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListVmClusterNetworksRequest, ListVmClusterNetworksResponse> onSuccess = new SuccessConsumer<ListVmClusterNetworksRequest, ListVmClusterNetworksResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListVmClusterNetworksRequest> onError = new ErrorConsumer<ListVmClusterNetworksRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListVmClusterNetworksRequest, ListVmClusterNetworksResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListVmClusterNetworksRequest, ListVmClusterNetworksResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListVmClusterNetworksRequest> onError = handler == null ? null : new ErrorConsumer<ListVmClusterNetworksRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListVmClusterNetworksResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListVmClusterNetworksResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ListVmClustersResponse> listVmClusters(ListVmClustersRequest request, AsyncHandler<ListVmClustersRequest, ListVmClustersResponse> handler) {
        LOG.trace("Called async listVmClusters");
        final ListVmClustersRequest interceptedRequest = ListVmClustersConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ListVmClustersConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ListVmClustersResponse> transformer = ListVmClustersConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ListVmClustersRequest, ListVmClustersResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ListVmClustersRequest, ListVmClustersResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ListVmClustersRequest, ListVmClustersResponse> onSuccess = new SuccessConsumer<ListVmClustersRequest, ListVmClustersResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ListVmClustersRequest> onError = new ErrorConsumer<ListVmClustersRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ListVmClustersRequest, ListVmClustersResponse> onSuccess = handler == null ? null : new SuccessConsumer<ListVmClustersRequest, ListVmClustersResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ListVmClustersRequest> onError = handler == null ? null : new ErrorConsumer<ListVmClustersRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.get(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ListVmClustersResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.get(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ListVmClustersResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ReinstateDataGuardAssociationResponse> reinstateDataGuardAssociation(ReinstateDataGuardAssociationRequest request, AsyncHandler<ReinstateDataGuardAssociationRequest, ReinstateDataGuardAssociationResponse> handler) {
        LOG.trace("Called async reinstateDataGuardAssociation");
        final ReinstateDataGuardAssociationRequest interceptedRequest = ReinstateDataGuardAssociationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ReinstateDataGuardAssociationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ReinstateDataGuardAssociationResponse> transformer = ReinstateDataGuardAssociationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ReinstateDataGuardAssociationRequest, ReinstateDataGuardAssociationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ReinstateDataGuardAssociationRequest, ReinstateDataGuardAssociationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ReinstateDataGuardAssociationRequest, ReinstateDataGuardAssociationResponse> onSuccess = new SuccessConsumer<ReinstateDataGuardAssociationRequest, ReinstateDataGuardAssociationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ReinstateDataGuardAssociationRequest> onError = new ErrorConsumer<ReinstateDataGuardAssociationRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getReinstateDataGuardAssociationDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ReinstateDataGuardAssociationRequest, ReinstateDataGuardAssociationResponse> onSuccess = handler == null ? null : new SuccessConsumer<ReinstateDataGuardAssociationRequest, ReinstateDataGuardAssociationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ReinstateDataGuardAssociationRequest> onError = handler == null ? null : new ErrorConsumer<ReinstateDataGuardAssociationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getReinstateDataGuardAssociationDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ReinstateDataGuardAssociationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getReinstateDataGuardAssociationDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ReinstateDataGuardAssociationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<RestartAutonomousContainerDatabaseResponse> restartAutonomousContainerDatabase(RestartAutonomousContainerDatabaseRequest request, AsyncHandler<RestartAutonomousContainerDatabaseRequest, RestartAutonomousContainerDatabaseResponse> handler) {
        LOG.trace("Called async restartAutonomousContainerDatabase");
        final RestartAutonomousContainerDatabaseRequest interceptedRequest = RestartAutonomousContainerDatabaseConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = RestartAutonomousContainerDatabaseConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, RestartAutonomousContainerDatabaseResponse> transformer = RestartAutonomousContainerDatabaseConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<RestartAutonomousContainerDatabaseRequest, RestartAutonomousContainerDatabaseResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<RestartAutonomousContainerDatabaseRequest, RestartAutonomousContainerDatabaseResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<RestartAutonomousContainerDatabaseRequest, RestartAutonomousContainerDatabaseResponse> onSuccess = new SuccessConsumer<RestartAutonomousContainerDatabaseRequest, RestartAutonomousContainerDatabaseResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<RestartAutonomousContainerDatabaseRequest> onError = new ErrorConsumer<RestartAutonomousContainerDatabaseRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<RestartAutonomousContainerDatabaseRequest, RestartAutonomousContainerDatabaseResponse> onSuccess = handler == null ? null : new SuccessConsumer<RestartAutonomousContainerDatabaseRequest, RestartAutonomousContainerDatabaseResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<RestartAutonomousContainerDatabaseRequest> onError = handler == null ? null : new ErrorConsumer<RestartAutonomousContainerDatabaseRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, RestartAutonomousContainerDatabaseResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, RestartAutonomousContainerDatabaseResponse>(responseFuture, transformer);
    }

    @Override
    public Future<RestoreAutonomousDataWarehouseResponse> restoreAutonomousDataWarehouse(RestoreAutonomousDataWarehouseRequest request, AsyncHandler<RestoreAutonomousDataWarehouseRequest, RestoreAutonomousDataWarehouseResponse> handler) {
        LOG.trace("Called async restoreAutonomousDataWarehouse");
        final RestoreAutonomousDataWarehouseRequest interceptedRequest = RestoreAutonomousDataWarehouseConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = RestoreAutonomousDataWarehouseConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, RestoreAutonomousDataWarehouseResponse> transformer = RestoreAutonomousDataWarehouseConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<RestoreAutonomousDataWarehouseRequest, RestoreAutonomousDataWarehouseResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<RestoreAutonomousDataWarehouseRequest, RestoreAutonomousDataWarehouseResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<RestoreAutonomousDataWarehouseRequest, RestoreAutonomousDataWarehouseResponse> onSuccess = new SuccessConsumer<RestoreAutonomousDataWarehouseRequest, RestoreAutonomousDataWarehouseResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<RestoreAutonomousDataWarehouseRequest> onError = new ErrorConsumer<RestoreAutonomousDataWarehouseRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getRestoreAutonomousDataWarehouseDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<RestoreAutonomousDataWarehouseRequest, RestoreAutonomousDataWarehouseResponse> onSuccess = handler == null ? null : new SuccessConsumer<RestoreAutonomousDataWarehouseRequest, RestoreAutonomousDataWarehouseResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<RestoreAutonomousDataWarehouseRequest> onError = handler == null ? null : new ErrorConsumer<RestoreAutonomousDataWarehouseRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getRestoreAutonomousDataWarehouseDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, RestoreAutonomousDataWarehouseResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getRestoreAutonomousDataWarehouseDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, RestoreAutonomousDataWarehouseResponse>(responseFuture, transformer);
    }

    @Override
    public Future<RestoreAutonomousDatabaseResponse> restoreAutonomousDatabase(RestoreAutonomousDatabaseRequest request, AsyncHandler<RestoreAutonomousDatabaseRequest, RestoreAutonomousDatabaseResponse> handler) {
        LOG.trace("Called async restoreAutonomousDatabase");
        final RestoreAutonomousDatabaseRequest interceptedRequest = RestoreAutonomousDatabaseConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = RestoreAutonomousDatabaseConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, RestoreAutonomousDatabaseResponse> transformer = RestoreAutonomousDatabaseConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<RestoreAutonomousDatabaseRequest, RestoreAutonomousDatabaseResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<RestoreAutonomousDatabaseRequest, RestoreAutonomousDatabaseResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<RestoreAutonomousDatabaseRequest, RestoreAutonomousDatabaseResponse> onSuccess = new SuccessConsumer<RestoreAutonomousDatabaseRequest, RestoreAutonomousDatabaseResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<RestoreAutonomousDatabaseRequest> onError = new ErrorConsumer<RestoreAutonomousDatabaseRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getRestoreAutonomousDatabaseDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<RestoreAutonomousDatabaseRequest, RestoreAutonomousDatabaseResponse> onSuccess = handler == null ? null : new SuccessConsumer<RestoreAutonomousDatabaseRequest, RestoreAutonomousDatabaseResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<RestoreAutonomousDatabaseRequest> onError = handler == null ? null : new ErrorConsumer<RestoreAutonomousDatabaseRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getRestoreAutonomousDatabaseDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, RestoreAutonomousDatabaseResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getRestoreAutonomousDatabaseDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, RestoreAutonomousDatabaseResponse>(responseFuture, transformer);
    }

    @Override
    public Future<RestoreDatabaseResponse> restoreDatabase(RestoreDatabaseRequest request, AsyncHandler<RestoreDatabaseRequest, RestoreDatabaseResponse> handler) {
        LOG.trace("Called async restoreDatabase");
        final RestoreDatabaseRequest interceptedRequest = RestoreDatabaseConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = RestoreDatabaseConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, RestoreDatabaseResponse> transformer = RestoreDatabaseConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<RestoreDatabaseRequest, RestoreDatabaseResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<RestoreDatabaseRequest, RestoreDatabaseResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<RestoreDatabaseRequest, RestoreDatabaseResponse> onSuccess = new SuccessConsumer<RestoreDatabaseRequest, RestoreDatabaseResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<RestoreDatabaseRequest> onError = new ErrorConsumer<RestoreDatabaseRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getRestoreDatabaseDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<RestoreDatabaseRequest, RestoreDatabaseResponse> onSuccess = handler == null ? null : new SuccessConsumer<RestoreDatabaseRequest, RestoreDatabaseResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<RestoreDatabaseRequest> onError = handler == null ? null : new ErrorConsumer<RestoreDatabaseRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getRestoreDatabaseDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, RestoreDatabaseResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getRestoreDatabaseDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, RestoreDatabaseResponse>(responseFuture, transformer);
    }

    @Override
    public Future<StartAutonomousDataWarehouseResponse> startAutonomousDataWarehouse(StartAutonomousDataWarehouseRequest request, AsyncHandler<StartAutonomousDataWarehouseRequest, StartAutonomousDataWarehouseResponse> handler) {
        LOG.trace("Called async startAutonomousDataWarehouse");
        final StartAutonomousDataWarehouseRequest interceptedRequest = StartAutonomousDataWarehouseConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = StartAutonomousDataWarehouseConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, StartAutonomousDataWarehouseResponse> transformer = StartAutonomousDataWarehouseConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<StartAutonomousDataWarehouseRequest, StartAutonomousDataWarehouseResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<StartAutonomousDataWarehouseRequest, StartAutonomousDataWarehouseResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<StartAutonomousDataWarehouseRequest, StartAutonomousDataWarehouseResponse> onSuccess = new SuccessConsumer<StartAutonomousDataWarehouseRequest, StartAutonomousDataWarehouseResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<StartAutonomousDataWarehouseRequest> onError = new ErrorConsumer<StartAutonomousDataWarehouseRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<StartAutonomousDataWarehouseRequest, StartAutonomousDataWarehouseResponse> onSuccess = handler == null ? null : new SuccessConsumer<StartAutonomousDataWarehouseRequest, StartAutonomousDataWarehouseResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<StartAutonomousDataWarehouseRequest> onError = handler == null ? null : new ErrorConsumer<StartAutonomousDataWarehouseRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, StartAutonomousDataWarehouseResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, StartAutonomousDataWarehouseResponse>(responseFuture, transformer);
    }

    @Override
    public Future<StartAutonomousDatabaseResponse> startAutonomousDatabase(StartAutonomousDatabaseRequest request, AsyncHandler<StartAutonomousDatabaseRequest, StartAutonomousDatabaseResponse> handler) {
        LOG.trace("Called async startAutonomousDatabase");
        final StartAutonomousDatabaseRequest interceptedRequest = StartAutonomousDatabaseConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = StartAutonomousDatabaseConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, StartAutonomousDatabaseResponse> transformer = StartAutonomousDatabaseConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<StartAutonomousDatabaseRequest, StartAutonomousDatabaseResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<StartAutonomousDatabaseRequest, StartAutonomousDatabaseResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<StartAutonomousDatabaseRequest, StartAutonomousDatabaseResponse> onSuccess = new SuccessConsumer<StartAutonomousDatabaseRequest, StartAutonomousDatabaseResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<StartAutonomousDatabaseRequest> onError = new ErrorConsumer<StartAutonomousDatabaseRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<StartAutonomousDatabaseRequest, StartAutonomousDatabaseResponse> onSuccess = handler == null ? null : new SuccessConsumer<StartAutonomousDatabaseRequest, StartAutonomousDatabaseResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<StartAutonomousDatabaseRequest> onError = handler == null ? null : new ErrorConsumer<StartAutonomousDatabaseRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, StartAutonomousDatabaseResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, StartAutonomousDatabaseResponse>(responseFuture, transformer);
    }

    @Override
    public Future<StopAutonomousDataWarehouseResponse> stopAutonomousDataWarehouse(StopAutonomousDataWarehouseRequest request, AsyncHandler<StopAutonomousDataWarehouseRequest, StopAutonomousDataWarehouseResponse> handler) {
        LOG.trace("Called async stopAutonomousDataWarehouse");
        final StopAutonomousDataWarehouseRequest interceptedRequest = StopAutonomousDataWarehouseConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = StopAutonomousDataWarehouseConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, StopAutonomousDataWarehouseResponse> transformer = StopAutonomousDataWarehouseConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<StopAutonomousDataWarehouseRequest, StopAutonomousDataWarehouseResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<StopAutonomousDataWarehouseRequest, StopAutonomousDataWarehouseResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<StopAutonomousDataWarehouseRequest, StopAutonomousDataWarehouseResponse> onSuccess = new SuccessConsumer<StopAutonomousDataWarehouseRequest, StopAutonomousDataWarehouseResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<StopAutonomousDataWarehouseRequest> onError = new ErrorConsumer<StopAutonomousDataWarehouseRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<StopAutonomousDataWarehouseRequest, StopAutonomousDataWarehouseResponse> onSuccess = handler == null ? null : new SuccessConsumer<StopAutonomousDataWarehouseRequest, StopAutonomousDataWarehouseResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<StopAutonomousDataWarehouseRequest> onError = handler == null ? null : new ErrorConsumer<StopAutonomousDataWarehouseRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, StopAutonomousDataWarehouseResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, StopAutonomousDataWarehouseResponse>(responseFuture, transformer);
    }

    @Override
    public Future<StopAutonomousDatabaseResponse> stopAutonomousDatabase(StopAutonomousDatabaseRequest request, AsyncHandler<StopAutonomousDatabaseRequest, StopAutonomousDatabaseResponse> handler) {
        LOG.trace("Called async stopAutonomousDatabase");
        final StopAutonomousDatabaseRequest interceptedRequest = StopAutonomousDatabaseConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = StopAutonomousDatabaseConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, StopAutonomousDatabaseResponse> transformer = StopAutonomousDatabaseConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<StopAutonomousDatabaseRequest, StopAutonomousDatabaseResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<StopAutonomousDatabaseRequest, StopAutonomousDatabaseResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<StopAutonomousDatabaseRequest, StopAutonomousDatabaseResponse> onSuccess = new SuccessConsumer<StopAutonomousDatabaseRequest, StopAutonomousDatabaseResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<StopAutonomousDatabaseRequest> onError = new ErrorConsumer<StopAutonomousDatabaseRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<StopAutonomousDatabaseRequest, StopAutonomousDatabaseResponse> onSuccess = handler == null ? null : new SuccessConsumer<StopAutonomousDatabaseRequest, StopAutonomousDatabaseResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<StopAutonomousDatabaseRequest> onError = handler == null ? null : new ErrorConsumer<StopAutonomousDatabaseRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, StopAutonomousDatabaseResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, StopAutonomousDatabaseResponse>(responseFuture, transformer);
    }

    @Override
    public Future<SwitchoverDataGuardAssociationResponse> switchoverDataGuardAssociation(SwitchoverDataGuardAssociationRequest request, AsyncHandler<SwitchoverDataGuardAssociationRequest, SwitchoverDataGuardAssociationResponse> handler) {
        LOG.trace("Called async switchoverDataGuardAssociation");
        final SwitchoverDataGuardAssociationRequest interceptedRequest = SwitchoverDataGuardAssociationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = SwitchoverDataGuardAssociationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, SwitchoverDataGuardAssociationResponse> transformer = SwitchoverDataGuardAssociationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<SwitchoverDataGuardAssociationRequest, SwitchoverDataGuardAssociationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<SwitchoverDataGuardAssociationRequest, SwitchoverDataGuardAssociationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<SwitchoverDataGuardAssociationRequest, SwitchoverDataGuardAssociationResponse> onSuccess = new SuccessConsumer<SwitchoverDataGuardAssociationRequest, SwitchoverDataGuardAssociationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<SwitchoverDataGuardAssociationRequest> onError = new ErrorConsumer<SwitchoverDataGuardAssociationRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getSwitchoverDataGuardAssociationDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<SwitchoverDataGuardAssociationRequest, SwitchoverDataGuardAssociationResponse> onSuccess = handler == null ? null : new SuccessConsumer<SwitchoverDataGuardAssociationRequest, SwitchoverDataGuardAssociationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<SwitchoverDataGuardAssociationRequest> onError = handler == null ? null : new ErrorConsumer<SwitchoverDataGuardAssociationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest.getSwitchoverDataGuardAssociationDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, SwitchoverDataGuardAssociationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest.getSwitchoverDataGuardAssociationDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, SwitchoverDataGuardAssociationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<TerminateAutonomousContainerDatabaseResponse> terminateAutonomousContainerDatabase(TerminateAutonomousContainerDatabaseRequest request, AsyncHandler<TerminateAutonomousContainerDatabaseRequest, TerminateAutonomousContainerDatabaseResponse> handler) {
        LOG.trace("Called async terminateAutonomousContainerDatabase");
        final TerminateAutonomousContainerDatabaseRequest interceptedRequest = TerminateAutonomousContainerDatabaseConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = TerminateAutonomousContainerDatabaseConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, TerminateAutonomousContainerDatabaseResponse> transformer = TerminateAutonomousContainerDatabaseConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<TerminateAutonomousContainerDatabaseRequest, TerminateAutonomousContainerDatabaseResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<TerminateAutonomousContainerDatabaseRequest, TerminateAutonomousContainerDatabaseResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<TerminateAutonomousContainerDatabaseRequest, TerminateAutonomousContainerDatabaseResponse> onSuccess = new SuccessConsumer<TerminateAutonomousContainerDatabaseRequest, TerminateAutonomousContainerDatabaseResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<TerminateAutonomousContainerDatabaseRequest> onError = new ErrorConsumer<TerminateAutonomousContainerDatabaseRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<TerminateAutonomousContainerDatabaseRequest, TerminateAutonomousContainerDatabaseResponse> onSuccess = handler == null ? null : new SuccessConsumer<TerminateAutonomousContainerDatabaseRequest, TerminateAutonomousContainerDatabaseResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<TerminateAutonomousContainerDatabaseRequest> onError = handler == null ? null : new ErrorConsumer<TerminateAutonomousContainerDatabaseRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, TerminateAutonomousContainerDatabaseResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, TerminateAutonomousContainerDatabaseResponse>(responseFuture, transformer);
    }

    @Override
    public Future<TerminateAutonomousExadataInfrastructureResponse> terminateAutonomousExadataInfrastructure(TerminateAutonomousExadataInfrastructureRequest request, AsyncHandler<TerminateAutonomousExadataInfrastructureRequest, TerminateAutonomousExadataInfrastructureResponse> handler) {
        LOG.trace("Called async terminateAutonomousExadataInfrastructure");
        final TerminateAutonomousExadataInfrastructureRequest interceptedRequest = TerminateAutonomousExadataInfrastructureConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = TerminateAutonomousExadataInfrastructureConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, TerminateAutonomousExadataInfrastructureResponse> transformer = TerminateAutonomousExadataInfrastructureConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<TerminateAutonomousExadataInfrastructureRequest, TerminateAutonomousExadataInfrastructureResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<TerminateAutonomousExadataInfrastructureRequest, TerminateAutonomousExadataInfrastructureResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<TerminateAutonomousExadataInfrastructureRequest, TerminateAutonomousExadataInfrastructureResponse> onSuccess = new SuccessConsumer<TerminateAutonomousExadataInfrastructureRequest, TerminateAutonomousExadataInfrastructureResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<TerminateAutonomousExadataInfrastructureRequest> onError = new ErrorConsumer<TerminateAutonomousExadataInfrastructureRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<TerminateAutonomousExadataInfrastructureRequest, TerminateAutonomousExadataInfrastructureResponse> onSuccess = handler == null ? null : new SuccessConsumer<TerminateAutonomousExadataInfrastructureRequest, TerminateAutonomousExadataInfrastructureResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<TerminateAutonomousExadataInfrastructureRequest> onError = handler == null ? null : new ErrorConsumer<TerminateAutonomousExadataInfrastructureRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, TerminateAutonomousExadataInfrastructureResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, TerminateAutonomousExadataInfrastructureResponse>(responseFuture, transformer);
    }

    @Override
    public Future<TerminateDbSystemResponse> terminateDbSystem(TerminateDbSystemRequest request, AsyncHandler<TerminateDbSystemRequest, TerminateDbSystemResponse> handler) {
        LOG.trace("Called async terminateDbSystem");
        final TerminateDbSystemRequest interceptedRequest = TerminateDbSystemConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = TerminateDbSystemConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, TerminateDbSystemResponse> transformer = TerminateDbSystemConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<TerminateDbSystemRequest, TerminateDbSystemResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<TerminateDbSystemRequest, TerminateDbSystemResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<TerminateDbSystemRequest, TerminateDbSystemResponse> onSuccess = new SuccessConsumer<TerminateDbSystemRequest, TerminateDbSystemResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<TerminateDbSystemRequest> onError = new ErrorConsumer<TerminateDbSystemRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<TerminateDbSystemRequest, TerminateDbSystemResponse> onSuccess = handler == null ? null : new SuccessConsumer<TerminateDbSystemRequest, TerminateDbSystemResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<TerminateDbSystemRequest> onError = handler == null ? null : new ErrorConsumer<TerminateDbSystemRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.delete(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, TerminateDbSystemResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.delete(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, TerminateDbSystemResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateAutonomousContainerDatabaseResponse> updateAutonomousContainerDatabase(UpdateAutonomousContainerDatabaseRequest request, AsyncHandler<UpdateAutonomousContainerDatabaseRequest, UpdateAutonomousContainerDatabaseResponse> handler) {
        LOG.trace("Called async updateAutonomousContainerDatabase");
        final UpdateAutonomousContainerDatabaseRequest interceptedRequest = UpdateAutonomousContainerDatabaseConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateAutonomousContainerDatabaseConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateAutonomousContainerDatabaseResponse> transformer = UpdateAutonomousContainerDatabaseConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateAutonomousContainerDatabaseRequest, UpdateAutonomousContainerDatabaseResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateAutonomousContainerDatabaseRequest, UpdateAutonomousContainerDatabaseResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateAutonomousContainerDatabaseRequest, UpdateAutonomousContainerDatabaseResponse> onSuccess = new SuccessConsumer<UpdateAutonomousContainerDatabaseRequest, UpdateAutonomousContainerDatabaseResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateAutonomousContainerDatabaseRequest> onError = new ErrorConsumer<UpdateAutonomousContainerDatabaseRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getUpdateAutonomousContainerDatabaseDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateAutonomousContainerDatabaseRequest, UpdateAutonomousContainerDatabaseResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateAutonomousContainerDatabaseRequest, UpdateAutonomousContainerDatabaseResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateAutonomousContainerDatabaseRequest> onError = handler == null ? null : new ErrorConsumer<UpdateAutonomousContainerDatabaseRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateAutonomousContainerDatabaseDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateAutonomousContainerDatabaseResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getUpdateAutonomousContainerDatabaseDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateAutonomousContainerDatabaseResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateAutonomousDataWarehouseResponse> updateAutonomousDataWarehouse(UpdateAutonomousDataWarehouseRequest request, AsyncHandler<UpdateAutonomousDataWarehouseRequest, UpdateAutonomousDataWarehouseResponse> handler) {
        LOG.trace("Called async updateAutonomousDataWarehouse");
        final UpdateAutonomousDataWarehouseRequest interceptedRequest = UpdateAutonomousDataWarehouseConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateAutonomousDataWarehouseConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateAutonomousDataWarehouseResponse> transformer = UpdateAutonomousDataWarehouseConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateAutonomousDataWarehouseRequest, UpdateAutonomousDataWarehouseResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateAutonomousDataWarehouseRequest, UpdateAutonomousDataWarehouseResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateAutonomousDataWarehouseRequest, UpdateAutonomousDataWarehouseResponse> onSuccess = new SuccessConsumer<UpdateAutonomousDataWarehouseRequest, UpdateAutonomousDataWarehouseResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateAutonomousDataWarehouseRequest> onError = new ErrorConsumer<UpdateAutonomousDataWarehouseRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getUpdateAutonomousDataWarehouseDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateAutonomousDataWarehouseRequest, UpdateAutonomousDataWarehouseResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateAutonomousDataWarehouseRequest, UpdateAutonomousDataWarehouseResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateAutonomousDataWarehouseRequest> onError = handler == null ? null : new ErrorConsumer<UpdateAutonomousDataWarehouseRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateAutonomousDataWarehouseDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateAutonomousDataWarehouseResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getUpdateAutonomousDataWarehouseDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateAutonomousDataWarehouseResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateAutonomousDatabaseResponse> updateAutonomousDatabase(UpdateAutonomousDatabaseRequest request, AsyncHandler<UpdateAutonomousDatabaseRequest, UpdateAutonomousDatabaseResponse> handler) {
        LOG.trace("Called async updateAutonomousDatabase");
        final UpdateAutonomousDatabaseRequest interceptedRequest = UpdateAutonomousDatabaseConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateAutonomousDatabaseConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateAutonomousDatabaseResponse> transformer = UpdateAutonomousDatabaseConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateAutonomousDatabaseRequest, UpdateAutonomousDatabaseResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateAutonomousDatabaseRequest, UpdateAutonomousDatabaseResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateAutonomousDatabaseRequest, UpdateAutonomousDatabaseResponse> onSuccess = new SuccessConsumer<UpdateAutonomousDatabaseRequest, UpdateAutonomousDatabaseResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateAutonomousDatabaseRequest> onError = new ErrorConsumer<UpdateAutonomousDatabaseRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getUpdateAutonomousDatabaseDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateAutonomousDatabaseRequest, UpdateAutonomousDatabaseResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateAutonomousDatabaseRequest, UpdateAutonomousDatabaseResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateAutonomousDatabaseRequest> onError = handler == null ? null : new ErrorConsumer<UpdateAutonomousDatabaseRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateAutonomousDatabaseDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateAutonomousDatabaseResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getUpdateAutonomousDatabaseDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateAutonomousDatabaseResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateAutonomousExadataInfrastructureResponse> updateAutonomousExadataInfrastructure(UpdateAutonomousExadataInfrastructureRequest request, AsyncHandler<UpdateAutonomousExadataInfrastructureRequest, UpdateAutonomousExadataInfrastructureResponse> handler) {
        LOG.trace("Called async updateAutonomousExadataInfrastructure");
        final UpdateAutonomousExadataInfrastructureRequest interceptedRequest = UpdateAutonomousExadataInfrastructureConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateAutonomousExadataInfrastructureConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateAutonomousExadataInfrastructureResponse> transformer = UpdateAutonomousExadataInfrastructureConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateAutonomousExadataInfrastructureRequest, UpdateAutonomousExadataInfrastructureResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateAutonomousExadataInfrastructureRequest, UpdateAutonomousExadataInfrastructureResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateAutonomousExadataInfrastructureRequest, UpdateAutonomousExadataInfrastructureResponse> onSuccess = new SuccessConsumer<UpdateAutonomousExadataInfrastructureRequest, UpdateAutonomousExadataInfrastructureResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateAutonomousExadataInfrastructureRequest> onError = new ErrorConsumer<UpdateAutonomousExadataInfrastructureRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getUpdateAutonomousExadataInfrastructuresDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateAutonomousExadataInfrastructureRequest, UpdateAutonomousExadataInfrastructureResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateAutonomousExadataInfrastructureRequest, UpdateAutonomousExadataInfrastructureResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateAutonomousExadataInfrastructureRequest> onError = handler == null ? null : new ErrorConsumer<UpdateAutonomousExadataInfrastructureRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateAutonomousExadataInfrastructuresDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateAutonomousExadataInfrastructureResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getUpdateAutonomousExadataInfrastructuresDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateAutonomousExadataInfrastructureResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateBackupDestinationResponse> updateBackupDestination(UpdateBackupDestinationRequest request, AsyncHandler<UpdateBackupDestinationRequest, UpdateBackupDestinationResponse> handler) {
        LOG.trace("Called async updateBackupDestination");
        final UpdateBackupDestinationRequest interceptedRequest = UpdateBackupDestinationConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateBackupDestinationConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateBackupDestinationResponse> transformer = UpdateBackupDestinationConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateBackupDestinationRequest, UpdateBackupDestinationResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateBackupDestinationRequest, UpdateBackupDestinationResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateBackupDestinationRequest, UpdateBackupDestinationResponse> onSuccess = new SuccessConsumer<UpdateBackupDestinationRequest, UpdateBackupDestinationResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateBackupDestinationRequest> onError = new ErrorConsumer<UpdateBackupDestinationRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getUpdateBackupDestinationDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateBackupDestinationRequest, UpdateBackupDestinationResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateBackupDestinationRequest, UpdateBackupDestinationResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateBackupDestinationRequest> onError = handler == null ? null : new ErrorConsumer<UpdateBackupDestinationRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateBackupDestinationDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateBackupDestinationResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getUpdateBackupDestinationDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateBackupDestinationResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateDatabaseResponse> updateDatabase(UpdateDatabaseRequest request, AsyncHandler<UpdateDatabaseRequest, UpdateDatabaseResponse> handler) {
        LOG.trace("Called async updateDatabase");
        final UpdateDatabaseRequest interceptedRequest = UpdateDatabaseConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateDatabaseConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateDatabaseResponse> transformer = UpdateDatabaseConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateDatabaseRequest, UpdateDatabaseResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateDatabaseRequest, UpdateDatabaseResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateDatabaseRequest, UpdateDatabaseResponse> onSuccess = new SuccessConsumer<UpdateDatabaseRequest, UpdateDatabaseResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateDatabaseRequest> onError = new ErrorConsumer<UpdateDatabaseRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getUpdateDatabaseDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateDatabaseRequest, UpdateDatabaseResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateDatabaseRequest, UpdateDatabaseResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateDatabaseRequest> onError = handler == null ? null : new ErrorConsumer<UpdateDatabaseRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateDatabaseDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateDatabaseResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getUpdateDatabaseDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateDatabaseResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateDbHomeResponse> updateDbHome(UpdateDbHomeRequest request, AsyncHandler<UpdateDbHomeRequest, UpdateDbHomeResponse> handler) {
        LOG.trace("Called async updateDbHome");
        final UpdateDbHomeRequest interceptedRequest = UpdateDbHomeConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateDbHomeConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateDbHomeResponse> transformer = UpdateDbHomeConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateDbHomeRequest, UpdateDbHomeResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateDbHomeRequest, UpdateDbHomeResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateDbHomeRequest, UpdateDbHomeResponse> onSuccess = new SuccessConsumer<UpdateDbHomeRequest, UpdateDbHomeResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateDbHomeRequest> onError = new ErrorConsumer<UpdateDbHomeRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getUpdateDbHomeDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateDbHomeRequest, UpdateDbHomeResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateDbHomeRequest, UpdateDbHomeResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateDbHomeRequest> onError = handler == null ? null : new ErrorConsumer<UpdateDbHomeRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateDbHomeDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateDbHomeResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getUpdateDbHomeDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateDbHomeResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateDbSystemResponse> updateDbSystem(UpdateDbSystemRequest request, AsyncHandler<UpdateDbSystemRequest, UpdateDbSystemResponse> handler) {
        LOG.trace("Called async updateDbSystem");
        final UpdateDbSystemRequest interceptedRequest = UpdateDbSystemConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateDbSystemConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateDbSystemResponse> transformer = UpdateDbSystemConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateDbSystemRequest, UpdateDbSystemResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateDbSystemRequest, UpdateDbSystemResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateDbSystemRequest, UpdateDbSystemResponse> onSuccess = new SuccessConsumer<UpdateDbSystemRequest, UpdateDbSystemResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateDbSystemRequest> onError = new ErrorConsumer<UpdateDbSystemRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getUpdateDbSystemDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateDbSystemRequest, UpdateDbSystemResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateDbSystemRequest, UpdateDbSystemResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateDbSystemRequest> onError = handler == null ? null : new ErrorConsumer<UpdateDbSystemRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateDbSystemDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateDbSystemResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getUpdateDbSystemDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateDbSystemResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateExadataInfrastructureResponse> updateExadataInfrastructure(UpdateExadataInfrastructureRequest request, AsyncHandler<UpdateExadataInfrastructureRequest, UpdateExadataInfrastructureResponse> handler) {
        LOG.trace("Called async updateExadataInfrastructure");
        final UpdateExadataInfrastructureRequest interceptedRequest = UpdateExadataInfrastructureConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateExadataInfrastructureConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateExadataInfrastructureResponse> transformer = UpdateExadataInfrastructureConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateExadataInfrastructureRequest, UpdateExadataInfrastructureResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateExadataInfrastructureRequest, UpdateExadataInfrastructureResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateExadataInfrastructureRequest, UpdateExadataInfrastructureResponse> onSuccess = new SuccessConsumer<UpdateExadataInfrastructureRequest, UpdateExadataInfrastructureResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateExadataInfrastructureRequest> onError = new ErrorConsumer<UpdateExadataInfrastructureRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getUpdateExadataInfrastructureDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateExadataInfrastructureRequest, UpdateExadataInfrastructureResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateExadataInfrastructureRequest, UpdateExadataInfrastructureResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateExadataInfrastructureRequest> onError = handler == null ? null : new ErrorConsumer<UpdateExadataInfrastructureRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateExadataInfrastructureDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateExadataInfrastructureResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getUpdateExadataInfrastructureDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateExadataInfrastructureResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateExadataIormConfigResponse> updateExadataIormConfig(UpdateExadataIormConfigRequest request, AsyncHandler<UpdateExadataIormConfigRequest, UpdateExadataIormConfigResponse> handler) {
        LOG.trace("Called async updateExadataIormConfig");
        final UpdateExadataIormConfigRequest interceptedRequest = UpdateExadataIormConfigConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateExadataIormConfigConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateExadataIormConfigResponse> transformer = UpdateExadataIormConfigConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateExadataIormConfigRequest, UpdateExadataIormConfigResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateExadataIormConfigRequest, UpdateExadataIormConfigResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateExadataIormConfigRequest, UpdateExadataIormConfigResponse> onSuccess = new SuccessConsumer<UpdateExadataIormConfigRequest, UpdateExadataIormConfigResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateExadataIormConfigRequest> onError = new ErrorConsumer<UpdateExadataIormConfigRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getExadataIormConfigUpdateDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateExadataIormConfigRequest, UpdateExadataIormConfigResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateExadataIormConfigRequest, UpdateExadataIormConfigResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateExadataIormConfigRequest> onError = handler == null ? null : new ErrorConsumer<UpdateExadataIormConfigRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getExadataIormConfigUpdateDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateExadataIormConfigResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getExadataIormConfigUpdateDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateExadataIormConfigResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateMaintenanceRunResponse> updateMaintenanceRun(UpdateMaintenanceRunRequest request, AsyncHandler<UpdateMaintenanceRunRequest, UpdateMaintenanceRunResponse> handler) {
        LOG.trace("Called async updateMaintenanceRun");
        final UpdateMaintenanceRunRequest interceptedRequest = UpdateMaintenanceRunConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateMaintenanceRunConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateMaintenanceRunResponse> transformer = UpdateMaintenanceRunConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateMaintenanceRunRequest, UpdateMaintenanceRunResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateMaintenanceRunRequest, UpdateMaintenanceRunResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateMaintenanceRunRequest, UpdateMaintenanceRunResponse> onSuccess = new SuccessConsumer<UpdateMaintenanceRunRequest, UpdateMaintenanceRunResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateMaintenanceRunRequest> onError = new ErrorConsumer<UpdateMaintenanceRunRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getUpdateMaintenanceRunDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateMaintenanceRunRequest, UpdateMaintenanceRunResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateMaintenanceRunRequest, UpdateMaintenanceRunResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateMaintenanceRunRequest> onError = handler == null ? null : new ErrorConsumer<UpdateMaintenanceRunRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateMaintenanceRunDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateMaintenanceRunResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getUpdateMaintenanceRunDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateMaintenanceRunResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateVmClusterResponse> updateVmCluster(UpdateVmClusterRequest request, AsyncHandler<UpdateVmClusterRequest, UpdateVmClusterResponse> handler) {
        LOG.trace("Called async updateVmCluster");
        final UpdateVmClusterRequest interceptedRequest = UpdateVmClusterConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateVmClusterConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateVmClusterResponse> transformer = UpdateVmClusterConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateVmClusterRequest, UpdateVmClusterResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateVmClusterRequest, UpdateVmClusterResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateVmClusterRequest, UpdateVmClusterResponse> onSuccess = new SuccessConsumer<UpdateVmClusterRequest, UpdateVmClusterResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateVmClusterRequest> onError = new ErrorConsumer<UpdateVmClusterRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getUpdateVmClusterDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateVmClusterRequest, UpdateVmClusterResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateVmClusterRequest, UpdateVmClusterResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateVmClusterRequest> onError = handler == null ? null : new ErrorConsumer<UpdateVmClusterRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateVmClusterDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateVmClusterResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getUpdateVmClusterDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateVmClusterResponse>(responseFuture, transformer);
    }

    @Override
    public Future<UpdateVmClusterNetworkResponse> updateVmClusterNetwork(UpdateVmClusterNetworkRequest request, AsyncHandler<UpdateVmClusterNetworkRequest, UpdateVmClusterNetworkResponse> handler) {
        LOG.trace("Called async updateVmClusterNetwork");
        final UpdateVmClusterNetworkRequest interceptedRequest = UpdateVmClusterNetworkConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = UpdateVmClusterNetworkConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, UpdateVmClusterNetworkResponse> transformer = UpdateVmClusterNetworkConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<UpdateVmClusterNetworkRequest, UpdateVmClusterNetworkResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<UpdateVmClusterNetworkRequest, UpdateVmClusterNetworkResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<UpdateVmClusterNetworkRequest, UpdateVmClusterNetworkResponse> onSuccess = new SuccessConsumer<UpdateVmClusterNetworkRequest, UpdateVmClusterNetworkResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<UpdateVmClusterNetworkRequest> onError = new ErrorConsumer<UpdateVmClusterNetworkRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getUpdateVmClusterNetworkDetails(), interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<UpdateVmClusterNetworkRequest, UpdateVmClusterNetworkResponse> onSuccess = handler == null ? null : new SuccessConsumer<UpdateVmClusterNetworkRequest, UpdateVmClusterNetworkResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<UpdateVmClusterNetworkRequest> onError = handler == null ? null : new ErrorConsumer<UpdateVmClusterNetworkRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.put(ib, interceptedRequest.getUpdateVmClusterNetworkDetails(), interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, UpdateVmClusterNetworkResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.put(ib, interceptedRequest.getUpdateVmClusterNetworkDetails(), interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, UpdateVmClusterNetworkResponse>(responseFuture, transformer);
    }

    @Override
    public Future<ValidateVmClusterNetworkResponse> validateVmClusterNetwork(ValidateVmClusterNetworkRequest request, AsyncHandler<ValidateVmClusterNetworkRequest, ValidateVmClusterNetworkResponse> handler) {
        LOG.trace("Called async validateVmClusterNetwork");
        final ValidateVmClusterNetworkRequest interceptedRequest = ValidateVmClusterNetworkConverter.interceptRequest(request);
        final WrappedInvocationBuilder ib = ValidateVmClusterNetworkConverter.fromRequest(this.client, interceptedRequest);
        final Function<Response, ValidateVmClusterNetworkResponse> transformer = ValidateVmClusterNetworkConverter.fromResponse();
        RefreshAuthTokenWrappingAsyncHandler<ValidateVmClusterNetworkRequest, ValidateVmClusterNetworkResponse> handlerToUse = handler;
        if (handler != null && this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            handlerToUse = new RefreshAuthTokenWrappingAsyncHandler<ValidateVmClusterNetworkRequest, ValidateVmClusterNetworkResponse>((RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), handler){

                @Override
                public void retryCall() {
                    SuccessConsumer<ValidateVmClusterNetworkRequest, ValidateVmClusterNetworkResponse> onSuccess = new SuccessConsumer<ValidateVmClusterNetworkRequest, ValidateVmClusterNetworkResponse>(this, transformer, interceptedRequest);
                    ErrorConsumer<ValidateVmClusterNetworkRequest> onError = new ErrorConsumer<ValidateVmClusterNetworkRequest>(this, interceptedRequest);
                    DatabaseAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            };
        }
        final SuccessConsumer<ValidateVmClusterNetworkRequest, ValidateVmClusterNetworkResponse> onSuccess = handler == null ? null : new SuccessConsumer<ValidateVmClusterNetworkRequest, ValidateVmClusterNetworkResponse>(handlerToUse, transformer, interceptedRequest);
        final ErrorConsumer<ValidateVmClusterNetworkRequest> onError = handler == null ? null : new ErrorConsumer<ValidateVmClusterNetworkRequest>(handlerToUse, interceptedRequest);
        Future<Response> responseFuture = this.client.post(ib, interceptedRequest, onSuccess, onError);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenTransformingFuture<Response, ValidateVmClusterNetworkResponse>(responseFuture, transformer, (RefreshableOnNotAuthenticatedProvider)((Object)this.authenticationDetailsProvider), new Supplier<Future<Response>>(){

                public Future<Response> get() {
                    return DatabaseAsyncClient.this.client.post(ib, interceptedRequest, onSuccess, onError);
                }
            });
        }
        return new TransformingFuture<Response, ValidateVmClusterNetworkResponse>(responseFuture, transformer);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DatabaseAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        @Override
        public DatabaseAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new DatabaseAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

