/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.database.Database;
import com.oracle.bmc.database.DatabasePaginators;
import com.oracle.bmc.database.DatabaseWaiters;
import com.oracle.bmc.database.internal.http.ActivateExadataInfrastructureConverter;
import com.oracle.bmc.database.internal.http.ChangeAutonomousContainerDatabaseCompartmentConverter;
import com.oracle.bmc.database.internal.http.ChangeAutonomousDatabaseCompartmentConverter;
import com.oracle.bmc.database.internal.http.ChangeAutonomousExadataInfrastructureCompartmentConverter;
import com.oracle.bmc.database.internal.http.ChangeBackupDestinationCompartmentConverter;
import com.oracle.bmc.database.internal.http.ChangeDbSystemCompartmentConverter;
import com.oracle.bmc.database.internal.http.ChangeExadataInfrastructureCompartmentConverter;
import com.oracle.bmc.database.internal.http.ChangeVmClusterCompartmentConverter;
import com.oracle.bmc.database.internal.http.CompleteExternalBackupJobConverter;
import com.oracle.bmc.database.internal.http.CreateAutonomousContainerDatabaseConverter;
import com.oracle.bmc.database.internal.http.CreateAutonomousDataWarehouseBackupConverter;
import com.oracle.bmc.database.internal.http.CreateAutonomousDataWarehouseConverter;
import com.oracle.bmc.database.internal.http.CreateAutonomousDatabaseBackupConverter;
import com.oracle.bmc.database.internal.http.CreateAutonomousDatabaseConverter;
import com.oracle.bmc.database.internal.http.CreateBackupConverter;
import com.oracle.bmc.database.internal.http.CreateBackupDestinationConverter;
import com.oracle.bmc.database.internal.http.CreateDataGuardAssociationConverter;
import com.oracle.bmc.database.internal.http.CreateDbHomeConverter;
import com.oracle.bmc.database.internal.http.CreateExadataInfrastructureConverter;
import com.oracle.bmc.database.internal.http.CreateExternalBackupJobConverter;
import com.oracle.bmc.database.internal.http.CreateVmClusterConverter;
import com.oracle.bmc.database.internal.http.CreateVmClusterNetworkConverter;
import com.oracle.bmc.database.internal.http.DbNodeActionConverter;
import com.oracle.bmc.database.internal.http.DeleteAutonomousDataWarehouseConverter;
import com.oracle.bmc.database.internal.http.DeleteAutonomousDatabaseConverter;
import com.oracle.bmc.database.internal.http.DeleteBackupConverter;
import com.oracle.bmc.database.internal.http.DeleteBackupDestinationConverter;
import com.oracle.bmc.database.internal.http.DeleteDbHomeConverter;
import com.oracle.bmc.database.internal.http.DeleteExadataInfrastructureConverter;
import com.oracle.bmc.database.internal.http.DeleteVmClusterConverter;
import com.oracle.bmc.database.internal.http.DeleteVmClusterNetworkConverter;
import com.oracle.bmc.database.internal.http.DownloadExadataInfrastructureConfigFileConverter;
import com.oracle.bmc.database.internal.http.DownloadVmClusterNetworkConfigFileConverter;
import com.oracle.bmc.database.internal.http.FailoverDataGuardAssociationConverter;
import com.oracle.bmc.database.internal.http.GenerateAutonomousDataWarehouseWalletConverter;
import com.oracle.bmc.database.internal.http.GenerateAutonomousDatabaseWalletConverter;
import com.oracle.bmc.database.internal.http.GenerateRecommendedVmClusterNetworkConverter;
import com.oracle.bmc.database.internal.http.GetAutonomousContainerDatabaseConverter;
import com.oracle.bmc.database.internal.http.GetAutonomousDataWarehouseBackupConverter;
import com.oracle.bmc.database.internal.http.GetAutonomousDataWarehouseConverter;
import com.oracle.bmc.database.internal.http.GetAutonomousDatabaseBackupConverter;
import com.oracle.bmc.database.internal.http.GetAutonomousDatabaseConverter;
import com.oracle.bmc.database.internal.http.GetAutonomousExadataInfrastructureConverter;
import com.oracle.bmc.database.internal.http.GetBackupConverter;
import com.oracle.bmc.database.internal.http.GetBackupDestinationConverter;
import com.oracle.bmc.database.internal.http.GetDataGuardAssociationConverter;
import com.oracle.bmc.database.internal.http.GetDatabaseConverter;
import com.oracle.bmc.database.internal.http.GetDbHomeConverter;
import com.oracle.bmc.database.internal.http.GetDbHomePatchConverter;
import com.oracle.bmc.database.internal.http.GetDbHomePatchHistoryEntryConverter;
import com.oracle.bmc.database.internal.http.GetDbNodeConverter;
import com.oracle.bmc.database.internal.http.GetDbSystemConverter;
import com.oracle.bmc.database.internal.http.GetDbSystemPatchConverter;
import com.oracle.bmc.database.internal.http.GetDbSystemPatchHistoryEntryConverter;
import com.oracle.bmc.database.internal.http.GetExadataInfrastructureConverter;
import com.oracle.bmc.database.internal.http.GetExadataIormConfigConverter;
import com.oracle.bmc.database.internal.http.GetExternalBackupJobConverter;
import com.oracle.bmc.database.internal.http.GetMaintenanceRunConverter;
import com.oracle.bmc.database.internal.http.GetVmClusterConverter;
import com.oracle.bmc.database.internal.http.GetVmClusterNetworkConverter;
import com.oracle.bmc.database.internal.http.LaunchAutonomousExadataInfrastructureConverter;
import com.oracle.bmc.database.internal.http.LaunchDbSystemConverter;
import com.oracle.bmc.database.internal.http.ListAutonomousContainerDatabasesConverter;
import com.oracle.bmc.database.internal.http.ListAutonomousDataWarehouseBackupsConverter;
import com.oracle.bmc.database.internal.http.ListAutonomousDataWarehousesConverter;
import com.oracle.bmc.database.internal.http.ListAutonomousDatabaseBackupsConverter;
import com.oracle.bmc.database.internal.http.ListAutonomousDatabasesConverter;
import com.oracle.bmc.database.internal.http.ListAutonomousDbPreviewVersionsConverter;
import com.oracle.bmc.database.internal.http.ListAutonomousExadataInfrastructureShapesConverter;
import com.oracle.bmc.database.internal.http.ListAutonomousExadataInfrastructuresConverter;
import com.oracle.bmc.database.internal.http.ListBackupDestinationConverter;
import com.oracle.bmc.database.internal.http.ListBackupsConverter;
import com.oracle.bmc.database.internal.http.ListDataGuardAssociationsConverter;
import com.oracle.bmc.database.internal.http.ListDatabasesConverter;
import com.oracle.bmc.database.internal.http.ListDbHomePatchHistoryEntriesConverter;
import com.oracle.bmc.database.internal.http.ListDbHomePatchesConverter;
import com.oracle.bmc.database.internal.http.ListDbHomesConverter;
import com.oracle.bmc.database.internal.http.ListDbNodesConverter;
import com.oracle.bmc.database.internal.http.ListDbSystemPatchHistoryEntriesConverter;
import com.oracle.bmc.database.internal.http.ListDbSystemPatchesConverter;
import com.oracle.bmc.database.internal.http.ListDbSystemShapesConverter;
import com.oracle.bmc.database.internal.http.ListDbSystemsConverter;
import com.oracle.bmc.database.internal.http.ListDbVersionsConverter;
import com.oracle.bmc.database.internal.http.ListExadataInfrastructuresConverter;
import com.oracle.bmc.database.internal.http.ListGiVersionsConverter;
import com.oracle.bmc.database.internal.http.ListMaintenanceRunsConverter;
import com.oracle.bmc.database.internal.http.ListVmClusterNetworksConverter;
import com.oracle.bmc.database.internal.http.ListVmClustersConverter;
import com.oracle.bmc.database.internal.http.ReinstateDataGuardAssociationConverter;
import com.oracle.bmc.database.internal.http.RestartAutonomousContainerDatabaseConverter;
import com.oracle.bmc.database.internal.http.RestoreAutonomousDataWarehouseConverter;
import com.oracle.bmc.database.internal.http.RestoreAutonomousDatabaseConverter;
import com.oracle.bmc.database.internal.http.RestoreDatabaseConverter;
import com.oracle.bmc.database.internal.http.StartAutonomousDataWarehouseConverter;
import com.oracle.bmc.database.internal.http.StartAutonomousDatabaseConverter;
import com.oracle.bmc.database.internal.http.StopAutonomousDataWarehouseConverter;
import com.oracle.bmc.database.internal.http.StopAutonomousDatabaseConverter;
import com.oracle.bmc.database.internal.http.SwitchoverDataGuardAssociationConverter;
import com.oracle.bmc.database.internal.http.TerminateAutonomousContainerDatabaseConverter;
import com.oracle.bmc.database.internal.http.TerminateAutonomousExadataInfrastructureConverter;
import com.oracle.bmc.database.internal.http.TerminateDbSystemConverter;
import com.oracle.bmc.database.internal.http.UpdateAutonomousContainerDatabaseConverter;
import com.oracle.bmc.database.internal.http.UpdateAutonomousDataWarehouseConverter;
import com.oracle.bmc.database.internal.http.UpdateAutonomousDatabaseConverter;
import com.oracle.bmc.database.internal.http.UpdateAutonomousExadataInfrastructureConverter;
import com.oracle.bmc.database.internal.http.UpdateBackupDestinationConverter;
import com.oracle.bmc.database.internal.http.UpdateDatabaseConverter;
import com.oracle.bmc.database.internal.http.UpdateDbHomeConverter;
import com.oracle.bmc.database.internal.http.UpdateDbSystemConverter;
import com.oracle.bmc.database.internal.http.UpdateExadataInfrastructureConverter;
import com.oracle.bmc.database.internal.http.UpdateExadataIormConfigConverter;
import com.oracle.bmc.database.internal.http.UpdateMaintenanceRunConverter;
import com.oracle.bmc.database.internal.http.UpdateVmClusterConverter;
import com.oracle.bmc.database.internal.http.UpdateVmClusterNetworkConverter;
import com.oracle.bmc.database.internal.http.ValidateVmClusterNetworkConverter;
import com.oracle.bmc.database.requests.ActivateExadataInfrastructureRequest;
import com.oracle.bmc.database.requests.ChangeAutonomousContainerDatabaseCompartmentRequest;
import com.oracle.bmc.database.requests.ChangeAutonomousDatabaseCompartmentRequest;
import com.oracle.bmc.database.requests.ChangeAutonomousExadataInfrastructureCompartmentRequest;
import com.oracle.bmc.database.requests.ChangeBackupDestinationCompartmentRequest;
import com.oracle.bmc.database.requests.ChangeDbSystemCompartmentRequest;
import com.oracle.bmc.database.requests.ChangeExadataInfrastructureCompartmentRequest;
import com.oracle.bmc.database.requests.ChangeVmClusterCompartmentRequest;
import com.oracle.bmc.database.requests.CompleteExternalBackupJobRequest;
import com.oracle.bmc.database.requests.CreateAutonomousContainerDatabaseRequest;
import com.oracle.bmc.database.requests.CreateAutonomousDataWarehouseBackupRequest;
import com.oracle.bmc.database.requests.CreateAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.requests.CreateAutonomousDatabaseBackupRequest;
import com.oracle.bmc.database.requests.CreateAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.CreateBackupDestinationRequest;
import com.oracle.bmc.database.requests.CreateBackupRequest;
import com.oracle.bmc.database.requests.CreateDataGuardAssociationRequest;
import com.oracle.bmc.database.requests.CreateDbHomeRequest;
import com.oracle.bmc.database.requests.CreateExadataInfrastructureRequest;
import com.oracle.bmc.database.requests.CreateExternalBackupJobRequest;
import com.oracle.bmc.database.requests.CreateVmClusterNetworkRequest;
import com.oracle.bmc.database.requests.CreateVmClusterRequest;
import com.oracle.bmc.database.requests.DbNodeActionRequest;
import com.oracle.bmc.database.requests.DeleteAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.requests.DeleteAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.DeleteBackupDestinationRequest;
import com.oracle.bmc.database.requests.DeleteBackupRequest;
import com.oracle.bmc.database.requests.DeleteDbHomeRequest;
import com.oracle.bmc.database.requests.DeleteExadataInfrastructureRequest;
import com.oracle.bmc.database.requests.DeleteVmClusterNetworkRequest;
import com.oracle.bmc.database.requests.DeleteVmClusterRequest;
import com.oracle.bmc.database.requests.DownloadExadataInfrastructureConfigFileRequest;
import com.oracle.bmc.database.requests.DownloadVmClusterNetworkConfigFileRequest;
import com.oracle.bmc.database.requests.FailoverDataGuardAssociationRequest;
import com.oracle.bmc.database.requests.GenerateAutonomousDataWarehouseWalletRequest;
import com.oracle.bmc.database.requests.GenerateAutonomousDatabaseWalletRequest;
import com.oracle.bmc.database.requests.GenerateRecommendedVmClusterNetworkRequest;
import com.oracle.bmc.database.requests.GetAutonomousContainerDatabaseRequest;
import com.oracle.bmc.database.requests.GetAutonomousDataWarehouseBackupRequest;
import com.oracle.bmc.database.requests.GetAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.requests.GetAutonomousDatabaseBackupRequest;
import com.oracle.bmc.database.requests.GetAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.GetAutonomousExadataInfrastructureRequest;
import com.oracle.bmc.database.requests.GetBackupDestinationRequest;
import com.oracle.bmc.database.requests.GetBackupRequest;
import com.oracle.bmc.database.requests.GetDataGuardAssociationRequest;
import com.oracle.bmc.database.requests.GetDatabaseRequest;
import com.oracle.bmc.database.requests.GetDbHomePatchHistoryEntryRequest;
import com.oracle.bmc.database.requests.GetDbHomePatchRequest;
import com.oracle.bmc.database.requests.GetDbHomeRequest;
import com.oracle.bmc.database.requests.GetDbNodeRequest;
import com.oracle.bmc.database.requests.GetDbSystemPatchHistoryEntryRequest;
import com.oracle.bmc.database.requests.GetDbSystemPatchRequest;
import com.oracle.bmc.database.requests.GetDbSystemRequest;
import com.oracle.bmc.database.requests.GetExadataInfrastructureRequest;
import com.oracle.bmc.database.requests.GetExadataIormConfigRequest;
import com.oracle.bmc.database.requests.GetExternalBackupJobRequest;
import com.oracle.bmc.database.requests.GetMaintenanceRunRequest;
import com.oracle.bmc.database.requests.GetVmClusterNetworkRequest;
import com.oracle.bmc.database.requests.GetVmClusterRequest;
import com.oracle.bmc.database.requests.LaunchAutonomousExadataInfrastructureRequest;
import com.oracle.bmc.database.requests.LaunchDbSystemRequest;
import com.oracle.bmc.database.requests.ListAutonomousContainerDatabasesRequest;
import com.oracle.bmc.database.requests.ListAutonomousDataWarehouseBackupsRequest;
import com.oracle.bmc.database.requests.ListAutonomousDataWarehousesRequest;
import com.oracle.bmc.database.requests.ListAutonomousDatabaseBackupsRequest;
import com.oracle.bmc.database.requests.ListAutonomousDatabasesRequest;
import com.oracle.bmc.database.requests.ListAutonomousDbPreviewVersionsRequest;
import com.oracle.bmc.database.requests.ListAutonomousExadataInfrastructureShapesRequest;
import com.oracle.bmc.database.requests.ListAutonomousExadataInfrastructuresRequest;
import com.oracle.bmc.database.requests.ListBackupDestinationRequest;
import com.oracle.bmc.database.requests.ListBackupsRequest;
import com.oracle.bmc.database.requests.ListDataGuardAssociationsRequest;
import com.oracle.bmc.database.requests.ListDatabasesRequest;
import com.oracle.bmc.database.requests.ListDbHomePatchHistoryEntriesRequest;
import com.oracle.bmc.database.requests.ListDbHomePatchesRequest;
import com.oracle.bmc.database.requests.ListDbHomesRequest;
import com.oracle.bmc.database.requests.ListDbNodesRequest;
import com.oracle.bmc.database.requests.ListDbSystemPatchHistoryEntriesRequest;
import com.oracle.bmc.database.requests.ListDbSystemPatchesRequest;
import com.oracle.bmc.database.requests.ListDbSystemShapesRequest;
import com.oracle.bmc.database.requests.ListDbSystemsRequest;
import com.oracle.bmc.database.requests.ListDbVersionsRequest;
import com.oracle.bmc.database.requests.ListExadataInfrastructuresRequest;
import com.oracle.bmc.database.requests.ListGiVersionsRequest;
import com.oracle.bmc.database.requests.ListMaintenanceRunsRequest;
import com.oracle.bmc.database.requests.ListVmClusterNetworksRequest;
import com.oracle.bmc.database.requests.ListVmClustersRequest;
import com.oracle.bmc.database.requests.ReinstateDataGuardAssociationRequest;
import com.oracle.bmc.database.requests.RestartAutonomousContainerDatabaseRequest;
import com.oracle.bmc.database.requests.RestoreAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.requests.RestoreAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.RestoreDatabaseRequest;
import com.oracle.bmc.database.requests.StartAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.requests.StartAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.StopAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.requests.StopAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.SwitchoverDataGuardAssociationRequest;
import com.oracle.bmc.database.requests.TerminateAutonomousContainerDatabaseRequest;
import com.oracle.bmc.database.requests.TerminateAutonomousExadataInfrastructureRequest;
import com.oracle.bmc.database.requests.TerminateDbSystemRequest;
import com.oracle.bmc.database.requests.UpdateAutonomousContainerDatabaseRequest;
import com.oracle.bmc.database.requests.UpdateAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.requests.UpdateAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.UpdateAutonomousExadataInfrastructureRequest;
import com.oracle.bmc.database.requests.UpdateBackupDestinationRequest;
import com.oracle.bmc.database.requests.UpdateDatabaseRequest;
import com.oracle.bmc.database.requests.UpdateDbHomeRequest;
import com.oracle.bmc.database.requests.UpdateDbSystemRequest;
import com.oracle.bmc.database.requests.UpdateExadataInfrastructureRequest;
import com.oracle.bmc.database.requests.UpdateExadataIormConfigRequest;
import com.oracle.bmc.database.requests.UpdateMaintenanceRunRequest;
import com.oracle.bmc.database.requests.UpdateVmClusterNetworkRequest;
import com.oracle.bmc.database.requests.UpdateVmClusterRequest;
import com.oracle.bmc.database.requests.ValidateVmClusterNetworkRequest;
import com.oracle.bmc.database.responses.ActivateExadataInfrastructureResponse;
import com.oracle.bmc.database.responses.ChangeAutonomousContainerDatabaseCompartmentResponse;
import com.oracle.bmc.database.responses.ChangeAutonomousDatabaseCompartmentResponse;
import com.oracle.bmc.database.responses.ChangeAutonomousExadataInfrastructureCompartmentResponse;
import com.oracle.bmc.database.responses.ChangeBackupDestinationCompartmentResponse;
import com.oracle.bmc.database.responses.ChangeDbSystemCompartmentResponse;
import com.oracle.bmc.database.responses.ChangeExadataInfrastructureCompartmentResponse;
import com.oracle.bmc.database.responses.ChangeVmClusterCompartmentResponse;
import com.oracle.bmc.database.responses.CompleteExternalBackupJobResponse;
import com.oracle.bmc.database.responses.CreateAutonomousContainerDatabaseResponse;
import com.oracle.bmc.database.responses.CreateAutonomousDataWarehouseBackupResponse;
import com.oracle.bmc.database.responses.CreateAutonomousDataWarehouseResponse;
import com.oracle.bmc.database.responses.CreateAutonomousDatabaseBackupResponse;
import com.oracle.bmc.database.responses.CreateAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.CreateBackupDestinationResponse;
import com.oracle.bmc.database.responses.CreateBackupResponse;
import com.oracle.bmc.database.responses.CreateDataGuardAssociationResponse;
import com.oracle.bmc.database.responses.CreateDbHomeResponse;
import com.oracle.bmc.database.responses.CreateExadataInfrastructureResponse;
import com.oracle.bmc.database.responses.CreateExternalBackupJobResponse;
import com.oracle.bmc.database.responses.CreateVmClusterNetworkResponse;
import com.oracle.bmc.database.responses.CreateVmClusterResponse;
import com.oracle.bmc.database.responses.DbNodeActionResponse;
import com.oracle.bmc.database.responses.DeleteAutonomousDataWarehouseResponse;
import com.oracle.bmc.database.responses.DeleteAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.DeleteBackupDestinationResponse;
import com.oracle.bmc.database.responses.DeleteBackupResponse;
import com.oracle.bmc.database.responses.DeleteDbHomeResponse;
import com.oracle.bmc.database.responses.DeleteExadataInfrastructureResponse;
import com.oracle.bmc.database.responses.DeleteVmClusterNetworkResponse;
import com.oracle.bmc.database.responses.DeleteVmClusterResponse;
import com.oracle.bmc.database.responses.DownloadExadataInfrastructureConfigFileResponse;
import com.oracle.bmc.database.responses.DownloadVmClusterNetworkConfigFileResponse;
import com.oracle.bmc.database.responses.FailoverDataGuardAssociationResponse;
import com.oracle.bmc.database.responses.GenerateAutonomousDataWarehouseWalletResponse;
import com.oracle.bmc.database.responses.GenerateAutonomousDatabaseWalletResponse;
import com.oracle.bmc.database.responses.GenerateRecommendedVmClusterNetworkResponse;
import com.oracle.bmc.database.responses.GetAutonomousContainerDatabaseResponse;
import com.oracle.bmc.database.responses.GetAutonomousDataWarehouseBackupResponse;
import com.oracle.bmc.database.responses.GetAutonomousDataWarehouseResponse;
import com.oracle.bmc.database.responses.GetAutonomousDatabaseBackupResponse;
import com.oracle.bmc.database.responses.GetAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.GetAutonomousExadataInfrastructureResponse;
import com.oracle.bmc.database.responses.GetBackupDestinationResponse;
import com.oracle.bmc.database.responses.GetBackupResponse;
import com.oracle.bmc.database.responses.GetDataGuardAssociationResponse;
import com.oracle.bmc.database.responses.GetDatabaseResponse;
import com.oracle.bmc.database.responses.GetDbHomePatchHistoryEntryResponse;
import com.oracle.bmc.database.responses.GetDbHomePatchResponse;
import com.oracle.bmc.database.responses.GetDbHomeResponse;
import com.oracle.bmc.database.responses.GetDbNodeResponse;
import com.oracle.bmc.database.responses.GetDbSystemPatchHistoryEntryResponse;
import com.oracle.bmc.database.responses.GetDbSystemPatchResponse;
import com.oracle.bmc.database.responses.GetDbSystemResponse;
import com.oracle.bmc.database.responses.GetExadataInfrastructureResponse;
import com.oracle.bmc.database.responses.GetExadataIormConfigResponse;
import com.oracle.bmc.database.responses.GetExternalBackupJobResponse;
import com.oracle.bmc.database.responses.GetMaintenanceRunResponse;
import com.oracle.bmc.database.responses.GetVmClusterNetworkResponse;
import com.oracle.bmc.database.responses.GetVmClusterResponse;
import com.oracle.bmc.database.responses.LaunchAutonomousExadataInfrastructureResponse;
import com.oracle.bmc.database.responses.LaunchDbSystemResponse;
import com.oracle.bmc.database.responses.ListAutonomousContainerDatabasesResponse;
import com.oracle.bmc.database.responses.ListAutonomousDataWarehouseBackupsResponse;
import com.oracle.bmc.database.responses.ListAutonomousDataWarehousesResponse;
import com.oracle.bmc.database.responses.ListAutonomousDatabaseBackupsResponse;
import com.oracle.bmc.database.responses.ListAutonomousDatabasesResponse;
import com.oracle.bmc.database.responses.ListAutonomousDbPreviewVersionsResponse;
import com.oracle.bmc.database.responses.ListAutonomousExadataInfrastructureShapesResponse;
import com.oracle.bmc.database.responses.ListAutonomousExadataInfrastructuresResponse;
import com.oracle.bmc.database.responses.ListBackupDestinationResponse;
import com.oracle.bmc.database.responses.ListBackupsResponse;
import com.oracle.bmc.database.responses.ListDataGuardAssociationsResponse;
import com.oracle.bmc.database.responses.ListDatabasesResponse;
import com.oracle.bmc.database.responses.ListDbHomePatchHistoryEntriesResponse;
import com.oracle.bmc.database.responses.ListDbHomePatchesResponse;
import com.oracle.bmc.database.responses.ListDbHomesResponse;
import com.oracle.bmc.database.responses.ListDbNodesResponse;
import com.oracle.bmc.database.responses.ListDbSystemPatchHistoryEntriesResponse;
import com.oracle.bmc.database.responses.ListDbSystemPatchesResponse;
import com.oracle.bmc.database.responses.ListDbSystemShapesResponse;
import com.oracle.bmc.database.responses.ListDbSystemsResponse;
import com.oracle.bmc.database.responses.ListDbVersionsResponse;
import com.oracle.bmc.database.responses.ListExadataInfrastructuresResponse;
import com.oracle.bmc.database.responses.ListGiVersionsResponse;
import com.oracle.bmc.database.responses.ListMaintenanceRunsResponse;
import com.oracle.bmc.database.responses.ListVmClusterNetworksResponse;
import com.oracle.bmc.database.responses.ListVmClustersResponse;
import com.oracle.bmc.database.responses.ReinstateDataGuardAssociationResponse;
import com.oracle.bmc.database.responses.RestartAutonomousContainerDatabaseResponse;
import com.oracle.bmc.database.responses.RestoreAutonomousDataWarehouseResponse;
import com.oracle.bmc.database.responses.RestoreAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.RestoreDatabaseResponse;
import com.oracle.bmc.database.responses.StartAutonomousDataWarehouseResponse;
import com.oracle.bmc.database.responses.StartAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.StopAutonomousDataWarehouseResponse;
import com.oracle.bmc.database.responses.StopAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.SwitchoverDataGuardAssociationResponse;
import com.oracle.bmc.database.responses.TerminateAutonomousContainerDatabaseResponse;
import com.oracle.bmc.database.responses.TerminateAutonomousExadataInfrastructureResponse;
import com.oracle.bmc.database.responses.TerminateDbSystemResponse;
import com.oracle.bmc.database.responses.UpdateAutonomousContainerDatabaseResponse;
import com.oracle.bmc.database.responses.UpdateAutonomousDataWarehouseResponse;
import com.oracle.bmc.database.responses.UpdateAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.UpdateAutonomousExadataInfrastructureResponse;
import com.oracle.bmc.database.responses.UpdateBackupDestinationResponse;
import com.oracle.bmc.database.responses.UpdateDatabaseResponse;
import com.oracle.bmc.database.responses.UpdateDbHomeResponse;
import com.oracle.bmc.database.responses.UpdateDbSystemResponse;
import com.oracle.bmc.database.responses.UpdateExadataInfrastructureResponse;
import com.oracle.bmc.database.responses.UpdateExadataIormConfigResponse;
import com.oracle.bmc.database.responses.UpdateMaintenanceRunResponse;
import com.oracle.bmc.database.responses.UpdateVmClusterNetworkResponse;
import com.oracle.bmc.database.responses.UpdateVmClusterResponse;
import com.oracle.bmc.database.responses.ValidateVmClusterNetworkResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import com.oracle.bmc.workrequests.WorkRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseClient
implements Database {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATABASE").serviceEndpointPrefix("database").serviceEndpointTemplate("https://database.{region}.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final DatabaseWaiters waiters;
    private final DatabasePaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final ExecutorService executorService;
    private final RetryConfiguration retryConfiguration;

    public DatabaseClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DatabaseClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DatabaseClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DatabaseClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DatabaseClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DatabaseClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DatabaseClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public DatabaseClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        RestClientFactory restClientFactory = RestClientFactoryBuilder.builder().clientConfigurator(clientConfigurator).additionalClientConfigurators(additionalClientConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get((Object)s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Database-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.executorService = executorService;
        this.waiters = new DatabaseWaiters(executorService, this);
        this.paginators = new DatabasePaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)((Object)this.authenticationDetailsProvider)).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public void setRegion(Region region) {
        Optional<String> endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId(regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint(SERVICE, regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ActivateExadataInfrastructureResponse activateExadataInfrastructure(ActivateExadataInfrastructureRequest request) {
        LOG.trace("Called activateExadataInfrastructure");
        ActivateExadataInfrastructureRequest interceptedRequest = ActivateExadataInfrastructureConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ActivateExadataInfrastructureConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ActivateExadataInfrastructureResponse> transformer = ActivateExadataInfrastructureConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getActivateExadataInfrastructureDetails(), retriedRequest);
                return (ActivateExadataInfrastructureResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeAutonomousContainerDatabaseCompartmentResponse changeAutonomousContainerDatabaseCompartment(ChangeAutonomousContainerDatabaseCompartmentRequest request) {
        LOG.trace("Called changeAutonomousContainerDatabaseCompartment");
        ChangeAutonomousContainerDatabaseCompartmentRequest interceptedRequest = ChangeAutonomousContainerDatabaseCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeAutonomousContainerDatabaseCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeAutonomousContainerDatabaseCompartmentResponse> transformer = ChangeAutonomousContainerDatabaseCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeCompartmentDetails(), retriedRequest);
                return (ChangeAutonomousContainerDatabaseCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeAutonomousDatabaseCompartmentResponse changeAutonomousDatabaseCompartment(ChangeAutonomousDatabaseCompartmentRequest request) {
        LOG.trace("Called changeAutonomousDatabaseCompartment");
        ChangeAutonomousDatabaseCompartmentRequest interceptedRequest = ChangeAutonomousDatabaseCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeAutonomousDatabaseCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeAutonomousDatabaseCompartmentResponse> transformer = ChangeAutonomousDatabaseCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeCompartmentDetails(), retriedRequest);
                return (ChangeAutonomousDatabaseCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeAutonomousExadataInfrastructureCompartmentResponse changeAutonomousExadataInfrastructureCompartment(ChangeAutonomousExadataInfrastructureCompartmentRequest request) {
        LOG.trace("Called changeAutonomousExadataInfrastructureCompartment");
        ChangeAutonomousExadataInfrastructureCompartmentRequest interceptedRequest = ChangeAutonomousExadataInfrastructureCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeAutonomousExadataInfrastructureCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeAutonomousExadataInfrastructureCompartmentResponse> transformer = ChangeAutonomousExadataInfrastructureCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeCompartmentDetails(), retriedRequest);
                return (ChangeAutonomousExadataInfrastructureCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeBackupDestinationCompartmentResponse changeBackupDestinationCompartment(ChangeBackupDestinationCompartmentRequest request) {
        LOG.trace("Called changeBackupDestinationCompartment");
        ChangeBackupDestinationCompartmentRequest interceptedRequest = ChangeBackupDestinationCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeBackupDestinationCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeBackupDestinationCompartmentResponse> transformer = ChangeBackupDestinationCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeCompartmentDetails(), retriedRequest);
                return (ChangeBackupDestinationCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeDbSystemCompartmentResponse changeDbSystemCompartment(ChangeDbSystemCompartmentRequest request) {
        LOG.trace("Called changeDbSystemCompartment");
        ChangeDbSystemCompartmentRequest interceptedRequest = ChangeDbSystemCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeDbSystemCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeDbSystemCompartmentResponse> transformer = ChangeDbSystemCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeCompartmentDetails(), retriedRequest);
                return (ChangeDbSystemCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeExadataInfrastructureCompartmentResponse changeExadataInfrastructureCompartment(ChangeExadataInfrastructureCompartmentRequest request) {
        LOG.trace("Called changeExadataInfrastructureCompartment");
        ChangeExadataInfrastructureCompartmentRequest interceptedRequest = ChangeExadataInfrastructureCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeExadataInfrastructureCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeExadataInfrastructureCompartmentResponse> transformer = ChangeExadataInfrastructureCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeExadataInfrastructureCompartmentDetails(), retriedRequest);
                return (ChangeExadataInfrastructureCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeVmClusterCompartmentResponse changeVmClusterCompartment(ChangeVmClusterCompartmentRequest request) {
        LOG.trace("Called changeVmClusterCompartment");
        ChangeVmClusterCompartmentRequest interceptedRequest = ChangeVmClusterCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeVmClusterCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeVmClusterCompartmentResponse> transformer = ChangeVmClusterCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getChangeVmClusterCompartmentDetails(), retriedRequest);
                return (ChangeVmClusterCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CompleteExternalBackupJobResponse completeExternalBackupJob(CompleteExternalBackupJobRequest request) {
        LOG.trace("Called completeExternalBackupJob");
        CompleteExternalBackupJobRequest interceptedRequest = CompleteExternalBackupJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CompleteExternalBackupJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CompleteExternalBackupJobResponse> transformer = CompleteExternalBackupJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCompleteExternalBackupJobDetails(), retriedRequest);
                return (CompleteExternalBackupJobResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateAutonomousContainerDatabaseResponse createAutonomousContainerDatabase(CreateAutonomousContainerDatabaseRequest request) {
        LOG.trace("Called createAutonomousContainerDatabase");
        CreateAutonomousContainerDatabaseRequest interceptedRequest = CreateAutonomousContainerDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAutonomousContainerDatabaseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateAutonomousContainerDatabaseResponse> transformer = CreateAutonomousContainerDatabaseConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateAutonomousContainerDatabaseDetails(), retriedRequest);
                return (CreateAutonomousContainerDatabaseResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateAutonomousDataWarehouseResponse createAutonomousDataWarehouse(CreateAutonomousDataWarehouseRequest request) {
        LOG.trace("Called createAutonomousDataWarehouse");
        CreateAutonomousDataWarehouseRequest interceptedRequest = CreateAutonomousDataWarehouseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAutonomousDataWarehouseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateAutonomousDataWarehouseResponse> transformer = CreateAutonomousDataWarehouseConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateAutonomousDataWarehouseDetails(), retriedRequest);
                return (CreateAutonomousDataWarehouseResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateAutonomousDataWarehouseBackupResponse createAutonomousDataWarehouseBackup(CreateAutonomousDataWarehouseBackupRequest request) {
        LOG.trace("Called createAutonomousDataWarehouseBackup");
        CreateAutonomousDataWarehouseBackupRequest interceptedRequest = CreateAutonomousDataWarehouseBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAutonomousDataWarehouseBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateAutonomousDataWarehouseBackupResponse> transformer = CreateAutonomousDataWarehouseBackupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateAutonomousDataWarehouseBackupDetails(), retriedRequest);
                return (CreateAutonomousDataWarehouseBackupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateAutonomousDatabaseResponse createAutonomousDatabase(CreateAutonomousDatabaseRequest request) {
        LOG.trace("Called createAutonomousDatabase");
        CreateAutonomousDatabaseRequest interceptedRequest = CreateAutonomousDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAutonomousDatabaseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateAutonomousDatabaseResponse> transformer = CreateAutonomousDatabaseConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateAutonomousDatabaseDetails(), retriedRequest);
                return (CreateAutonomousDatabaseResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateAutonomousDatabaseBackupResponse createAutonomousDatabaseBackup(CreateAutonomousDatabaseBackupRequest request) {
        LOG.trace("Called createAutonomousDatabaseBackup");
        CreateAutonomousDatabaseBackupRequest interceptedRequest = CreateAutonomousDatabaseBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateAutonomousDatabaseBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateAutonomousDatabaseBackupResponse> transformer = CreateAutonomousDatabaseBackupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateAutonomousDatabaseBackupDetails(), retriedRequest);
                return (CreateAutonomousDatabaseBackupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateBackupResponse createBackup(CreateBackupRequest request) {
        LOG.trace("Called createBackup");
        CreateBackupRequest interceptedRequest = CreateBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateBackupResponse> transformer = CreateBackupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateBackupDetails(), retriedRequest);
                return (CreateBackupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateBackupDestinationResponse createBackupDestination(CreateBackupDestinationRequest request) {
        LOG.trace("Called createBackupDestination");
        CreateBackupDestinationRequest interceptedRequest = CreateBackupDestinationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBackupDestinationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateBackupDestinationResponse> transformer = CreateBackupDestinationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateBackupDestinationDetails(), retriedRequest);
                return (CreateBackupDestinationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateDataGuardAssociationResponse createDataGuardAssociation(CreateDataGuardAssociationRequest request) {
        LOG.trace("Called createDataGuardAssociation");
        CreateDataGuardAssociationRequest interceptedRequest = CreateDataGuardAssociationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDataGuardAssociationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDataGuardAssociationResponse> transformer = CreateDataGuardAssociationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateDataGuardAssociationDetails(), retriedRequest);
                return (CreateDataGuardAssociationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateDbHomeResponse createDbHome(CreateDbHomeRequest request) {
        LOG.trace("Called createDbHome");
        CreateDbHomeRequest interceptedRequest = CreateDbHomeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDbHomeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDbHomeResponse> transformer = CreateDbHomeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateDbHomeWithDbSystemIdDetails(), retriedRequest);
                return (CreateDbHomeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateExadataInfrastructureResponse createExadataInfrastructure(CreateExadataInfrastructureRequest request) {
        LOG.trace("Called createExadataInfrastructure");
        CreateExadataInfrastructureRequest interceptedRequest = CreateExadataInfrastructureConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateExadataInfrastructureConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateExadataInfrastructureResponse> transformer = CreateExadataInfrastructureConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateExadataInfrastructureDetails(), retriedRequest);
                return (CreateExadataInfrastructureResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateExternalBackupJobResponse createExternalBackupJob(CreateExternalBackupJobRequest request) {
        LOG.trace("Called createExternalBackupJob");
        CreateExternalBackupJobRequest interceptedRequest = CreateExternalBackupJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateExternalBackupJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateExternalBackupJobResponse> transformer = CreateExternalBackupJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateExternalBackupJobDetails(), retriedRequest);
                return (CreateExternalBackupJobResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateVmClusterResponse createVmCluster(CreateVmClusterRequest request) {
        LOG.trace("Called createVmCluster");
        CreateVmClusterRequest interceptedRequest = CreateVmClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateVmClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateVmClusterResponse> transformer = CreateVmClusterConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getCreateVmClusterDetails(), retriedRequest);
                return (CreateVmClusterResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateVmClusterNetworkResponse createVmClusterNetwork(CreateVmClusterNetworkRequest request) {
        LOG.trace("Called createVmClusterNetwork");
        CreateVmClusterNetworkRequest interceptedRequest = CreateVmClusterNetworkConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateVmClusterNetworkConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateVmClusterNetworkResponse> transformer = CreateVmClusterNetworkConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getVmClusterNetworkDetails(), retriedRequest);
                return (CreateVmClusterNetworkResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DbNodeActionResponse dbNodeAction(DbNodeActionRequest request) {
        LOG.trace("Called dbNodeAction");
        DbNodeActionRequest interceptedRequest = DbNodeActionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DbNodeActionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DbNodeActionResponse> transformer = DbNodeActionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest);
                return (DbNodeActionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteAutonomousDataWarehouseResponse deleteAutonomousDataWarehouse(DeleteAutonomousDataWarehouseRequest request) {
        LOG.trace("Called deleteAutonomousDataWarehouse");
        DeleteAutonomousDataWarehouseRequest interceptedRequest = DeleteAutonomousDataWarehouseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAutonomousDataWarehouseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteAutonomousDataWarehouseResponse> transformer = DeleteAutonomousDataWarehouseConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteAutonomousDataWarehouseResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteAutonomousDatabaseResponse deleteAutonomousDatabase(DeleteAutonomousDatabaseRequest request) {
        LOG.trace("Called deleteAutonomousDatabase");
        DeleteAutonomousDatabaseRequest interceptedRequest = DeleteAutonomousDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteAutonomousDatabaseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteAutonomousDatabaseResponse> transformer = DeleteAutonomousDatabaseConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteAutonomousDatabaseResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteBackupResponse deleteBackup(DeleteBackupRequest request) {
        LOG.trace("Called deleteBackup");
        DeleteBackupRequest interceptedRequest = DeleteBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteBackupResponse> transformer = DeleteBackupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteBackupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteBackupDestinationResponse deleteBackupDestination(DeleteBackupDestinationRequest request) {
        LOG.trace("Called deleteBackupDestination");
        DeleteBackupDestinationRequest interceptedRequest = DeleteBackupDestinationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBackupDestinationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteBackupDestinationResponse> transformer = DeleteBackupDestinationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteBackupDestinationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteDbHomeResponse deleteDbHome(DeleteDbHomeRequest request) {
        LOG.trace("Called deleteDbHome");
        DeleteDbHomeRequest interceptedRequest = DeleteDbHomeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDbHomeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDbHomeResponse> transformer = DeleteDbHomeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteDbHomeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteExadataInfrastructureResponse deleteExadataInfrastructure(DeleteExadataInfrastructureRequest request) {
        LOG.trace("Called deleteExadataInfrastructure");
        DeleteExadataInfrastructureRequest interceptedRequest = DeleteExadataInfrastructureConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteExadataInfrastructureConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteExadataInfrastructureResponse> transformer = DeleteExadataInfrastructureConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteExadataInfrastructureResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteVmClusterResponse deleteVmCluster(DeleteVmClusterRequest request) {
        LOG.trace("Called deleteVmCluster");
        DeleteVmClusterRequest interceptedRequest = DeleteVmClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteVmClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteVmClusterResponse> transformer = DeleteVmClusterConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteVmClusterResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteVmClusterNetworkResponse deleteVmClusterNetwork(DeleteVmClusterNetworkRequest request) {
        LOG.trace("Called deleteVmClusterNetwork");
        DeleteVmClusterNetworkRequest interceptedRequest = DeleteVmClusterNetworkConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteVmClusterNetworkConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteVmClusterNetworkResponse> transformer = DeleteVmClusterNetworkConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (DeleteVmClusterNetworkResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DownloadExadataInfrastructureConfigFileResponse downloadExadataInfrastructureConfigFile(DownloadExadataInfrastructureConfigFileRequest request) {
        LOG.trace("Called downloadExadataInfrastructureConfigFile");
        DownloadExadataInfrastructureConfigFileRequest interceptedRequest = DownloadExadataInfrastructureConfigFileConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DownloadExadataInfrastructureConfigFileConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DownloadExadataInfrastructureConfigFileResponse> transformer = DownloadExadataInfrastructureConfigFileConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest);
                return (DownloadExadataInfrastructureConfigFileResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DownloadVmClusterNetworkConfigFileResponse downloadVmClusterNetworkConfigFile(DownloadVmClusterNetworkConfigFileRequest request) {
        LOG.trace("Called downloadVmClusterNetworkConfigFile");
        DownloadVmClusterNetworkConfigFileRequest interceptedRequest = DownloadVmClusterNetworkConfigFileConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DownloadVmClusterNetworkConfigFileConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DownloadVmClusterNetworkConfigFileResponse> transformer = DownloadVmClusterNetworkConfigFileConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest);
                return (DownloadVmClusterNetworkConfigFileResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public FailoverDataGuardAssociationResponse failoverDataGuardAssociation(FailoverDataGuardAssociationRequest request) {
        LOG.trace("Called failoverDataGuardAssociation");
        FailoverDataGuardAssociationRequest interceptedRequest = FailoverDataGuardAssociationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = FailoverDataGuardAssociationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, FailoverDataGuardAssociationResponse> transformer = FailoverDataGuardAssociationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getFailoverDataGuardAssociationDetails(), retriedRequest);
                return (FailoverDataGuardAssociationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GenerateAutonomousDataWarehouseWalletResponse generateAutonomousDataWarehouseWallet(GenerateAutonomousDataWarehouseWalletRequest request) {
        LOG.trace("Called generateAutonomousDataWarehouseWallet");
        GenerateAutonomousDataWarehouseWalletRequest interceptedRequest = GenerateAutonomousDataWarehouseWalletConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GenerateAutonomousDataWarehouseWalletConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GenerateAutonomousDataWarehouseWalletResponse> transformer = GenerateAutonomousDataWarehouseWalletConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getGenerateAutonomousDataWarehouseWalletDetails(), retriedRequest);
                return (GenerateAutonomousDataWarehouseWalletResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GenerateAutonomousDatabaseWalletResponse generateAutonomousDatabaseWallet(GenerateAutonomousDatabaseWalletRequest request) {
        LOG.trace("Called generateAutonomousDatabaseWallet");
        GenerateAutonomousDatabaseWalletRequest interceptedRequest = GenerateAutonomousDatabaseWalletConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GenerateAutonomousDatabaseWalletConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GenerateAutonomousDatabaseWalletResponse> transformer = GenerateAutonomousDatabaseWalletConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getGenerateAutonomousDatabaseWalletDetails(), retriedRequest);
                return (GenerateAutonomousDatabaseWalletResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GenerateRecommendedVmClusterNetworkResponse generateRecommendedVmClusterNetwork(GenerateRecommendedVmClusterNetworkRequest request) {
        LOG.trace("Called generateRecommendedVmClusterNetwork");
        GenerateRecommendedVmClusterNetworkRequest interceptedRequest = GenerateRecommendedVmClusterNetworkConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GenerateRecommendedVmClusterNetworkConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GenerateRecommendedVmClusterNetworkResponse> transformer = GenerateRecommendedVmClusterNetworkConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getGenerateRecommendedNetworkDetails(), retriedRequest);
                return (GenerateRecommendedVmClusterNetworkResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetAutonomousContainerDatabaseResponse getAutonomousContainerDatabase(GetAutonomousContainerDatabaseRequest request) {
        LOG.trace("Called getAutonomousContainerDatabase");
        GetAutonomousContainerDatabaseRequest interceptedRequest = GetAutonomousContainerDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAutonomousContainerDatabaseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAutonomousContainerDatabaseResponse> transformer = GetAutonomousContainerDatabaseConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetAutonomousContainerDatabaseResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetAutonomousDataWarehouseResponse getAutonomousDataWarehouse(GetAutonomousDataWarehouseRequest request) {
        LOG.trace("Called getAutonomousDataWarehouse");
        GetAutonomousDataWarehouseRequest interceptedRequest = GetAutonomousDataWarehouseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAutonomousDataWarehouseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAutonomousDataWarehouseResponse> transformer = GetAutonomousDataWarehouseConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetAutonomousDataWarehouseResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetAutonomousDataWarehouseBackupResponse getAutonomousDataWarehouseBackup(GetAutonomousDataWarehouseBackupRequest request) {
        LOG.trace("Called getAutonomousDataWarehouseBackup");
        GetAutonomousDataWarehouseBackupRequest interceptedRequest = GetAutonomousDataWarehouseBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAutonomousDataWarehouseBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAutonomousDataWarehouseBackupResponse> transformer = GetAutonomousDataWarehouseBackupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetAutonomousDataWarehouseBackupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetAutonomousDatabaseResponse getAutonomousDatabase(GetAutonomousDatabaseRequest request) {
        LOG.trace("Called getAutonomousDatabase");
        GetAutonomousDatabaseRequest interceptedRequest = GetAutonomousDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAutonomousDatabaseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAutonomousDatabaseResponse> transformer = GetAutonomousDatabaseConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetAutonomousDatabaseResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetAutonomousDatabaseBackupResponse getAutonomousDatabaseBackup(GetAutonomousDatabaseBackupRequest request) {
        LOG.trace("Called getAutonomousDatabaseBackup");
        GetAutonomousDatabaseBackupRequest interceptedRequest = GetAutonomousDatabaseBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAutonomousDatabaseBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAutonomousDatabaseBackupResponse> transformer = GetAutonomousDatabaseBackupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetAutonomousDatabaseBackupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetAutonomousExadataInfrastructureResponse getAutonomousExadataInfrastructure(GetAutonomousExadataInfrastructureRequest request) {
        LOG.trace("Called getAutonomousExadataInfrastructure");
        GetAutonomousExadataInfrastructureRequest interceptedRequest = GetAutonomousExadataInfrastructureConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAutonomousExadataInfrastructureConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAutonomousExadataInfrastructureResponse> transformer = GetAutonomousExadataInfrastructureConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetAutonomousExadataInfrastructureResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetBackupResponse getBackup(GetBackupRequest request) {
        LOG.trace("Called getBackup");
        GetBackupRequest interceptedRequest = GetBackupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBackupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBackupResponse> transformer = GetBackupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetBackupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetBackupDestinationResponse getBackupDestination(GetBackupDestinationRequest request) {
        LOG.trace("Called getBackupDestination");
        GetBackupDestinationRequest interceptedRequest = GetBackupDestinationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBackupDestinationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBackupDestinationResponse> transformer = GetBackupDestinationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetBackupDestinationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDataGuardAssociationResponse getDataGuardAssociation(GetDataGuardAssociationRequest request) {
        LOG.trace("Called getDataGuardAssociation");
        GetDataGuardAssociationRequest interceptedRequest = GetDataGuardAssociationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDataGuardAssociationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDataGuardAssociationResponse> transformer = GetDataGuardAssociationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetDataGuardAssociationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDatabaseResponse getDatabase(GetDatabaseRequest request) {
        LOG.trace("Called getDatabase");
        GetDatabaseRequest interceptedRequest = GetDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDatabaseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDatabaseResponse> transformer = GetDatabaseConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetDatabaseResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDbHomeResponse getDbHome(GetDbHomeRequest request) {
        LOG.trace("Called getDbHome");
        GetDbHomeRequest interceptedRequest = GetDbHomeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDbHomeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDbHomeResponse> transformer = GetDbHomeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetDbHomeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDbHomePatchResponse getDbHomePatch(GetDbHomePatchRequest request) {
        LOG.trace("Called getDbHomePatch");
        GetDbHomePatchRequest interceptedRequest = GetDbHomePatchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDbHomePatchConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDbHomePatchResponse> transformer = GetDbHomePatchConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetDbHomePatchResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDbHomePatchHistoryEntryResponse getDbHomePatchHistoryEntry(GetDbHomePatchHistoryEntryRequest request) {
        LOG.trace("Called getDbHomePatchHistoryEntry");
        GetDbHomePatchHistoryEntryRequest interceptedRequest = GetDbHomePatchHistoryEntryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDbHomePatchHistoryEntryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDbHomePatchHistoryEntryResponse> transformer = GetDbHomePatchHistoryEntryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetDbHomePatchHistoryEntryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDbNodeResponse getDbNode(GetDbNodeRequest request) {
        LOG.trace("Called getDbNode");
        GetDbNodeRequest interceptedRequest = GetDbNodeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDbNodeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDbNodeResponse> transformer = GetDbNodeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetDbNodeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDbSystemResponse getDbSystem(GetDbSystemRequest request) {
        LOG.trace("Called getDbSystem");
        GetDbSystemRequest interceptedRequest = GetDbSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDbSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDbSystemResponse> transformer = GetDbSystemConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetDbSystemResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDbSystemPatchResponse getDbSystemPatch(GetDbSystemPatchRequest request) {
        LOG.trace("Called getDbSystemPatch");
        GetDbSystemPatchRequest interceptedRequest = GetDbSystemPatchConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDbSystemPatchConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDbSystemPatchResponse> transformer = GetDbSystemPatchConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetDbSystemPatchResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDbSystemPatchHistoryEntryResponse getDbSystemPatchHistoryEntry(GetDbSystemPatchHistoryEntryRequest request) {
        LOG.trace("Called getDbSystemPatchHistoryEntry");
        GetDbSystemPatchHistoryEntryRequest interceptedRequest = GetDbSystemPatchHistoryEntryConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDbSystemPatchHistoryEntryConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDbSystemPatchHistoryEntryResponse> transformer = GetDbSystemPatchHistoryEntryConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetDbSystemPatchHistoryEntryResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetExadataInfrastructureResponse getExadataInfrastructure(GetExadataInfrastructureRequest request) {
        LOG.trace("Called getExadataInfrastructure");
        GetExadataInfrastructureRequest interceptedRequest = GetExadataInfrastructureConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetExadataInfrastructureConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetExadataInfrastructureResponse> transformer = GetExadataInfrastructureConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetExadataInfrastructureResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetExadataIormConfigResponse getExadataIormConfig(GetExadataIormConfigRequest request) {
        LOG.trace("Called getExadataIormConfig");
        GetExadataIormConfigRequest interceptedRequest = GetExadataIormConfigConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetExadataIormConfigConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetExadataIormConfigResponse> transformer = GetExadataIormConfigConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetExadataIormConfigResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetExternalBackupJobResponse getExternalBackupJob(GetExternalBackupJobRequest request) {
        LOG.trace("Called getExternalBackupJob");
        GetExternalBackupJobRequest interceptedRequest = GetExternalBackupJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetExternalBackupJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetExternalBackupJobResponse> transformer = GetExternalBackupJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetExternalBackupJobResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetMaintenanceRunResponse getMaintenanceRun(GetMaintenanceRunRequest request) {
        LOG.trace("Called getMaintenanceRun");
        GetMaintenanceRunRequest interceptedRequest = GetMaintenanceRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetMaintenanceRunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetMaintenanceRunResponse> transformer = GetMaintenanceRunConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetMaintenanceRunResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetVmClusterResponse getVmCluster(GetVmClusterRequest request) {
        LOG.trace("Called getVmCluster");
        GetVmClusterRequest interceptedRequest = GetVmClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetVmClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetVmClusterResponse> transformer = GetVmClusterConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetVmClusterResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetVmClusterNetworkResponse getVmClusterNetwork(GetVmClusterNetworkRequest request) {
        LOG.trace("Called getVmClusterNetwork");
        GetVmClusterNetworkRequest interceptedRequest = GetVmClusterNetworkConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetVmClusterNetworkConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetVmClusterNetworkResponse> transformer = GetVmClusterNetworkConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (GetVmClusterNetworkResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public LaunchAutonomousExadataInfrastructureResponse launchAutonomousExadataInfrastructure(LaunchAutonomousExadataInfrastructureRequest request) {
        LOG.trace("Called launchAutonomousExadataInfrastructure");
        LaunchAutonomousExadataInfrastructureRequest interceptedRequest = LaunchAutonomousExadataInfrastructureConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = LaunchAutonomousExadataInfrastructureConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, LaunchAutonomousExadataInfrastructureResponse> transformer = LaunchAutonomousExadataInfrastructureConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getLaunchAutonomousExadataInfrastructureDetails(), retriedRequest);
                return (LaunchAutonomousExadataInfrastructureResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public LaunchDbSystemResponse launchDbSystem(LaunchDbSystemRequest request) {
        LOG.trace("Called launchDbSystem");
        LaunchDbSystemRequest interceptedRequest = LaunchDbSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = LaunchDbSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, LaunchDbSystemResponse> transformer = LaunchDbSystemConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getLaunchDbSystemDetails(), retriedRequest);
                return (LaunchDbSystemResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAutonomousContainerDatabasesResponse listAutonomousContainerDatabases(ListAutonomousContainerDatabasesRequest request) {
        LOG.trace("Called listAutonomousContainerDatabases");
        ListAutonomousContainerDatabasesRequest interceptedRequest = ListAutonomousContainerDatabasesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAutonomousContainerDatabasesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAutonomousContainerDatabasesResponse> transformer = ListAutonomousContainerDatabasesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListAutonomousContainerDatabasesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAutonomousDataWarehouseBackupsResponse listAutonomousDataWarehouseBackups(ListAutonomousDataWarehouseBackupsRequest request) {
        LOG.trace("Called listAutonomousDataWarehouseBackups");
        ListAutonomousDataWarehouseBackupsRequest interceptedRequest = ListAutonomousDataWarehouseBackupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAutonomousDataWarehouseBackupsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAutonomousDataWarehouseBackupsResponse> transformer = ListAutonomousDataWarehouseBackupsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListAutonomousDataWarehouseBackupsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAutonomousDataWarehousesResponse listAutonomousDataWarehouses(ListAutonomousDataWarehousesRequest request) {
        LOG.trace("Called listAutonomousDataWarehouses");
        ListAutonomousDataWarehousesRequest interceptedRequest = ListAutonomousDataWarehousesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAutonomousDataWarehousesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAutonomousDataWarehousesResponse> transformer = ListAutonomousDataWarehousesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListAutonomousDataWarehousesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAutonomousDatabaseBackupsResponse listAutonomousDatabaseBackups(ListAutonomousDatabaseBackupsRequest request) {
        LOG.trace("Called listAutonomousDatabaseBackups");
        ListAutonomousDatabaseBackupsRequest interceptedRequest = ListAutonomousDatabaseBackupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAutonomousDatabaseBackupsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAutonomousDatabaseBackupsResponse> transformer = ListAutonomousDatabaseBackupsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListAutonomousDatabaseBackupsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAutonomousDatabasesResponse listAutonomousDatabases(ListAutonomousDatabasesRequest request) {
        LOG.trace("Called listAutonomousDatabases");
        ListAutonomousDatabasesRequest interceptedRequest = ListAutonomousDatabasesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAutonomousDatabasesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAutonomousDatabasesResponse> transformer = ListAutonomousDatabasesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListAutonomousDatabasesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAutonomousDbPreviewVersionsResponse listAutonomousDbPreviewVersions(ListAutonomousDbPreviewVersionsRequest request) {
        LOG.trace("Called listAutonomousDbPreviewVersions");
        ListAutonomousDbPreviewVersionsRequest interceptedRequest = ListAutonomousDbPreviewVersionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAutonomousDbPreviewVersionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAutonomousDbPreviewVersionsResponse> transformer = ListAutonomousDbPreviewVersionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListAutonomousDbPreviewVersionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAutonomousExadataInfrastructureShapesResponse listAutonomousExadataInfrastructureShapes(ListAutonomousExadataInfrastructureShapesRequest request) {
        LOG.trace("Called listAutonomousExadataInfrastructureShapes");
        ListAutonomousExadataInfrastructureShapesRequest interceptedRequest = ListAutonomousExadataInfrastructureShapesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAutonomousExadataInfrastructureShapesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAutonomousExadataInfrastructureShapesResponse> transformer = ListAutonomousExadataInfrastructureShapesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListAutonomousExadataInfrastructureShapesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAutonomousExadataInfrastructuresResponse listAutonomousExadataInfrastructures(ListAutonomousExadataInfrastructuresRequest request) {
        LOG.trace("Called listAutonomousExadataInfrastructures");
        ListAutonomousExadataInfrastructuresRequest interceptedRequest = ListAutonomousExadataInfrastructuresConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAutonomousExadataInfrastructuresConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAutonomousExadataInfrastructuresResponse> transformer = ListAutonomousExadataInfrastructuresConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListAutonomousExadataInfrastructuresResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListBackupDestinationResponse listBackupDestination(ListBackupDestinationRequest request) {
        LOG.trace("Called listBackupDestination");
        ListBackupDestinationRequest interceptedRequest = ListBackupDestinationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBackupDestinationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListBackupDestinationResponse> transformer = ListBackupDestinationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListBackupDestinationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListBackupsResponse listBackups(ListBackupsRequest request) {
        LOG.trace("Called listBackups");
        ListBackupsRequest interceptedRequest = ListBackupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBackupsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListBackupsResponse> transformer = ListBackupsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListBackupsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDataGuardAssociationsResponse listDataGuardAssociations(ListDataGuardAssociationsRequest request) {
        LOG.trace("Called listDataGuardAssociations");
        ListDataGuardAssociationsRequest interceptedRequest = ListDataGuardAssociationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDataGuardAssociationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDataGuardAssociationsResponse> transformer = ListDataGuardAssociationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListDataGuardAssociationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDatabasesResponse listDatabases(ListDatabasesRequest request) {
        LOG.trace("Called listDatabases");
        ListDatabasesRequest interceptedRequest = ListDatabasesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDatabasesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDatabasesResponse> transformer = ListDatabasesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListDatabasesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDbHomePatchHistoryEntriesResponse listDbHomePatchHistoryEntries(ListDbHomePatchHistoryEntriesRequest request) {
        LOG.trace("Called listDbHomePatchHistoryEntries");
        ListDbHomePatchHistoryEntriesRequest interceptedRequest = ListDbHomePatchHistoryEntriesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDbHomePatchHistoryEntriesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDbHomePatchHistoryEntriesResponse> transformer = ListDbHomePatchHistoryEntriesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListDbHomePatchHistoryEntriesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDbHomePatchesResponse listDbHomePatches(ListDbHomePatchesRequest request) {
        LOG.trace("Called listDbHomePatches");
        ListDbHomePatchesRequest interceptedRequest = ListDbHomePatchesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDbHomePatchesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDbHomePatchesResponse> transformer = ListDbHomePatchesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListDbHomePatchesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDbHomesResponse listDbHomes(ListDbHomesRequest request) {
        LOG.trace("Called listDbHomes");
        ListDbHomesRequest interceptedRequest = ListDbHomesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDbHomesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDbHomesResponse> transformer = ListDbHomesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListDbHomesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDbNodesResponse listDbNodes(ListDbNodesRequest request) {
        LOG.trace("Called listDbNodes");
        ListDbNodesRequest interceptedRequest = ListDbNodesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDbNodesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDbNodesResponse> transformer = ListDbNodesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListDbNodesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDbSystemPatchHistoryEntriesResponse listDbSystemPatchHistoryEntries(ListDbSystemPatchHistoryEntriesRequest request) {
        LOG.trace("Called listDbSystemPatchHistoryEntries");
        ListDbSystemPatchHistoryEntriesRequest interceptedRequest = ListDbSystemPatchHistoryEntriesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDbSystemPatchHistoryEntriesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDbSystemPatchHistoryEntriesResponse> transformer = ListDbSystemPatchHistoryEntriesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListDbSystemPatchHistoryEntriesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDbSystemPatchesResponse listDbSystemPatches(ListDbSystemPatchesRequest request) {
        LOG.trace("Called listDbSystemPatches");
        ListDbSystemPatchesRequest interceptedRequest = ListDbSystemPatchesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDbSystemPatchesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDbSystemPatchesResponse> transformer = ListDbSystemPatchesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListDbSystemPatchesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDbSystemShapesResponse listDbSystemShapes(ListDbSystemShapesRequest request) {
        LOG.trace("Called listDbSystemShapes");
        ListDbSystemShapesRequest interceptedRequest = ListDbSystemShapesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDbSystemShapesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDbSystemShapesResponse> transformer = ListDbSystemShapesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListDbSystemShapesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDbSystemsResponse listDbSystems(ListDbSystemsRequest request) {
        LOG.trace("Called listDbSystems");
        ListDbSystemsRequest interceptedRequest = ListDbSystemsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDbSystemsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDbSystemsResponse> transformer = ListDbSystemsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListDbSystemsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDbVersionsResponse listDbVersions(ListDbVersionsRequest request) {
        LOG.trace("Called listDbVersions");
        ListDbVersionsRequest interceptedRequest = ListDbVersionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDbVersionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDbVersionsResponse> transformer = ListDbVersionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListDbVersionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListExadataInfrastructuresResponse listExadataInfrastructures(ListExadataInfrastructuresRequest request) {
        LOG.trace("Called listExadataInfrastructures");
        ListExadataInfrastructuresRequest interceptedRequest = ListExadataInfrastructuresConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListExadataInfrastructuresConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListExadataInfrastructuresResponse> transformer = ListExadataInfrastructuresConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListExadataInfrastructuresResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListGiVersionsResponse listGiVersions(ListGiVersionsRequest request) {
        LOG.trace("Called listGiVersions");
        ListGiVersionsRequest interceptedRequest = ListGiVersionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListGiVersionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListGiVersionsResponse> transformer = ListGiVersionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListGiVersionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListMaintenanceRunsResponse listMaintenanceRuns(ListMaintenanceRunsRequest request) {
        LOG.trace("Called listMaintenanceRuns");
        ListMaintenanceRunsRequest interceptedRequest = ListMaintenanceRunsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListMaintenanceRunsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListMaintenanceRunsResponse> transformer = ListMaintenanceRunsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListMaintenanceRunsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListVmClusterNetworksResponse listVmClusterNetworks(ListVmClusterNetworksRequest request) {
        LOG.trace("Called listVmClusterNetworks");
        ListVmClusterNetworksRequest interceptedRequest = ListVmClusterNetworksConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListVmClusterNetworksConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListVmClusterNetworksResponse> transformer = ListVmClusterNetworksConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListVmClusterNetworksResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListVmClustersResponse listVmClusters(ListVmClustersRequest request) {
        LOG.trace("Called listVmClusters");
        ListVmClustersRequest interceptedRequest = ListVmClustersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListVmClustersConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListVmClustersResponse> transformer = ListVmClustersConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, retriedRequest);
                return (ListVmClustersResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ReinstateDataGuardAssociationResponse reinstateDataGuardAssociation(ReinstateDataGuardAssociationRequest request) {
        LOG.trace("Called reinstateDataGuardAssociation");
        ReinstateDataGuardAssociationRequest interceptedRequest = ReinstateDataGuardAssociationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ReinstateDataGuardAssociationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ReinstateDataGuardAssociationResponse> transformer = ReinstateDataGuardAssociationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getReinstateDataGuardAssociationDetails(), retriedRequest);
                return (ReinstateDataGuardAssociationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RestartAutonomousContainerDatabaseResponse restartAutonomousContainerDatabase(RestartAutonomousContainerDatabaseRequest request) {
        LOG.trace("Called restartAutonomousContainerDatabase");
        RestartAutonomousContainerDatabaseRequest interceptedRequest = RestartAutonomousContainerDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestartAutonomousContainerDatabaseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RestartAutonomousContainerDatabaseResponse> transformer = RestartAutonomousContainerDatabaseConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest);
                return (RestartAutonomousContainerDatabaseResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RestoreAutonomousDataWarehouseResponse restoreAutonomousDataWarehouse(RestoreAutonomousDataWarehouseRequest request) {
        LOG.trace("Called restoreAutonomousDataWarehouse");
        RestoreAutonomousDataWarehouseRequest interceptedRequest = RestoreAutonomousDataWarehouseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestoreAutonomousDataWarehouseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RestoreAutonomousDataWarehouseResponse> transformer = RestoreAutonomousDataWarehouseConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getRestoreAutonomousDataWarehouseDetails(), retriedRequest);
                return (RestoreAutonomousDataWarehouseResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RestoreAutonomousDatabaseResponse restoreAutonomousDatabase(RestoreAutonomousDatabaseRequest request) {
        LOG.trace("Called restoreAutonomousDatabase");
        RestoreAutonomousDatabaseRequest interceptedRequest = RestoreAutonomousDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestoreAutonomousDatabaseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RestoreAutonomousDatabaseResponse> transformer = RestoreAutonomousDatabaseConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getRestoreAutonomousDatabaseDetails(), retriedRequest);
                return (RestoreAutonomousDatabaseResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RestoreDatabaseResponse restoreDatabase(RestoreDatabaseRequest request) {
        LOG.trace("Called restoreDatabase");
        RestoreDatabaseRequest interceptedRequest = RestoreDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestoreDatabaseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RestoreDatabaseResponse> transformer = RestoreDatabaseConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getRestoreDatabaseDetails(), retriedRequest);
                return (RestoreDatabaseResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public StartAutonomousDataWarehouseResponse startAutonomousDataWarehouse(StartAutonomousDataWarehouseRequest request) {
        LOG.trace("Called startAutonomousDataWarehouse");
        StartAutonomousDataWarehouseRequest interceptedRequest = StartAutonomousDataWarehouseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StartAutonomousDataWarehouseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StartAutonomousDataWarehouseResponse> transformer = StartAutonomousDataWarehouseConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest);
                return (StartAutonomousDataWarehouseResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public StartAutonomousDatabaseResponse startAutonomousDatabase(StartAutonomousDatabaseRequest request) {
        LOG.trace("Called startAutonomousDatabase");
        StartAutonomousDatabaseRequest interceptedRequest = StartAutonomousDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StartAutonomousDatabaseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StartAutonomousDatabaseResponse> transformer = StartAutonomousDatabaseConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest);
                return (StartAutonomousDatabaseResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public StopAutonomousDataWarehouseResponse stopAutonomousDataWarehouse(StopAutonomousDataWarehouseRequest request) {
        LOG.trace("Called stopAutonomousDataWarehouse");
        StopAutonomousDataWarehouseRequest interceptedRequest = StopAutonomousDataWarehouseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StopAutonomousDataWarehouseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StopAutonomousDataWarehouseResponse> transformer = StopAutonomousDataWarehouseConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest);
                return (StopAutonomousDataWarehouseResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public StopAutonomousDatabaseResponse stopAutonomousDatabase(StopAutonomousDatabaseRequest request) {
        LOG.trace("Called stopAutonomousDatabase");
        StopAutonomousDatabaseRequest interceptedRequest = StopAutonomousDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = StopAutonomousDatabaseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, StopAutonomousDatabaseResponse> transformer = StopAutonomousDatabaseConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest);
                return (StopAutonomousDatabaseResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public SwitchoverDataGuardAssociationResponse switchoverDataGuardAssociation(SwitchoverDataGuardAssociationRequest request) {
        LOG.trace("Called switchoverDataGuardAssociation");
        SwitchoverDataGuardAssociationRequest interceptedRequest = SwitchoverDataGuardAssociationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = SwitchoverDataGuardAssociationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, SwitchoverDataGuardAssociationResponse> transformer = SwitchoverDataGuardAssociationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest.getSwitchoverDataGuardAssociationDetails(), retriedRequest);
                return (SwitchoverDataGuardAssociationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public TerminateAutonomousContainerDatabaseResponse terminateAutonomousContainerDatabase(TerminateAutonomousContainerDatabaseRequest request) {
        LOG.trace("Called terminateAutonomousContainerDatabase");
        TerminateAutonomousContainerDatabaseRequest interceptedRequest = TerminateAutonomousContainerDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = TerminateAutonomousContainerDatabaseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, TerminateAutonomousContainerDatabaseResponse> transformer = TerminateAutonomousContainerDatabaseConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (TerminateAutonomousContainerDatabaseResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public TerminateAutonomousExadataInfrastructureResponse terminateAutonomousExadataInfrastructure(TerminateAutonomousExadataInfrastructureRequest request) {
        LOG.trace("Called terminateAutonomousExadataInfrastructure");
        TerminateAutonomousExadataInfrastructureRequest interceptedRequest = TerminateAutonomousExadataInfrastructureConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = TerminateAutonomousExadataInfrastructureConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, TerminateAutonomousExadataInfrastructureResponse> transformer = TerminateAutonomousExadataInfrastructureConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (TerminateAutonomousExadataInfrastructureResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public TerminateDbSystemResponse terminateDbSystem(TerminateDbSystemRequest request) {
        LOG.trace("Called terminateDbSystem");
        TerminateDbSystemRequest interceptedRequest = TerminateDbSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = TerminateDbSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, TerminateDbSystemResponse> transformer = TerminateDbSystemConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, retriedRequest);
                return (TerminateDbSystemResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateAutonomousContainerDatabaseResponse updateAutonomousContainerDatabase(UpdateAutonomousContainerDatabaseRequest request) {
        LOG.trace("Called updateAutonomousContainerDatabase");
        UpdateAutonomousContainerDatabaseRequest interceptedRequest = UpdateAutonomousContainerDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAutonomousContainerDatabaseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateAutonomousContainerDatabaseResponse> transformer = UpdateAutonomousContainerDatabaseConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateAutonomousContainerDatabaseDetails(), retriedRequest);
                return (UpdateAutonomousContainerDatabaseResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateAutonomousDataWarehouseResponse updateAutonomousDataWarehouse(UpdateAutonomousDataWarehouseRequest request) {
        LOG.trace("Called updateAutonomousDataWarehouse");
        UpdateAutonomousDataWarehouseRequest interceptedRequest = UpdateAutonomousDataWarehouseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAutonomousDataWarehouseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateAutonomousDataWarehouseResponse> transformer = UpdateAutonomousDataWarehouseConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateAutonomousDataWarehouseDetails(), retriedRequest);
                return (UpdateAutonomousDataWarehouseResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateAutonomousDatabaseResponse updateAutonomousDatabase(UpdateAutonomousDatabaseRequest request) {
        LOG.trace("Called updateAutonomousDatabase");
        UpdateAutonomousDatabaseRequest interceptedRequest = UpdateAutonomousDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAutonomousDatabaseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateAutonomousDatabaseResponse> transformer = UpdateAutonomousDatabaseConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateAutonomousDatabaseDetails(), retriedRequest);
                return (UpdateAutonomousDatabaseResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateAutonomousExadataInfrastructureResponse updateAutonomousExadataInfrastructure(UpdateAutonomousExadataInfrastructureRequest request) {
        LOG.trace("Called updateAutonomousExadataInfrastructure");
        UpdateAutonomousExadataInfrastructureRequest interceptedRequest = UpdateAutonomousExadataInfrastructureConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAutonomousExadataInfrastructureConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateAutonomousExadataInfrastructureResponse> transformer = UpdateAutonomousExadataInfrastructureConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateAutonomousExadataInfrastructuresDetails(), retriedRequest);
                return (UpdateAutonomousExadataInfrastructureResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateBackupDestinationResponse updateBackupDestination(UpdateBackupDestinationRequest request) {
        LOG.trace("Called updateBackupDestination");
        UpdateBackupDestinationRequest interceptedRequest = UpdateBackupDestinationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBackupDestinationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateBackupDestinationResponse> transformer = UpdateBackupDestinationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateBackupDestinationDetails(), retriedRequest);
                return (UpdateBackupDestinationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateDatabaseResponse updateDatabase(UpdateDatabaseRequest request) {
        LOG.trace("Called updateDatabase");
        UpdateDatabaseRequest interceptedRequest = UpdateDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDatabaseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDatabaseResponse> transformer = UpdateDatabaseConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateDatabaseDetails(), retriedRequest);
                return (UpdateDatabaseResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateDbHomeResponse updateDbHome(UpdateDbHomeRequest request) {
        LOG.trace("Called updateDbHome");
        UpdateDbHomeRequest interceptedRequest = UpdateDbHomeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDbHomeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDbHomeResponse> transformer = UpdateDbHomeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateDbHomeDetails(), retriedRequest);
                return (UpdateDbHomeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateDbSystemResponse updateDbSystem(UpdateDbSystemRequest request) {
        LOG.trace("Called updateDbSystem");
        UpdateDbSystemRequest interceptedRequest = UpdateDbSystemConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDbSystemConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDbSystemResponse> transformer = UpdateDbSystemConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateDbSystemDetails(), retriedRequest);
                return (UpdateDbSystemResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateExadataInfrastructureResponse updateExadataInfrastructure(UpdateExadataInfrastructureRequest request) {
        LOG.trace("Called updateExadataInfrastructure");
        UpdateExadataInfrastructureRequest interceptedRequest = UpdateExadataInfrastructureConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateExadataInfrastructureConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateExadataInfrastructureResponse> transformer = UpdateExadataInfrastructureConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateExadataInfrastructureDetails(), retriedRequest);
                return (UpdateExadataInfrastructureResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateExadataIormConfigResponse updateExadataIormConfig(UpdateExadataIormConfigRequest request) {
        LOG.trace("Called updateExadataIormConfig");
        UpdateExadataIormConfigRequest interceptedRequest = UpdateExadataIormConfigConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateExadataIormConfigConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateExadataIormConfigResponse> transformer = UpdateExadataIormConfigConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getExadataIormConfigUpdateDetails(), retriedRequest);
                return (UpdateExadataIormConfigResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateMaintenanceRunResponse updateMaintenanceRun(UpdateMaintenanceRunRequest request) {
        LOG.trace("Called updateMaintenanceRun");
        UpdateMaintenanceRunRequest interceptedRequest = UpdateMaintenanceRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateMaintenanceRunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateMaintenanceRunResponse> transformer = UpdateMaintenanceRunConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateMaintenanceRunDetails(), retriedRequest);
                return (UpdateMaintenanceRunResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateVmClusterResponse updateVmCluster(UpdateVmClusterRequest request) {
        LOG.trace("Called updateVmCluster");
        UpdateVmClusterRequest interceptedRequest = UpdateVmClusterConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateVmClusterConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateVmClusterResponse> transformer = UpdateVmClusterConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateVmClusterDetails(), retriedRequest);
                return (UpdateVmClusterResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateVmClusterNetworkResponse updateVmClusterNetwork(UpdateVmClusterNetworkRequest request) {
        LOG.trace("Called updateVmClusterNetwork");
        UpdateVmClusterNetworkRequest interceptedRequest = UpdateVmClusterNetworkConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateVmClusterNetworkConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateVmClusterNetworkResponse> transformer = UpdateVmClusterNetworkConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, retriedRequest.getUpdateVmClusterNetworkDetails(), retriedRequest);
                return (UpdateVmClusterNetworkResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ValidateVmClusterNetworkResponse validateVmClusterNetwork(ValidateVmClusterNetworkRequest request) {
        LOG.trace("Called validateVmClusterNetwork");
        ValidateVmClusterNetworkRequest interceptedRequest = ValidateVmClusterNetworkConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ValidateVmClusterNetworkConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ValidateVmClusterNetworkResponse> transformer = ValidateVmClusterNetworkConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier(interceptedRequest.getRetryConfiguration(), this.retryConfiguration);
        return retrier.execute(interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return tokenRefreshRetrier.execute(retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, retriedRequest);
                return (ValidateVmClusterNetworkResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DatabaseWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DatabaseWaiters newWaiters(WorkRequest workRequestClient) {
        return new DatabaseWaiters(this.executorService, this, workRequestClient);
    }

    @Override
    public DatabasePaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DatabaseClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public DatabaseClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new DatabaseClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

