/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.database.Database;
import com.oracle.bmc.database.model.AutonomousContainerDatabaseSummary;
import com.oracle.bmc.database.model.AutonomousDataWarehouseBackupSummary;
import com.oracle.bmc.database.model.AutonomousDataWarehouseSummary;
import com.oracle.bmc.database.model.AutonomousDatabaseBackupSummary;
import com.oracle.bmc.database.model.AutonomousDatabaseSummary;
import com.oracle.bmc.database.model.AutonomousDbPreviewVersionSummary;
import com.oracle.bmc.database.model.AutonomousExadataInfrastructureShapeSummary;
import com.oracle.bmc.database.model.AutonomousExadataInfrastructureSummary;
import com.oracle.bmc.database.model.BackupSummary;
import com.oracle.bmc.database.model.DataGuardAssociationSummary;
import com.oracle.bmc.database.model.DatabaseSummary;
import com.oracle.bmc.database.model.DbHomeSummary;
import com.oracle.bmc.database.model.DbNodeSummary;
import com.oracle.bmc.database.model.DbSystemShapeSummary;
import com.oracle.bmc.database.model.DbSystemSummary;
import com.oracle.bmc.database.model.DbVersionSummary;
import com.oracle.bmc.database.model.ExadataInfrastructureSummary;
import com.oracle.bmc.database.model.GiVersionSummary;
import com.oracle.bmc.database.model.MaintenanceRunSummary;
import com.oracle.bmc.database.model.PatchHistoryEntrySummary;
import com.oracle.bmc.database.model.PatchSummary;
import com.oracle.bmc.database.model.VmClusterNetworkSummary;
import com.oracle.bmc.database.model.VmClusterSummary;
import com.oracle.bmc.database.requests.ListAutonomousContainerDatabasesRequest;
import com.oracle.bmc.database.requests.ListAutonomousDataWarehouseBackupsRequest;
import com.oracle.bmc.database.requests.ListAutonomousDataWarehousesRequest;
import com.oracle.bmc.database.requests.ListAutonomousDatabaseBackupsRequest;
import com.oracle.bmc.database.requests.ListAutonomousDatabasesRequest;
import com.oracle.bmc.database.requests.ListAutonomousDbPreviewVersionsRequest;
import com.oracle.bmc.database.requests.ListAutonomousExadataInfrastructureShapesRequest;
import com.oracle.bmc.database.requests.ListAutonomousExadataInfrastructuresRequest;
import com.oracle.bmc.database.requests.ListBackupsRequest;
import com.oracle.bmc.database.requests.ListDataGuardAssociationsRequest;
import com.oracle.bmc.database.requests.ListDatabasesRequest;
import com.oracle.bmc.database.requests.ListDbHomePatchHistoryEntriesRequest;
import com.oracle.bmc.database.requests.ListDbHomePatchesRequest;
import com.oracle.bmc.database.requests.ListDbHomesRequest;
import com.oracle.bmc.database.requests.ListDbNodesRequest;
import com.oracle.bmc.database.requests.ListDbSystemPatchHistoryEntriesRequest;
import com.oracle.bmc.database.requests.ListDbSystemPatchesRequest;
import com.oracle.bmc.database.requests.ListDbSystemShapesRequest;
import com.oracle.bmc.database.requests.ListDbSystemsRequest;
import com.oracle.bmc.database.requests.ListDbVersionsRequest;
import com.oracle.bmc.database.requests.ListExadataInfrastructuresRequest;
import com.oracle.bmc.database.requests.ListGiVersionsRequest;
import com.oracle.bmc.database.requests.ListMaintenanceRunsRequest;
import com.oracle.bmc.database.requests.ListVmClusterNetworksRequest;
import com.oracle.bmc.database.requests.ListVmClustersRequest;
import com.oracle.bmc.database.responses.ListAutonomousContainerDatabasesResponse;
import com.oracle.bmc.database.responses.ListAutonomousDataWarehouseBackupsResponse;
import com.oracle.bmc.database.responses.ListAutonomousDataWarehousesResponse;
import com.oracle.bmc.database.responses.ListAutonomousDatabaseBackupsResponse;
import com.oracle.bmc.database.responses.ListAutonomousDatabasesResponse;
import com.oracle.bmc.database.responses.ListAutonomousDbPreviewVersionsResponse;
import com.oracle.bmc.database.responses.ListAutonomousExadataInfrastructureShapesResponse;
import com.oracle.bmc.database.responses.ListAutonomousExadataInfrastructuresResponse;
import com.oracle.bmc.database.responses.ListBackupsResponse;
import com.oracle.bmc.database.responses.ListDataGuardAssociationsResponse;
import com.oracle.bmc.database.responses.ListDatabasesResponse;
import com.oracle.bmc.database.responses.ListDbHomePatchHistoryEntriesResponse;
import com.oracle.bmc.database.responses.ListDbHomePatchesResponse;
import com.oracle.bmc.database.responses.ListDbHomesResponse;
import com.oracle.bmc.database.responses.ListDbNodesResponse;
import com.oracle.bmc.database.responses.ListDbSystemPatchHistoryEntriesResponse;
import com.oracle.bmc.database.responses.ListDbSystemPatchesResponse;
import com.oracle.bmc.database.responses.ListDbSystemShapesResponse;
import com.oracle.bmc.database.responses.ListDbSystemsResponse;
import com.oracle.bmc.database.responses.ListDbVersionsResponse;
import com.oracle.bmc.database.responses.ListExadataInfrastructuresResponse;
import com.oracle.bmc.database.responses.ListGiVersionsResponse;
import com.oracle.bmc.database.responses.ListMaintenanceRunsResponse;
import com.oracle.bmc.database.responses.ListVmClusterNetworksResponse;
import com.oracle.bmc.database.responses.ListVmClustersResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class DatabasePaginators {
    private final Database client;

    public Iterable<ListAutonomousContainerDatabasesResponse> listAutonomousContainerDatabasesResponseIterator(final ListAutonomousContainerDatabasesRequest request) {
        return new ResponseIterable<ListAutonomousContainerDatabasesRequest.Builder, ListAutonomousContainerDatabasesRequest, ListAutonomousContainerDatabasesResponse>(new Supplier<ListAutonomousContainerDatabasesRequest.Builder>(){

            public ListAutonomousContainerDatabasesRequest.Builder get() {
                return ListAutonomousContainerDatabasesRequest.builder().copy(request);
            }
        }, new Function<ListAutonomousContainerDatabasesResponse, String>(){

            public String apply(ListAutonomousContainerDatabasesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAutonomousContainerDatabasesRequest.Builder>, ListAutonomousContainerDatabasesRequest>(){

            public ListAutonomousContainerDatabasesRequest apply(RequestBuilderAndToken<ListAutonomousContainerDatabasesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAutonomousContainerDatabasesRequest, ListAutonomousContainerDatabasesResponse>(){

            public ListAutonomousContainerDatabasesResponse apply(ListAutonomousContainerDatabasesRequest request) {
                return DatabasePaginators.this.client.listAutonomousContainerDatabases(request);
            }
        });
    }

    public Iterable<AutonomousContainerDatabaseSummary> listAutonomousContainerDatabasesRecordIterator(final ListAutonomousContainerDatabasesRequest request) {
        return new ResponseRecordIterable<ListAutonomousContainerDatabasesRequest.Builder, ListAutonomousContainerDatabasesRequest, ListAutonomousContainerDatabasesResponse, AutonomousContainerDatabaseSummary>(new Supplier<ListAutonomousContainerDatabasesRequest.Builder>(){

            public ListAutonomousContainerDatabasesRequest.Builder get() {
                return ListAutonomousContainerDatabasesRequest.builder().copy(request);
            }
        }, new Function<ListAutonomousContainerDatabasesResponse, String>(){

            public String apply(ListAutonomousContainerDatabasesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAutonomousContainerDatabasesRequest.Builder>, ListAutonomousContainerDatabasesRequest>(){

            public ListAutonomousContainerDatabasesRequest apply(RequestBuilderAndToken<ListAutonomousContainerDatabasesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAutonomousContainerDatabasesRequest, ListAutonomousContainerDatabasesResponse>(){

            public ListAutonomousContainerDatabasesResponse apply(ListAutonomousContainerDatabasesRequest request) {
                return DatabasePaginators.this.client.listAutonomousContainerDatabases(request);
            }
        }, new Function<ListAutonomousContainerDatabasesResponse, List<AutonomousContainerDatabaseSummary>>(){

            public List<AutonomousContainerDatabaseSummary> apply(ListAutonomousContainerDatabasesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListAutonomousDataWarehouseBackupsResponse> listAutonomousDataWarehouseBackupsResponseIterator(final ListAutonomousDataWarehouseBackupsRequest request) {
        return new ResponseIterable<ListAutonomousDataWarehouseBackupsRequest.Builder, ListAutonomousDataWarehouseBackupsRequest, ListAutonomousDataWarehouseBackupsResponse>(new Supplier<ListAutonomousDataWarehouseBackupsRequest.Builder>(){

            public ListAutonomousDataWarehouseBackupsRequest.Builder get() {
                return ListAutonomousDataWarehouseBackupsRequest.builder().copy(request);
            }
        }, new Function<ListAutonomousDataWarehouseBackupsResponse, String>(){

            public String apply(ListAutonomousDataWarehouseBackupsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAutonomousDataWarehouseBackupsRequest.Builder>, ListAutonomousDataWarehouseBackupsRequest>(){

            public ListAutonomousDataWarehouseBackupsRequest apply(RequestBuilderAndToken<ListAutonomousDataWarehouseBackupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAutonomousDataWarehouseBackupsRequest, ListAutonomousDataWarehouseBackupsResponse>(){

            public ListAutonomousDataWarehouseBackupsResponse apply(ListAutonomousDataWarehouseBackupsRequest request) {
                return DatabasePaginators.this.client.listAutonomousDataWarehouseBackups(request);
            }
        });
    }

    public Iterable<AutonomousDataWarehouseBackupSummary> listAutonomousDataWarehouseBackupsRecordIterator(final ListAutonomousDataWarehouseBackupsRequest request) {
        return new ResponseRecordIterable<ListAutonomousDataWarehouseBackupsRequest.Builder, ListAutonomousDataWarehouseBackupsRequest, ListAutonomousDataWarehouseBackupsResponse, AutonomousDataWarehouseBackupSummary>(new Supplier<ListAutonomousDataWarehouseBackupsRequest.Builder>(){

            public ListAutonomousDataWarehouseBackupsRequest.Builder get() {
                return ListAutonomousDataWarehouseBackupsRequest.builder().copy(request);
            }
        }, new Function<ListAutonomousDataWarehouseBackupsResponse, String>(){

            public String apply(ListAutonomousDataWarehouseBackupsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAutonomousDataWarehouseBackupsRequest.Builder>, ListAutonomousDataWarehouseBackupsRequest>(){

            public ListAutonomousDataWarehouseBackupsRequest apply(RequestBuilderAndToken<ListAutonomousDataWarehouseBackupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAutonomousDataWarehouseBackupsRequest, ListAutonomousDataWarehouseBackupsResponse>(){

            public ListAutonomousDataWarehouseBackupsResponse apply(ListAutonomousDataWarehouseBackupsRequest request) {
                return DatabasePaginators.this.client.listAutonomousDataWarehouseBackups(request);
            }
        }, new Function<ListAutonomousDataWarehouseBackupsResponse, List<AutonomousDataWarehouseBackupSummary>>(){

            public List<AutonomousDataWarehouseBackupSummary> apply(ListAutonomousDataWarehouseBackupsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListAutonomousDataWarehousesResponse> listAutonomousDataWarehousesResponseIterator(final ListAutonomousDataWarehousesRequest request) {
        return new ResponseIterable<ListAutonomousDataWarehousesRequest.Builder, ListAutonomousDataWarehousesRequest, ListAutonomousDataWarehousesResponse>(new Supplier<ListAutonomousDataWarehousesRequest.Builder>(){

            public ListAutonomousDataWarehousesRequest.Builder get() {
                return ListAutonomousDataWarehousesRequest.builder().copy(request);
            }
        }, new Function<ListAutonomousDataWarehousesResponse, String>(){

            public String apply(ListAutonomousDataWarehousesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAutonomousDataWarehousesRequest.Builder>, ListAutonomousDataWarehousesRequest>(){

            public ListAutonomousDataWarehousesRequest apply(RequestBuilderAndToken<ListAutonomousDataWarehousesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAutonomousDataWarehousesRequest, ListAutonomousDataWarehousesResponse>(){

            public ListAutonomousDataWarehousesResponse apply(ListAutonomousDataWarehousesRequest request) {
                return DatabasePaginators.this.client.listAutonomousDataWarehouses(request);
            }
        });
    }

    public Iterable<AutonomousDataWarehouseSummary> listAutonomousDataWarehousesRecordIterator(final ListAutonomousDataWarehousesRequest request) {
        return new ResponseRecordIterable<ListAutonomousDataWarehousesRequest.Builder, ListAutonomousDataWarehousesRequest, ListAutonomousDataWarehousesResponse, AutonomousDataWarehouseSummary>(new Supplier<ListAutonomousDataWarehousesRequest.Builder>(){

            public ListAutonomousDataWarehousesRequest.Builder get() {
                return ListAutonomousDataWarehousesRequest.builder().copy(request);
            }
        }, new Function<ListAutonomousDataWarehousesResponse, String>(){

            public String apply(ListAutonomousDataWarehousesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAutonomousDataWarehousesRequest.Builder>, ListAutonomousDataWarehousesRequest>(){

            public ListAutonomousDataWarehousesRequest apply(RequestBuilderAndToken<ListAutonomousDataWarehousesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAutonomousDataWarehousesRequest, ListAutonomousDataWarehousesResponse>(){

            public ListAutonomousDataWarehousesResponse apply(ListAutonomousDataWarehousesRequest request) {
                return DatabasePaginators.this.client.listAutonomousDataWarehouses(request);
            }
        }, new Function<ListAutonomousDataWarehousesResponse, List<AutonomousDataWarehouseSummary>>(){

            public List<AutonomousDataWarehouseSummary> apply(ListAutonomousDataWarehousesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListAutonomousDatabaseBackupsResponse> listAutonomousDatabaseBackupsResponseIterator(final ListAutonomousDatabaseBackupsRequest request) {
        return new ResponseIterable<ListAutonomousDatabaseBackupsRequest.Builder, ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse>(new Supplier<ListAutonomousDatabaseBackupsRequest.Builder>(){

            public ListAutonomousDatabaseBackupsRequest.Builder get() {
                return ListAutonomousDatabaseBackupsRequest.builder().copy(request);
            }
        }, new Function<ListAutonomousDatabaseBackupsResponse, String>(){

            public String apply(ListAutonomousDatabaseBackupsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAutonomousDatabaseBackupsRequest.Builder>, ListAutonomousDatabaseBackupsRequest>(){

            public ListAutonomousDatabaseBackupsRequest apply(RequestBuilderAndToken<ListAutonomousDatabaseBackupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse>(){

            public ListAutonomousDatabaseBackupsResponse apply(ListAutonomousDatabaseBackupsRequest request) {
                return DatabasePaginators.this.client.listAutonomousDatabaseBackups(request);
            }
        });
    }

    public Iterable<AutonomousDatabaseBackupSummary> listAutonomousDatabaseBackupsRecordIterator(final ListAutonomousDatabaseBackupsRequest request) {
        return new ResponseRecordIterable<ListAutonomousDatabaseBackupsRequest.Builder, ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse, AutonomousDatabaseBackupSummary>(new Supplier<ListAutonomousDatabaseBackupsRequest.Builder>(){

            public ListAutonomousDatabaseBackupsRequest.Builder get() {
                return ListAutonomousDatabaseBackupsRequest.builder().copy(request);
            }
        }, new Function<ListAutonomousDatabaseBackupsResponse, String>(){

            public String apply(ListAutonomousDatabaseBackupsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAutonomousDatabaseBackupsRequest.Builder>, ListAutonomousDatabaseBackupsRequest>(){

            public ListAutonomousDatabaseBackupsRequest apply(RequestBuilderAndToken<ListAutonomousDatabaseBackupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAutonomousDatabaseBackupsRequest, ListAutonomousDatabaseBackupsResponse>(){

            public ListAutonomousDatabaseBackupsResponse apply(ListAutonomousDatabaseBackupsRequest request) {
                return DatabasePaginators.this.client.listAutonomousDatabaseBackups(request);
            }
        }, new Function<ListAutonomousDatabaseBackupsResponse, List<AutonomousDatabaseBackupSummary>>(){

            public List<AutonomousDatabaseBackupSummary> apply(ListAutonomousDatabaseBackupsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListAutonomousDatabasesResponse> listAutonomousDatabasesResponseIterator(final ListAutonomousDatabasesRequest request) {
        return new ResponseIterable<ListAutonomousDatabasesRequest.Builder, ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse>(new Supplier<ListAutonomousDatabasesRequest.Builder>(){

            public ListAutonomousDatabasesRequest.Builder get() {
                return ListAutonomousDatabasesRequest.builder().copy(request);
            }
        }, new Function<ListAutonomousDatabasesResponse, String>(){

            public String apply(ListAutonomousDatabasesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAutonomousDatabasesRequest.Builder>, ListAutonomousDatabasesRequest>(){

            public ListAutonomousDatabasesRequest apply(RequestBuilderAndToken<ListAutonomousDatabasesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse>(){

            public ListAutonomousDatabasesResponse apply(ListAutonomousDatabasesRequest request) {
                return DatabasePaginators.this.client.listAutonomousDatabases(request);
            }
        });
    }

    public Iterable<AutonomousDatabaseSummary> listAutonomousDatabasesRecordIterator(final ListAutonomousDatabasesRequest request) {
        return new ResponseRecordIterable<ListAutonomousDatabasesRequest.Builder, ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse, AutonomousDatabaseSummary>(new Supplier<ListAutonomousDatabasesRequest.Builder>(){

            public ListAutonomousDatabasesRequest.Builder get() {
                return ListAutonomousDatabasesRequest.builder().copy(request);
            }
        }, new Function<ListAutonomousDatabasesResponse, String>(){

            public String apply(ListAutonomousDatabasesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAutonomousDatabasesRequest.Builder>, ListAutonomousDatabasesRequest>(){

            public ListAutonomousDatabasesRequest apply(RequestBuilderAndToken<ListAutonomousDatabasesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAutonomousDatabasesRequest, ListAutonomousDatabasesResponse>(){

            public ListAutonomousDatabasesResponse apply(ListAutonomousDatabasesRequest request) {
                return DatabasePaginators.this.client.listAutonomousDatabases(request);
            }
        }, new Function<ListAutonomousDatabasesResponse, List<AutonomousDatabaseSummary>>(){

            public List<AutonomousDatabaseSummary> apply(ListAutonomousDatabasesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListAutonomousDbPreviewVersionsResponse> listAutonomousDbPreviewVersionsResponseIterator(final ListAutonomousDbPreviewVersionsRequest request) {
        return new ResponseIterable<ListAutonomousDbPreviewVersionsRequest.Builder, ListAutonomousDbPreviewVersionsRequest, ListAutonomousDbPreviewVersionsResponse>(new Supplier<ListAutonomousDbPreviewVersionsRequest.Builder>(){

            public ListAutonomousDbPreviewVersionsRequest.Builder get() {
                return ListAutonomousDbPreviewVersionsRequest.builder().copy(request);
            }
        }, new Function<ListAutonomousDbPreviewVersionsResponse, String>(){

            public String apply(ListAutonomousDbPreviewVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAutonomousDbPreviewVersionsRequest.Builder>, ListAutonomousDbPreviewVersionsRequest>(){

            public ListAutonomousDbPreviewVersionsRequest apply(RequestBuilderAndToken<ListAutonomousDbPreviewVersionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAutonomousDbPreviewVersionsRequest, ListAutonomousDbPreviewVersionsResponse>(){

            public ListAutonomousDbPreviewVersionsResponse apply(ListAutonomousDbPreviewVersionsRequest request) {
                return DatabasePaginators.this.client.listAutonomousDbPreviewVersions(request);
            }
        });
    }

    public Iterable<AutonomousDbPreviewVersionSummary> listAutonomousDbPreviewVersionsRecordIterator(final ListAutonomousDbPreviewVersionsRequest request) {
        return new ResponseRecordIterable<ListAutonomousDbPreviewVersionsRequest.Builder, ListAutonomousDbPreviewVersionsRequest, ListAutonomousDbPreviewVersionsResponse, AutonomousDbPreviewVersionSummary>(new Supplier<ListAutonomousDbPreviewVersionsRequest.Builder>(){

            public ListAutonomousDbPreviewVersionsRequest.Builder get() {
                return ListAutonomousDbPreviewVersionsRequest.builder().copy(request);
            }
        }, new Function<ListAutonomousDbPreviewVersionsResponse, String>(){

            public String apply(ListAutonomousDbPreviewVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAutonomousDbPreviewVersionsRequest.Builder>, ListAutonomousDbPreviewVersionsRequest>(){

            public ListAutonomousDbPreviewVersionsRequest apply(RequestBuilderAndToken<ListAutonomousDbPreviewVersionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAutonomousDbPreviewVersionsRequest, ListAutonomousDbPreviewVersionsResponse>(){

            public ListAutonomousDbPreviewVersionsResponse apply(ListAutonomousDbPreviewVersionsRequest request) {
                return DatabasePaginators.this.client.listAutonomousDbPreviewVersions(request);
            }
        }, new Function<ListAutonomousDbPreviewVersionsResponse, List<AutonomousDbPreviewVersionSummary>>(){

            public List<AutonomousDbPreviewVersionSummary> apply(ListAutonomousDbPreviewVersionsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListAutonomousExadataInfrastructureShapesResponse> listAutonomousExadataInfrastructureShapesResponseIterator(final ListAutonomousExadataInfrastructureShapesRequest request) {
        return new ResponseIterable<ListAutonomousExadataInfrastructureShapesRequest.Builder, ListAutonomousExadataInfrastructureShapesRequest, ListAutonomousExadataInfrastructureShapesResponse>(new Supplier<ListAutonomousExadataInfrastructureShapesRequest.Builder>(){

            public ListAutonomousExadataInfrastructureShapesRequest.Builder get() {
                return ListAutonomousExadataInfrastructureShapesRequest.builder().copy(request);
            }
        }, new Function<ListAutonomousExadataInfrastructureShapesResponse, String>(){

            public String apply(ListAutonomousExadataInfrastructureShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAutonomousExadataInfrastructureShapesRequest.Builder>, ListAutonomousExadataInfrastructureShapesRequest>(){

            public ListAutonomousExadataInfrastructureShapesRequest apply(RequestBuilderAndToken<ListAutonomousExadataInfrastructureShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAutonomousExadataInfrastructureShapesRequest, ListAutonomousExadataInfrastructureShapesResponse>(){

            public ListAutonomousExadataInfrastructureShapesResponse apply(ListAutonomousExadataInfrastructureShapesRequest request) {
                return DatabasePaginators.this.client.listAutonomousExadataInfrastructureShapes(request);
            }
        });
    }

    public Iterable<AutonomousExadataInfrastructureShapeSummary> listAutonomousExadataInfrastructureShapesRecordIterator(final ListAutonomousExadataInfrastructureShapesRequest request) {
        return new ResponseRecordIterable<ListAutonomousExadataInfrastructureShapesRequest.Builder, ListAutonomousExadataInfrastructureShapesRequest, ListAutonomousExadataInfrastructureShapesResponse, AutonomousExadataInfrastructureShapeSummary>(new Supplier<ListAutonomousExadataInfrastructureShapesRequest.Builder>(){

            public ListAutonomousExadataInfrastructureShapesRequest.Builder get() {
                return ListAutonomousExadataInfrastructureShapesRequest.builder().copy(request);
            }
        }, new Function<ListAutonomousExadataInfrastructureShapesResponse, String>(){

            public String apply(ListAutonomousExadataInfrastructureShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAutonomousExadataInfrastructureShapesRequest.Builder>, ListAutonomousExadataInfrastructureShapesRequest>(){

            public ListAutonomousExadataInfrastructureShapesRequest apply(RequestBuilderAndToken<ListAutonomousExadataInfrastructureShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAutonomousExadataInfrastructureShapesRequest, ListAutonomousExadataInfrastructureShapesResponse>(){

            public ListAutonomousExadataInfrastructureShapesResponse apply(ListAutonomousExadataInfrastructureShapesRequest request) {
                return DatabasePaginators.this.client.listAutonomousExadataInfrastructureShapes(request);
            }
        }, new Function<ListAutonomousExadataInfrastructureShapesResponse, List<AutonomousExadataInfrastructureShapeSummary>>(){

            public List<AutonomousExadataInfrastructureShapeSummary> apply(ListAutonomousExadataInfrastructureShapesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListAutonomousExadataInfrastructuresResponse> listAutonomousExadataInfrastructuresResponseIterator(final ListAutonomousExadataInfrastructuresRequest request) {
        return new ResponseIterable<ListAutonomousExadataInfrastructuresRequest.Builder, ListAutonomousExadataInfrastructuresRequest, ListAutonomousExadataInfrastructuresResponse>(new Supplier<ListAutonomousExadataInfrastructuresRequest.Builder>(){

            public ListAutonomousExadataInfrastructuresRequest.Builder get() {
                return ListAutonomousExadataInfrastructuresRequest.builder().copy(request);
            }
        }, new Function<ListAutonomousExadataInfrastructuresResponse, String>(){

            public String apply(ListAutonomousExadataInfrastructuresResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAutonomousExadataInfrastructuresRequest.Builder>, ListAutonomousExadataInfrastructuresRequest>(){

            public ListAutonomousExadataInfrastructuresRequest apply(RequestBuilderAndToken<ListAutonomousExadataInfrastructuresRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAutonomousExadataInfrastructuresRequest, ListAutonomousExadataInfrastructuresResponse>(){

            public ListAutonomousExadataInfrastructuresResponse apply(ListAutonomousExadataInfrastructuresRequest request) {
                return DatabasePaginators.this.client.listAutonomousExadataInfrastructures(request);
            }
        });
    }

    public Iterable<AutonomousExadataInfrastructureSummary> listAutonomousExadataInfrastructuresRecordIterator(final ListAutonomousExadataInfrastructuresRequest request) {
        return new ResponseRecordIterable<ListAutonomousExadataInfrastructuresRequest.Builder, ListAutonomousExadataInfrastructuresRequest, ListAutonomousExadataInfrastructuresResponse, AutonomousExadataInfrastructureSummary>(new Supplier<ListAutonomousExadataInfrastructuresRequest.Builder>(){

            public ListAutonomousExadataInfrastructuresRequest.Builder get() {
                return ListAutonomousExadataInfrastructuresRequest.builder().copy(request);
            }
        }, new Function<ListAutonomousExadataInfrastructuresResponse, String>(){

            public String apply(ListAutonomousExadataInfrastructuresResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListAutonomousExadataInfrastructuresRequest.Builder>, ListAutonomousExadataInfrastructuresRequest>(){

            public ListAutonomousExadataInfrastructuresRequest apply(RequestBuilderAndToken<ListAutonomousExadataInfrastructuresRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListAutonomousExadataInfrastructuresRequest, ListAutonomousExadataInfrastructuresResponse>(){

            public ListAutonomousExadataInfrastructuresResponse apply(ListAutonomousExadataInfrastructuresRequest request) {
                return DatabasePaginators.this.client.listAutonomousExadataInfrastructures(request);
            }
        }, new Function<ListAutonomousExadataInfrastructuresResponse, List<AutonomousExadataInfrastructureSummary>>(){

            public List<AutonomousExadataInfrastructureSummary> apply(ListAutonomousExadataInfrastructuresResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListBackupsResponse> listBackupsResponseIterator(final ListBackupsRequest request) {
        return new ResponseIterable<ListBackupsRequest.Builder, ListBackupsRequest, ListBackupsResponse>(new Supplier<ListBackupsRequest.Builder>(){

            public ListBackupsRequest.Builder get() {
                return ListBackupsRequest.builder().copy(request);
            }
        }, new Function<ListBackupsResponse, String>(){

            public String apply(ListBackupsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListBackupsRequest.Builder>, ListBackupsRequest>(){

            public ListBackupsRequest apply(RequestBuilderAndToken<ListBackupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListBackupsRequest, ListBackupsResponse>(){

            public ListBackupsResponse apply(ListBackupsRequest request) {
                return DatabasePaginators.this.client.listBackups(request);
            }
        });
    }

    public Iterable<BackupSummary> listBackupsRecordIterator(final ListBackupsRequest request) {
        return new ResponseRecordIterable<ListBackupsRequest.Builder, ListBackupsRequest, ListBackupsResponse, BackupSummary>(new Supplier<ListBackupsRequest.Builder>(){

            public ListBackupsRequest.Builder get() {
                return ListBackupsRequest.builder().copy(request);
            }
        }, new Function<ListBackupsResponse, String>(){

            public String apply(ListBackupsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListBackupsRequest.Builder>, ListBackupsRequest>(){

            public ListBackupsRequest apply(RequestBuilderAndToken<ListBackupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListBackupsRequest, ListBackupsResponse>(){

            public ListBackupsResponse apply(ListBackupsRequest request) {
                return DatabasePaginators.this.client.listBackups(request);
            }
        }, new Function<ListBackupsResponse, List<BackupSummary>>(){

            public List<BackupSummary> apply(ListBackupsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDataGuardAssociationsResponse> listDataGuardAssociationsResponseIterator(final ListDataGuardAssociationsRequest request) {
        return new ResponseIterable<ListDataGuardAssociationsRequest.Builder, ListDataGuardAssociationsRequest, ListDataGuardAssociationsResponse>(new Supplier<ListDataGuardAssociationsRequest.Builder>(){

            public ListDataGuardAssociationsRequest.Builder get() {
                return ListDataGuardAssociationsRequest.builder().copy(request);
            }
        }, new Function<ListDataGuardAssociationsResponse, String>(){

            public String apply(ListDataGuardAssociationsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDataGuardAssociationsRequest.Builder>, ListDataGuardAssociationsRequest>(){

            public ListDataGuardAssociationsRequest apply(RequestBuilderAndToken<ListDataGuardAssociationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDataGuardAssociationsRequest, ListDataGuardAssociationsResponse>(){

            public ListDataGuardAssociationsResponse apply(ListDataGuardAssociationsRequest request) {
                return DatabasePaginators.this.client.listDataGuardAssociations(request);
            }
        });
    }

    public Iterable<DataGuardAssociationSummary> listDataGuardAssociationsRecordIterator(final ListDataGuardAssociationsRequest request) {
        return new ResponseRecordIterable<ListDataGuardAssociationsRequest.Builder, ListDataGuardAssociationsRequest, ListDataGuardAssociationsResponse, DataGuardAssociationSummary>(new Supplier<ListDataGuardAssociationsRequest.Builder>(){

            public ListDataGuardAssociationsRequest.Builder get() {
                return ListDataGuardAssociationsRequest.builder().copy(request);
            }
        }, new Function<ListDataGuardAssociationsResponse, String>(){

            public String apply(ListDataGuardAssociationsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDataGuardAssociationsRequest.Builder>, ListDataGuardAssociationsRequest>(){

            public ListDataGuardAssociationsRequest apply(RequestBuilderAndToken<ListDataGuardAssociationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDataGuardAssociationsRequest, ListDataGuardAssociationsResponse>(){

            public ListDataGuardAssociationsResponse apply(ListDataGuardAssociationsRequest request) {
                return DatabasePaginators.this.client.listDataGuardAssociations(request);
            }
        }, new Function<ListDataGuardAssociationsResponse, List<DataGuardAssociationSummary>>(){

            public List<DataGuardAssociationSummary> apply(ListDataGuardAssociationsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDatabasesResponse> listDatabasesResponseIterator(final ListDatabasesRequest request) {
        return new ResponseIterable<ListDatabasesRequest.Builder, ListDatabasesRequest, ListDatabasesResponse>(new Supplier<ListDatabasesRequest.Builder>(){

            public ListDatabasesRequest.Builder get() {
                return ListDatabasesRequest.builder().copy(request);
            }
        }, new Function<ListDatabasesResponse, String>(){

            public String apply(ListDatabasesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDatabasesRequest.Builder>, ListDatabasesRequest>(){

            public ListDatabasesRequest apply(RequestBuilderAndToken<ListDatabasesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDatabasesRequest, ListDatabasesResponse>(){

            public ListDatabasesResponse apply(ListDatabasesRequest request) {
                return DatabasePaginators.this.client.listDatabases(request);
            }
        });
    }

    public Iterable<DatabaseSummary> listDatabasesRecordIterator(final ListDatabasesRequest request) {
        return new ResponseRecordIterable<ListDatabasesRequest.Builder, ListDatabasesRequest, ListDatabasesResponse, DatabaseSummary>(new Supplier<ListDatabasesRequest.Builder>(){

            public ListDatabasesRequest.Builder get() {
                return ListDatabasesRequest.builder().copy(request);
            }
        }, new Function<ListDatabasesResponse, String>(){

            public String apply(ListDatabasesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDatabasesRequest.Builder>, ListDatabasesRequest>(){

            public ListDatabasesRequest apply(RequestBuilderAndToken<ListDatabasesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDatabasesRequest, ListDatabasesResponse>(){

            public ListDatabasesResponse apply(ListDatabasesRequest request) {
                return DatabasePaginators.this.client.listDatabases(request);
            }
        }, new Function<ListDatabasesResponse, List<DatabaseSummary>>(){

            public List<DatabaseSummary> apply(ListDatabasesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDbHomePatchHistoryEntriesResponse> listDbHomePatchHistoryEntriesResponseIterator(final ListDbHomePatchHistoryEntriesRequest request) {
        return new ResponseIterable<ListDbHomePatchHistoryEntriesRequest.Builder, ListDbHomePatchHistoryEntriesRequest, ListDbHomePatchHistoryEntriesResponse>(new Supplier<ListDbHomePatchHistoryEntriesRequest.Builder>(){

            public ListDbHomePatchHistoryEntriesRequest.Builder get() {
                return ListDbHomePatchHistoryEntriesRequest.builder().copy(request);
            }
        }, new Function<ListDbHomePatchHistoryEntriesResponse, String>(){

            public String apply(ListDbHomePatchHistoryEntriesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDbHomePatchHistoryEntriesRequest.Builder>, ListDbHomePatchHistoryEntriesRequest>(){

            public ListDbHomePatchHistoryEntriesRequest apply(RequestBuilderAndToken<ListDbHomePatchHistoryEntriesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDbHomePatchHistoryEntriesRequest, ListDbHomePatchHistoryEntriesResponse>(){

            public ListDbHomePatchHistoryEntriesResponse apply(ListDbHomePatchHistoryEntriesRequest request) {
                return DatabasePaginators.this.client.listDbHomePatchHistoryEntries(request);
            }
        });
    }

    public Iterable<PatchHistoryEntrySummary> listDbHomePatchHistoryEntriesRecordIterator(final ListDbHomePatchHistoryEntriesRequest request) {
        return new ResponseRecordIterable<ListDbHomePatchHistoryEntriesRequest.Builder, ListDbHomePatchHistoryEntriesRequest, ListDbHomePatchHistoryEntriesResponse, PatchHistoryEntrySummary>(new Supplier<ListDbHomePatchHistoryEntriesRequest.Builder>(){

            public ListDbHomePatchHistoryEntriesRequest.Builder get() {
                return ListDbHomePatchHistoryEntriesRequest.builder().copy(request);
            }
        }, new Function<ListDbHomePatchHistoryEntriesResponse, String>(){

            public String apply(ListDbHomePatchHistoryEntriesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDbHomePatchHistoryEntriesRequest.Builder>, ListDbHomePatchHistoryEntriesRequest>(){

            public ListDbHomePatchHistoryEntriesRequest apply(RequestBuilderAndToken<ListDbHomePatchHistoryEntriesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDbHomePatchHistoryEntriesRequest, ListDbHomePatchHistoryEntriesResponse>(){

            public ListDbHomePatchHistoryEntriesResponse apply(ListDbHomePatchHistoryEntriesRequest request) {
                return DatabasePaginators.this.client.listDbHomePatchHistoryEntries(request);
            }
        }, new Function<ListDbHomePatchHistoryEntriesResponse, List<PatchHistoryEntrySummary>>(){

            public List<PatchHistoryEntrySummary> apply(ListDbHomePatchHistoryEntriesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDbHomePatchesResponse> listDbHomePatchesResponseIterator(final ListDbHomePatchesRequest request) {
        return new ResponseIterable<ListDbHomePatchesRequest.Builder, ListDbHomePatchesRequest, ListDbHomePatchesResponse>(new Supplier<ListDbHomePatchesRequest.Builder>(){

            public ListDbHomePatchesRequest.Builder get() {
                return ListDbHomePatchesRequest.builder().copy(request);
            }
        }, new Function<ListDbHomePatchesResponse, String>(){

            public String apply(ListDbHomePatchesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDbHomePatchesRequest.Builder>, ListDbHomePatchesRequest>(){

            public ListDbHomePatchesRequest apply(RequestBuilderAndToken<ListDbHomePatchesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDbHomePatchesRequest, ListDbHomePatchesResponse>(){

            public ListDbHomePatchesResponse apply(ListDbHomePatchesRequest request) {
                return DatabasePaginators.this.client.listDbHomePatches(request);
            }
        });
    }

    public Iterable<PatchSummary> listDbHomePatchesRecordIterator(final ListDbHomePatchesRequest request) {
        return new ResponseRecordIterable<ListDbHomePatchesRequest.Builder, ListDbHomePatchesRequest, ListDbHomePatchesResponse, PatchSummary>(new Supplier<ListDbHomePatchesRequest.Builder>(){

            public ListDbHomePatchesRequest.Builder get() {
                return ListDbHomePatchesRequest.builder().copy(request);
            }
        }, new Function<ListDbHomePatchesResponse, String>(){

            public String apply(ListDbHomePatchesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDbHomePatchesRequest.Builder>, ListDbHomePatchesRequest>(){

            public ListDbHomePatchesRequest apply(RequestBuilderAndToken<ListDbHomePatchesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDbHomePatchesRequest, ListDbHomePatchesResponse>(){

            public ListDbHomePatchesResponse apply(ListDbHomePatchesRequest request) {
                return DatabasePaginators.this.client.listDbHomePatches(request);
            }
        }, new Function<ListDbHomePatchesResponse, List<PatchSummary>>(){

            public List<PatchSummary> apply(ListDbHomePatchesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDbHomesResponse> listDbHomesResponseIterator(final ListDbHomesRequest request) {
        return new ResponseIterable<ListDbHomesRequest.Builder, ListDbHomesRequest, ListDbHomesResponse>(new Supplier<ListDbHomesRequest.Builder>(){

            public ListDbHomesRequest.Builder get() {
                return ListDbHomesRequest.builder().copy(request);
            }
        }, new Function<ListDbHomesResponse, String>(){

            public String apply(ListDbHomesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDbHomesRequest.Builder>, ListDbHomesRequest>(){

            public ListDbHomesRequest apply(RequestBuilderAndToken<ListDbHomesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDbHomesRequest, ListDbHomesResponse>(){

            public ListDbHomesResponse apply(ListDbHomesRequest request) {
                return DatabasePaginators.this.client.listDbHomes(request);
            }
        });
    }

    public Iterable<DbHomeSummary> listDbHomesRecordIterator(final ListDbHomesRequest request) {
        return new ResponseRecordIterable<ListDbHomesRequest.Builder, ListDbHomesRequest, ListDbHomesResponse, DbHomeSummary>(new Supplier<ListDbHomesRequest.Builder>(){

            public ListDbHomesRequest.Builder get() {
                return ListDbHomesRequest.builder().copy(request);
            }
        }, new Function<ListDbHomesResponse, String>(){

            public String apply(ListDbHomesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDbHomesRequest.Builder>, ListDbHomesRequest>(){

            public ListDbHomesRequest apply(RequestBuilderAndToken<ListDbHomesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDbHomesRequest, ListDbHomesResponse>(){

            public ListDbHomesResponse apply(ListDbHomesRequest request) {
                return DatabasePaginators.this.client.listDbHomes(request);
            }
        }, new Function<ListDbHomesResponse, List<DbHomeSummary>>(){

            public List<DbHomeSummary> apply(ListDbHomesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDbNodesResponse> listDbNodesResponseIterator(final ListDbNodesRequest request) {
        return new ResponseIterable<ListDbNodesRequest.Builder, ListDbNodesRequest, ListDbNodesResponse>(new Supplier<ListDbNodesRequest.Builder>(){

            public ListDbNodesRequest.Builder get() {
                return ListDbNodesRequest.builder().copy(request);
            }
        }, new Function<ListDbNodesResponse, String>(){

            public String apply(ListDbNodesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDbNodesRequest.Builder>, ListDbNodesRequest>(){

            public ListDbNodesRequest apply(RequestBuilderAndToken<ListDbNodesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDbNodesRequest, ListDbNodesResponse>(){

            public ListDbNodesResponse apply(ListDbNodesRequest request) {
                return DatabasePaginators.this.client.listDbNodes(request);
            }
        });
    }

    public Iterable<DbNodeSummary> listDbNodesRecordIterator(final ListDbNodesRequest request) {
        return new ResponseRecordIterable<ListDbNodesRequest.Builder, ListDbNodesRequest, ListDbNodesResponse, DbNodeSummary>(new Supplier<ListDbNodesRequest.Builder>(){

            public ListDbNodesRequest.Builder get() {
                return ListDbNodesRequest.builder().copy(request);
            }
        }, new Function<ListDbNodesResponse, String>(){

            public String apply(ListDbNodesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDbNodesRequest.Builder>, ListDbNodesRequest>(){

            public ListDbNodesRequest apply(RequestBuilderAndToken<ListDbNodesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDbNodesRequest, ListDbNodesResponse>(){

            public ListDbNodesResponse apply(ListDbNodesRequest request) {
                return DatabasePaginators.this.client.listDbNodes(request);
            }
        }, new Function<ListDbNodesResponse, List<DbNodeSummary>>(){

            public List<DbNodeSummary> apply(ListDbNodesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDbSystemPatchHistoryEntriesResponse> listDbSystemPatchHistoryEntriesResponseIterator(final ListDbSystemPatchHistoryEntriesRequest request) {
        return new ResponseIterable<ListDbSystemPatchHistoryEntriesRequest.Builder, ListDbSystemPatchHistoryEntriesRequest, ListDbSystemPatchHistoryEntriesResponse>(new Supplier<ListDbSystemPatchHistoryEntriesRequest.Builder>(){

            public ListDbSystemPatchHistoryEntriesRequest.Builder get() {
                return ListDbSystemPatchHistoryEntriesRequest.builder().copy(request);
            }
        }, new Function<ListDbSystemPatchHistoryEntriesResponse, String>(){

            public String apply(ListDbSystemPatchHistoryEntriesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDbSystemPatchHistoryEntriesRequest.Builder>, ListDbSystemPatchHistoryEntriesRequest>(){

            public ListDbSystemPatchHistoryEntriesRequest apply(RequestBuilderAndToken<ListDbSystemPatchHistoryEntriesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDbSystemPatchHistoryEntriesRequest, ListDbSystemPatchHistoryEntriesResponse>(){

            public ListDbSystemPatchHistoryEntriesResponse apply(ListDbSystemPatchHistoryEntriesRequest request) {
                return DatabasePaginators.this.client.listDbSystemPatchHistoryEntries(request);
            }
        });
    }

    public Iterable<PatchHistoryEntrySummary> listDbSystemPatchHistoryEntriesRecordIterator(final ListDbSystemPatchHistoryEntriesRequest request) {
        return new ResponseRecordIterable<ListDbSystemPatchHistoryEntriesRequest.Builder, ListDbSystemPatchHistoryEntriesRequest, ListDbSystemPatchHistoryEntriesResponse, PatchHistoryEntrySummary>(new Supplier<ListDbSystemPatchHistoryEntriesRequest.Builder>(){

            public ListDbSystemPatchHistoryEntriesRequest.Builder get() {
                return ListDbSystemPatchHistoryEntriesRequest.builder().copy(request);
            }
        }, new Function<ListDbSystemPatchHistoryEntriesResponse, String>(){

            public String apply(ListDbSystemPatchHistoryEntriesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDbSystemPatchHistoryEntriesRequest.Builder>, ListDbSystemPatchHistoryEntriesRequest>(){

            public ListDbSystemPatchHistoryEntriesRequest apply(RequestBuilderAndToken<ListDbSystemPatchHistoryEntriesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDbSystemPatchHistoryEntriesRequest, ListDbSystemPatchHistoryEntriesResponse>(){

            public ListDbSystemPatchHistoryEntriesResponse apply(ListDbSystemPatchHistoryEntriesRequest request) {
                return DatabasePaginators.this.client.listDbSystemPatchHistoryEntries(request);
            }
        }, new Function<ListDbSystemPatchHistoryEntriesResponse, List<PatchHistoryEntrySummary>>(){

            public List<PatchHistoryEntrySummary> apply(ListDbSystemPatchHistoryEntriesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDbSystemPatchesResponse> listDbSystemPatchesResponseIterator(final ListDbSystemPatchesRequest request) {
        return new ResponseIterable<ListDbSystemPatchesRequest.Builder, ListDbSystemPatchesRequest, ListDbSystemPatchesResponse>(new Supplier<ListDbSystemPatchesRequest.Builder>(){

            public ListDbSystemPatchesRequest.Builder get() {
                return ListDbSystemPatchesRequest.builder().copy(request);
            }
        }, new Function<ListDbSystemPatchesResponse, String>(){

            public String apply(ListDbSystemPatchesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDbSystemPatchesRequest.Builder>, ListDbSystemPatchesRequest>(){

            public ListDbSystemPatchesRequest apply(RequestBuilderAndToken<ListDbSystemPatchesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDbSystemPatchesRequest, ListDbSystemPatchesResponse>(){

            public ListDbSystemPatchesResponse apply(ListDbSystemPatchesRequest request) {
                return DatabasePaginators.this.client.listDbSystemPatches(request);
            }
        });
    }

    public Iterable<PatchSummary> listDbSystemPatchesRecordIterator(final ListDbSystemPatchesRequest request) {
        return new ResponseRecordIterable<ListDbSystemPatchesRequest.Builder, ListDbSystemPatchesRequest, ListDbSystemPatchesResponse, PatchSummary>(new Supplier<ListDbSystemPatchesRequest.Builder>(){

            public ListDbSystemPatchesRequest.Builder get() {
                return ListDbSystemPatchesRequest.builder().copy(request);
            }
        }, new Function<ListDbSystemPatchesResponse, String>(){

            public String apply(ListDbSystemPatchesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDbSystemPatchesRequest.Builder>, ListDbSystemPatchesRequest>(){

            public ListDbSystemPatchesRequest apply(RequestBuilderAndToken<ListDbSystemPatchesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDbSystemPatchesRequest, ListDbSystemPatchesResponse>(){

            public ListDbSystemPatchesResponse apply(ListDbSystemPatchesRequest request) {
                return DatabasePaginators.this.client.listDbSystemPatches(request);
            }
        }, new Function<ListDbSystemPatchesResponse, List<PatchSummary>>(){

            public List<PatchSummary> apply(ListDbSystemPatchesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDbSystemShapesResponse> listDbSystemShapesResponseIterator(final ListDbSystemShapesRequest request) {
        return new ResponseIterable<ListDbSystemShapesRequest.Builder, ListDbSystemShapesRequest, ListDbSystemShapesResponse>(new Supplier<ListDbSystemShapesRequest.Builder>(){

            public ListDbSystemShapesRequest.Builder get() {
                return ListDbSystemShapesRequest.builder().copy(request);
            }
        }, new Function<ListDbSystemShapesResponse, String>(){

            public String apply(ListDbSystemShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDbSystemShapesRequest.Builder>, ListDbSystemShapesRequest>(){

            public ListDbSystemShapesRequest apply(RequestBuilderAndToken<ListDbSystemShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDbSystemShapesRequest, ListDbSystemShapesResponse>(){

            public ListDbSystemShapesResponse apply(ListDbSystemShapesRequest request) {
                return DatabasePaginators.this.client.listDbSystemShapes(request);
            }
        });
    }

    public Iterable<DbSystemShapeSummary> listDbSystemShapesRecordIterator(final ListDbSystemShapesRequest request) {
        return new ResponseRecordIterable<ListDbSystemShapesRequest.Builder, ListDbSystemShapesRequest, ListDbSystemShapesResponse, DbSystemShapeSummary>(new Supplier<ListDbSystemShapesRequest.Builder>(){

            public ListDbSystemShapesRequest.Builder get() {
                return ListDbSystemShapesRequest.builder().copy(request);
            }
        }, new Function<ListDbSystemShapesResponse, String>(){

            public String apply(ListDbSystemShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDbSystemShapesRequest.Builder>, ListDbSystemShapesRequest>(){

            public ListDbSystemShapesRequest apply(RequestBuilderAndToken<ListDbSystemShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDbSystemShapesRequest, ListDbSystemShapesResponse>(){

            public ListDbSystemShapesResponse apply(ListDbSystemShapesRequest request) {
                return DatabasePaginators.this.client.listDbSystemShapes(request);
            }
        }, new Function<ListDbSystemShapesResponse, List<DbSystemShapeSummary>>(){

            public List<DbSystemShapeSummary> apply(ListDbSystemShapesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDbSystemsResponse> listDbSystemsResponseIterator(final ListDbSystemsRequest request) {
        return new ResponseIterable<ListDbSystemsRequest.Builder, ListDbSystemsRequest, ListDbSystemsResponse>(new Supplier<ListDbSystemsRequest.Builder>(){

            public ListDbSystemsRequest.Builder get() {
                return ListDbSystemsRequest.builder().copy(request);
            }
        }, new Function<ListDbSystemsResponse, String>(){

            public String apply(ListDbSystemsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDbSystemsRequest.Builder>, ListDbSystemsRequest>(){

            public ListDbSystemsRequest apply(RequestBuilderAndToken<ListDbSystemsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDbSystemsRequest, ListDbSystemsResponse>(){

            public ListDbSystemsResponse apply(ListDbSystemsRequest request) {
                return DatabasePaginators.this.client.listDbSystems(request);
            }
        });
    }

    public Iterable<DbSystemSummary> listDbSystemsRecordIterator(final ListDbSystemsRequest request) {
        return new ResponseRecordIterable<ListDbSystemsRequest.Builder, ListDbSystemsRequest, ListDbSystemsResponse, DbSystemSummary>(new Supplier<ListDbSystemsRequest.Builder>(){

            public ListDbSystemsRequest.Builder get() {
                return ListDbSystemsRequest.builder().copy(request);
            }
        }, new Function<ListDbSystemsResponse, String>(){

            public String apply(ListDbSystemsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDbSystemsRequest.Builder>, ListDbSystemsRequest>(){

            public ListDbSystemsRequest apply(RequestBuilderAndToken<ListDbSystemsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDbSystemsRequest, ListDbSystemsResponse>(){

            public ListDbSystemsResponse apply(ListDbSystemsRequest request) {
                return DatabasePaginators.this.client.listDbSystems(request);
            }
        }, new Function<ListDbSystemsResponse, List<DbSystemSummary>>(){

            public List<DbSystemSummary> apply(ListDbSystemsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListDbVersionsResponse> listDbVersionsResponseIterator(final ListDbVersionsRequest request) {
        return new ResponseIterable<ListDbVersionsRequest.Builder, ListDbVersionsRequest, ListDbVersionsResponse>(new Supplier<ListDbVersionsRequest.Builder>(){

            public ListDbVersionsRequest.Builder get() {
                return ListDbVersionsRequest.builder().copy(request);
            }
        }, new Function<ListDbVersionsResponse, String>(){

            public String apply(ListDbVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDbVersionsRequest.Builder>, ListDbVersionsRequest>(){

            public ListDbVersionsRequest apply(RequestBuilderAndToken<ListDbVersionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDbVersionsRequest, ListDbVersionsResponse>(){

            public ListDbVersionsResponse apply(ListDbVersionsRequest request) {
                return DatabasePaginators.this.client.listDbVersions(request);
            }
        });
    }

    public Iterable<DbVersionSummary> listDbVersionsRecordIterator(final ListDbVersionsRequest request) {
        return new ResponseRecordIterable<ListDbVersionsRequest.Builder, ListDbVersionsRequest, ListDbVersionsResponse, DbVersionSummary>(new Supplier<ListDbVersionsRequest.Builder>(){

            public ListDbVersionsRequest.Builder get() {
                return ListDbVersionsRequest.builder().copy(request);
            }
        }, new Function<ListDbVersionsResponse, String>(){

            public String apply(ListDbVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListDbVersionsRequest.Builder>, ListDbVersionsRequest>(){

            public ListDbVersionsRequest apply(RequestBuilderAndToken<ListDbVersionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListDbVersionsRequest, ListDbVersionsResponse>(){

            public ListDbVersionsResponse apply(ListDbVersionsRequest request) {
                return DatabasePaginators.this.client.listDbVersions(request);
            }
        }, new Function<ListDbVersionsResponse, List<DbVersionSummary>>(){

            public List<DbVersionSummary> apply(ListDbVersionsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListExadataInfrastructuresResponse> listExadataInfrastructuresResponseIterator(final ListExadataInfrastructuresRequest request) {
        return new ResponseIterable<ListExadataInfrastructuresRequest.Builder, ListExadataInfrastructuresRequest, ListExadataInfrastructuresResponse>(new Supplier<ListExadataInfrastructuresRequest.Builder>(){

            public ListExadataInfrastructuresRequest.Builder get() {
                return ListExadataInfrastructuresRequest.builder().copy(request);
            }
        }, new Function<ListExadataInfrastructuresResponse, String>(){

            public String apply(ListExadataInfrastructuresResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListExadataInfrastructuresRequest.Builder>, ListExadataInfrastructuresRequest>(){

            public ListExadataInfrastructuresRequest apply(RequestBuilderAndToken<ListExadataInfrastructuresRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListExadataInfrastructuresRequest, ListExadataInfrastructuresResponse>(){

            public ListExadataInfrastructuresResponse apply(ListExadataInfrastructuresRequest request) {
                return DatabasePaginators.this.client.listExadataInfrastructures(request);
            }
        });
    }

    public Iterable<ExadataInfrastructureSummary> listExadataInfrastructuresRecordIterator(final ListExadataInfrastructuresRequest request) {
        return new ResponseRecordIterable<ListExadataInfrastructuresRequest.Builder, ListExadataInfrastructuresRequest, ListExadataInfrastructuresResponse, ExadataInfrastructureSummary>(new Supplier<ListExadataInfrastructuresRequest.Builder>(){

            public ListExadataInfrastructuresRequest.Builder get() {
                return ListExadataInfrastructuresRequest.builder().copy(request);
            }
        }, new Function<ListExadataInfrastructuresResponse, String>(){

            public String apply(ListExadataInfrastructuresResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListExadataInfrastructuresRequest.Builder>, ListExadataInfrastructuresRequest>(){

            public ListExadataInfrastructuresRequest apply(RequestBuilderAndToken<ListExadataInfrastructuresRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListExadataInfrastructuresRequest, ListExadataInfrastructuresResponse>(){

            public ListExadataInfrastructuresResponse apply(ListExadataInfrastructuresRequest request) {
                return DatabasePaginators.this.client.listExadataInfrastructures(request);
            }
        }, new Function<ListExadataInfrastructuresResponse, List<ExadataInfrastructureSummary>>(){

            public List<ExadataInfrastructureSummary> apply(ListExadataInfrastructuresResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListGiVersionsResponse> listGiVersionsResponseIterator(final ListGiVersionsRequest request) {
        return new ResponseIterable<ListGiVersionsRequest.Builder, ListGiVersionsRequest, ListGiVersionsResponse>(new Supplier<ListGiVersionsRequest.Builder>(){

            public ListGiVersionsRequest.Builder get() {
                return ListGiVersionsRequest.builder().copy(request);
            }
        }, new Function<ListGiVersionsResponse, String>(){

            public String apply(ListGiVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListGiVersionsRequest.Builder>, ListGiVersionsRequest>(){

            public ListGiVersionsRequest apply(RequestBuilderAndToken<ListGiVersionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListGiVersionsRequest, ListGiVersionsResponse>(){

            public ListGiVersionsResponse apply(ListGiVersionsRequest request) {
                return DatabasePaginators.this.client.listGiVersions(request);
            }
        });
    }

    public Iterable<GiVersionSummary> listGiVersionsRecordIterator(final ListGiVersionsRequest request) {
        return new ResponseRecordIterable<ListGiVersionsRequest.Builder, ListGiVersionsRequest, ListGiVersionsResponse, GiVersionSummary>(new Supplier<ListGiVersionsRequest.Builder>(){

            public ListGiVersionsRequest.Builder get() {
                return ListGiVersionsRequest.builder().copy(request);
            }
        }, new Function<ListGiVersionsResponse, String>(){

            public String apply(ListGiVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListGiVersionsRequest.Builder>, ListGiVersionsRequest>(){

            public ListGiVersionsRequest apply(RequestBuilderAndToken<ListGiVersionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListGiVersionsRequest, ListGiVersionsResponse>(){

            public ListGiVersionsResponse apply(ListGiVersionsRequest request) {
                return DatabasePaginators.this.client.listGiVersions(request);
            }
        }, new Function<ListGiVersionsResponse, List<GiVersionSummary>>(){

            public List<GiVersionSummary> apply(ListGiVersionsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListMaintenanceRunsResponse> listMaintenanceRunsResponseIterator(final ListMaintenanceRunsRequest request) {
        return new ResponseIterable<ListMaintenanceRunsRequest.Builder, ListMaintenanceRunsRequest, ListMaintenanceRunsResponse>(new Supplier<ListMaintenanceRunsRequest.Builder>(){

            public ListMaintenanceRunsRequest.Builder get() {
                return ListMaintenanceRunsRequest.builder().copy(request);
            }
        }, new Function<ListMaintenanceRunsResponse, String>(){

            public String apply(ListMaintenanceRunsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListMaintenanceRunsRequest.Builder>, ListMaintenanceRunsRequest>(){

            public ListMaintenanceRunsRequest apply(RequestBuilderAndToken<ListMaintenanceRunsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListMaintenanceRunsRequest, ListMaintenanceRunsResponse>(){

            public ListMaintenanceRunsResponse apply(ListMaintenanceRunsRequest request) {
                return DatabasePaginators.this.client.listMaintenanceRuns(request);
            }
        });
    }

    public Iterable<MaintenanceRunSummary> listMaintenanceRunsRecordIterator(final ListMaintenanceRunsRequest request) {
        return new ResponseRecordIterable<ListMaintenanceRunsRequest.Builder, ListMaintenanceRunsRequest, ListMaintenanceRunsResponse, MaintenanceRunSummary>(new Supplier<ListMaintenanceRunsRequest.Builder>(){

            public ListMaintenanceRunsRequest.Builder get() {
                return ListMaintenanceRunsRequest.builder().copy(request);
            }
        }, new Function<ListMaintenanceRunsResponse, String>(){

            public String apply(ListMaintenanceRunsResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListMaintenanceRunsRequest.Builder>, ListMaintenanceRunsRequest>(){

            public ListMaintenanceRunsRequest apply(RequestBuilderAndToken<ListMaintenanceRunsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListMaintenanceRunsRequest, ListMaintenanceRunsResponse>(){

            public ListMaintenanceRunsResponse apply(ListMaintenanceRunsRequest request) {
                return DatabasePaginators.this.client.listMaintenanceRuns(request);
            }
        }, new Function<ListMaintenanceRunsResponse, List<MaintenanceRunSummary>>(){

            public List<MaintenanceRunSummary> apply(ListMaintenanceRunsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListVmClusterNetworksResponse> listVmClusterNetworksResponseIterator(final ListVmClusterNetworksRequest request) {
        return new ResponseIterable<ListVmClusterNetworksRequest.Builder, ListVmClusterNetworksRequest, ListVmClusterNetworksResponse>(new Supplier<ListVmClusterNetworksRequest.Builder>(){

            public ListVmClusterNetworksRequest.Builder get() {
                return ListVmClusterNetworksRequest.builder().copy(request);
            }
        }, new Function<ListVmClusterNetworksResponse, String>(){

            public String apply(ListVmClusterNetworksResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListVmClusterNetworksRequest.Builder>, ListVmClusterNetworksRequest>(){

            public ListVmClusterNetworksRequest apply(RequestBuilderAndToken<ListVmClusterNetworksRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListVmClusterNetworksRequest, ListVmClusterNetworksResponse>(){

            public ListVmClusterNetworksResponse apply(ListVmClusterNetworksRequest request) {
                return DatabasePaginators.this.client.listVmClusterNetworks(request);
            }
        });
    }

    public Iterable<VmClusterNetworkSummary> listVmClusterNetworksRecordIterator(final ListVmClusterNetworksRequest request) {
        return new ResponseRecordIterable<ListVmClusterNetworksRequest.Builder, ListVmClusterNetworksRequest, ListVmClusterNetworksResponse, VmClusterNetworkSummary>(new Supplier<ListVmClusterNetworksRequest.Builder>(){

            public ListVmClusterNetworksRequest.Builder get() {
                return ListVmClusterNetworksRequest.builder().copy(request);
            }
        }, new Function<ListVmClusterNetworksResponse, String>(){

            public String apply(ListVmClusterNetworksResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListVmClusterNetworksRequest.Builder>, ListVmClusterNetworksRequest>(){

            public ListVmClusterNetworksRequest apply(RequestBuilderAndToken<ListVmClusterNetworksRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListVmClusterNetworksRequest, ListVmClusterNetworksResponse>(){

            public ListVmClusterNetworksResponse apply(ListVmClusterNetworksRequest request) {
                return DatabasePaginators.this.client.listVmClusterNetworks(request);
            }
        }, new Function<ListVmClusterNetworksResponse, List<VmClusterNetworkSummary>>(){

            public List<VmClusterNetworkSummary> apply(ListVmClusterNetworksResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListVmClustersResponse> listVmClustersResponseIterator(final ListVmClustersRequest request) {
        return new ResponseIterable<ListVmClustersRequest.Builder, ListVmClustersRequest, ListVmClustersResponse>(new Supplier<ListVmClustersRequest.Builder>(){

            public ListVmClustersRequest.Builder get() {
                return ListVmClustersRequest.builder().copy(request);
            }
        }, new Function<ListVmClustersResponse, String>(){

            public String apply(ListVmClustersResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListVmClustersRequest.Builder>, ListVmClustersRequest>(){

            public ListVmClustersRequest apply(RequestBuilderAndToken<ListVmClustersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListVmClustersRequest, ListVmClustersResponse>(){

            public ListVmClustersResponse apply(ListVmClustersRequest request) {
                return DatabasePaginators.this.client.listVmClusters(request);
            }
        });
    }

    public Iterable<VmClusterSummary> listVmClustersRecordIterator(final ListVmClustersRequest request) {
        return new ResponseRecordIterable<ListVmClustersRequest.Builder, ListVmClustersRequest, ListVmClustersResponse, VmClusterSummary>(new Supplier<ListVmClustersRequest.Builder>(){

            public ListVmClustersRequest.Builder get() {
                return ListVmClustersRequest.builder().copy(request);
            }
        }, new Function<ListVmClustersResponse, String>(){

            public String apply(ListVmClustersResponse response) {
                return response.getOpcNextPage();
            }
        }, new Function<RequestBuilderAndToken<ListVmClustersRequest.Builder>, ListVmClustersRequest>(){

            public ListVmClustersRequest apply(RequestBuilderAndToken<ListVmClustersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return input.getRequestBuilder().build();
                }
                return input.getRequestBuilder().page((String)input.getToken().orNull()).build();
            }
        }, new Function<ListVmClustersRequest, ListVmClustersResponse>(){

            public ListVmClustersResponse apply(ListVmClustersRequest request) {
                return DatabasePaginators.this.client.listVmClusters(request);
            }
        }, new Function<ListVmClustersResponse, List<VmClusterSummary>>(){

            public List<VmClusterSummary> apply(ListVmClustersResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public DatabasePaginators(Database client) {
        this.client = client;
    }
}

