/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.database.Database;
import com.oracle.bmc.database.model.AutonomousContainerDatabase;
import com.oracle.bmc.database.model.AutonomousDataWarehouse;
import com.oracle.bmc.database.model.AutonomousDataWarehouseBackup;
import com.oracle.bmc.database.model.AutonomousDatabase;
import com.oracle.bmc.database.model.AutonomousDatabaseBackup;
import com.oracle.bmc.database.model.AutonomousExadataInfrastructure;
import com.oracle.bmc.database.model.Backup;
import com.oracle.bmc.database.model.BackupDestination;
import com.oracle.bmc.database.model.DataGuardAssociation;
import com.oracle.bmc.database.model.Database;
import com.oracle.bmc.database.model.DbHome;
import com.oracle.bmc.database.model.DbNode;
import com.oracle.bmc.database.model.DbSystem;
import com.oracle.bmc.database.model.ExadataInfrastructure;
import com.oracle.bmc.database.model.ExadataIormConfig;
import com.oracle.bmc.database.model.MaintenanceRun;
import com.oracle.bmc.database.model.VmCluster;
import com.oracle.bmc.database.model.VmClusterNetwork;
import com.oracle.bmc.database.requests.ChangeAutonomousContainerDatabaseCompartmentRequest;
import com.oracle.bmc.database.requests.ChangeAutonomousDatabaseCompartmentRequest;
import com.oracle.bmc.database.requests.ChangeAutonomousExadataInfrastructureCompartmentRequest;
import com.oracle.bmc.database.requests.ChangeBackupDestinationCompartmentRequest;
import com.oracle.bmc.database.requests.ChangeDbSystemCompartmentRequest;
import com.oracle.bmc.database.requests.ChangeExadataInfrastructureCompartmentRequest;
import com.oracle.bmc.database.requests.ChangeVmClusterCompartmentRequest;
import com.oracle.bmc.database.requests.CreateAutonomousContainerDatabaseRequest;
import com.oracle.bmc.database.requests.CreateAutonomousDatabaseBackupRequest;
import com.oracle.bmc.database.requests.CreateAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.DeleteAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.GetAutonomousContainerDatabaseRequest;
import com.oracle.bmc.database.requests.GetAutonomousDataWarehouseBackupRequest;
import com.oracle.bmc.database.requests.GetAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.requests.GetAutonomousDatabaseBackupRequest;
import com.oracle.bmc.database.requests.GetAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.GetAutonomousExadataInfrastructureRequest;
import com.oracle.bmc.database.requests.GetBackupDestinationRequest;
import com.oracle.bmc.database.requests.GetBackupRequest;
import com.oracle.bmc.database.requests.GetDataGuardAssociationRequest;
import com.oracle.bmc.database.requests.GetDatabaseRequest;
import com.oracle.bmc.database.requests.GetDbHomeRequest;
import com.oracle.bmc.database.requests.GetDbNodeRequest;
import com.oracle.bmc.database.requests.GetDbSystemRequest;
import com.oracle.bmc.database.requests.GetExadataInfrastructureRequest;
import com.oracle.bmc.database.requests.GetExadataIormConfigRequest;
import com.oracle.bmc.database.requests.GetMaintenanceRunRequest;
import com.oracle.bmc.database.requests.GetVmClusterNetworkRequest;
import com.oracle.bmc.database.requests.GetVmClusterRequest;
import com.oracle.bmc.database.requests.LaunchAutonomousExadataInfrastructureRequest;
import com.oracle.bmc.database.requests.RestartAutonomousContainerDatabaseRequest;
import com.oracle.bmc.database.requests.RestoreAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.StartAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.StopAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.TerminateAutonomousContainerDatabaseRequest;
import com.oracle.bmc.database.requests.TerminateAutonomousExadataInfrastructureRequest;
import com.oracle.bmc.database.requests.UpdateAutonomousContainerDatabaseRequest;
import com.oracle.bmc.database.requests.UpdateAutonomousDatabaseRequest;
import com.oracle.bmc.database.requests.UpdateAutonomousExadataInfrastructureRequest;
import com.oracle.bmc.database.responses.ChangeAutonomousContainerDatabaseCompartmentResponse;
import com.oracle.bmc.database.responses.ChangeAutonomousDatabaseCompartmentResponse;
import com.oracle.bmc.database.responses.ChangeAutonomousExadataInfrastructureCompartmentResponse;
import com.oracle.bmc.database.responses.ChangeBackupDestinationCompartmentResponse;
import com.oracle.bmc.database.responses.ChangeDbSystemCompartmentResponse;
import com.oracle.bmc.database.responses.ChangeExadataInfrastructureCompartmentResponse;
import com.oracle.bmc.database.responses.ChangeVmClusterCompartmentResponse;
import com.oracle.bmc.database.responses.CreateAutonomousContainerDatabaseResponse;
import com.oracle.bmc.database.responses.CreateAutonomousDatabaseBackupResponse;
import com.oracle.bmc.database.responses.CreateAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.DeleteAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.GetAutonomousContainerDatabaseResponse;
import com.oracle.bmc.database.responses.GetAutonomousDataWarehouseBackupResponse;
import com.oracle.bmc.database.responses.GetAutonomousDataWarehouseResponse;
import com.oracle.bmc.database.responses.GetAutonomousDatabaseBackupResponse;
import com.oracle.bmc.database.responses.GetAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.GetAutonomousExadataInfrastructureResponse;
import com.oracle.bmc.database.responses.GetBackupDestinationResponse;
import com.oracle.bmc.database.responses.GetBackupResponse;
import com.oracle.bmc.database.responses.GetDataGuardAssociationResponse;
import com.oracle.bmc.database.responses.GetDatabaseResponse;
import com.oracle.bmc.database.responses.GetDbHomeResponse;
import com.oracle.bmc.database.responses.GetDbNodeResponse;
import com.oracle.bmc.database.responses.GetDbSystemResponse;
import com.oracle.bmc.database.responses.GetExadataInfrastructureResponse;
import com.oracle.bmc.database.responses.GetExadataIormConfigResponse;
import com.oracle.bmc.database.responses.GetMaintenanceRunResponse;
import com.oracle.bmc.database.responses.GetVmClusterNetworkResponse;
import com.oracle.bmc.database.responses.GetVmClusterResponse;
import com.oracle.bmc.database.responses.LaunchAutonomousExadataInfrastructureResponse;
import com.oracle.bmc.database.responses.RestartAutonomousContainerDatabaseResponse;
import com.oracle.bmc.database.responses.RestoreAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.StartAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.StopAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.TerminateAutonomousContainerDatabaseResponse;
import com.oracle.bmc.database.responses.TerminateAutonomousExadataInfrastructureResponse;
import com.oracle.bmc.database.responses.UpdateAutonomousContainerDatabaseResponse;
import com.oracle.bmc.database.responses.UpdateAutonomousDatabaseResponse;
import com.oracle.bmc.database.responses.UpdateAutonomousExadataInfrastructureResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import com.oracle.bmc.workrequests.WorkRequest;
import com.oracle.bmc.workrequests.requests.GetWorkRequestRequest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import lombok.NonNull;
import org.apache.commons.lang3.Validate;

public class DatabaseWaiters {
    @NonNull
    private final ExecutorService executorService;
    @NonNull
    private final Database client;
    private final WorkRequest workRequestClient;

    @Deprecated
    public DatabaseWaiters(@NonNull ExecutorService executorService, @NonNull Database client) {
        this(executorService, client, null);
        if (executorService == null) {
            throw new NullPointerException("executorService is marked @NonNull but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked @NonNull but is null");
        }
    }

    public DatabaseWaiters(@NonNull ExecutorService executorService, @NonNull Database client, WorkRequest workRequestClient) {
        if (executorService == null) {
            throw new NullPointerException("executorService is marked @NonNull but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked @NonNull but is null");
        }
        this.executorService = executorService;
        this.client = client;
        this.workRequestClient = workRequestClient;
    }

    public Waiter<ChangeAutonomousContainerDatabaseCompartmentRequest, ChangeAutonomousContainerDatabaseCompartmentResponse> forChangeAutonomousContainerDatabaseCompartment(ChangeAutonomousContainerDatabaseCompartmentRequest request) {
        return this.forChangeAutonomousContainerDatabaseCompartment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ChangeAutonomousContainerDatabaseCompartmentRequest, ChangeAutonomousContainerDatabaseCompartmentResponse> forChangeAutonomousContainerDatabaseCompartment(final ChangeAutonomousContainerDatabaseCompartmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<ChangeAutonomousContainerDatabaseCompartmentRequest, ChangeAutonomousContainerDatabaseCompartmentResponse>(this.executorService, new Callable<ChangeAutonomousContainerDatabaseCompartmentResponse>(){

            @Override
            public ChangeAutonomousContainerDatabaseCompartmentResponse call() throws Exception {
                ChangeAutonomousContainerDatabaseCompartmentResponse response = DatabaseWaiters.this.client.changeAutonomousContainerDatabaseCompartment(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                DatabaseWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<ChangeAutonomousDatabaseCompartmentRequest, ChangeAutonomousDatabaseCompartmentResponse> forChangeAutonomousDatabaseCompartment(ChangeAutonomousDatabaseCompartmentRequest request) {
        return this.forChangeAutonomousDatabaseCompartment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ChangeAutonomousDatabaseCompartmentRequest, ChangeAutonomousDatabaseCompartmentResponse> forChangeAutonomousDatabaseCompartment(final ChangeAutonomousDatabaseCompartmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<ChangeAutonomousDatabaseCompartmentRequest, ChangeAutonomousDatabaseCompartmentResponse>(this.executorService, new Callable<ChangeAutonomousDatabaseCompartmentResponse>(){

            @Override
            public ChangeAutonomousDatabaseCompartmentResponse call() throws Exception {
                ChangeAutonomousDatabaseCompartmentResponse response = DatabaseWaiters.this.client.changeAutonomousDatabaseCompartment(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                DatabaseWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<ChangeAutonomousExadataInfrastructureCompartmentRequest, ChangeAutonomousExadataInfrastructureCompartmentResponse> forChangeAutonomousExadataInfrastructureCompartment(ChangeAutonomousExadataInfrastructureCompartmentRequest request) {
        return this.forChangeAutonomousExadataInfrastructureCompartment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ChangeAutonomousExadataInfrastructureCompartmentRequest, ChangeAutonomousExadataInfrastructureCompartmentResponse> forChangeAutonomousExadataInfrastructureCompartment(final ChangeAutonomousExadataInfrastructureCompartmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<ChangeAutonomousExadataInfrastructureCompartmentRequest, ChangeAutonomousExadataInfrastructureCompartmentResponse>(this.executorService, new Callable<ChangeAutonomousExadataInfrastructureCompartmentResponse>(){

            @Override
            public ChangeAutonomousExadataInfrastructureCompartmentResponse call() throws Exception {
                ChangeAutonomousExadataInfrastructureCompartmentResponse response = DatabaseWaiters.this.client.changeAutonomousExadataInfrastructureCompartment(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                DatabaseWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<ChangeBackupDestinationCompartmentRequest, ChangeBackupDestinationCompartmentResponse> forChangeBackupDestinationCompartment(ChangeBackupDestinationCompartmentRequest request) {
        return this.forChangeBackupDestinationCompartment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ChangeBackupDestinationCompartmentRequest, ChangeBackupDestinationCompartmentResponse> forChangeBackupDestinationCompartment(final ChangeBackupDestinationCompartmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<ChangeBackupDestinationCompartmentRequest, ChangeBackupDestinationCompartmentResponse>(this.executorService, new Callable<ChangeBackupDestinationCompartmentResponse>(){

            @Override
            public ChangeBackupDestinationCompartmentResponse call() throws Exception {
                ChangeBackupDestinationCompartmentResponse response = DatabaseWaiters.this.client.changeBackupDestinationCompartment(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                DatabaseWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<ChangeDbSystemCompartmentRequest, ChangeDbSystemCompartmentResponse> forChangeDbSystemCompartment(ChangeDbSystemCompartmentRequest request) {
        return this.forChangeDbSystemCompartment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ChangeDbSystemCompartmentRequest, ChangeDbSystemCompartmentResponse> forChangeDbSystemCompartment(final ChangeDbSystemCompartmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<ChangeDbSystemCompartmentRequest, ChangeDbSystemCompartmentResponse>(this.executorService, new Callable<ChangeDbSystemCompartmentResponse>(){

            @Override
            public ChangeDbSystemCompartmentResponse call() throws Exception {
                ChangeDbSystemCompartmentResponse response = DatabaseWaiters.this.client.changeDbSystemCompartment(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                DatabaseWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<ChangeExadataInfrastructureCompartmentRequest, ChangeExadataInfrastructureCompartmentResponse> forChangeExadataInfrastructureCompartment(ChangeExadataInfrastructureCompartmentRequest request) {
        return this.forChangeExadataInfrastructureCompartment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ChangeExadataInfrastructureCompartmentRequest, ChangeExadataInfrastructureCompartmentResponse> forChangeExadataInfrastructureCompartment(final ChangeExadataInfrastructureCompartmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<ChangeExadataInfrastructureCompartmentRequest, ChangeExadataInfrastructureCompartmentResponse>(this.executorService, new Callable<ChangeExadataInfrastructureCompartmentResponse>(){

            @Override
            public ChangeExadataInfrastructureCompartmentResponse call() throws Exception {
                ChangeExadataInfrastructureCompartmentResponse response = DatabaseWaiters.this.client.changeExadataInfrastructureCompartment(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                DatabaseWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<ChangeVmClusterCompartmentRequest, ChangeVmClusterCompartmentResponse> forChangeVmClusterCompartment(ChangeVmClusterCompartmentRequest request) {
        return this.forChangeVmClusterCompartment(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<ChangeVmClusterCompartmentRequest, ChangeVmClusterCompartmentResponse> forChangeVmClusterCompartment(final ChangeVmClusterCompartmentRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<ChangeVmClusterCompartmentRequest, ChangeVmClusterCompartmentResponse>(this.executorService, new Callable<ChangeVmClusterCompartmentResponse>(){

            @Override
            public ChangeVmClusterCompartmentResponse call() throws Exception {
                ChangeVmClusterCompartmentResponse response = DatabaseWaiters.this.client.changeVmClusterCompartment(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                DatabaseWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<CreateAutonomousContainerDatabaseRequest, CreateAutonomousContainerDatabaseResponse> forCreateAutonomousContainerDatabase(CreateAutonomousContainerDatabaseRequest request) {
        return this.forCreateAutonomousContainerDatabase(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<CreateAutonomousContainerDatabaseRequest, CreateAutonomousContainerDatabaseResponse> forCreateAutonomousContainerDatabase(final CreateAutonomousContainerDatabaseRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<CreateAutonomousContainerDatabaseRequest, CreateAutonomousContainerDatabaseResponse>(this.executorService, new Callable<CreateAutonomousContainerDatabaseResponse>(){

            @Override
            public CreateAutonomousContainerDatabaseResponse call() throws Exception {
                CreateAutonomousContainerDatabaseResponse response = DatabaseWaiters.this.client.createAutonomousContainerDatabase(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                DatabaseWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<CreateAutonomousDatabaseRequest, CreateAutonomousDatabaseResponse> forCreateAutonomousDatabase(CreateAutonomousDatabaseRequest request) {
        return this.forCreateAutonomousDatabase(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<CreateAutonomousDatabaseRequest, CreateAutonomousDatabaseResponse> forCreateAutonomousDatabase(final CreateAutonomousDatabaseRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<CreateAutonomousDatabaseRequest, CreateAutonomousDatabaseResponse>(this.executorService, new Callable<CreateAutonomousDatabaseResponse>(){

            @Override
            public CreateAutonomousDatabaseResponse call() throws Exception {
                CreateAutonomousDatabaseResponse response = DatabaseWaiters.this.client.createAutonomousDatabase(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                DatabaseWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<CreateAutonomousDatabaseBackupRequest, CreateAutonomousDatabaseBackupResponse> forCreateAutonomousDatabaseBackup(CreateAutonomousDatabaseBackupRequest request) {
        return this.forCreateAutonomousDatabaseBackup(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<CreateAutonomousDatabaseBackupRequest, CreateAutonomousDatabaseBackupResponse> forCreateAutonomousDatabaseBackup(final CreateAutonomousDatabaseBackupRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<CreateAutonomousDatabaseBackupRequest, CreateAutonomousDatabaseBackupResponse>(this.executorService, new Callable<CreateAutonomousDatabaseBackupResponse>(){

            @Override
            public CreateAutonomousDatabaseBackupResponse call() throws Exception {
                CreateAutonomousDatabaseBackupResponse response = DatabaseWaiters.this.client.createAutonomousDatabaseBackup(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                DatabaseWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<DeleteAutonomousDatabaseRequest, DeleteAutonomousDatabaseResponse> forDeleteAutonomousDatabase(DeleteAutonomousDatabaseRequest request) {
        return this.forDeleteAutonomousDatabase(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<DeleteAutonomousDatabaseRequest, DeleteAutonomousDatabaseResponse> forDeleteAutonomousDatabase(final DeleteAutonomousDatabaseRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<DeleteAutonomousDatabaseRequest, DeleteAutonomousDatabaseResponse>(this.executorService, new Callable<DeleteAutonomousDatabaseResponse>(){

            @Override
            public DeleteAutonomousDatabaseResponse call() throws Exception {
                DeleteAutonomousDatabaseResponse response = DatabaseWaiters.this.client.deleteAutonomousDatabase(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                DatabaseWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<GetAutonomousContainerDatabaseRequest, GetAutonomousContainerDatabaseResponse> forAutonomousContainerDatabase(GetAutonomousContainerDatabaseRequest request, AutonomousContainerDatabase.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAutonomousContainerDatabase(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAutonomousContainerDatabaseRequest, GetAutonomousContainerDatabaseResponse> forAutonomousContainerDatabase(GetAutonomousContainerDatabaseRequest request, AutonomousContainerDatabase.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAutonomousContainerDatabase(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetAutonomousContainerDatabaseRequest, GetAutonomousContainerDatabaseResponse> forAutonomousContainerDatabase(GetAutonomousContainerDatabaseRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AutonomousContainerDatabase.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAutonomousContainerDatabase(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetAutonomousContainerDatabaseRequest, GetAutonomousContainerDatabaseResponse> forAutonomousContainerDatabase(BmcGenericWaiter waiter, GetAutonomousContainerDatabaseRequest request, AutonomousContainerDatabase.LifecycleState ... targetStates) {
        final HashSet<AutonomousContainerDatabase.LifecycleState> targetStatesSet = new HashSet<AutonomousContainerDatabase.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetAutonomousContainerDatabaseRequest, GetAutonomousContainerDatabaseResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetAutonomousContainerDatabaseRequest, GetAutonomousContainerDatabaseResponse>(){

            public GetAutonomousContainerDatabaseResponse apply(GetAutonomousContainerDatabaseRequest request) {
                return DatabaseWaiters.this.client.getAutonomousContainerDatabase(request);
            }
        }, new Predicate<GetAutonomousContainerDatabaseResponse>(){

            public boolean apply(GetAutonomousContainerDatabaseResponse response) {
                return targetStatesSet.contains((Object)response.getAutonomousContainerDatabase().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AutonomousContainerDatabase.LifecycleState.Terminated)), request);
    }

    public Waiter<GetAutonomousDataWarehouseRequest, GetAutonomousDataWarehouseResponse> forAutonomousDataWarehouse(GetAutonomousDataWarehouseRequest request, AutonomousDataWarehouse.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAutonomousDataWarehouse(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAutonomousDataWarehouseRequest, GetAutonomousDataWarehouseResponse> forAutonomousDataWarehouse(GetAutonomousDataWarehouseRequest request, AutonomousDataWarehouse.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAutonomousDataWarehouse(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetAutonomousDataWarehouseRequest, GetAutonomousDataWarehouseResponse> forAutonomousDataWarehouse(GetAutonomousDataWarehouseRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AutonomousDataWarehouse.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAutonomousDataWarehouse(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetAutonomousDataWarehouseRequest, GetAutonomousDataWarehouseResponse> forAutonomousDataWarehouse(BmcGenericWaiter waiter, GetAutonomousDataWarehouseRequest request, AutonomousDataWarehouse.LifecycleState ... targetStates) {
        final HashSet<AutonomousDataWarehouse.LifecycleState> targetStatesSet = new HashSet<AutonomousDataWarehouse.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetAutonomousDataWarehouseRequest, GetAutonomousDataWarehouseResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetAutonomousDataWarehouseRequest, GetAutonomousDataWarehouseResponse>(){

            public GetAutonomousDataWarehouseResponse apply(GetAutonomousDataWarehouseRequest request) {
                return DatabaseWaiters.this.client.getAutonomousDataWarehouse(request);
            }
        }, new Predicate<GetAutonomousDataWarehouseResponse>(){

            public boolean apply(GetAutonomousDataWarehouseResponse response) {
                return targetStatesSet.contains((Object)response.getAutonomousDataWarehouse().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AutonomousDataWarehouse.LifecycleState.Terminated)), request);
    }

    public Waiter<GetAutonomousDataWarehouseBackupRequest, GetAutonomousDataWarehouseBackupResponse> forAutonomousDataWarehouseBackup(GetAutonomousDataWarehouseBackupRequest request, AutonomousDataWarehouseBackup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAutonomousDataWarehouseBackup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAutonomousDataWarehouseBackupRequest, GetAutonomousDataWarehouseBackupResponse> forAutonomousDataWarehouseBackup(GetAutonomousDataWarehouseBackupRequest request, AutonomousDataWarehouseBackup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAutonomousDataWarehouseBackup(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetAutonomousDataWarehouseBackupRequest, GetAutonomousDataWarehouseBackupResponse> forAutonomousDataWarehouseBackup(GetAutonomousDataWarehouseBackupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AutonomousDataWarehouseBackup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAutonomousDataWarehouseBackup(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetAutonomousDataWarehouseBackupRequest, GetAutonomousDataWarehouseBackupResponse> forAutonomousDataWarehouseBackup(BmcGenericWaiter waiter, GetAutonomousDataWarehouseBackupRequest request, AutonomousDataWarehouseBackup.LifecycleState ... targetStates) {
        final HashSet<AutonomousDataWarehouseBackup.LifecycleState> targetStatesSet = new HashSet<AutonomousDataWarehouseBackup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetAutonomousDataWarehouseBackupRequest, GetAutonomousDataWarehouseBackupResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetAutonomousDataWarehouseBackupRequest, GetAutonomousDataWarehouseBackupResponse>(){

            public GetAutonomousDataWarehouseBackupResponse apply(GetAutonomousDataWarehouseBackupRequest request) {
                return DatabaseWaiters.this.client.getAutonomousDataWarehouseBackup(request);
            }
        }, new Predicate<GetAutonomousDataWarehouseBackupResponse>(){

            public boolean apply(GetAutonomousDataWarehouseBackupResponse response) {
                return targetStatesSet.contains((Object)response.getAutonomousDataWarehouseBackup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AutonomousDataWarehouseBackup.LifecycleState.Deleted)), request);
    }

    public Waiter<GetAutonomousDatabaseRequest, GetAutonomousDatabaseResponse> forAutonomousDatabase(GetAutonomousDatabaseRequest request, AutonomousDatabase.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAutonomousDatabase(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAutonomousDatabaseRequest, GetAutonomousDatabaseResponse> forAutonomousDatabase(GetAutonomousDatabaseRequest request, AutonomousDatabase.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAutonomousDatabase(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetAutonomousDatabaseRequest, GetAutonomousDatabaseResponse> forAutonomousDatabase(GetAutonomousDatabaseRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AutonomousDatabase.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAutonomousDatabase(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetAutonomousDatabaseRequest, GetAutonomousDatabaseResponse> forAutonomousDatabase(BmcGenericWaiter waiter, GetAutonomousDatabaseRequest request, AutonomousDatabase.LifecycleState ... targetStates) {
        final HashSet<AutonomousDatabase.LifecycleState> targetStatesSet = new HashSet<AutonomousDatabase.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetAutonomousDatabaseRequest, GetAutonomousDatabaseResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetAutonomousDatabaseRequest, GetAutonomousDatabaseResponse>(){

            public GetAutonomousDatabaseResponse apply(GetAutonomousDatabaseRequest request) {
                return DatabaseWaiters.this.client.getAutonomousDatabase(request);
            }
        }, new Predicate<GetAutonomousDatabaseResponse>(){

            public boolean apply(GetAutonomousDatabaseResponse response) {
                return targetStatesSet.contains((Object)response.getAutonomousDatabase().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AutonomousDatabase.LifecycleState.Terminated)), request);
    }

    public Waiter<GetAutonomousDatabaseBackupRequest, GetAutonomousDatabaseBackupResponse> forAutonomousDatabaseBackup(GetAutonomousDatabaseBackupRequest request, AutonomousDatabaseBackup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAutonomousDatabaseBackup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAutonomousDatabaseBackupRequest, GetAutonomousDatabaseBackupResponse> forAutonomousDatabaseBackup(GetAutonomousDatabaseBackupRequest request, AutonomousDatabaseBackup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAutonomousDatabaseBackup(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetAutonomousDatabaseBackupRequest, GetAutonomousDatabaseBackupResponse> forAutonomousDatabaseBackup(GetAutonomousDatabaseBackupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AutonomousDatabaseBackup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAutonomousDatabaseBackup(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetAutonomousDatabaseBackupRequest, GetAutonomousDatabaseBackupResponse> forAutonomousDatabaseBackup(BmcGenericWaiter waiter, GetAutonomousDatabaseBackupRequest request, AutonomousDatabaseBackup.LifecycleState ... targetStates) {
        final HashSet<AutonomousDatabaseBackup.LifecycleState> targetStatesSet = new HashSet<AutonomousDatabaseBackup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetAutonomousDatabaseBackupRequest, GetAutonomousDatabaseBackupResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetAutonomousDatabaseBackupRequest, GetAutonomousDatabaseBackupResponse>(){

            public GetAutonomousDatabaseBackupResponse apply(GetAutonomousDatabaseBackupRequest request) {
                return DatabaseWaiters.this.client.getAutonomousDatabaseBackup(request);
            }
        }, new Predicate<GetAutonomousDatabaseBackupResponse>(){

            public boolean apply(GetAutonomousDatabaseBackupResponse response) {
                return targetStatesSet.contains((Object)response.getAutonomousDatabaseBackup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AutonomousDatabaseBackup.LifecycleState.Deleted)), request);
    }

    public Waiter<GetAutonomousExadataInfrastructureRequest, GetAutonomousExadataInfrastructureResponse> forAutonomousExadataInfrastructure(GetAutonomousExadataInfrastructureRequest request, AutonomousExadataInfrastructure.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAutonomousExadataInfrastructure(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAutonomousExadataInfrastructureRequest, GetAutonomousExadataInfrastructureResponse> forAutonomousExadataInfrastructure(GetAutonomousExadataInfrastructureRequest request, AutonomousExadataInfrastructure.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAutonomousExadataInfrastructure(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetAutonomousExadataInfrastructureRequest, GetAutonomousExadataInfrastructureResponse> forAutonomousExadataInfrastructure(GetAutonomousExadataInfrastructureRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AutonomousExadataInfrastructure.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAutonomousExadataInfrastructure(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetAutonomousExadataInfrastructureRequest, GetAutonomousExadataInfrastructureResponse> forAutonomousExadataInfrastructure(BmcGenericWaiter waiter, GetAutonomousExadataInfrastructureRequest request, AutonomousExadataInfrastructure.LifecycleState ... targetStates) {
        final HashSet<AutonomousExadataInfrastructure.LifecycleState> targetStatesSet = new HashSet<AutonomousExadataInfrastructure.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetAutonomousExadataInfrastructureRequest, GetAutonomousExadataInfrastructureResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetAutonomousExadataInfrastructureRequest, GetAutonomousExadataInfrastructureResponse>(){

            public GetAutonomousExadataInfrastructureResponse apply(GetAutonomousExadataInfrastructureRequest request) {
                return DatabaseWaiters.this.client.getAutonomousExadataInfrastructure(request);
            }
        }, new Predicate<GetAutonomousExadataInfrastructureResponse>(){

            public boolean apply(GetAutonomousExadataInfrastructureResponse response) {
                return targetStatesSet.contains((Object)response.getAutonomousExadataInfrastructure().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AutonomousExadataInfrastructure.LifecycleState.Terminated)), request);
    }

    public Waiter<GetBackupRequest, GetBackupResponse> forBackup(GetBackupRequest request, Backup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBackup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBackupRequest, GetBackupResponse> forBackup(GetBackupRequest request, Backup.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBackup(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetBackupRequest, GetBackupResponse> forBackup(GetBackupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Backup.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forBackup(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetBackupRequest, GetBackupResponse> forBackup(BmcGenericWaiter waiter, GetBackupRequest request, Backup.LifecycleState ... targetStates) {
        final HashSet<Backup.LifecycleState> targetStatesSet = new HashSet<Backup.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetBackupRequest, GetBackupResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetBackupRequest, GetBackupResponse>(){

            public GetBackupResponse apply(GetBackupRequest request) {
                return DatabaseWaiters.this.client.getBackup(request);
            }
        }, new Predicate<GetBackupResponse>(){

            public boolean apply(GetBackupResponse response) {
                return targetStatesSet.contains((Object)response.getBackup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Backup.LifecycleState.Deleted)), request);
    }

    public Waiter<GetBackupDestinationRequest, GetBackupDestinationResponse> forBackupDestination(GetBackupDestinationRequest request, BackupDestination.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBackupDestination(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBackupDestinationRequest, GetBackupDestinationResponse> forBackupDestination(GetBackupDestinationRequest request, BackupDestination.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBackupDestination(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetBackupDestinationRequest, GetBackupDestinationResponse> forBackupDestination(GetBackupDestinationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, BackupDestination.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forBackupDestination(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetBackupDestinationRequest, GetBackupDestinationResponse> forBackupDestination(BmcGenericWaiter waiter, GetBackupDestinationRequest request, BackupDestination.LifecycleState ... targetStates) {
        final HashSet<BackupDestination.LifecycleState> targetStatesSet = new HashSet<BackupDestination.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetBackupDestinationRequest, GetBackupDestinationResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetBackupDestinationRequest, GetBackupDestinationResponse>(){

            public GetBackupDestinationResponse apply(GetBackupDestinationRequest request) {
                return DatabaseWaiters.this.client.getBackupDestination(request);
            }
        }, new Predicate<GetBackupDestinationResponse>(){

            public boolean apply(GetBackupDestinationResponse response) {
                return targetStatesSet.contains((Object)response.getBackupDestination().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)BackupDestination.LifecycleState.Deleted)), request);
    }

    public Waiter<GetDataGuardAssociationRequest, GetDataGuardAssociationResponse> forDataGuardAssociation(GetDataGuardAssociationRequest request, DataGuardAssociation.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDataGuardAssociation(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDataGuardAssociationRequest, GetDataGuardAssociationResponse> forDataGuardAssociation(GetDataGuardAssociationRequest request, DataGuardAssociation.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDataGuardAssociation(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetDataGuardAssociationRequest, GetDataGuardAssociationResponse> forDataGuardAssociation(GetDataGuardAssociationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DataGuardAssociation.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDataGuardAssociation(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetDataGuardAssociationRequest, GetDataGuardAssociationResponse> forDataGuardAssociation(BmcGenericWaiter waiter, GetDataGuardAssociationRequest request, DataGuardAssociation.LifecycleState ... targetStates) {
        final HashSet<DataGuardAssociation.LifecycleState> targetStatesSet = new HashSet<DataGuardAssociation.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetDataGuardAssociationRequest, GetDataGuardAssociationResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetDataGuardAssociationRequest, GetDataGuardAssociationResponse>(){

            public GetDataGuardAssociationResponse apply(GetDataGuardAssociationRequest request) {
                return DatabaseWaiters.this.client.getDataGuardAssociation(request);
            }
        }, new Predicate<GetDataGuardAssociationResponse>(){

            public boolean apply(GetDataGuardAssociationResponse response) {
                return targetStatesSet.contains((Object)response.getDataGuardAssociation().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DataGuardAssociation.LifecycleState.Terminated)), request);
    }

    public Waiter<GetDatabaseRequest, GetDatabaseResponse> forDatabase(GetDatabaseRequest request, Database.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDatabase(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDatabaseRequest, GetDatabaseResponse> forDatabase(GetDatabaseRequest request, Database.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDatabase(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetDatabaseRequest, GetDatabaseResponse> forDatabase(GetDatabaseRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Database.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDatabase(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetDatabaseRequest, GetDatabaseResponse> forDatabase(BmcGenericWaiter waiter, GetDatabaseRequest request, Database.LifecycleState ... targetStates) {
        final HashSet<Database.LifecycleState> targetStatesSet = new HashSet<Database.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetDatabaseRequest, GetDatabaseResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetDatabaseRequest, GetDatabaseResponse>(){

            public GetDatabaseResponse apply(GetDatabaseRequest request) {
                return DatabaseWaiters.this.client.getDatabase(request);
            }
        }, new Predicate<GetDatabaseResponse>(){

            public boolean apply(GetDatabaseResponse response) {
                return targetStatesSet.contains((Object)response.getDatabase().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Database.LifecycleState.Terminated)), request);
    }

    public Waiter<GetDbHomeRequest, GetDbHomeResponse> forDbHome(GetDbHomeRequest request, DbHome.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDbHome(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDbHomeRequest, GetDbHomeResponse> forDbHome(GetDbHomeRequest request, DbHome.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDbHome(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetDbHomeRequest, GetDbHomeResponse> forDbHome(GetDbHomeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DbHome.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDbHome(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetDbHomeRequest, GetDbHomeResponse> forDbHome(BmcGenericWaiter waiter, GetDbHomeRequest request, DbHome.LifecycleState ... targetStates) {
        final HashSet<DbHome.LifecycleState> targetStatesSet = new HashSet<DbHome.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetDbHomeRequest, GetDbHomeResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetDbHomeRequest, GetDbHomeResponse>(){

            public GetDbHomeResponse apply(GetDbHomeRequest request) {
                return DatabaseWaiters.this.client.getDbHome(request);
            }
        }, new Predicate<GetDbHomeResponse>(){

            public boolean apply(GetDbHomeResponse response) {
                return targetStatesSet.contains((Object)response.getDbHome().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DbHome.LifecycleState.Terminated)), request);
    }

    public Waiter<GetDbNodeRequest, GetDbNodeResponse> forDbNode(GetDbNodeRequest request, DbNode.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDbNode(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDbNodeRequest, GetDbNodeResponse> forDbNode(GetDbNodeRequest request, DbNode.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDbNode(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetDbNodeRequest, GetDbNodeResponse> forDbNode(GetDbNodeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DbNode.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDbNode(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetDbNodeRequest, GetDbNodeResponse> forDbNode(BmcGenericWaiter waiter, GetDbNodeRequest request, DbNode.LifecycleState ... targetStates) {
        final HashSet<DbNode.LifecycleState> targetStatesSet = new HashSet<DbNode.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetDbNodeRequest, GetDbNodeResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetDbNodeRequest, GetDbNodeResponse>(){

            public GetDbNodeResponse apply(GetDbNodeRequest request) {
                return DatabaseWaiters.this.client.getDbNode(request);
            }
        }, new Predicate<GetDbNodeResponse>(){

            public boolean apply(GetDbNodeResponse response) {
                return targetStatesSet.contains((Object)response.getDbNode().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DbNode.LifecycleState.Terminated)), request);
    }

    public Waiter<GetDbSystemRequest, GetDbSystemResponse> forDbSystem(GetDbSystemRequest request, DbSystem.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDbSystem(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDbSystemRequest, GetDbSystemResponse> forDbSystem(GetDbSystemRequest request, DbSystem.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDbSystem(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetDbSystemRequest, GetDbSystemResponse> forDbSystem(GetDbSystemRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DbSystem.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forDbSystem(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetDbSystemRequest, GetDbSystemResponse> forDbSystem(BmcGenericWaiter waiter, GetDbSystemRequest request, DbSystem.LifecycleState ... targetStates) {
        final HashSet<DbSystem.LifecycleState> targetStatesSet = new HashSet<DbSystem.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetDbSystemRequest, GetDbSystemResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetDbSystemRequest, GetDbSystemResponse>(){

            public GetDbSystemResponse apply(GetDbSystemRequest request) {
                return DatabaseWaiters.this.client.getDbSystem(request);
            }
        }, new Predicate<GetDbSystemResponse>(){

            public boolean apply(GetDbSystemResponse response) {
                return targetStatesSet.contains((Object)response.getDbSystem().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DbSystem.LifecycleState.Terminated)), request);
    }

    public Waiter<GetExadataInfrastructureRequest, GetExadataInfrastructureResponse> forExadataInfrastructure(GetExadataInfrastructureRequest request, ExadataInfrastructure.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forExadataInfrastructure(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetExadataInfrastructureRequest, GetExadataInfrastructureResponse> forExadataInfrastructure(GetExadataInfrastructureRequest request, ExadataInfrastructure.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forExadataInfrastructure(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetExadataInfrastructureRequest, GetExadataInfrastructureResponse> forExadataInfrastructure(GetExadataInfrastructureRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ExadataInfrastructure.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forExadataInfrastructure(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetExadataInfrastructureRequest, GetExadataInfrastructureResponse> forExadataInfrastructure(BmcGenericWaiter waiter, GetExadataInfrastructureRequest request, ExadataInfrastructure.LifecycleState ... targetStates) {
        final HashSet<ExadataInfrastructure.LifecycleState> targetStatesSet = new HashSet<ExadataInfrastructure.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetExadataInfrastructureRequest, GetExadataInfrastructureResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetExadataInfrastructureRequest, GetExadataInfrastructureResponse>(){

            public GetExadataInfrastructureResponse apply(GetExadataInfrastructureRequest request) {
                return DatabaseWaiters.this.client.getExadataInfrastructure(request);
            }
        }, new Predicate<GetExadataInfrastructureResponse>(){

            public boolean apply(GetExadataInfrastructureResponse response) {
                return targetStatesSet.contains((Object)response.getExadataInfrastructure().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ExadataInfrastructure.LifecycleState.Deleted)), request);
    }

    public Waiter<GetExadataIormConfigRequest, GetExadataIormConfigResponse> forExadataIormConfig(GetExadataIormConfigRequest request, ExadataIormConfig.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forExadataIormConfig(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetExadataIormConfigRequest, GetExadataIormConfigResponse> forExadataIormConfig(GetExadataIormConfigRequest request, ExadataIormConfig.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forExadataIormConfig(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetExadataIormConfigRequest, GetExadataIormConfigResponse> forExadataIormConfig(GetExadataIormConfigRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ExadataIormConfig.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forExadataIormConfig(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetExadataIormConfigRequest, GetExadataIormConfigResponse> forExadataIormConfig(BmcGenericWaiter waiter, GetExadataIormConfigRequest request, ExadataIormConfig.LifecycleState ... targetStates) {
        final HashSet<ExadataIormConfig.LifecycleState> targetStatesSet = new HashSet<ExadataIormConfig.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetExadataIormConfigRequest, GetExadataIormConfigResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetExadataIormConfigRequest, GetExadataIormConfigResponse>(){

            public GetExadataIormConfigResponse apply(GetExadataIormConfigRequest request) {
                return DatabaseWaiters.this.client.getExadataIormConfig(request);
            }
        }, new Predicate<GetExadataIormConfigResponse>(){

            public boolean apply(GetExadataIormConfigResponse response) {
                return targetStatesSet.contains((Object)response.getExadataIormConfig().getLifecycleState());
            }
        }, false), request);
    }

    public Waiter<GetMaintenanceRunRequest, GetMaintenanceRunResponse> forMaintenanceRun(GetMaintenanceRunRequest request, MaintenanceRun.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forMaintenanceRun(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetMaintenanceRunRequest, GetMaintenanceRunResponse> forMaintenanceRun(GetMaintenanceRunRequest request, MaintenanceRun.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forMaintenanceRun(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetMaintenanceRunRequest, GetMaintenanceRunResponse> forMaintenanceRun(GetMaintenanceRunRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, MaintenanceRun.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forMaintenanceRun(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetMaintenanceRunRequest, GetMaintenanceRunResponse> forMaintenanceRun(BmcGenericWaiter waiter, GetMaintenanceRunRequest request, MaintenanceRun.LifecycleState ... targetStates) {
        final HashSet<MaintenanceRun.LifecycleState> targetStatesSet = new HashSet<MaintenanceRun.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetMaintenanceRunRequest, GetMaintenanceRunResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetMaintenanceRunRequest, GetMaintenanceRunResponse>(){

            public GetMaintenanceRunResponse apply(GetMaintenanceRunRequest request) {
                return DatabaseWaiters.this.client.getMaintenanceRun(request);
            }
        }, new Predicate<GetMaintenanceRunResponse>(){

            public boolean apply(GetMaintenanceRunResponse response) {
                return targetStatesSet.contains((Object)response.getMaintenanceRun().getLifecycleState());
            }
        }, false), request);
    }

    public Waiter<GetVmClusterRequest, GetVmClusterResponse> forVmCluster(GetVmClusterRequest request, VmCluster.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVmCluster(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVmClusterRequest, GetVmClusterResponse> forVmCluster(GetVmClusterRequest request, VmCluster.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVmCluster(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetVmClusterRequest, GetVmClusterResponse> forVmCluster(GetVmClusterRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, VmCluster.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVmCluster(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetVmClusterRequest, GetVmClusterResponse> forVmCluster(BmcGenericWaiter waiter, GetVmClusterRequest request, VmCluster.LifecycleState ... targetStates) {
        final HashSet<VmCluster.LifecycleState> targetStatesSet = new HashSet<VmCluster.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetVmClusterRequest, GetVmClusterResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetVmClusterRequest, GetVmClusterResponse>(){

            public GetVmClusterResponse apply(GetVmClusterRequest request) {
                return DatabaseWaiters.this.client.getVmCluster(request);
            }
        }, new Predicate<GetVmClusterResponse>(){

            public boolean apply(GetVmClusterResponse response) {
                return targetStatesSet.contains((Object)response.getVmCluster().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)VmCluster.LifecycleState.Terminated)), request);
    }

    public Waiter<GetVmClusterNetworkRequest, GetVmClusterNetworkResponse> forVmClusterNetwork(GetVmClusterNetworkRequest request, VmClusterNetwork.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forVmClusterNetwork(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetVmClusterNetworkRequest, GetVmClusterNetworkResponse> forVmClusterNetwork(GetVmClusterNetworkRequest request, VmClusterNetwork.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forVmClusterNetwork(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetState);
    }

    public Waiter<GetVmClusterNetworkRequest, GetVmClusterNetworkResponse> forVmClusterNetwork(GetVmClusterNetworkRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, VmClusterNetwork.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forVmClusterNetwork(Waiters.newWaiter(terminationStrategy, delayStrategy), request, targetStates);
    }

    private Waiter<GetVmClusterNetworkRequest, GetVmClusterNetworkResponse> forVmClusterNetwork(BmcGenericWaiter waiter, GetVmClusterNetworkRequest request, VmClusterNetwork.LifecycleState ... targetStates) {
        final HashSet<VmClusterNetwork.LifecycleState> targetStatesSet = new HashSet<VmClusterNetwork.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl<GetVmClusterNetworkRequest, GetVmClusterNetworkResponse>(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)request), new Function<GetVmClusterNetworkRequest, GetVmClusterNetworkResponse>(){

            public GetVmClusterNetworkResponse apply(GetVmClusterNetworkRequest request) {
                return DatabaseWaiters.this.client.getVmClusterNetwork(request);
            }
        }, new Predicate<GetVmClusterNetworkResponse>(){

            public boolean apply(GetVmClusterNetworkResponse response) {
                return targetStatesSet.contains((Object)response.getVmClusterNetwork().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)VmClusterNetwork.LifecycleState.Terminated)), request);
    }

    public Waiter<LaunchAutonomousExadataInfrastructureRequest, LaunchAutonomousExadataInfrastructureResponse> forLaunchAutonomousExadataInfrastructure(LaunchAutonomousExadataInfrastructureRequest request) {
        return this.forLaunchAutonomousExadataInfrastructure(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<LaunchAutonomousExadataInfrastructureRequest, LaunchAutonomousExadataInfrastructureResponse> forLaunchAutonomousExadataInfrastructure(final LaunchAutonomousExadataInfrastructureRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<LaunchAutonomousExadataInfrastructureRequest, LaunchAutonomousExadataInfrastructureResponse>(this.executorService, new Callable<LaunchAutonomousExadataInfrastructureResponse>(){

            @Override
            public LaunchAutonomousExadataInfrastructureResponse call() throws Exception {
                LaunchAutonomousExadataInfrastructureResponse response = DatabaseWaiters.this.client.launchAutonomousExadataInfrastructure(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                DatabaseWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<RestartAutonomousContainerDatabaseRequest, RestartAutonomousContainerDatabaseResponse> forRestartAutonomousContainerDatabase(RestartAutonomousContainerDatabaseRequest request) {
        return this.forRestartAutonomousContainerDatabase(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<RestartAutonomousContainerDatabaseRequest, RestartAutonomousContainerDatabaseResponse> forRestartAutonomousContainerDatabase(final RestartAutonomousContainerDatabaseRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<RestartAutonomousContainerDatabaseRequest, RestartAutonomousContainerDatabaseResponse>(this.executorService, new Callable<RestartAutonomousContainerDatabaseResponse>(){

            @Override
            public RestartAutonomousContainerDatabaseResponse call() throws Exception {
                RestartAutonomousContainerDatabaseResponse response = DatabaseWaiters.this.client.restartAutonomousContainerDatabase(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                DatabaseWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<RestoreAutonomousDatabaseRequest, RestoreAutonomousDatabaseResponse> forRestoreAutonomousDatabase(RestoreAutonomousDatabaseRequest request) {
        return this.forRestoreAutonomousDatabase(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<RestoreAutonomousDatabaseRequest, RestoreAutonomousDatabaseResponse> forRestoreAutonomousDatabase(final RestoreAutonomousDatabaseRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<RestoreAutonomousDatabaseRequest, RestoreAutonomousDatabaseResponse>(this.executorService, new Callable<RestoreAutonomousDatabaseResponse>(){

            @Override
            public RestoreAutonomousDatabaseResponse call() throws Exception {
                RestoreAutonomousDatabaseResponse response = DatabaseWaiters.this.client.restoreAutonomousDatabase(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                DatabaseWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<StartAutonomousDatabaseRequest, StartAutonomousDatabaseResponse> forStartAutonomousDatabase(StartAutonomousDatabaseRequest request) {
        return this.forStartAutonomousDatabase(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<StartAutonomousDatabaseRequest, StartAutonomousDatabaseResponse> forStartAutonomousDatabase(final StartAutonomousDatabaseRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<StartAutonomousDatabaseRequest, StartAutonomousDatabaseResponse>(this.executorService, new Callable<StartAutonomousDatabaseResponse>(){

            @Override
            public StartAutonomousDatabaseResponse call() throws Exception {
                StartAutonomousDatabaseResponse response = DatabaseWaiters.this.client.startAutonomousDatabase(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                DatabaseWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<StopAutonomousDatabaseRequest, StopAutonomousDatabaseResponse> forStopAutonomousDatabase(StopAutonomousDatabaseRequest request) {
        return this.forStopAutonomousDatabase(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<StopAutonomousDatabaseRequest, StopAutonomousDatabaseResponse> forStopAutonomousDatabase(final StopAutonomousDatabaseRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<StopAutonomousDatabaseRequest, StopAutonomousDatabaseResponse>(this.executorService, new Callable<StopAutonomousDatabaseResponse>(){

            @Override
            public StopAutonomousDatabaseResponse call() throws Exception {
                StopAutonomousDatabaseResponse response = DatabaseWaiters.this.client.stopAutonomousDatabase(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                DatabaseWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<TerminateAutonomousContainerDatabaseRequest, TerminateAutonomousContainerDatabaseResponse> forTerminateAutonomousContainerDatabase(TerminateAutonomousContainerDatabaseRequest request) {
        return this.forTerminateAutonomousContainerDatabase(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<TerminateAutonomousContainerDatabaseRequest, TerminateAutonomousContainerDatabaseResponse> forTerminateAutonomousContainerDatabase(final TerminateAutonomousContainerDatabaseRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<TerminateAutonomousContainerDatabaseRequest, TerminateAutonomousContainerDatabaseResponse>(this.executorService, new Callable<TerminateAutonomousContainerDatabaseResponse>(){

            @Override
            public TerminateAutonomousContainerDatabaseResponse call() throws Exception {
                TerminateAutonomousContainerDatabaseResponse response = DatabaseWaiters.this.client.terminateAutonomousContainerDatabase(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                DatabaseWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<TerminateAutonomousExadataInfrastructureRequest, TerminateAutonomousExadataInfrastructureResponse> forTerminateAutonomousExadataInfrastructure(TerminateAutonomousExadataInfrastructureRequest request) {
        return this.forTerminateAutonomousExadataInfrastructure(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<TerminateAutonomousExadataInfrastructureRequest, TerminateAutonomousExadataInfrastructureResponse> forTerminateAutonomousExadataInfrastructure(final TerminateAutonomousExadataInfrastructureRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<TerminateAutonomousExadataInfrastructureRequest, TerminateAutonomousExadataInfrastructureResponse>(this.executorService, new Callable<TerminateAutonomousExadataInfrastructureResponse>(){

            @Override
            public TerminateAutonomousExadataInfrastructureResponse call() throws Exception {
                TerminateAutonomousExadataInfrastructureResponse response = DatabaseWaiters.this.client.terminateAutonomousExadataInfrastructure(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                DatabaseWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<UpdateAutonomousContainerDatabaseRequest, UpdateAutonomousContainerDatabaseResponse> forUpdateAutonomousContainerDatabase(UpdateAutonomousContainerDatabaseRequest request) {
        return this.forUpdateAutonomousContainerDatabase(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<UpdateAutonomousContainerDatabaseRequest, UpdateAutonomousContainerDatabaseResponse> forUpdateAutonomousContainerDatabase(final UpdateAutonomousContainerDatabaseRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<UpdateAutonomousContainerDatabaseRequest, UpdateAutonomousContainerDatabaseResponse>(this.executorService, new Callable<UpdateAutonomousContainerDatabaseResponse>(){

            @Override
            public UpdateAutonomousContainerDatabaseResponse call() throws Exception {
                UpdateAutonomousContainerDatabaseResponse response = DatabaseWaiters.this.client.updateAutonomousContainerDatabase(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                DatabaseWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<UpdateAutonomousDatabaseRequest, UpdateAutonomousDatabaseResponse> forUpdateAutonomousDatabase(UpdateAutonomousDatabaseRequest request) {
        return this.forUpdateAutonomousDatabase(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<UpdateAutonomousDatabaseRequest, UpdateAutonomousDatabaseResponse> forUpdateAutonomousDatabase(final UpdateAutonomousDatabaseRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<UpdateAutonomousDatabaseRequest, UpdateAutonomousDatabaseResponse>(this.executorService, new Callable<UpdateAutonomousDatabaseResponse>(){

            @Override
            public UpdateAutonomousDatabaseResponse call() throws Exception {
                UpdateAutonomousDatabaseResponse response = DatabaseWaiters.this.client.updateAutonomousDatabase(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                DatabaseWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }

    public Waiter<UpdateAutonomousExadataInfrastructureRequest, UpdateAutonomousExadataInfrastructureResponse> forUpdateAutonomousExadataInfrastructure(UpdateAutonomousExadataInfrastructureRequest request) {
        return this.forUpdateAutonomousExadataInfrastructure(request, Waiters.DEFAULT_POLLING_TERMINATION_STRATEGY, Waiters.DEFAULT_POLLING_DELAY_STRATEGY);
    }

    public Waiter<UpdateAutonomousExadataInfrastructureRequest, UpdateAutonomousExadataInfrastructureResponse> forUpdateAutonomousExadataInfrastructure(final UpdateAutonomousExadataInfrastructureRequest request, final TerminationStrategy terminationStrategy, final DelayStrategy delayStrategy) {
        if (this.workRequestClient == null) {
            throw new IllegalStateException("A WorkRequestClient must be supplied to this waiter for this operation");
        }
        return new SimpleWaiterImpl<UpdateAutonomousExadataInfrastructureRequest, UpdateAutonomousExadataInfrastructureResponse>(this.executorService, new Callable<UpdateAutonomousExadataInfrastructureResponse>(){

            @Override
            public UpdateAutonomousExadataInfrastructureResponse call() throws Exception {
                UpdateAutonomousExadataInfrastructureResponse response = DatabaseWaiters.this.client.updateAutonomousExadataInfrastructure(request);
                GetWorkRequestRequest getWorkRequestRequest = GetWorkRequestRequest.builder().workRequestId(response.getOpcWorkRequestId()).build();
                DatabaseWaiters.this.workRequestClient.getWaiters().forWorkRequest(getWorkRequestRequest, terminationStrategy, delayStrategy).execute();
                return response;
            }
        }, request);
    }
}

