/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.requests.GenerateAutonomousDataWarehouseWalletRequest;
import com.oracle.bmc.database.responses.GenerateAutonomousDataWarehouseWalletResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateAutonomousDataWarehouseWalletConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GenerateAutonomousDataWarehouseWalletConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GenerateAutonomousDataWarehouseWalletRequest interceptRequest(GenerateAutonomousDataWarehouseWalletRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GenerateAutonomousDataWarehouseWalletRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getAutonomousDataWarehouseId(), (String)"autonomousDataWarehouseId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getGenerateAutonomousDataWarehouseWalletDetails(), (String)"generateAutonomousDataWarehouseWalletDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("autonomousDataWarehouses").path(HttpUtils.encodePathSegment(request.getAutonomousDataWarehouseId())).path("actions").path("generateWallet");
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/octet-stream");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, GenerateAutonomousDataWarehouseWalletResponse> fromResponse() {
        Function<Response, GenerateAutonomousDataWarehouseWalletResponse> transformer = new Function<Response, GenerateAutonomousDataWarehouseWalletResponse>(){

            public GenerateAutonomousDataWarehouseWalletResponse apply(Response rawResponse) {
                Optional<List<String>> lastModifiedHeader;
                Optional<List<String>> contentLengthHeader;
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for GenerateAutonomousDataWarehouseWalletResponse");
                Function<Response, WithHeaders<InputStream>> responseFn = RESPONSE_CONVERSION_FACTORY.create(InputStream.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GenerateAutonomousDataWarehouseWalletResponse.Builder builder = GenerateAutonomousDataWarehouseWalletResponse.builder();
                builder.inputStream((InputStream)response.getItem());
                Optional<List<String>> etagHeader = HeaderUtils.get(headers, "etag");
                if (etagHeader.isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                if ((contentLengthHeader = HeaderUtils.get(headers, "content-length")).isPresent()) {
                    builder.contentLength(HeaderUtils.toValue("content-length", (String)((List)contentLengthHeader.get()).get(0), Long.class));
                }
                if ((lastModifiedHeader = HeaderUtils.get(headers, "last-modified")).isPresent()) {
                    builder.lastModified(HeaderUtils.toValue("last-modified", (String)((List)lastModifiedHeader.get()).get(0), Date.class));
                }
                GenerateAutonomousDataWarehouseWalletResponse responseWrapper = builder.build();
                return responseWrapper;
            }
        };
        return transformer;
    }
}

