/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.AutonomousDataWarehouse;
import com.oracle.bmc.database.requests.GetAutonomousDataWarehouseRequest;
import com.oracle.bmc.database.responses.GetAutonomousDataWarehouseResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetAutonomousDataWarehouseConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetAutonomousDataWarehouseConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetAutonomousDataWarehouseRequest interceptRequest(GetAutonomousDataWarehouseRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetAutonomousDataWarehouseRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getAutonomousDataWarehouseId(), (String)"autonomousDataWarehouseId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("autonomousDataWarehouses").path(HttpUtils.encodePathSegment(request.getAutonomousDataWarehouseId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, GetAutonomousDataWarehouseResponse> fromResponse() {
        Function<Response, GetAutonomousDataWarehouseResponse> transformer = new Function<Response, GetAutonomousDataWarehouseResponse>(){

            public GetAutonomousDataWarehouseResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for GetAutonomousDataWarehouseResponse");
                Function<Response, WithHeaders<AutonomousDataWarehouse>> responseFn = RESPONSE_CONVERSION_FACTORY.create(AutonomousDataWarehouse.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetAutonomousDataWarehouseResponse.Builder builder = GetAutonomousDataWarehouseResponse.builder();
                builder.autonomousDataWarehouse((AutonomousDataWarehouse)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                GetAutonomousDataWarehouseResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

