/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.Patch;
import com.oracle.bmc.database.requests.GetDbSystemPatchRequest;
import com.oracle.bmc.database.responses.GetDbSystemPatchResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDbSystemPatchConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetDbSystemPatchConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetDbSystemPatchRequest interceptRequest(GetDbSystemPatchRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetDbSystemPatchRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getPatchId(), (String)"patchId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("dbSystems").path(HttpUtils.encodePathSegment(request.getDbSystemId())).path("patches").path(HttpUtils.encodePathSegment(request.getPatchId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, GetDbSystemPatchResponse> fromResponse() {
        Function<Response, GetDbSystemPatchResponse> transformer = new Function<Response, GetDbSystemPatchResponse>(){

            public GetDbSystemPatchResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for GetDbSystemPatchResponse");
                Function<Response, WithHeaders<Patch>> responseFn = RESPONSE_CONVERSION_FACTORY.create(Patch.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetDbSystemPatchResponse.Builder builder = GetDbSystemPatchResponse.builder();
                builder.patch((Patch)response.getItem());
                Optional<List<String>> opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                GetDbSystemPatchResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

