/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.PatchHistoryEntry;
import com.oracle.bmc.database.requests.GetDbSystemPatchHistoryEntryRequest;
import com.oracle.bmc.database.responses.GetDbSystemPatchHistoryEntryResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDbSystemPatchHistoryEntryConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetDbSystemPatchHistoryEntryConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetDbSystemPatchHistoryEntryRequest interceptRequest(GetDbSystemPatchHistoryEntryRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetDbSystemPatchHistoryEntryRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getDbSystemId(), (String)"dbSystemId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getPatchHistoryEntryId(), (String)"patchHistoryEntryId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("dbSystems").path(HttpUtils.encodePathSegment(request.getDbSystemId())).path("patchHistoryEntries").path(HttpUtils.encodePathSegment(request.getPatchHistoryEntryId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        return ib;
    }

    public static Function<Response, GetDbSystemPatchHistoryEntryResponse> fromResponse() {
        Function<Response, GetDbSystemPatchHistoryEntryResponse> transformer = new Function<Response, GetDbSystemPatchHistoryEntryResponse>(){

            public GetDbSystemPatchHistoryEntryResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for GetDbSystemPatchHistoryEntryResponse");
                Function<Response, WithHeaders<PatchHistoryEntry>> responseFn = RESPONSE_CONVERSION_FACTORY.create(PatchHistoryEntry.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetDbSystemPatchHistoryEntryResponse.Builder builder = GetDbSystemPatchHistoryEntryResponse.builder();
                builder.patchHistoryEntry((PatchHistoryEntry)response.getItem());
                Optional<List<String>> etagHeader = HeaderUtils.get(headers, "etag");
                if (etagHeader.isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                GetDbSystemPatchHistoryEntryResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

