/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.database.model.VmClusterNetwork;
import com.oracle.bmc.database.requests.GetVmClusterNetworkRequest;
import com.oracle.bmc.database.responses.GetVmClusterNetworkResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetVmClusterNetworkConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetVmClusterNetworkConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetVmClusterNetworkRequest interceptRequest(GetVmClusterNetworkRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetVmClusterNetworkRequest request) {
        Validate.notNull((Object)request, (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getExadataInfrastructureId(), (String)"exadataInfrastructureId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getVmClusterNetworkId(), (String)"vmClusterNetworkId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("exadataInfrastructures").path(HttpUtils.encodePathSegment(request.getExadataInfrastructureId())).path("vmClusterNetworks").path(HttpUtils.encodePathSegment(request.getVmClusterNetworkId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept("application/json");
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetVmClusterNetworkResponse> fromResponse() {
        Function<Response, GetVmClusterNetworkResponse> transformer = new Function<Response, GetVmClusterNetworkResponse>(){

            public GetVmClusterNetworkResponse apply(Response rawResponse) {
                Optional<List<String>> opcRequestIdHeader;
                LOG.trace("Transform function invoked for GetVmClusterNetworkResponse");
                Function<Response, WithHeaders<VmClusterNetwork>> responseFn = RESPONSE_CONVERSION_FACTORY.create(VmClusterNetwork.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap<String, String> headers = response.getHeaders();
                GetVmClusterNetworkResponse.Builder builder = GetVmClusterNetworkResponse.builder();
                builder.vmClusterNetwork((VmClusterNetwork)response.getItem());
                Optional<List<String>> etagHeader = HeaderUtils.get(headers, "etag");
                if (etagHeader.isPresent()) {
                    builder.etag(HeaderUtils.toValue("etag", (String)((List)etagHeader.get()).get(0), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get(headers, "opc-request-id")).isPresent()) {
                    builder.opcRequestId(HeaderUtils.toValue("opc-request-id", (String)((List)opcRequestIdHeader.get()).get(0), String.class));
                }
                GetVmClusterNetworkResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered(rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

